/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TurnDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "culcfunc.h"
#define _TURNDLG_
#include "TurnDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void turn_dlg_cancel_pushed(GtkWidget *widget, TURN_DLG *turn_dlg)
{
	turn_dlg->value = -1;
	turn_dlg->x_pos = 0;
	turn_dlg->y_pos = 0;
	turn_dlg->angle = 0;
	turn_dlg->repeats = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void turn_dlg_ok_pushed(GtkWidget *widget, TURN_DLG *turn_dlg)
{
	char str[256];


	/* テキストエントリーから文字列を取得 */
	if (turn_dlg->x_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->x_pos_entry)));
		turn_dlg->x_pos = atof(str);
	}

	if (turn_dlg->y_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->y_pos_entry)));
		turn_dlg->y_pos = atof(str);
	}

	if (turn_dlg->angle_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->angle_entry)));
		turn_dlg->angle = atof(str);
	}

	if (turn_dlg->repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->repeats_entry)));
		turn_dlg->repeats = atoi(str);
	}

}



static gint turn_dlg_delete_event(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	return TRUE;
}

static gint turn_dlg_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
#ifdef G_OS_WIN32
	gtk_window_present(GTK_WINDOW(widget));
#endif
	return FALSE;
}

/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint turn_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, TURN_DLG *turn_dlg)
{
//	g_print("sagcad.c : turn_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* フォーカス x_pos_entry で Enter ならフォーカスを y_pos_entry に移す */
		if (GTK_WIDGET( turn_dlg->x_pos_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->y_pos_entry);
			gtk_editable_select_region(GTK_EDITABLE(turn_dlg->y_pos_entry), 0, GTK_ENTRY(turn_dlg->y_pos_entry)->text_length);
		}
		/* フォーカス y_pos_entry で Enter ならフォーカスを angle_entry に移す */
		else if (GTK_WIDGET(turn_dlg->y_pos_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->angle_entry);
			gtk_editable_select_region(GTK_EDITABLE(turn_dlg->angle_entry), 0, GTK_ENTRY(turn_dlg->angle_entry)->text_length);
		}
		/* フォーカス angle_entry で Enter ならフォーカスを repeats_entry に移す */
		else if (GTK_WIDGET(turn_dlg->angle_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->repeats_entry);
			gtk_editable_select_region(GTK_EDITABLE(turn_dlg->repeats_entry), 0, GTK_ENTRY(turn_dlg->repeats_entry)->text_length);
		}
		/* フォーカス repeats_entry で Enter なら終わり */
		else if (GTK_WIDGET(turn_dlg->repeats_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			turn_dlg_ok_pushed(widget, turn_dlg);
			gtk_main_quit();
		}
	}
	return FALSE;
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 */
gint TurnDialog(TURN_DLG *turn_dlg)
{
//	GtkWidget *dialog;
	char str[256];

	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *label_vbox;
				GtkWidget *x_pos_label;
				GtkWidget *y_pos_label;
				GtkWidget *angle_label;
				GtkWidget *repeats_label;
			GtkWidget *entry_vbox;
//				GtkWidget *x_pos_entry;
//				GtkWidget *y_pos_entry;
//				GtkWidget *angle_entry;
//				GtkWidget *repeats_entry;
		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;
			GtkWidget *ok_buttun;


	/* ダイアログ生成 */
	turn_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(turn_dlg->dialog), _("Turn [Move/Copy] Setting") );
	gtk_window_set_resizable(GTK_WINDOW(turn_dlg->dialog), FALSE);
	gtk_window_set_position(GTK_WINDOW(turn_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(turn_dlg->dialog), TRUE);
	/* ダイアログがメインウィンドウの後ろに隠れてしまわないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(turn_dlg->dialog), GTK_WINDOW(turn_dlg->parent));
	
	g_signal_connect(G_OBJECT(turn_dlg->dialog), "delete_event",
			 G_CALLBACK(turn_dlg_delete_event), NULL);
	g_signal_connect( G_OBJECT(turn_dlg->dialog), "key_press_event",
				G_CALLBACK(turn_dlg_key_press_event), turn_dlg);
	g_signal_connect(G_OBJECT(turn_dlg->dialog), "focus_out_event",
			 G_CALLBACK(turn_dlg_focus_out), NULL);
	
	/* main_vbox */
	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(turn_dlg->dialog), main_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(turn_dlg->dialog), 5);
	gtk_widget_show(main_vbox);
	
	/* hbox */
	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
						hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);
	
	/* セパレーター(separator) */
	separator = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
	gtk_widget_show(separator);
	
	action_hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( GTK_BOX(main_vbox), 
						action_hbox, TRUE, TRUE, 0);
	gtk_widget_show(action_hbox);

		label_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
		gtk_widget_show(label_vbox);

		entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(entry_vbox);


			x_pos_label = gtk_label_new( _("Starting Point X") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), x_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(x_pos_label);

			y_pos_label = gtk_label_new( _("Starting Point Y") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), y_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(y_pos_label);

			angle_label = gtk_label_new( _("Angle") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), angle_label, TRUE, TRUE, 0);
			gtk_widget_show(angle_label);

			repeats_label = gtk_label_new( _("Number of times") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
			gtk_widget_show(repeats_label);


			/* テキストエントリー生成 */
			/* 回転原点Ｘ */
			turn_dlg->x_pos_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->x_pos_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			FloatOut_n(str, turn_dlg->x_pos, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->x_pos_entry), str);
			gtk_editable_select_region( GTK_EDITABLE(turn_dlg->x_pos_entry), 0, 
						 GTK_ENTRY(turn_dlg->x_pos_entry)->text_length);
			gtk_widget_show(turn_dlg->x_pos_entry);

			/* 回転原点Ｙ */
			turn_dlg->y_pos_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->y_pos_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			FloatOut_n(str, turn_dlg->y_pos, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->y_pos_entry), str);
			gtk_widget_show(turn_dlg->y_pos_entry);

			/* 角度 */
			turn_dlg->angle_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->angle_entry, TRUE, TRUE, 1);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->angle_entry), "0");
			gtk_widget_show(turn_dlg->angle_entry);

			/* 回数 */
			turn_dlg->repeats_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->repeats_entry, TRUE, TRUE, 1);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->repeats_entry), "1");
			gtk_widget_show(turn_dlg->repeats_entry);

		/* CANCELボタンの生成 */
		cancel_buttun = gtk_button_new_with_label("CANCEL");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
					G_CALLBACK(turn_dlg_cancel_pushed), turn_dlg);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
					G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(cancel_buttun);

		/* OKボタンの生成 */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
					G_CALLBACK(turn_dlg_ok_pushed), turn_dlg);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
					G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(ok_buttun);

	/*  フォーカスを x_pos_entry に設定 */
	gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->x_pos_entry);

	/* ダイアログを可視状態へ */
	gtk_widget_show(turn_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(turn_dlg->dialog);
	return turn_dlg->value; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TurnDlg.c
 * ====================================================================
 */
