/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Mouse.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/18
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include "intl.h"

#include "types.h"
#include "List_cad.h"
#include "List_cam.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "culcfunc.h"
#include "Select.h"
#include "Draw.h"
#include "sagcad.h"
#include "DrawMode.h"
#include "MsgBox.h"
#include "TrimFunc.h"
#include "Ellipse.h"
#include "InputBox.h"
//#include "CamProfile.h"
//#include "Dlg.h"
#include "etc.h"
#include "CopyFunc.h"
#include "Dimension.h"
//#include "FileFunc.h"
//#include "offset.h"
#include "plcDlg.h"
#include "B_spline.h"
#include "spline.h"
#include "MemoryLeak.h"

#include "CopyDlg.h"
#include "TurnDlg.h"
#include "ScalingDlg.h"
#include "GridCopyDlg.h"
#include "SnapDlg.h"
#include "TextEditDlg.h"
#include "sgy.h"
#include "DXF_read.h"
#include "CulcInputDlg.h"
#include "Command.h"
#include "CamSetDlg.h"
#include "CamProfile.h"
#include "OutsideProcess.h"

#define _MOUSE_
#include "Mouse.h"





/* -------------------------------------------------------------------
 * マウスのボタンが押されたとき
 */
void SagCad_MouseDown(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	if (Shift != 0) {
		/* Alt + ボタン */
		if (Shift == 4) {
//			if (Button == 1) MenuCommand(widget, ID_ZOOM_UP);
//			else if (Button == 2) MenuCommand(widget, ID_ZOOM_DOWN);
		}
		/* Ctrl + 左右 */
		else if (Shift == 2) {
//			if (Button == 1) MenuCommand(widget, ID_LEFT);
//			else if (Button == 2) MenuCommand(widget, ID_RIGHT);
		}
		/* Shift + 上下 */
		else if (Shift == 1) {
//			if (Button == 1) MenuCommand(widget, ID_UP);
//			else if (Button == 2) MenuCommand(widget, ID_DOWN);
		}
	}


//g_print("Mouse.c : SagCad_MouseDown() : in 1\n");


	/* 拡大中心設定（図形点）*/
	else if (Center_set_mode == 100) MouseMode_Center(widget, Button, ToViewX(x), ToViewY(y));
	/* 1個選択モード (OnlyOne) */
	else if (OnlyOne_mode == 210) {
		MouseRet_OnlyOne(widget, x, y, Button);
		MouseMode_OnlyOne(widget, x, y, Button);
	}
	/* チェイン選択モード (OnlyOne) */
	else if (Chain2_OnlyOne_mode == 211) MouseMode_ChainOne(widget, x, y, Button);
	else {
		/* モード無しのとき (mode = 0) */
		if (mode == 0) MouseMode_Non(widget, Button, x, y);
		/* 作図モード */
		else if (mode == 200) MouseMode_Draw(widget, Button, x, y);
		/* 部品図挿入 */
		else if (mode == 110) MouseMode_PartsRead(widget, Button, x, y);

		/* 選択モード */
		else if (mode == 300 && outside_process_on == 0) MouseMode_Select(widget, Button, x, y);
		/* 選択モード (外部処理中) */
		else if (mode == 300 && outside_process_on == 1) MouseMode_Select_ops(widget, Button, x, y);
		/* 範囲選択モード */
		else if (mode == 310 && outside_process_on == 0) MouseMode_Rect(widget, Button, x, y);
		/* 範囲選択モード (外部処理中) */
		else if (mode == 310 && outside_process_on == 1) MouseMode_Rect_ops(widget, Button, x, y);

		/* 片方　トリムモード */
		else if (mode == 220) MouseMode_Trim(widget, Button, x, y);
		/* 両方　トリムモード */
		else if (mode == 225) MouseMode_Trim(widget, Button, x, y);
		/* 分割 */
		else if (mode == 260) MouseMode_Split(widget, Button, x, y);
		/* フィレット */
		else if (mode == 270) MouseMode_Fillet(widget, Button, x, y);
		/* Ｃ面 */
		else if (mode == 280) MouseMode_Chamfering(widget, Button, x, y);
		/* 連続線 */
		else if (mode == 250) MouseMode_ContLine(widget, Button, x, y);
		/* ３点で円 */
		else if (mode == 230) MouseMode_3P_Circle(widget, Button, x, y);
		/* ３辺で円 */
		else if (mode == 240) MouseMode_3L_Circle(widget, Button, x, y);

		/* 平行 */
		else if (mode == 340) MouseMode_Parallel(widget, Button, x, y);
		/* 回転 */
		else if (mode == 350) MouseMode_Turn(widget, Button, x, y);
		/* 対象 */
		else if (mode == 330) MouseMode_Mirror(widget, Button, x, y);

		/* 寸法　水平 */
		else if (mode == 510) MouseMode_DimensionX(widget, Button, x, y);
		/* 寸法　垂直 */
		else if (mode == 520) MouseMode_DimensionY(widget, Button, x, y);
		/* 寸法　距離 */
		else if (mode == 530) MouseMode_DimensionP(widget, Button, x, y);
		/* 寸法　半径 */
		else if (mode == 540) MouseMode_DimensionR(widget, Button, x, y);
		/* 寸法　直径 */
		else if (mode == 550) MouseMode_DimensionD(widget, Button, x, y);
		/* 寸法　角度 */
		else if (mode == 560) MouseMode_DimensionA(widget, Button, x, y);
		/* 寸法　座標 */
		else if (mode == 570) MouseMode_DimensionPT(widget, Button, x, y);
		/* 寸法　引出線 */
		else if (mode == 580) MouseMode_DimensionHD(widget, Button, x, y);
		/* 寸法　注釈 */
		else if (mode == 590) MouseMode_DimensionAT(widget, Button, x, y);
		/* 寸法　編集 */
		else if (mode == 610) MouseMode_DimensionEDT(widget, Button, x, y);
		/* ポリライン */
		else if (mode == 255) MouseMode_PolyLine(widget, Button, x, y);
		/* ＣＡＭ始点設定 (図形端点) */
		else if (mode == 900) MouseMode_CamProfile(widget, Button, x, y);
#ifdef AFTER
		/* offset 始点設定 (図形端点) */
		else if (mode == 1000) MouseMode_offset(widget, Button, x, y);
#endif
	}
}





/* -------------------------------------------------------------------
 * マウスのボタンを放したとき
 *	
 */
void SagCad_MouseUp(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	/*	*/
	if (OnlyOne_mode != 0 || Center_set_mode != 0 || Chain2_OnlyOne_mode != 0) return;

	/* 左ボタンが放されたとき */
	if (Button == 1) {
		/* 範囲セレクト */
		if (mode == 310) {
			//g_print("Mouse.c : SagCad_MouseUp() : mode = 310 : in\n");
			if (RectStart == 1) {
				//g_print("Mouse.c : SagCad_MouseUp() : RectStart = 1 : in\n");
				/* マウスをキャプチャーしないと画面から外れたときにおかしくなる。*/
				RectStart = 0;
				MoveX = x;
				MoveY = y;
				EndX = x;
				EndY = y;

				PenSet_with_back(gc, 2, sagcad_color.Back, sagcad_color.Back);
				gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
				gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
				gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
				gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
				
				SqSelect(widget, ToViewX(StartX), ToViewY(StartY), ToViewX(EndX), ToViewY(EndY));
				(*ReturnFunc)(widget, Button, x, y);
			}
			return;
		}



		/* -------------------------------------------------
		 *	 マウスを放すときに、押した時の座標と DC 以内のズレなら、
		 * その図形をセレクトする。
		 *	 マウスを放すときに、押した時の座標とずらして放すと、
		 * その図形はセレクトしないでキャンセルする。
		 * 
		 * 押したときの座標は、(mouse_select_frag.x , mouse_select_frag.y)
		 */
		else if (mode != 0 /*&& (mode < 500 || mode > 530)*/) {
			/* 押したときの座標(mouse_select_frag.x , mouse_select_frag.y)で離したとき */
			if ((mouse_select_frag.x > sg(ToViewX(x), 3) - DC && mouse_select_frag.x < sg(ToViewX(x), 3) + DC) 
				&& (mouse_select_frag.y > sg(ToViewY(y), 3) - DC && mouse_select_frag.y < sg(ToViewY(y), 3) + DC))
			{
				/* [押したときの Sleep よりも早く [離したとき] のためのフラグ */
				Already = 1;
				select_list_add_last(&mouse_select_frag);
				SelectDraw(widget, select_list_info.tail->select, SCD_SELECT, UPDATE_ON);
				(*ReturnFunc)(widget, Button, x, y);
			}

			/* ズラされたキャンセル */
			else {
				(*ReturnFunc)(widget, Button, x, y);
				SelectDraw(widget, &mouse_select_frag, SCD_ORG, UPDATE_ON);
			}
			mouse_select_frag.index = 0;
			mouse_select_frag.x = 0;
			mouse_select_frag.y = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
		}
	}
	return;
}





/* -------------------------------------------------------------------
 * マウスが動いたとき
 *	
 */
void SagCad_MouseMove(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	char str[256];


	char value[256];
	int len, n, i, k;

	/* Mouse X */
	FloatOut_n(value, abs(ToViewX(x)), 0, 0);
	len = strlen(value);
	if (len == 1) k = 5;
	else if (len == 2) k = 4;
	else if (len == 3) k = 3;
	else if (len == 4) k = 2;
	else if (len == 5) k = 1;
	else if (len > 5) k = 0;
	else k = 3;
	FloatOut_n(value, ToViewX(x), k, 0);
	len = strlen(value);
	n = 10-len;
	strcpy (str, "X");
	if (n > 0) {
		for (i = 0 ; i < n ; i++) {
			strcat (str, " ");
		}
	}
	strcat (str, value);
	StatusMsg_MouseX(str);

	/* Mousu Y */
	FloatOut_n(value, abs(ToViewY(y)), 0, 0);
	len = strlen(value);
	if (len == 1) k = 5;
	else if (len == 2) k = 4;
	else if (len == 3) k = 3;
	else if (len == 4) k = 2;
	else if (len == 5) k = 1;
	else if (len > 5) k = 0;
	else k = 3;
	FloatOut_n(value, ToViewY(y), k, 0);
	len = strlen(value);
	n = 10-len;
	strcpy (str, "Y");
	if (n > 0) {
		for (i = 0 ; i < n ; i++) {
			strcat (str, " ");
		}
	}
	strcat (str, value);
	StatusMsg_MouseY(str);


	if (OnlyOne_mode != 0 || Center_set_mode != 0 || Chain2_OnlyOne_mode != 0) return;


	if (Button == 1) {
		/* モード */
		switch (mode) {
			case 0:
				return;
				break;

			/* 範囲セレクト */
			case 310:
				//g_print("Mouse.c : SagCad_MouseMove() : mode = 310 : in\n");
				if(RectStart == 1) {
					//g_print("Mouse.c : SagCad_MouseMove() : 消去 : StartX[%d]  StartY[%d] MoveX[%d]  MoveY[%d]\n", 
					//					StartX, StartY, MoveX, MoveY);
					/* 前の線を消す */
					PenSet_with_back(gc, 2, sagcad_color.Back, sagcad_color.Back);
					gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
					gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
					gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
					gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
					
					MoveX = x;
					MoveY = y;
					//g_print("Mouse.c : SagCad_MouseMove() : 描画 : StartX[%d]  StartY[%d] MoveX[%d]  MoveY[%d]\n", 
					//					StartX, StartY, MoveX, MoveY);
					
					/* 新しい線を描く */
					PenSet_with_back(gc, 2, sagcad_color.Dimension, sagcad_color.Back);
					gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
					gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
					gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
					gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
				}
				break;
		}
	}



	/* モード */
	switch (mode) {
		/* 水平寸法 */
		case 510:
			if(select_list_num() == 2) {
				Dim_now.Type = 10;
				/* ２回目以降の時 
				 * 最初にここに来たときは、まだ寸法線を描いていないので、
				 * 消すための操作は、してはいけない。
				 * 
				 * 最初にここに来たとき、Dim_old.Text は。NULL 。
				 * 
				 */
				if(Dim_old.Text[0] != '\0')
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_X_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;
		/* 垂直寸法 */
		case 520:
			if(select_list_num() == 2) {
				Dim_now.Type = 20;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_Y_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 距離寸法 */
		case 530:
			if(select_list_num() == 2) {
				Dim_now.Type = 30;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_P_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 半径寸法 */
		case 540:
			if(select_list_num() == 1) {
				Dim_now.Type = 40;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_R_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 直径寸法 */
		case 550:
			if(select_list_num() == 1) {
				Dim_now.Type = 50;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_D_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 角度寸法 */
		case 560:
			if(select_list_num() == 3) {
				Dim_now.Type = 60;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[4] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[4] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[4] = ToViewX(x);
					PicPoint.Y[4] = ToViewY(y);
				}
				Dimension_A_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 座標寸法 */
		case 570:
			if(select_list_num() == 1) {
				Dim_now.Type = 70;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_PT_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 引出寸法 */
		case 580:
			if(select_list_num() >= 1) {
				Dim_now.Type = 80;
				if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);
				if(select_list_num() == 1) {
					if ((sagcad_system.GridMode & 2) == 2) {
						PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
						PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
					}
					else {
						PicPoint.X[2] = ToViewX(x);
						PicPoint.Y[2] = ToViewY(y);
					}
				}
				if(select_list_num() == 2) {
					if ((sagcad_system.GridMode & 2) == 2) {
						PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
						PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
					}
					else {
						PicPoint.X[3] = ToViewX(x);
						PicPoint.Y[3] = ToViewY(y);
					}
				}
				Dimension_HD_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* 注釈寸法 */
		case 590:
			Dim_now.Type = 90;
			if(Dim_old.Text[0] != '\0')		/* ２回目以降の時 */
				DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

			if ((sagcad_system.GridMode & 2) == 2) {
				Dim_now.SearchPointX = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
				Dim_now.SearchPointY = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
			}
			else {
				Dim_now.SearchPointX = ToViewX(x);
				Dim_now.SearchPointY = ToViewY(y);
			}

			/*  */
			Dim_now.diagram_of_char_index = 0;
			if (Dim_now.diagram_of_char != NULL) {
				xfree(Dim_now.diagram_of_char);
			}
			Dim_now.diagram_of_char = NULL;


			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			Dim_old = Dim_now;
			UpDate();
			break;
#ifdef AFTER
#endif
	}
}





/* ---------------------------------------------------------
 * モード無しのとき (Main)
 */
int MouseMode_Non(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 右ボタン */
		case 2:
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			(*ReturnFunc)(widget, Button, x, y);
			break;
	}
	return 0;
}


/* ---------------------------------------------------------
 * モード無しのとき (Return)
 */
int MouseRet_Non(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _("Select a command.") );	
	StatusMsg(mstr);
	return 1;
}





/* -------------------------------------------------------------------
 * 拡大中心設定 (Main)
 */
int MouseMode_Center(GtkWidget *widget, int Button, double x, double y)
{
	int dumy;


	switch (Button) {
		case 1:
			g_print("Left Button\n");
			dumy = MouseRet_CenterL(x, y);
			if (dumy == 1) {
				/* 再描画 */
				Redraw();
				/* 中心設定フラグ OFF */
				Center_set_mode = 0;
				/* コマンドラインに元のメッセージを表示 */
				(*ReturnFunc)(widget, 1, 0, 0);
			}
			return 1;
			break;
		case 2:
			g_print("Right Button\n");
			dumy = MouseRet_CenterR(x, y);
			/* 再描画 */
			Redraw();
			/* 中心設定フラグ OFF */
			Center_set_mode = 0;
			/* コマンドラインに元のメッセージを表示 */
			(*ReturnFunc)(widget, 1, 0, 0);
			return 1;
			break;
		case 4:
			g_print("Mid Button\n");
			/* 中心設定フラグ OFF */
			Center_set_mode = 0;
			/* コマンドラインに元のメッセージを表示 */
			(*ReturnFunc)(widget, 1, 0, 0);
			return 1;
			break;
	}
	return 0;
}


/* -------------------------------------------------------------------
 * 拡大中心設定  図形の点読み取り (Sub L)
 */
int MouseRet_CenterL(double x, double y)
{
	CAD *cad;
	if( (DcObj & 1) == 1 ) {
		cad = TenLook(x, y);
		if (cad != NULL) {
			MagX = (float)cad->sx;
			MagY = (float)cad->sy;
			return 1;
		}
	}
	return 0;
}


/* -------------------------------------------------------------------
 * 拡大中心設定   任意点 (Sub R)
 */
int MouseRet_CenterR(double x,double y)
{
	MagX = (float) x;
	MagY = (float) y;
	return 1;
}





/* -------------------------------------------------------
 * セレクトされた最後のデータのセレクト解除
 */
int select_last_cansel(void)
{
	if (select_list_info.head != NULL && select_list_info.tail != NULL) {
		/* 元の色に戻す */
		SelectDraw(drawing_area, select_list_info.tail->select, SCD_ORG, UPDATE_ON);
		/* Select Data をリストから削除 */
		select_list_free(select_list_info.tail);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------
 * スナップ設定
 * 
 *	  図形要素	 1 : 点
 *				 2 : 線
 *				 4 : 円弧
 *				 8 : 円
 *				15 : 全図形
 *	
 *	  寸法図形	16 : 始点・終点
 *				32 : 四半点
 *				64 : 中心点
 *			   128 : 任意点
 *			   256 : 寸法図形
 *			   512 : ポリライン
 *			  1024 : ブロック
 * 
 * 
 * draw			: 1+2+4+8=15
 * select		: 1+2+4+8+256+512=783
 * dimension	: 1+16+32+64=113
 * 
 * 
 * 
 */
int snap_set(int snap, int mask)
{
	SNAP_DLG snap_dlg;


	/* SnapDialog */
	if (mode == 300) {
		snap_dlg.value = 16;
	}
	else {
		snap_dlg.value = 0;
	}
	snap_dlg.mask = mask;		// 設定できるものを入れておく (3 なら点と線しか操作できない)
	snap_dlg.snap = snap;

	snap_dlg.point_check_button = NULL;
	snap_dlg.line_check_button = NULL;
	snap_dlg.arc_check_button = NULL;
	snap_dlg.circle_check_button = NULL;

	snap_dlg.polyline_check_button = NULL;
	snap_dlg.dimension_check_button = NULL;
	snap_dlg.block_check_button = NULL;
	snap_dlg.ellipse_check_button = NULL;

	snap_dlg.start_end_check_button = NULL;
	snap_dlg.half_4_point_check_button = NULL;
	snap_dlg.center_check_button = NULL;
	snap_dlg.any_check_button = NULL;

	snap_dlg.chain_check_button = NULL;
	snap_dlg.chain2_check_button = NULL;
	snap_dlg.color_check_button = NULL;

	snap_dlg.parent = MainWindow;
	snap_dlg.dialog = NULL;

	SnapDialog(&snap_dlg);

//	g_print("----- [ SnapDialog ] -----\n");
//	g_print("mode = %d\n", snap_dlg.mask);
//	g_print("snap = %d\n", snap_dlg.snap);
//	g_print("--------------------------\n\n");

	if (snap_dlg.value == 0) {
		return 0;
	}
	
	DcObj = snap_dlg.snap;

	if (snap_dlg.value == 2) {
		cmd_select_chain();
	}
	else if (snap_dlg.value == 4) {
		cmd_select_chain2();
	}
	else if (snap_dlg.value == 8) {
		cmd_select_color();
	}

	return 1;
}





/* -------------------------------------------------------------------
 * 選択モード (Main)
 * 
 */
int MouseMode_Select(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			
			if (SelectChainFrag == 0 && SelectColorFrag == 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			}
			else if (SelectChainFrag != 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 0);
			}
			else if (SelectColorFrag != 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 15, 0);
			}
			break;
		/* 右ボタン */
		case 2:
			if (SelectChainFrag == 0 || SelectColorFrag == 0) {
				select_last_cansel();
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 選択モード (Return)
 */
int MouseRet_Select(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, _(" [Select] Select a diagram. (Select %d)  %s") , (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, _(" [Select] Select a diagram. (Select 0) ") );
	}
	StatusMsg(mstr);


	switch (Button) {
		/* 左ボタン */
		case 1:
			if(select_list_info.head != NULL) {
				/* コマンド起動時に何かセレクトされていた */
				/* コマンド起動時 + 1 に何かセレクトされている */
				/* それは、図形データである */
				if (OP_SelectList != NULL && OP_SelectList->next != NULL && select_list_info.tail->select->index != 3) {
					if (SelectChainFrag == 1) SelectChain(select_list_info.tail->select->diagram_point.cad_point);
					if (SelectColorFrag == 1) SelectMaskColor(select_list_info.tail->select->diagram_point.cad_point);
					if (SelectChainFrag == 2) {
						KeepReturnFunc = ReturnFunc;
						ReturnFunc = MouseRet_ChainOne;
						Chain2index = 0;
						SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
					}
					SelectChainFrag = 0;
					SelectColorFrag = 0;
					OP_SelectList = NULL;
				}

				/* コマンド起動時に何かセレクトされていなかった */
				/* １個何かセレクトされている */
				/* それは、図形データである */
				else if (OP_SelectList == NULL && select_list_info.head != NULL && select_list_info.head->select->index != 3) {
					if (SelectChainFrag == 1) SelectChain(select_list_info.head->select->diagram_point.cad_point);
					if (SelectColorFrag == 1) SelectMaskColor(select_list_info.head->select->diagram_point.cad_point);
					if (SelectChainFrag == 2) {
						KeepReturnFunc = ReturnFunc;
						ReturnFunc = MouseRet_ChainOne;
						Chain2index = 0;
						SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
					}
					SelectChainFrag = 0;
					SelectColorFrag = 0;
					OP_SelectList = NULL;
				}
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * 範囲選択モード (Main)
 */
int MouseMode_Rect(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			//g_print("Mouse.c : MouseMode_Rect() : Button = 1 : in\n");
//			SetCapture(widget);
			RectStart = 1;
			MoveX = x;
			MoveY = y;
			StartX = x;
			StartY = y;
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * 範囲選択モード (Return)
 */
int MouseRet_Rect(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, _(" [Rect Select] Select a diagram. (Select %d)  %s") , (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, _(" [Rect Select] Select a diagram. (Select 0) ") );
	}
	StatusMsg(mstr);


	switch (Button) {
		/* 左ボタン */
		case 1:
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 1個選択モード (OnlyOne)
 */
int MouseMode_OnlyOne(GtkWidget *widget, int X, int Y, int Button)
{
	/* 決定 (OK) */
	if (Button == 1) {
		OnlyOne (1);
		UpDate();
		return 1;
	}
	/* 違う (NO) */
	if (Button == 2) {
		OnlyOne (2);
		UpDate();
		return 1;
	}
	/* やめた (Cancel) */
	if (Button == 4) {
		OnlyOne (0);
		UpDate();
		return 1;
	}
	return 0;
}


/* ---------------------------------------------------------
 * 1個選択モード (OnlyOne) (Return)
 */
int MouseRet_OnlyOne(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _(" Is it this diagram? [Yes:(Left/RET)] [No:(Right/SPC)] [Cancel:(Center/ESC)]") );
	StatusMsg(mstr);
	return 1;
}


/* -------------------------------------------------------------------
 * 図形１個選択モード (mode = 210)
 * エントリーされている図形の中から目的の図形を選ぶ。
 * -------------------------------------------------------------------
 * 関数 : OnlyOne
 * 引数 : int Frag
 *		  Frag = 0 : CANCEL
 *		  Frag = 1 : YES
 *		  Frag = 2 : NO	 
 *		  Frag = 3 : START	   Frag = 2 と同じだけど前のインデックスを消さない。（初期用）
 * 戻値 : void
 * 外部 : OnlyOneIndex : インデックス
 *		: OnlyOneEntry : 選択データ数
 *		: OnlyOneCAD[] : 
 *	
 * 注意 : OnlyOne(3) を使って最初の候補を表示するとき,その前にダイアログなどを
 *		: 消去する操作があったら "expouse_event" が発生するので
 *		: そのときまた描かなくてはならない。
 *	
 *	
 *	
 * struct OnlyOneDat{
 *	   int Index;
 *	   int Entry;
 *	   struct CAD cad[13];
 *	   int RetMode;
 *	   int (*ReturnFunc)();
 * };
 * struct OnlyOneDat OnlyOne;
 *	
 *	
 */
void OnlyOne(int Frag)
{
	int J;
//	char DumyStr[255];


	/* TEST */
	if (Frag == 2) {
		if (OnlyOneIndex == OnlyOneEntry)	OnlyOneIndex = 1;
		else	OnlyOneIndex = OnlyOneIndex + 1;
	}
	/* TEST */

//	if (Frag == 3) {
//		sprintf(DumyStr,	"この図形ですか　？　[Yes/左ボタン/Return] [No/右ボタン/Space] [Cancel/中ボタン/ESC]");
//		StatusMsg(DumyStr);
//		MouseRet_OnlyOne(drawing_area, 1, 0, 0);
//	}


	if (OnlyOneIndex == 1)	J = OnlyOneEntry;
	else	J = OnlyOneIndex - 1;

	/* 決定 */
	if (Frag == 1) {
		OnlyOneCAD[OnlyOneIndex].layer = NowLayer;
		OnlyOneCAD[OnlyOneIndex].color = NowColor;
		OnlyOneCAD[OnlyOneIndex].style = NowStyle;
	}
	else if (Frag == 2 || Frag == 3) {
		OnlyOneCAD[OnlyOneIndex].color = sagcad_color.Select;
		OnlyOneCAD[OnlyOneIndex].style = 2;
	}
	else if (Frag == 0) {
		OnlyOneCAD[OnlyOneIndex].color = sagcad_color.Back;
		OnlyOneCAD[OnlyOneIndex].style = 2;
	}

	/* 点のとき */
	if (OnlyOneCAD[OnlyOneIndex].code == 0) {
		/* 点を描画 */
		if (Frag == 2) {
			PointDraw(drawing_area, OnlyOneCAD[J].sx, OnlyOneCAD[J].sy,
					  OnlyOneCAD[J].style, sagcad_color.Back);
		}
		PointDraw(drawing_area, OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy,
				  OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}

	/* 直線のとき */
	else if (OnlyOneCAD[OnlyOneIndex].code == 1) {
		/* 直線を描画 */
		if (Frag == 2) {
			LineDraw(drawing_area, OnlyOneCAD[J].sx, OnlyOneCAD[J].sy,
					 OnlyOneCAD[J].ex, OnlyOneCAD[J].ey,
					 OnlyOneCAD[J].style, sagcad_color.Back);
		}
		LineDraw(drawing_area, OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy,
				 OnlyOneCAD[OnlyOneIndex].ex, OnlyOneCAD[OnlyOneIndex].ey,
				 OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}
	/* 円弧のとき */
	else if (OnlyOneCAD[OnlyOneIndex].code == 2) {
		/* 円弧を描画 */
		if (Frag == 2) {
			ArcDraw(drawing_area, OnlyOneCAD[J].cx, OnlyOneCAD[J].cy, OnlyOneCAD[J].r, 
					OnlyOneCAD[J].sx, OnlyOneCAD[J].sy, OnlyOneCAD[J].ex, OnlyOneCAD[J].ey,
					OnlyOneCAD[J].style, sagcad_color.Back);
		}
		ArcDraw(drawing_area, 
				OnlyOneCAD[OnlyOneIndex].cx, OnlyOneCAD[OnlyOneIndex].cy, OnlyOneCAD[OnlyOneIndex].r, 
				OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy, 
				OnlyOneCAD[OnlyOneIndex].ex, OnlyOneCAD[OnlyOneIndex].ey,
				OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}
	/* 円のとき */
	else if (OnlyOneCAD[OnlyOneIndex].code == 4) {
		 /* 円を描画 */
		if (Frag == 2) {
			CircleDraw(drawing_area, OnlyOneCAD[J].cx, OnlyOneCAD[J].cy, OnlyOneCAD[J].r, 
					   OnlyOneCAD[OnlyOneIndex].style, sagcad_color.Back);
		}
		CircleDraw(drawing_area, 
				   OnlyOneCAD[OnlyOneIndex].cx, OnlyOneCAD[OnlyOneIndex].cy, OnlyOneCAD[OnlyOneIndex].r, 
				   OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}


	/* 決定 (OK) */
	if (Frag == 1) {
		undo_index_plus();
		cad_list_add_first_with_undo(&OnlyOneCAD[OnlyOneIndex], &cad_list_info);
//		SelectCadDraw(drawing_area, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
//		SelectCadDraw(drawing_area, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
		select_list_all_free();
		OnlyOne_mode = 0;
		ReturnFunc = OnlyOneKeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		ModifiedFlag = 1;
		return;
	}

	/* 違う (NO) */
	else if (Frag == 2 || Frag == 3) {
		MouseRet_OnlyOne(drawing_area, 1, 0, 0);
		return;
	}

	/* やめた (Cancel) */
	else if (Frag == 0) {
//		SelectCadDraw(drawing_area, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
//		SelectCadDraw(drawing_area, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
		select_list_all_free();
		OnlyOne_mode = 0;
		ReturnFunc = OnlyOneKeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		return;
	}
}





/* -------------------------------------------------------------------
 * チェイン選択モード (Main)
 */
int MouseMode_ChainOne(GtkWidget *widget, int X, int Y, int Button)
{
	/* 決定 (OK) */
	if (Button == 1) {
		SelectChain2_OnlyOne (1);
		return 1;
	}
	/* 違う (NO) */
	if (Button == 2) {
		SelectChain2_OnlyOne (2);
		return 1;
	}
	/* やめた (Cancel) */
	if (Button == 4) {
		SelectChain2_OnlyOne (0);
		return 1;
	}
	return 0;
}



/* ---------------------------------------------------------
 * チェイン選択モード (Return)
 */
int MouseRet_ChainOne(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _(" Does it go to here? [Yes:(Left/RET)] [No:(Right/SPC)] [Cancel:(Center/ESC)]") );	
	StatusMsg(mstr);
	return 0;
}





/* -------------------------------------------------------
 * 作図モード 200 (Main)
 */
int MouseMode_Draw(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * 作図モード 200 (Return)
 */
int MouseRet_Draw(GtkWidget *widget, int Button, int x, int y)
{
	int Ret;
	char str[256], mstr[256];
	PLC_DLG plc_dlg;


	switch ( select_list_num() ) {
		/* セレクトデータ数 */
		case 0:
			if (OnlyOne_mode == 210) {
				sprintf(mstr, _(" Is it this diagram? [Yes:(Left/RET)] [No:(Right/SPC)] [Center:(Mid/ESC)]") );
			}
			else {
				sprintf(mstr, _(" [Drawing] Select the 1st diagram. (Select 0) ") );
			}
			StatusMsg(mstr);
			break;
		case 1:
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Drawing] Select the 2nd diagram. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, 
				_(" [Drawing] Select the diagram to create. (Select %d)  %s") , 
				(int) select_list_num(), 
				str);
			StatusMsg(mstr);


			plc_dlg.value = 0;
			plc_dlg.parent = MainWindow;
			plc_dlg.dialog = NULL;
			Ret = plcDialog(&plc_dlg);
			switch (plc_dlg.value) {
				/* キャンセル */
				case 0:
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* 全リストを削除 */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* 点コマンド */
				case 1:
					CreatePoint(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* 全リストを削除 */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* 線コマンド */
				case 2:
					CreateLine(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* 全リストを削除 */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* 円コマンド */
				case 3:
					CreateCircle(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* 全リストを削除 */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
			}
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 片方＆両方 トリムモード (Main)
 */
int MouseMode_Trim(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() < 2) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			}
			else if (select_list_num() == 2) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			}
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * 片方＆両方 トリムモード (Return)
 */
int MouseRet_Trim(GtkWidget *widget, int Button, int x, int y)
{
	char DumyStr[255], str[256], mstr[256];
	struct TrimDat Trim;
	int CE_frag = 0;


	if (mode == 220) sprintf(DumyStr, " ");
	else if (mode == 225) sprintf(DumyStr, _("two") );


	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Trim %s] Limit element (S%d)  %s") , 
				DumyStr, (int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 2:
					/* １個目が楕円なら */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* 楕円 */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* 楕円弧 */
						else {
							CE_frag = 2;
						}
					}



					/* 円と楕円じゃないなら */
					if (select_search_num(1)->select->diagram_point.cad_point->code != 4 && CE_frag != 4) {
						if (mode == 220)		Trim.Index = 1;
						else if (mode == 225)	Trim.Index = 2;

						/* １個目のデータ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ２個目のデータ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ピックした点のデータ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;

						if(TrimMain(&Trim) == 1) {
							/* 消去 */
							SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_ON);

							/* トリム後データの変更 */
							/* CAD *p_cad のデータの検索 */
							/* CAD Data を変更する、 Undo Baffer に書込む */
							undo_index_plus();

							if (select_search_num(1)->select->index == 16) {
								ellipse_list_edit_with_undo(
									ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
														   &ellipse_list_info), 
									&Trim.ellipse[1], 
									&ellipse_list_info);
							}
							else {
								cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							}

							if (mode == 225) {
								if (select_search_num(2)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(2)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[2], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[2], 
										&cad_list_info);
								}
							}

							/*作図 */
							SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
							mouse_select_frag.index = 0;
							mouse_select_frag.x = 0;
							mouse_select_frag.y = 0;
							mouse_select_frag.diagram_point.cad_point = NULL;
						}
						/* 全リストを削除 */
						select_list_all_free();
						/* メッセージ表示 */
						sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
						StatusMsg(mstr);
						break;
					}

					/* 円と楕円ならもう１個境界図形 */
					/* メッセージ表示 */
					DataInfo(select_list_info.tail->select, str);
					sprintf(mstr, _(" [Trim %s] Limit element (S%d)  %s") , 
						DumyStr, (int) select_list_num(), str);
					StatusMsg(mstr);
					break;



				case 3:
					/* １個目が楕円なら */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* 楕円 */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* 楕円弧 */
						else {
							CE_frag = 2;
						}
					}


					if (select_search_num(1)->select->diagram_point.cad_point->code == 4 || CE_frag == 4) {
						if (mode == 220) Trim.Index = 1;
						else if (mode == 225) Trim.Index = 2;

						/* １個目のデータ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ２個目のデータ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ３個目のデータ */
						if (select_search_num(3)->select->index == 16) {
							Trim.TraceData[3].code = 16;
							Trim.ellipse[3] = *(select_search_num(3)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[3].sa, 3) == 0 && sg(Trim.ellipse[3].ea, 3) == 360) {
								Trim.ellipse[3].code = 0;
							}
							else {
								Trim.ellipse[3].code = 1;
							}
						}
						else {
							Trim.TraceData[3] = *(select_search_num(3)->select->diagram_point.cad_point);
						}

						/* ピックした点のデータ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;
						Trim.PicX[3] = select_search_num(3)->select->x;
						Trim.PicY[3] = select_search_num(3)->select->y;

						if(TrimMain(&Trim) == 1) {
							/* 消去 */
							SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(3)->select, SCD_HIDE, UPDATE_ON);
							
							/* トリム後データの変更 */
							/* CAD *p_cad のデータの検索 */
							/* CAD Data を変更する、 Undo Baffer に書込む */
							undo_index_plus();

							if (select_search_num(1)->select->index == 16) {
								ellipse_list_edit_with_undo(
									ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
														   &ellipse_list_info), 
									&Trim.ellipse[1], 
									&ellipse_list_info);
							}
							else {
								cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							}

							if (mode == 225) {
								if (select_search_num(2)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(2)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[2], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[2], 
										&cad_list_info);
								}
							}

							if (mode == 225) {
								if (select_search_num(3)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(3)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[3], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(3)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[3], 
										&cad_list_info);
								}
							}

							/* 作図 */
							mouse_select_frag.index = 0;
							mouse_select_frag.x = 0;
							mouse_select_frag.y = 0;
							mouse_select_frag.diagram_point.cad_point = NULL;
							mouse_select_frag.diagram_point.dimension_point = NULL;

							SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
							SelectDraw(widget, select_search_num(3)->select, SCD_ORG, UPDATE_ON);
						}
						/* 全リストを削除 */
						select_list_all_free();
						/* メッセージ表示 */
						sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
						StatusMsg(mstr);
					}
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * 分割モード (Main)
 */
int MouseMode_Split(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 分割モード (Return)
 */
int MouseRet_Split(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];
	struct TrimDat Trim;
	int CE_frag = 0;


	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Divide] element") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Divide] Dividing point (S%d)  %s") , 
				(int)select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 2:
					/* １個目が楕円なら */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* 楕円 */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* 楕円弧 */
						else {
							CE_frag = 2;
						}
					}

					/* 円と楕円じゃないなら */
					if (select_search_num(1)->select->diagram_point.cad_point->code != 4 && CE_frag != 4) {
						/* １個目のデータ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ２個目のデータ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ピックした点のデータ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;
					}
					else return 0;


					if (Split(&Trim) == 1) {
						/* 消去 */
						SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_ON);

						undo_index_plus();

						/* ELLIPSE */
						if (select_search_num(1)->select->index == 16) {
							/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
							ellipse_list_edit_with_undo(
								ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
													   &ellipse_list_info), 
								&Trim.ellipse[1], 
								&ellipse_list_info);
							/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
							ellipse_list_add_first_with_undo(&Trim.ellipse[3], &ellipse_list_info);
							
#ifdef TEST
							g_print ("MouseRet_Split() : ellipse 0 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 select_search_num(1)->select->diagram_point.ellipse_point->cx, 
									 select_search_num(1)->select->diagram_point.ellipse_point->cy, 
									 select_search_num(1)->select->diagram_point.ellipse_point->dx, 
									 select_search_num(1)->select->diagram_point.ellipse_point->dy, 
									 select_search_num(1)->select->diagram_point.ellipse_point->k, 
									 select_search_num(1)->select->diagram_point.ellipse_point->sa, 
									 select_search_num(1)->select->diagram_point.ellipse_point->ea);
							g_print ("MouseRet_Split() : ellipse 1 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 Trim.ellipse[1].cx, Trim.ellipse[1].cy, 
									 Trim.ellipse[1].dx, Trim.ellipse[1].dy, 
									 Trim.ellipse[1].k, 
									 Trim.ellipse[1].sa, Trim.ellipse[1].ea);
							g_print ("MouseRet_Split() : ellipse 2 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 Trim.ellipse[3].cx, Trim.ellipse[3].cy, 
									 Trim.ellipse[3].dx, Trim.ellipse[3].dy, 
									 Trim.ellipse[3].k, 
									 Trim.ellipse[3].sa, Trim.ellipse[3].ea);
#endif
						}
						/* CAD */
						else {
							/* CAD Data を変更する、 Undo Baffer に書込む */
							cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
							cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);
						}

						/* 作図 */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						if (select_search_num(1)->select->index == 16) {
							EllipseDraw(widget, ellipse_list_info.head->ellipse, SCD_ORG);
						}
						else {
							SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
						}
						SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					}
					else {
						g_print ("MouseRet_Split() : Split 関数が0を返しました。\n");
						SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					}

					/* 全リストを削除 */
					select_list_all_free();
					/* メッセージ表示 */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * フィレットモード (Main)
 */
int MouseMode_Fillet(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 15);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * フィレットモード (Return)
 */
int MouseRet_Fillet(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct TrimDat Trim;

	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Fillet] Select the 1st element. (Select 0) ") );
			StatusMsg(mstr);
			break;

		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Fillet] Select the 2nd element. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 2:
					Trim.TraceData[1] = *select_search_num(1)->select->diagram_point.cad_point;
					Trim.TraceData[2] = *select_search_num(2)->select->diagram_point.cad_point;
					Trim.PicX[1] = select_search_num(1)->select->x;
					Trim.PicY[1] = select_search_num(1)->select->y;
					Trim.PicX[2] = select_search_num(2)->select->x;
					Trim.PicY[2] = select_search_num(2)->select->y;


					if (Fillet(&Trim, sagcad_system.FilletRC) == 1) {
						/* 消去 */
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_HIDE);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_HIDE);

						undo_index_plus();
						/* CAD Data を変更する、 Undo Baffer に書込む */
						//CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad);
						/* データの検索(CAD *p_cad から CAD_LIST を求める) */
						//CAD_LIST *cad_search_cad(CAD *p_cad);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[1], 
								&cad_list_info);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[2], 
								&cad_list_info);


						/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
						cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);

						/* 作図 */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
					}
					/* 全リストを削除 */
					select_list_all_free();
					/* メッセージ表示 */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * Ｃ面取りモード (Main)
 */
int MouseMode_Chamfering(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 15);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * Ｃ面取りモード (Return)
 */
int MouseRet_Chamfering(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct TrimDat Trim;

	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Chamfer] Select the 1st element. (Select 0) ") );
			StatusMsg(mstr);
			break;

		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Chamfer] Select the 2nd element. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 2:
					Trim.TraceData[1] = *select_search_num(1)->select->diagram_point.cad_point;
					Trim.TraceData[2] = *select_search_num(2)->select->diagram_point.cad_point;
					Trim.PicX[1] = select_search_num(1)->select->x;
					Trim.PicY[1] = select_search_num(1)->select->y;
					Trim.PicX[2] = select_search_num(2)->select->x;
					Trim.PicY[2] = select_search_num(2)->select->y;
					
					if(Fillet(&Trim, sagcad_system.FilletRC) == 1) {
						/* 消去 */
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_HIDE);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_HIDE);


						undo_index_plus();
						/* CAD Data を変更する、 Undo Baffer に書込む */
						//CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad);
						/* データの検索(CAD *p_cad から CAD_LIST を求める) */
						//CAD_LIST *cad_search_cad(CAD *p_cad);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[1], 
								&cad_list_info);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[2], 
								&cad_list_info);


						Trim.TraceData[3].code = 1;
						Trim.TraceData[3].cx = 0;
						Trim.TraceData[3].cy = 0;
						Trim.TraceData[3].r = 0;
						/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
						cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);

						/* 作図 */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
					}
					/* 全リストを削除 */
					select_list_all_free();
					/* メッセージ表示 */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 連続線モード (Main)
 */
int MouseMode_ContLine(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* 右ボタン */
		case 2:
			/* 全リストを削除 */
			if(select_list_info.head != NULL) SelectCadDraw(widget, select_list_info.head->select->diagram_point.cad_point, SCD_ORG);
			select_list_all_free();
			/* メッセージ表示 */
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 連続線モード (Return)
 */
int MouseRet_ContLine(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	CAD cad;

	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Continuation Line] Start point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Continuation Line] End point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 2:
					cad.layer = NowLayer;
					cad.style = NowStyle;
					cad.color = NowColor;
					cad.code = 1;
					cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx;
					cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy;
					cad.ex = select_search_num(2)->select->diagram_point.cad_point->sx;
					cad.ey = select_search_num(2)->select->diagram_point.cad_point->sy;
					cad.cx = 0;
					cad.cy = 0;
					cad.r = 0;

					undo_index_plus();
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);

					select_search_num(1)->select->diagram_point.cad_point = select_search_num(2)->select->diagram_point.cad_point;
					/* Select Data をリストから削除 */
					select_list_free(select_list_info.tail);
					/* メッセージ表示 */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * ３点で円 (Main)
 */
int MouseMode_3P_Circle(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ３点で円 (Return)
 */
int MouseRet_3P_Circle(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct RtnDat PPPCH;
	CAD cad;

	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Circle from three points] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three points] 2nd point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three points] 3rd point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 3:
					SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(3)->select->diagram_point.cad_point, SCD_ORG);

					PPPCH.sx[1]= select_search_num(1)->select->diagram_point.cad_point->sx;
					PPPCH.sy[1]= select_search_num(1)->select->diagram_point.cad_point->sy;
					PPPCH.sx[2]= select_search_num(2)->select->diagram_point.cad_point->sx;
					PPPCH.sy[2]= select_search_num(2)->select->diagram_point.cad_point->sy;
					PPPCH.sx[3]= select_search_num(3)->select->diagram_point.cad_point->sx;
					PPPCH.sy[3]= select_search_num(3)->select->diagram_point.cad_point->sy;
					pppc(&PPPCH);

					cad.layer = NowLayer;
					cad.style = NowStyle;
					cad.color = NowColor;
					cad.code = 4;
					cad.sx = 0;
					cad.sy = 0;
					cad.ex = 0;
					cad.ey = 0;
					cad.cx = PPPCH.cx[1];
					cad.cy = PPPCH.cy[1];
					cad.r =  PPPCH.r[1];

					undo_index_plus();
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);

					mouse_select_frag.index = 0;
					mouse_select_frag.x = 0;
					mouse_select_frag.y = 0;
					mouse_select_frag.diagram_point.cad_point = NULL;
					mouse_select_frag.diagram_point.dimension_point = NULL;
					/* 全リストを削除 */
					select_list_all_free();
					(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ３辺で円 (Main)
 */
int MouseMode_3L_Circle(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 2, 0);
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ３辺で円 (Return)
 */
int MouseRet_3L_Circle(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct RtnDat LLLCH;
	int Ret;


	/* セレクトデータ数 */
	switch ( select_list_num() ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Circle from three lines] 1st line") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three lines] 2nd line (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			/* メッセージ表示 */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three lines] 3rd line (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 3:
					SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(3)->select->diagram_point.cad_point, SCD_ORG);

					LLLCH.sx[1]= select_search_num(1)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[1]= select_search_num(1)->select->diagram_point.cad_point->sy;
					LLLCH.ex[1]= select_search_num(1)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[1]= select_search_num(1)->select->diagram_point.cad_point->ey;

					LLLCH.sx[2]= select_search_num(2)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[2]= select_search_num(2)->select->diagram_point.cad_point->sy;
					LLLCH.ex[2]= select_search_num(2)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[2]= select_search_num(2)->select->diagram_point.cad_point->ey;

					LLLCH.sx[3]= select_search_num(3)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[3]= select_search_num(3)->select->diagram_point.cad_point->sy; 
					LLLCH.ex[3]= select_search_num(3)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[3]= select_search_num(3)->select->diagram_point.cad_point->ey; 

					Ret = lllc(&LLLCH);

					if (LLLCH.type == 0) {
						if (Ret == 0)
							MsgBox("SagCAD", "Error", _("Three straight line is Parallel !") , NULL, NULL, "OK");
						else if (Ret == -1)
							MsgBox("SagCAD", "Error", _("One point of intersection !") , NULL, NULL, "OK");
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						/* 全リストを削除 */
						select_list_all_free();
						/* メッセージ表示 */
						(*ReturnFunc)(widget, Button, x, y);
						return 0;
					}
					if (LLLCH.type == 2) {
						OnlyOneCAD[1].code =	4;
						OnlyOneCAD[1].cx =		sg(LLLCH.cx[1], 6);
						OnlyOneCAD[1].cy =		sg(LLLCH.cy[1], 6);
						OnlyOneCAD[1].r =		sg(LLLCH.r[1], 6);
						
						OnlyOneCAD[2].code =	4;
						OnlyOneCAD[2].cx =		sg(LLLCH.cx[2], 6);
						OnlyOneCAD[2].cy =		sg(LLLCH.cy[2], 6);
						OnlyOneCAD[2].r =		sg(LLLCH.r[2], 6);
						
						OnlyOneIndex = 1;
						OnlyOneEntry = 2;
						OnlyOne_mode = 210;
						OnlyOne(3);
						return 1;
					}
					else if (LLLCH.type == 4) {
						OnlyOneCAD[1].code =	4;
						OnlyOneCAD[1].cx =		sg(LLLCH.cx[1], 6);
						OnlyOneCAD[1].cy =		sg(LLLCH.cy[1], 6);
						OnlyOneCAD[1].r =		sg(LLLCH.r[1], 6);
						
						OnlyOneCAD[2].code =	4;
						OnlyOneCAD[2].cx =		sg(LLLCH.cx[2], 6);
						OnlyOneCAD[2].cy =		sg(LLLCH.cy[2], 6);
						OnlyOneCAD[2].r =		sg(LLLCH.r[2], 6);
						
						OnlyOneCAD[3].code =	4;
						OnlyOneCAD[3].cx =		sg(LLLCH.cx[3], 6);
						OnlyOneCAD[3].cy =		sg(LLLCH.cy[3], 6);
						OnlyOneCAD[3].r =		sg(LLLCH.r[3], 6);
						
						OnlyOneCAD[4].code =	4;
						OnlyOneCAD[4].cx =		sg(LLLCH.cx[4], 6);
						OnlyOneCAD[4].cy =		sg(LLLCH.cy[4], 6);
						OnlyOneCAD[4].r =		sg(LLLCH.r[4], 6);
						
						OnlyOneIndex = 1;
						OnlyOneEntry = 4;
						OnlyOne_mode = 210;
						OnlyOne(3);
						return 1;
					}
					break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* ---------------------------------------------------------
 * 平行 (Main)
 */
int MouseMode_Parallel(GtkWidget *widget, int Button, int x, int y)
{
	COPY_DLG copy_dlg;
	char mstr[256];
	
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* 右ボタン */
		case 2:
			if (select_list_num() == CopyFrag) {
				sprintf(mstr, _(" [Parallel] Move/Copy Setting Dialog") );
				StatusMsg(mstr);
				
				/* COPY_DLG 構造体初期値設定 */
				copy_dlg.value = 0;
				copy_dlg.x_pitch = 0;
				copy_dlg.y_pitch = 0;
				copy_dlg.repeats = 1;
				copy_dlg.x_pitch_entry = NULL;
				copy_dlg.y_pitch_entry = NULL;
				copy_dlg.repeats_entry = NULL;
				copy_dlg.parent = MainWindow;
				copy_dlg.dialog = NULL;
				
				/* キーボード入力ダイアログ表示 */
				CopyDialog(&copy_dlg);
				if (copy_dlg.value != -1) {
					CopyPara(copy_dlg.x_pitch, copy_dlg.y_pitch, copy_dlg.repeats);
				}
				
				/* mode を選択モード 300 に */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* メッセージ表示 */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* ---------------------------------------------------------
 * 平行 (Return)
 */
int MouseRet_Parallel(GtkWidget *widget, int Button, int x, int y)
{
	COPY_DLG copy_dlg;
	char mstr[256];
//	int Repeat;
	double sx1, sy1, sx2, sy2;
	
	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* メッセージ表示 */
				sprintf(mstr, _(" [Parallel] Left:Start point / Right:Show setting dialog.") );
				StatusMsg(mstr);
				return 1;
			}
			
			if (select_list_num() == CopyFrag + 1) {
				/* メッセージ表示 */
				sprintf(mstr, _(" [Parallel] Start point") );
				StatusMsg(mstr);
				return 1;
			}
			
			if (select_list_num() == CopyFrag + 2) {
				/* クリック点をオリジナル表示 */
				SelectCadDraw(widget, select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, SCD_ORG);
				SelectCadDraw(widget, select_search_num(CopyFrag + 2)->select->diagram_point.cad_point, SCD_ORG);
				
				sx1 = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				sy1 = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;
				sx2 = select_search_num(CopyFrag + 2)->select->diagram_point.cad_point->sx;
				sy2 = select_search_num(CopyFrag + 2)->select->diagram_point.cad_point->sy;
				
				/* COPY_DLG 構造体初期値設定 */
				copy_dlg.value = 1;
				copy_dlg.x_pitch = sx2 - sx1;
				copy_dlg.y_pitch = sy2 - sy1;
				copy_dlg.repeats = 1;
				copy_dlg.x_pitch_entry = NULL;
				copy_dlg.y_pitch_entry = NULL;
				copy_dlg.repeats_entry = NULL;
				copy_dlg.parent = MainWindow;
				copy_dlg.dialog = NULL;
				
				/* Select Data をリストから削除 */
				select_list_free(select_list_info.tail);
				select_list_free(select_list_info.tail);
				
				/* キーボード入力ダイアログ表示 */
				CopyDialog(&copy_dlg);
				if (copy_dlg.value != -1) {
					CopyPara(copy_dlg.x_pitch, copy_dlg.y_pitch, copy_dlg.repeats);
				}
				
				/* mode を選択モード 300 に */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* メッセージ表示 */
				(*ReturnFunc)(widget, Button, x, y);
				return 1;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * 回転移動 (Main)
 */
int MouseMode_Turn(GtkWidget *widget, int Button, int x, int y)
{
	TURN_DLG turn_dlg;
	char mstr[256];

	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* 右ボタン */
		case 2:
			if (select_list_num() == CopyFrag) {
				sprintf(mstr, _(" [Rotate] Move/Copy Setting Dialog") );
				StatusMsg(mstr);
				
				/* TurnDialog */
				turn_dlg.value = 1;
				turn_dlg.x_pos = 0;
				turn_dlg.y_pos = 0;
				turn_dlg.angle = 0;
				turn_dlg.repeats = 1;
				turn_dlg.x_pos_entry = NULL;
				turn_dlg.y_pos_entry = NULL;
				turn_dlg.angle_entry = NULL;
				turn_dlg.repeats_entry = NULL;
				turn_dlg.parent = MainWindow;
				turn_dlg.dialog = NULL;
				
				//g_print("TurnDialog() : START !\n");
				TurnDialog(&turn_dlg);
				//g_print("TurnDialog() : END !\n");
				if (turn_dlg.value != -1) {
					CopyRoll(turn_dlg.x_pos, turn_dlg.y_pos, turn_dlg.angle, turn_dlg.repeats);
				}
				
				/* mode を選択モード 300 に */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* メッセージ表示 */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 回転移動 (Return)
 */
int MouseRet_Turn(GtkWidget *widget, int Button, int x, int y)
{
	TURN_DLG turn_dlg;
	char mstr[256];

	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* メッセージ表示 */
				sprintf(mstr, 
					_(" [Rotate] Left:Rotate center point / Right:Show setting dialog.") );
				StatusMsg(mstr);
			}
			
			if (select_list_num() == CopyFrag + 1) {
				/** クリック点をオリジナル表示 **/
				SelectCadDraw(widget, select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, SCD_ORG);
				
				turn_dlg.x_pos = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				turn_dlg.y_pos = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;
				
				/* Select Data をリストから削除 */
				select_list_free(select_list_info.tail);
				
				/* TurnDialog */
				turn_dlg.value = 1;
				turn_dlg.angle = 0;
				turn_dlg.repeats = 1;
				turn_dlg.x_pos_entry = NULL;
				turn_dlg.y_pos_entry = NULL;
				turn_dlg.angle_entry = NULL;
				turn_dlg.repeats_entry = NULL;
				turn_dlg.parent = MainWindow;
				turn_dlg.dialog = NULL;
				
				TurnDialog(&turn_dlg);
				if (turn_dlg.value != -1) {
					CopyRoll(turn_dlg.x_pos, turn_dlg.y_pos, turn_dlg.angle, turn_dlg.repeats);
				}
				
				/* mode を選択モード 300 に */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* メッセージ表示 */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 対称移動 (Main)
 */
int MouseMode_Mirror(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 2, 1);
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 対称移動 (Return)
 */
int MouseRet_Mirror(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	int Ret, Repeat;
	double sx, sy, ex, ey;

	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* メッセージ表示 */
				sprintf(mstr, 
					_(" [Mirror] Mirror axis line") );
				StatusMsg(mstr);
			}

			if (select_list_num() == CopyFrag + 1) {
				while (1) {
					/* 数値入力ダイアログボックス表示 */
					strcpy(str, "");
					Ret = InputBox( _("Mirror mode setting") , _("1 : Move") , _("2 : Copy") , str);
					if (Ret != -1) {
						Repeat = atoi(str);
						if (Repeat != 1 && Repeat != 2) {
							MsgBox("SagCAD", "Error", _("1 or 2") , NULL, NULL, "OK");
						}
						else {
							break;
						}
					}
					else {
						/* mode を選択モード 300 に */
						ReturnFunc = MouseRet_Select;
						DcObj = 15;
						mode = 300;
						/* メッセージ表示 */
						(*ReturnFunc)(widget, Button, x, y);
						return 0;
					}
				}

				/* クリック点をオリジナル表示 */
				SelectCadDraw(widget, 
							select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, 
							SCD_ORG);
				sx = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				sy = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;
				ex = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->ex;
				ey = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->ey;

				/* Select Data をリストから削除 */
				select_list_free(select_list_info.tail);

				CopyMirr(sx, sy, ex, ey, Repeat);

				/* mode を選択モード 300 に */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* メッセージ表示 */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 部品図読込 (Main)
 */
int MouseMode_PartsRead(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * 部品図読込 (Return)
 */
int MouseRet_PartsRead(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	/* コマンドラインに表示 */
	sprintf(mstr, _(" [Part Insert] Read point") );
	StatusMsg(mstr);


	if (select_list_num() == 1) {
		/* 座標データ */
		if (select_search_num(1)->select->index == 1) {
			if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
				ReadPartsFileNameGet(PartsFile, 
									 select_list_info.head->select->x, 
									 select_list_info.head->select->y);
			}
			else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
				DxfFileOpen(PartsFile, select_list_info.head->select->x, select_list_info.head->select->y);
			}
		}
		/* 点データ */
		else if (select_search_num(1)->select->index == 2) {
			if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
				if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
					ReadPartsFileNameGet(PartsFile, 
										 select_search_num(1)->select->diagram_point.cad_point->sx, 
										 select_search_num(1)->select->diagram_point.cad_point->sy
										 );
				}
				else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
					DxfFileOpen(PartsFile, 
								select_search_num(1)->select->diagram_point.cad_point->sx, 
								select_search_num(1)->select->diagram_point.cad_point->sy
								);
				}
			}
		}
		SelectCancel(drawing_area);
		/* mode を選択モード 300 に */
		ReturnFunc = MouseRet_Select;
		DcObj = 15;
		mode = 300;
		/* メッセージ表示 */
		(*ReturnFunc)(widget, Button, x, y);
		Redraw();
	}

	return 0;
}





int PicPointCheck(GtkWidget *widget, int Button, int x, int y, int n)
{
	if (
		PicPoint.X[n-1] == select_search_num(n)->select->x 
		&& 
		PicPoint.Y[n-1] == select_search_num(n)->select->y 
		) 
	{
		select_last_cansel();
		(*ReturnFunc)(widget, Button, x, y);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * 水平Ｘ寸法 モード (Main)
 * 510
 */
int MouseMode_DimensionX(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 水平Ｘ寸法 モード (Return)
 */
int MouseRet_DimensionX(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		/* セレクトデータ数 */
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Horizontal Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			sprintf(mstr, " [Horizontal Dimension] 2nd point");
			StatusMsg(mstr);
			PointDraw(drawing_area, 
					  select_search_num(1)->select->x, 
					  select_search_num(1)->select->y, 
					  1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Horizontal Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, 
						  select_search_num(2)->select->x, 
						  select_search_num(2)->select->y, 
						  1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			/* メッセージ表示 */
			sprintf(mstr, _(" [Horizontal Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);

			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_X_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 水平Ｙ寸法 モード (Main)
 */
int MouseMode_DimensionY(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 水平Ｙ寸法 モード (Return)
 */
int MouseRet_DimensionY(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		/* セレクトデータ数 */
		case 0:
			sprintf(mstr, _(" [Vertical Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Vertical Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Vertical Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, 
						  select_search_num(2)->select->x, select_search_num(2)->select->y, 
						  1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			sprintf(mstr, _(" [Vertical Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, 
					  select_search_num(1)->select->x, select_search_num(1)->select->y, 
					  1, sagcad_color.Back);
			PointDraw(drawing_area, 
					  select_search_num(2)->select->x, select_search_num(2)->select->y, 
					  1, sagcad_color.Back);
			UpDate();

			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_Y_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			Dim_now.Type = 20;

			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 距離寸法 モード (Main)
 */
int MouseMode_DimensionP(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;

		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* 中ボタン */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 距離寸法 モード (Return)
 */
int MouseRet_DimensionP(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		case 0:
			sprintf(mstr, _(" [Distance Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Distance Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
			
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Distance Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
			
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			sprintf(mstr, _(" [Distance Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);
			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_P_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			Dim_now.Type = 30;

			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 半径寸法 モード (Main)
 */
int MouseMode_DimensionR(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 0:
					MouseSelect(widget, ToViewX(x), ToViewY(y), 12, 1);
					break;
				case 1:
					MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
					break;
			}
			break;

		/* 右ボタン */
		case 2:
			if(select_list_num() == 1)
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 半径寸法 モード (Return)
 */
int MouseRet_DimensionR(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];
	struct RtnDat ISAEAH;


	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Radius Dimansion] circle or arc") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Radius Dimansion] What place ?") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_SELECT);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
			PicPoint.Y[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
			PicPoint.X[3] = select_search_num(1)->select->diagram_point.cad_point->r;
			if (select_search_num(1)->select->diagram_point.cad_point->code == 2) {
				iSaEa(cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), &ISAEAH);
				PicPoint.X[4] = ISAEAH.sx[1];
				PicPoint.Y[4] = ISAEAH.sy[1];
			}
			else if (select_search_num(1)->select->diagram_point.cad_point->code == 4) {
				PicPoint.X[4] = 0;
				PicPoint.Y[4] = 360;
			}
			break;
		case 2:
			Dimension_R_Culc(&Dim_now, PicPoint);
			if (Dim_now.AssistLine != NULL) {
				sprintf(mstr, _(" [Radius Dimansion] circle or arc") );
				StatusMsg(mstr);
				SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
				DimensionDraw(widget, &Dim_now, SCD_HIDE);
//				Dim_now.FontType = sagcad_dimension.font_Type;
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				UpDate();
				/* 寸法 追加 */
				undo_index_plus();
				dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
				Dim_old.Text[0] = '\0';
				Dim_now.diagram_of_char_index = 0;
				Dim_now.diagram_of_char = NULL;
				Dim_now.AssistLine = NULL;
				/* 全リストを削除 */
				select_list_all_free();
//				Dim_now.FontType = 1;
			}
			else {
				select_list_free(select_list_info.tail);
				sprintf(mstr, _(" [Radius Dimansion] What place ?") );
				StatusMsg(mstr);
			}
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 直径寸法 モード (Main)
 */
int MouseMode_DimensionD(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			switch ( select_list_num() ) {
				/* セレクトデータ数 */
				case 0:
					MouseSelect(widget, ToViewX(x), ToViewY(y), 12, 1);
					break;
				case 1:
					MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
					break;
			}
			break;

		/* 右ボタン */
		case 2:
			if(select_list_num() == 1)
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 直径寸法 モード (Return)
 */
int MouseRet_DimensionD(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Diameter Dimension] circle or arc") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Diameter Dimension] What place ?") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_SELECT);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
			PicPoint.Y[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
			PicPoint.X[6] = select_search_num(1)->select->diagram_point.cad_point->r;
			break;
		case 2:
			sprintf(mstr, _(" [Diameter Dimension] circle or arc") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			Dimension_D_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 角度寸法 モード (Main)
 */
int MouseMode_DimensionA(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 角度寸法 モード (Return)
 */
int MouseRet_DimensionA(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Angle Dimension] Center point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Angle Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
			
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;
			sprintf(mstr, _(" [Angle Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			break;
			
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Angle Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, select_search_num(3)->select->x, select_search_num(3)->select->y, 1, sagcad_color.Select);
				UpDate();

				PicPoint.X[3] = select_search_num(3)->select->x;
				PicPoint.Y[3] = select_search_num(3)->select->y;
			}
			break;
			
		case 4:
			if (PicPointCheck(widget, Button, x, y, 4)) break;
			sprintf(mstr, _(" [Angle Dimension] Center point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(3)->select->x, select_search_num(3)->select->y, 1, sagcad_color.Back);

			PicPoint.X[4] = select_search_num(4)->select->x;
			PicPoint.Y[4] = select_search_num(4)->select->y;
			Dimension_A_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 座標寸法 モード (Main)
 */
int MouseMode_DimensionPT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 座標寸法 モード (Return)
 */
int MouseRet_DimensionPT(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		/* セレクトデータ数 */
		case 0:
			sprintf(mstr, _(" [Coordinates Dimension] point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Coordinates Dimension] What place ?") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();
			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;
			sprintf(mstr, _(" [Coordinates Dimension] point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			Dimension_PT_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 引出線寸法 モード (Main)
 */
int MouseMode_DimensionHD(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 引出線寸法 モード (Return)
 */
int MouseRet_DimensionHD(GtkWidget *widget, int Button, int x, int y)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];

	switch ( select_list_num() ) {
		/* セレクトデータ数 */
		case 0:
			sprintf(mstr, _(" [Drawer Line Dimension] The tip of the arrow") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Drawer Line Dimension] To what place") );
			StatusMsg(mstr);

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[3] = 0;
			PicPoint.Y[3] = 0;
			break;
		case 2:
			sprintf(mstr, _(" [Drawer Line Dimension] What place ?") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			break;

		case 3:
			sprintf(mstr, _(" [Drawer Line Dimension] The tip of the arrow") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_HD_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = sagcad_dimension.font_Type;



			/* コマンドラインに表示 */
			sprintf(mstr, _(" [Drawer Line Dimension] Setting dialog") );
			StatusMsg(mstr);


			/* TextEditDialog */
			strcpy(a.Text, "");
			strcpy(a.UpperText, "");
			strcpy(a.LowerText, "");

			a.FontHeight = sagcad_dimension.Font_height;
			scale = a.FontHeight / 9;
			a.FontSpace = sagcad_dimension.Font_space * scale;
			a.WordSpace = sagcad_dimension.Word_space * scale;
			a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

			a.Angle = 0;
			a.SearchPointX = 0;
			a.SearchPointY = 0;
			a.FitPointX = 0;
			a.FitPointY = 1;


			a.entry_Text = NULL;
			a.entry_UpperText = NULL;
			a.entry_LowerText = NULL;

			a.entry_FontHeight = NULL;
			a.entry_FontSpace = NULL;
			a.entry_WordSpace = NULL;
			a.entry_FontOverLineSpace = NULL;
			a.entry_SearchPointX = NULL;
			a.entry_SearchPointY = NULL;
			a.entry_Angle = NULL;
			a.entry_FitPointX = NULL;
			a.entry_FitPointY = NULL;

			a.parent = MainWindow;
			a.dialog = NULL;

			TextEditDialog(&a);
			if (a.FontHeight == 0) {
				SelectCancel(drawing_area);
				mode = 0;
				return 0;
			}

			strcpy(Dim_now.Text, a.Text);
			strcpy(Dim_now.UpperText, a.UpperText);
			strcpy(Dim_now.LowerText, a.LowerText);
			Dim_now.FontHeight = a.FontHeight;
			Dim_now.FontSpace = a.FontSpace;
			Dim_now.WordSpace = a.WordSpace;
			Dim_now.FontOverLineSpace = a.FontOverLineSpace;


			ReturnFunc = MouseRet_DimensionHD;
			DcObj = 113;
			Dim_now.Type = 80;
			Dim_now.Layer = NowLayer;
			Dim_now.text_color = sagcad_color.Dimension;
			Dim_now.Assist_color = sagcad_color.Dimension;

			Dim_now.FontType = sagcad_dimension.font_Type;
			Dim_now.DrawType = DRAW_REAL;
			Dim_old.Text[0] = '\0';
			
			Dim_now.start.x = 0;
			Dim_now.start.y = 0;
			Dim_now.end.x = 0;
			Dim_now.end.y = 0;

			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.index = 0;
			Dim_now.AssistLine = NULL;
			mode = 580;
			(*ReturnFunc)(drawing_area, 1, 0, 0);
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * 注釈寸法 モード (Main)
 */
int MouseMode_DimensionAT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* 右ボタン */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * 注釈寸法 モード (Return)
 */
int MouseRet_DimensionAT(GtkWidget *widget, int Button, int x, int y)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];

	switch ( select_list_num() ) {
		case 1:
			sprintf(mstr, _(" [String] What place ?") );
			StatusMsg(mstr);
			Dim_now.SearchPointX = select_search_num(1)->select->x;
			Dim_now.SearchPointY = select_search_num(1)->select->y;
			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			UpDate();
			/* 寸法 追加 */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* 全リストを削除 */
			select_list_all_free();
//			Dim_now.FontType = 1;


			/* コマンドラインに表示 */
			sprintf(mstr, _(" [String] Input string") );
			StatusMsg(mstr);


			/* TextEditDialog */
			strcpy(a.Text, "");
			strcpy(a.UpperText, "");
			strcpy(a.LowerText, "");

			a.FontHeight = sagcad_dimension.Font_height;
			scale = a.FontHeight / 9;
			a.FontSpace = sagcad_dimension.Font_space * scale;
			a.WordSpace = sagcad_dimension.Word_space * scale;
			a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

			a.Angle = 0;
			a.SearchPointX = 0;
			a.SearchPointY = 0;
			a.FitPointX = 0;
			a.FitPointY = 1;


			a.entry_Text = NULL;
			a.entry_UpperText = NULL;
			a.entry_LowerText = NULL;

			a.entry_FontHeight = NULL;
			a.entry_FontSpace = NULL;
			a.entry_WordSpace = NULL;
			a.entry_FontOverLineSpace = NULL;
			a.entry_SearchPointX = NULL;
			a.entry_SearchPointY = NULL;
			a.entry_Angle = NULL;
			a.entry_FitPointX = NULL;
			a.entry_FitPointY = NULL;

			a.parent = MainWindow;
			a.dialog = NULL;

			TextEditDialog(&a);
			if (a.FontHeight == 0) {
				SelectCancel(drawing_area);
				mode = 0;
				return 0;
			}

			strcpy(Dim_now.Text, a.Text);
			strcpy(Dim_now.UpperText, a.UpperText);
			strcpy(Dim_now.LowerText, a.LowerText);
			Dim_now.FontHeight = a.FontHeight;
			Dim_now.FontSpace = a.FontSpace;
			Dim_now.WordSpace = a.WordSpace;
			Dim_now.FontOverLineSpace = a.FontOverLineSpace;


			ReturnFunc = MouseRet_DimensionAT;
			DcObj = 113;
			Dim_now.Type = 90;
			Dim_now.Layer = NowLayer;
			Dim_now.text_color = sagcad_color.Dimension;
			Dim_now.Assist_color = sagcad_color.Dimension;

			Dim_now.FontType = sagcad_dimension.font_Type;
			Dim_now.DrawType = DRAW_REAL;
			Dim_old.Text[0] = '\0';
			
			Dim_now.start.x = 0;
			Dim_now.start.y = 0;
			Dim_now.end.x = 0;
			Dim_now.end.y = 0;

			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.index = 0;
			Dim_now.AssistLine = NULL;
			mode = 590;
			(*ReturnFunc)(drawing_area, 1, 0, 0);


			/* コマンドラインに表示 */
			sprintf(mstr, _(" [String] What place ?") );
			StatusMsg(mstr);
			break;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 寸法 & テキスト 編集 モード(Main)
 */
int MouseMode_DimensionEDT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 256, 1);
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 寸法 & テキスト 編集 モード(Return)
 */
int MouseRet_DimensionEDT(GtkWidget *widget, int Button, int x, int y)
{
	TEXT_EDIT_DLG a;
	DIMENSION *dp, d;
	char mstr[256];


	if ( select_list_info.head != NULL 
		&& select_list_info.head->select->index == 3 
			&& select_list_info.head->select->diagram_point.dimension_point != NULL) 
	{
		sprintf(mstr, _(" [Edit Dimension] Edit text") );
		StatusMsg(mstr);

		/* TextEditDialog */
		dp = select_list_info.head->select->diagram_point.dimension_point;
		strcpy(a.Text, dp->Text);
		strcpy(a.UpperText, dp->UpperText);
		strcpy(a.LowerText, dp->LowerText);

		a.FontHeight = dp->FontHeight;
		a.FontSpace = dp->FontSpace;
		a.WordSpace = dp->WordSpace;
		a.FontOverLineSpace = dp->FontOverLineSpace;

		a.Angle = dp->Angle;
		a.SearchPointX = dp->SearchPointX;
		a.SearchPointY = dp->SearchPointY;
		a.FitPointX = dp->FitPointX;
		a.FitPointY = dp->FitPointY;


		a.entry_Text = NULL;
		a.entry_UpperText = NULL;
		a.entry_LowerText = NULL;

		a.entry_FontHeight = NULL;
		a.entry_FontSpace = NULL;
		a.entry_WordSpace = NULL;
		a.entry_FontOverLineSpace = NULL;
		a.entry_SearchPointX = NULL;
		a.entry_SearchPointY = NULL;
		a.entry_Angle = NULL;
		a.entry_FitPointX = NULL;
		a.entry_FitPointY = NULL;

		a.parent = MainWindow;
		a.dialog = NULL;

		TextEditDialog(&a);
		if (a.FontHeight == 0) {
			SelectCancel(drawing_area);
			mode = 0;
			return 0;
		}

		d.Layer = dp->Layer;
		d.text_color = dp->text_color;
		d.Assist_color = dp->Assist_color;
		d.Type = dp->Type;
		d.DrawType = dp->DrawType;

		strcpy(d.Text, a.Text);
		strcpy(d.UpperText, a.UpperText);
		strcpy(d.LowerText, a.LowerText);

		d.FontType = dp->FontType;
		strcpy(d.FontName, dp->FontName);

		d.FontHeight = a.FontHeight;
		d.FontSpace = a.FontSpace;
		d.WordSpace = a.WordSpace;
		d.FontOverLineSpace = a.FontOverLineSpace;

		d.Angle = a.Angle;
		d.SearchPointX = a.SearchPointX;
		d.SearchPointY = a.SearchPointY;
		d.StartPoint = dp->StartPoint;
		d.FitPointX = a.FitPointX;
		d.FitPointY = a.FitPointY;

		
		xfree(dp->diagram_of_char);
		dp->diagram_of_char_index = 0;
		dp->diagram_of_char = NULL;

		d.diagram_of_char_index = 0;
		d.diagram_of_char = NULL;
		d.index = dp->index;
		d.AssistLine = dp->AssistLine;

		SelectDraw(widget, select_list_info.head->select, SCD_HIDE, UPDATE_OFF);
		undo_index_plus();
		dimension_list_edit_with_undo(dimension_search_dimension(dp, &dimension_list_info), &d, &dimension_list_info);
		SelectDraw(widget, select_list_info.head->select, SCD_ORG, UPDATE_ON);


	}
	/* 全リストを削除 */
	select_list_all_free();
	sprintf(mstr, _(" [Edit Dimension] Dimension element"));
	StatusMsg(mstr);
	return 1;
}





/* -------------------------------------------------------------------
 * ポリラインモード (Main)
 */
int MouseMode_PolyLine(GtkWidget *widget, int Button, int x, int y)
{
	SELECT_LIST *slp;
	POLYLINE polyline;
	POLYLINE_LIST *pllp;
	VERTEX vertex;
	long n, i;
	char str[256];
	int Ret;


	switch (Button) {
		/* 左ボタン */
		case 1:
			/* 点 */
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* 右ボタン */
		case 2:
			/* 任意点 */
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			break;
		/* 中ボタン */
		case 4:
			/* 終了 */
			n = select_list_num();
			if (n > 2) {
				/* -----------------------------------------------------------------
				 * 選択図形
				 */
				i = 0;
				slp = select_list_info.head;
				/* -------------------------------------------
				 * 最後まで見つからない場合、 p に NULL が 
				 * 入ってループを抜ける。
				 */
				polyline.vertex_list_info.head = NULL;
				polyline.vertex_list_info.tail = NULL;

				while (slp != NULL) {
					/* 任意点 */
					if (slp->select->index == 1) {
						vertex.x = slp->select->x;
						vertex.y = slp->select->y;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
					}

					/* 点 */
					else if (   (slp->select->index == 2 || slp->select->index == 4) 
								&& 
								(slp->select->diagram_point.cad_point != NULL)   )
					{
						vertex.x = slp->select->diagram_point.cad_point->sx;
						vertex.y = slp->select->diagram_point.cad_point->sy;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
					}

					/* その他 */
					else {
						//
					}

					slp = slp->next;	/* ポインタを次のデータに移す */
				}

				/* 曲線タイプ 入力*/
				/* 数値入力ダイアログボックス表示 */
				strcpy(str, "");
				Ret = CulcInputBox(MainWindow, _("Curve Setting") , _("0:broken line (open)  1:broken line (close)") , 
								   _("2:open spline  3:close spline  4:B-spline") , str);
				if (Ret == -1) {
					/* 全リストを削除 */
					select_list_all_free();
					/* メッセージ表示 */
					(*ReturnFunc)(widget, Button, x, y);
					return 0;
				}

				/* 折れ線 */
				if (atoi(str) == 0) {
					polyline.code = 8;
					polyline.frag = 0;
				}
				/* 折れ線(閉) */
				else if (atoi(str) == 1) {
					polyline.code = 8;
					polyline.frag = 1;
				}
				/* スプライン補間 */
				else if (atoi(str) == 2) {
					polyline.code = 16;
					polyline.frag = 0;
				}
				/* スプライン補間(閉) */
				else if (atoi(str) == 3) {
					polyline.code = 16;
					polyline.frag = 1;
				}
				/* Ｂスプライン曲線 */
				else if (atoi(str) == 4) {
					polyline.code = 32;
					polyline.frag = 0;
				}
				/* 曲線を登録 */
				polyline.layer = NowLayer;
				polyline.style = 1;
				polyline.color = NowColor;
				polyline.pitch = 0.05;
				polyline.split = 7;
				polyline.index = vertex_list_num(&polyline.vertex_list_info);
				/* POLYLINE Data をリストの最後に追加 */
				undo_index_plus();
				pllp = polyline_list_add_first_with_undo(&polyline, &polyline_list_info);

				PolyLineDraw(widget, pllp->polyline, SCD_ORG);
			}
			/* 全リストを削除 */
			select_list_all_free();
			/* メッセージ表示 */
			(*ReturnFunc)(widget, Button, x, y);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ポリラインモードモード (Return)
 */
int MouseRet_PolyLine(GtkWidget *widget, int Button, int x, int y)
{
//char str[256];
	char mstr[256];
	long n;



	n = select_list_num();
	/* セレクトデータ数 */
	switch ( n ) {
		case 0:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Polyline] Start point (End : Center Button)") );
			StatusMsg(mstr);
			break;
		case 1:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Polyline] 2nd point (End : Center Button) (S %d)") , (int) n);
			StatusMsg(mstr);
			break;
		case 2:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Polyline] 3rd point (End : Center Button) (S %d)") , (int) n);
			StatusMsg(mstr);
			break;
		default:
			/* メッセージ表示 */
			sprintf(mstr, _(" [Polyline] %d point (End : Center Button) (S %d)") , 
				(int) n, (int) n);
			StatusMsg(mstr);
			break;
	}


	/* 始点は点だけ表示 */
	if (n == 1) {
		if (select_list_info.tail->select->index == 1) {
			PointDraw(widget, select_search_num(n)->select->x, select_search_num(n)->select->y, 1, 0x0000ff);
		}
		else if (	select_list_info.tail->select->index == 2 
					|| 
					select_list_info.tail->select->index == 4
				) 
		{
			SelectCadDraw(widget, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);
		}
	}
	/* ２点目以降は、点と線を表示 */
	else if (n > 1) {
		if (select_list_info.tail->select->index == 1) {
			PointDraw(	widget, 
						select_list_info.tail->select->x, 
						select_list_info.tail->select->y, 1, 0x0000ff);

			if (select_search_num(n-1)->select->index == 1) {
				LineDraw(	widget, 
							select_search_num(n-1)->select->x, 
							select_search_num(n-1)->select->y, 
							select_list_info.tail->select->x, 
							select_list_info.tail->select->y, 
							1, 
							NowColor);
			}
			else if (	select_search_num(n-1)->select->index == 2 
						|| 
						select_search_num(n-1)->select->index == 4) 
			{
				LineDraw(	widget, 
							select_search_num(n-1)->select->diagram_point.cad_point->sx, 
							select_search_num(n-1)->select->diagram_point.cad_point->sy, 
							select_list_info.tail->select->x, 
							select_list_info.tail->select->y, 
							1, 
							NowColor);
			}
		}

		else if (	select_list_info.tail->select->index == 2 
					|| 
					select_list_info.tail->select->index == 4
				) 
		{
			SelectCadDraw(widget, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);

			if (select_search_num(n-1)->select->index == 1) {
				LineDraw(	widget, 
							select_search_num(n-1)->select->x, 
							select_search_num(n-1)->select->y, 
							select_list_info.tail->select->diagram_point.cad_point->sx, 
							select_list_info.tail->select->diagram_point.cad_point->sy, 
							1, 
							NowColor);
			}
			else if (	select_search_num(n-1)->select->index == 2 
						|| 
						select_search_num(n-1)->select->index == 4) 
			{
				LineDraw(	widget, 
							select_search_num(n-1)->select->diagram_point.cad_point->sx, 
							select_search_num(n-1)->select->diagram_point.cad_point->sy, 
							select_list_info.tail->select->diagram_point.cad_point->sx, 
							select_list_info.tail->select->diagram_point.cad_point->sy, 
							1, 
							NowColor);
			}
		}
	}
	UpDate();
	return 0;
}





/* -------------------------------------------------------------------
 * ＣＡＭ 始点設定 (Main)
 */
int MouseMode_CamProfile(GtkWidget *widget, int Button, int x, int y)
{
	CAM_SET_DLG cam_set_dlg;
	SELECT *select = NULL;
	CAD *cad;
	static int frag = 2; /* 2:正転	4:反転 */
	CAM_ENV CamProperty;


	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 2);
			}
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);
				UpDate();

				select = select_search_cad(cad)->select;
				select_search_cad(cad)->select = select_list_info.head->select;
				select_list_info.head->select = select;


				/* 初期設定 */
//				cam_set_dlg.CamCheck = sagcad_cam.CamCheck;
				cam_set_dlg.AbsInc = sagcad_cam.AbsInc;
				cam_set_dlg.Modal = sagcad_cam.Modal;
				cam_set_dlg.RIJ = sagcad_cam.RIJ;
				cam_set_dlg.Heel = sagcad_cam.Heel;
				cam_set_dlg.start_str = NULL;
				cam_set_dlg.end_str = NULL;

				cam_set_dlg.value = 0;
				cam_set_dlg.toggle_frag = 0;

				cam_set_dlg.abs_check = NULL;
				cam_set_dlg.inc_check = NULL;
				cam_set_dlg.r_check = NULL;
				cam_set_dlg.ij_check = NULL;
				cam_set_dlg.modal_off_check = NULL;
				cam_set_dlg.modal_on_check = NULL;
				cam_set_dlg.start_text = NULL;
				cam_set_dlg.end_text = NULL;
				cam_set_dlg.parent = MainWindow;
				cam_set_dlg.dialog = NULL;


				CamSetDialog(&cam_set_dlg);

				if (cam_set_dlg.value == 0) {
					// g_print("Cancel されました\n");
					return 0;
				}
#ifdef TEST
				else {
					g_print ("AbsInc = %d   Modal = %d   RIJ = %d   Heel = %d\n", 
							 cam_set_dlg.AbsInc, 
							 cam_set_dlg.Modal, 
							 cam_set_dlg.RIJ, 
							 cam_set_dlg.Heel 
							);
				}
#endif


//#ifdef TEST
				CamDataRead(frag);

				CamProperty.CamCheck = 1;
				CamProperty.AbsInc = cam_set_dlg.AbsInc;
				CamProperty.Modal = cam_set_dlg.Modal;
				CamProperty.RIJ = cam_set_dlg.RIJ;
				CamProperty.Heel = cam_set_dlg.Heel;
				if (cam_set_dlg.start_str != NULL) {
					strcpy(CamProperty.StartStr, cam_set_dlg.start_str);
					//g_print ("Start Code\n%s\n", cam_set_dlg.start_str);
					g_free(cam_set_dlg.start_str);
					cam_set_dlg.start_str = NULL;
				}
				else {
					CamProperty.StartStr[0] = '\0';
				}
				if (cam_set_dlg.end_str != NULL) {
					strcpy(CamProperty.EndStr, cam_set_dlg.end_str);
					//g_print ("End Code\n%s\n", cam_set_dlg.end_str);
					g_free(cam_set_dlg.end_str);
					cam_set_dlg.end_str = NULL;
				}
				else {
					CamProperty.EndStr[0] = '\0';
				}

				if ( Hitohude(CamProperty.CamCheck) != 0 ) {
					NcOut(CamProperty);
				}
				frag = 2;
				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
//#endif

			}
			break;
		/* 右ボタン */
		case 2:
			if (select_list_num() == CopyFrag + 1) {
				if (frag == 2) frag = 4;
				else if (frag == 4) frag = 2;

				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Cam);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					if (frag == 2) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 4);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
					}
					if (frag == 4) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 2);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 4);
					}
				}
				UpDate();
			}
			break;
		/* 中ボタン */
		case 4:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				frag = 2;
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);
				UpDate();

				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
			}
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * ＣＡＭ 始点設定 (Return)
 */
int MouseRet_CamProfile(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];


	if (select_list_num() == CopyFrag) {
		/* コマンドラインに表示 */
		sprintf(mstr, _(" [CAM] Start point") );
		StatusMsg(mstr);
	}
	else if (select_list_num() == CopyFrag + 1) {
		/* コマンドラインに表示 */
		sprintf(mstr, _(" [CAM] Direction [ YES/Left  NO/Right  CANCEL/Mid]") );
		StatusMsg(mstr);
	}



	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
										select_list_info.tail->select->diagram_point.cad_point->sy, 
										select_list_info.tail->select->diagram_point.cad_point->ex, 
										select_list_info.tail->select->diagram_point.cad_point->ey, 
										sagcad_color.Cam);
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
				}
				UpDate();
				break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





#ifdef AFTER
void DUMMY_________________________________01(void){}













/* -------------------------------------------------------------------
 * OFFSET 始点方向設定 (Main)
 */
int MouseMode_offset(GtkWidget *widget, int Button, int x, int y)
{
	SELECT *select;
	CAD *cad;
	static int frag = 2; /* 2:正転	4:反転 */


	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 2);
			}
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}

				/* 開始図形の方向を OnScreen にいれる */
				if (frag == 2) {
					select_list_info.tail->select->diagram_point.cad_point->OnScreen = 1;
				}
				else if (frag == 4) {
					select_list_info.tail->select->diagram_point.cad_point->OnScreen = -1;
				}

				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);

				select = select_search_cad(cad)->select;
				select_search_cad(cad)->select = select_list_info.head->select;
				select_list_info.head->select = select;


				frag = 2;
				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);

				Poket_main();

			}
			break;
		/* 右ボタン */
		case 2:
			if (select_list_num() == CopyFrag + 1) {
				if (frag == 2) frag = 4;
				else if (frag == 4) frag = 2;

				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Cam);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					if (frag == 2) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 4);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
					}
					if (frag == 4) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 2);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 4);
					}
				}
			}
			break;
		/* 中ボタン */
		case 4:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				frag = 2;
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);

				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
			}
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * OFFSET 始点方向設定 (Return)
 */
int MouseRet_offset(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];


	if (select_list_num() == CopyFrag) {
		/* コマンドラインに表示 */
		sprintf(mstr," offset 始点方向設定設定モード   開始図形をピック（左ボタン）");
		StatusMsg(mstr);
	}
	else if (select_list_num() == CopyFrag + 1) {
		/* コマンドラインに表示 */
		sprintf(mstr," offset 始点方向設定設定モード：方向を指示して下さい。[ YES/Left   NO/Right   CANCEL/Mid]");
		StatusMsg(mstr);
	}



	switch (Button) {
		/* 左ボタン */
		case 1:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
										select_list_info.tail->select->diagram_point.cad_point->sy, 
										select_list_info.tail->select->diagram_point.cad_point->ex, 
										select_list_info.tail->select->diagram_point.cad_point->ey, 
										sagcad_color.Cam);
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
				}
				break;
			}
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





#endif





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Mouse.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * 選択モード (Main)
 * 
 */
int MouseMode_Select_ops(GtkWidget *widget, int Button, int x, int y)
{
	int i_obj;


	switch (Button) {
		/* 左ボタン */
		case 1:
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if ((outside_process.Work[outside_process.now].sel_obj & 128) == 128) {
					i_obj = outside_process.Work[outside_process.now].sel_obj - 128;
				}
				else {
					i_obj = outside_process.Work[outside_process.now].sel_obj;
				}
				MouseSelect(widget, ToViewX(x), ToViewY(y), i_obj, 0);
			}

			if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
				
				if (SelectChainFrag == 0 && SelectColorFrag == 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), outside_process.Work[outside_process.now].sel_obj, 0);
				}
				else if (SelectChainFrag != 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 0);
				}
				else if (SelectColorFrag != 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), 15, 0);
				}
			}
			
			break;
		/* 右ボタン */
		case 2:
			if ((outside_process.Work[outside_process.now].sel_obj & 128) == 128) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			}
			else {
				if (SelectChainFrag == 0 || SelectColorFrag == 0) {
					select_last_cansel();
					(*ReturnFunc)(widget, Button, x, y);
				}
			}
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * 選択モード (Return)
 */
int MouseRet_Select_ops(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	/* 選択されているときの表示 */
	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, " [Outside Process]［選択］ %s (選択終了は、Outside process Button) (Select %d)  %s", outside_process.Work[outside_process.now].msg, (int) select_list_num(), str);
	}

	/* 何も選択されていないときの表示 */
	else {
		/* １個選択 */
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
			sprintf(mstr, " [Outside Process]［選択］ %s (Select 0)", outside_process.Work[outside_process.now].msg);
		}
		/* たくさん選択 */
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
			sprintf(mstr, " [Outside Process]［選択］ %s (選択終了は、Outside process Button) (Select 0)", outside_process.Work[outside_process.now].msg);
		}
	}
	StatusMsg(mstr);


	switch (Button) {
		/* 左ボタン */
		case 1:
			/* １個選択 */
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if (select_list_info.head != NULL) {
					mode = 0;
					ReturnFunc = MouseRet_Non;
//					g_print ("Mouse L -> Go ops_select_output() \n");
					ops_select_output(&outside_process);
				}
			}
			
			/* たくさん選択 */
			else if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
				if (select_list_info.head != NULL) {
					/* コマンド起動時に何かセレクトされていた */
					/* コマンド起動時 + 1 に何かセレクトされている */
					/* それは、図形データである */
					if (OP_SelectList != NULL && OP_SelectList->next != NULL && select_list_info.tail->select->index != 3) {
						if (SelectChainFrag == 1) SelectChain(select_list_info.tail->select->diagram_point.cad_point);
						if (SelectColorFrag == 1) SelectMaskColor(select_list_info.tail->select->diagram_point.cad_point);
						if (SelectChainFrag == 2) {
							KeepReturnFunc = ReturnFunc;
							ReturnFunc = MouseRet_ChainOne;
							Chain2index = 0;
							SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
						}
						SelectChainFrag = 0;
						SelectColorFrag = 0;
						OP_SelectList = NULL;
					}

					/* コマンド起動時に何かセレクトされていなかった */
					/* １個何かセレクトされている */
					/* それは、図形データである */
					else if (OP_SelectList == NULL && select_list_info.head != NULL && select_list_info.head->select->index != 3) {
						if (SelectChainFrag == 1) SelectChain(select_list_info.head->select->diagram_point.cad_point);
						if (SelectColorFrag == 1) SelectMaskColor(select_list_info.head->select->diagram_point.cad_point);
						if (SelectChainFrag == 2) {
							KeepReturnFunc = ReturnFunc;
							ReturnFunc = MouseRet_ChainOne;
							Chain2index = 0;
							SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
						}
						SelectChainFrag = 0;
						SelectColorFrag = 0;
						OP_SelectList = NULL;
					}
				}
			}
			break;
		/* 右ボタン */
		case 2:
			/* １個選択 */
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if (select_list_info.head != NULL) {
					mode = 0;
					ReturnFunc = MouseRet_Non;
//					g_print ("Mouse R -> Go ops_select_output() \n");
					ops_select_output(&outside_process);
				}
			}
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * 範囲選択モード (Main)
 */
int MouseMode_Rect_ops(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* 左ボタン */
		case 1:
			//g_print("Mouse.c : MouseMode_Rect() : Button = 1 : in\n");
//			SetCapture(widget);
			RectStart = 1;
			MoveX = x;
			MoveY = y;
			StartX = x;
			StartY = y;
			break;
		/* 右ボタン */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* 中ボタン */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * 範囲選択モード (Return)
 */
int MouseRet_Rect_ops(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, " ［範囲選択］ 図形を選択してください。 (Select %d)  %s", (int) select_list_num(), str);
		sprintf(mstr, " [Outside Process]［範囲選択］ %s (選択終了は、Outside process Button) (Select %d)  %s", outside_process.Work[outside_process.now].msg, (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, " [Outside Process]［範囲選択］ %s (選択終了は、Outside process Button) (Select 0)", outside_process.Work[outside_process.now].msg);
	}
	StatusMsg(mstr);


	switch (Button) {
		/* 左ボタン */
		case 1:
			break;
		/* 右ボタン */
		case 2:
			break;
		/* 中ボタン */
		case 4:
			break;
	}
	return 0;
}





