/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Vertex.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2007/10/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#define _LIST_VERTEX_
#include "List_Vertex.h"





int init_vertex(VERTEX *vertex)
{
	/* VERTEX Data の初期化 */
	vertex->x = 0;
	vertex->y = 0;
	vertex->frag = 0;
	return 1;
}





/* -------------------------------------------------------------------
 * VERTEX Data をリストの最初に追加
 * 
 */
VERTEX_LIST *vertex_list_add_first(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));
	/* データ (vertex) を書き込むための領域を確保する */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* 確保した領域にデータ (vertex) を書き込む */
	*p_vertex_list->vertex = *add_vertex;
	p_vertex_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_vertex_list_info->head == NULL && p_vertex_list_info->tail == NULL) {
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_vertex_list_info->head;
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list->next = p;
	}

	return p_vertex_list_info->head;
}





/* -------------------------------------------------------------------
 * VERTEX Data をリストの最後に追加
 * 
 */
VERTEX_LIST *vertex_list_add_last(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));
	/* データ (vertex) を書き込むための領域を確保する */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* 確保した領域にデータ (vertex) を書き込む */
	*p_vertex_list->vertex = *add_vertex;
	p_vertex_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_vertex_list_info->head == NULL && p_vertex_list_info->tail == NULL) {
		p_vertex_list_info->head = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_vertex_list_info->head != NULL 
				&& p_vertex_list_info->tail != NULL 
					&& p_vertex_list_info->head == p_vertex_list_info->tail) {
		p_vertex_list_info->head->next = p_vertex_list;
		p_vertex_list_info->tail = p_vertex_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_vertex_list_info->tail;
		p_vertex_list_info->tail = p_vertex_list;
		p->next = p_vertex_list_info->tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, p_vertex_list_info->tail, NULL);
	return p_vertex_list_info->tail;
}





/* -------------------------------------------------------------------
 * VERTEX Data の削除機能 (メモリの削除ではない)
 * 
 */
int vertex_list_delete(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p = NULL;
	VERTEX_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_vertex_list_info->head && del_List->next == NULL) {
		p_vertex_list_info->head = NULL;
		p_vertex_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_vertex_list_info->head && del_List->next != NULL) {
		p_vertex_list_info->head = p_vertex_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_vertex_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}

		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_vertex_list_info->tail) {
				pb->next = NULL;
				p_vertex_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_vertex_list_info->head && del_List != p_vertex_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_vertex.c : vertex_list_delete() : There is not data of structure data VERTEX.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_vertex_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * VERTEX のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れる。
 *	
 * 戻り値　元のデータのアドレス
 */
VERTEX_LIST *vertex_list_edit(VERTEX_LIST *point, VERTEX *change_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	/* データ (LIST) を書き込むための領域を確保する */
	p_vertex_list = (VERTEX_LIST *)xmalloc(sizeof(VERTEX_LIST));

	/* データ (vertex) を書き込むための領域を確保する */
	p_vertex_list->vertex = (VERTEX *)xmalloc(sizeof(VERTEX));

	/* 確保した領域に変更前のデータ (vertex) を書き込む */
	*p_vertex_list->vertex = *point->vertex;
	p_vertex_list->next = point;

	/* 変更データを書き込む */
	*point->vertex = *change_vertex;

//	undo_list_add_first(13, p_vertex_list, NULL);
	return p_vertex_list;
}





/* -------------------------------------------------------------------
 *	リストの総数を調べる
 */
long vertex_list_num(VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;

	p = p_vertex_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 * 
 */
VERTEX_LIST *vertex_search_num(long search_number, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;


	p = p_vertex_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * VERTEX のデータの検索
 * 
 * 戻値  VERTEX_LIST
 */
VERTEX_LIST *vertex_search_vertex(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;


	p = p_vertex_list_info->head;
	/*	*/
	while( p != NULL && p->vertex != p_vertex) {
		p = p->next;
	}

	/* p_vertex のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * VERTEX のデータの検索
 * 
 * 戻値  long
 */
long vertex_search_vertex_to_num(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	long i;

	i = 1;
	p = p_vertex_list_info->head;
	/*	*/
	while( p != NULL && p->vertex != p_vertex) {
		p = p->next;
		i++;
	}

	/* p_vertex のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	VERTEX Data をリストから削除
 */
int vertex_list_free(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p = NULL;
	VERTEX_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_vertex_list_info->head && del_List->next == NULL) {
		p_vertex_list_info->head = NULL;
		p_vertex_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_vertex_list_info->head && del_List->next != NULL) {
		p_vertex_list_info->head = p_vertex_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_vertex_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_vertex_list_info->tail) {
				pb->next = NULL;
				p_vertex_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_vertex_list_info->head && del_List != p_vertex_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_vertex.c : vertex_list_free() : There is not data of structure data VERTEX.\n");
			return 0;
		}
	}
	xfree(del_List->vertex);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	全リストを削除
 */
void vertex_list_all_free(VERTEX_LIST_INFO *p_vertex_list_info)
{
	while(p_vertex_list_info->head != NULL) {
		if (vertex_list_free(p_vertex_list_info->head, p_vertex_list_info) == 0) {
			g_print("List_vertex.c : vertex_list_all_free() : vertex_list_free() でエラー\n");
			g_print("%s : %d : vertex_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void vertex_list_print(VERTEX_LIST_INFO *p_vertex_list_info)
{
	VERTEX_LIST *p;
	int i = 0;

	g_print("----- VERTEX リストを表示 -----\n");
	p = p_vertex_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : (%f,%f)\n", i, (int)p->vertex, p->vertex->x, p->vertex->y);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* -------------------------------------------------------------------
 * VERTEX_LIST_INFO_1 を VERTEX_LIST_INFO_2 にコピー
 * 
 */
int copy_vertex_list_info(VERTEX_LIST_INFO *org_vertex_list_info, VERTEX_LIST_INFO *cpy_vertex_list_info)
{
	VERTEX_LIST *pv;
	VERTEX vertex;


	cpy_vertex_list_info->head = NULL;
	cpy_vertex_list_info->tail = NULL;

	/* BLOCK の中の VERTEX データを VERTEX_LIST_INFO に登録 */
	pv = org_vertex_list_info->head;
	while (pv != NULL) {
		init_vertex(&vertex);
		vertex = *pv->vertex;
		vertex_list_add_last(&vertex, cpy_vertex_list_info);
		pv = pv->next;
	}
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Vertex.c
 * ====================================================================
 */
