/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Ellipse.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/25
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __LIST_ELLIPSE_H__
#define __LIST_ELLIPSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_ELLIPSE_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL ELLIPSE_LIST *p_ellipse_list;
	GLOBAL ELLIPSE_LIST_INFO ellipse_list_info;

	GLOBAL ELLIPSE_LIST *EllipseStartData GLOBAL_VAL(0);


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_ELLIPSE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* ELLIPSE Data ν */
int init_ellipse(ELLIPSE *ellipse);
ELLIPSE_LIST *r_ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data ꥹȤκǽɲ */
ELLIPSE_LIST *ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data ꥹȤκǽɲäơ Undo Baffer ˽ */
ELLIPSE_LIST *ellipse_list_add_first_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data ꥹȤκǸɲ */
ELLIPSE_LIST *ellipse_list_add_last(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data ꥹȤκǸɲá Undo Baffer ˽ */
ELLIPSE_LIST *ellipse_list_add_last_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data κǽ (κǤϤʤ) */
int ellipse_list_delete(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data κǽ (κǤϤʤUndo Buffer ذܤ) */
int ellipse_list_delete_Undo(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data ѹ */
ELLIPSE_LIST *ellipse_list_edit(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data ѹ롢 Undo Baffer ˽ */
ELLIPSE_LIST *ellipse_list_edit_with_undo(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ꥹȤĴ٤ */
long ellipse_list_num(ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* n ܤΥǡθ */
ELLIPSE_LIST *ellipse_search_num(long search_number, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ǡθ(ELLIPSE *p_ellipse  ELLIPSE_LIST ) */
ELLIPSE_LIST *ellipse_search_ellipse(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ǡθ(ELLIPSE *p_ellipse  Data No.  long ͤ) */
long ellipse_search_ellipse_to_num(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);


/* ELLIPSE Data ꥹȤ */
int ellipse_list_free(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ꥹȤ */
void ellipse_list_all_free(ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE ꥹȤɽ */
void ellipse_list_print(ELLIPSE_LIST_INFO *p_ellipse_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_ELLIPSE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Ellipse.h
 * ====================================================================
 */
