/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyFunc.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/10/14
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "types.h"
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_insert.h"
#include "List_Vertex.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "culcfunc.h"
#include "Ellipse.h"
#include "Dimension.h"
#include "etc.h"
#include "global.h"
#include "Draw.h"
#include "Select.h"
#include "Dimension.h"
#define _COPYFUNC_
#include "CopyFunc.h"





/* -------------------------------------------------------------------
 * 平行
 * 
 * SELECT DATA a を ベクトル(x,y) で平行移動
 * 
 */
int Parallel(SELECT *select, double x, double y)
{
	int i;
	VERTEX_LIST *pv;


	/* 図形データ */
	if (select->index == 2 || select->index == 4) {
		/* 点のとき */
		if ( select->diagram_point.cad_point->code == 0) {
			parallel(&select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy, x, y);
			//select->diagram_point.cad_point->sx = sg(select->diagram_point.cad_point->sx + x, calcu_digits);
			//select->diagram_point.cad_point->sy = sg(select->diagram_point.cad_point->sy + y, calcu_digits);
		}
		/* 線のとき */
		else if ( select->diagram_point.cad_point->code == 1) {
			parallel(&select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy, x, y);
			parallel(&select->diagram_point.cad_point->ex, &select->diagram_point.cad_point->ey, x, y);
		}
		/* 円弧のとき */
		else if ( select->diagram_point.cad_point->code == 2) {
			parallel(&select->diagram_point.cad_point->cx, &select->diagram_point.cad_point->cy, x, y);
			parallel(&select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy, x, y);
			parallel(&select->diagram_point.cad_point->ex, &select->diagram_point.cad_point->ey, x, y);
		}
		/* 円のとき */
		else if ( select->diagram_point.cad_point->code == 4) {
			parallel(&select->diagram_point.cad_point->cx, &select->diagram_point.cad_point->cy, x, y);
		}
		else return 0;
	}


	/* 寸法データ */
	else if (select->index == 3) {
		parallel(&select->diagram_point.dimension_point->SearchPointX, 
				 &select->diagram_point.dimension_point->SearchPointY, x, y);

		if (select->diagram_point.dimension_point->index > 0) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {
				/* 点のとき */
				if ( select->diagram_point.dimension_point->AssistLine[i].defin == 0) {
					parallel(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y);
				}
				/* 線のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 1 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 10 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 11 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 20 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 21 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 30 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 31 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 70 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 80 
					) 
				{
					parallel(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y);
					parallel(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey, x, y);
				}
				/* 円弧のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 2 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 60 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 61 
					) 
				{
					parallel(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy, x, y);
					parallel(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y);
					parallel(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey, x, y);
				}
				/* 円のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 4) {
					parallel(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy, x, y);
				}
				else return 0;
			}
		}
	}


	/* ポリラインデータ */
	else if (select->index == 8) {
		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			//g_print("Before parallel VERTEX (%f,%f)\n", pv->vertex->x, pv->vertex->y);
			parallel(&pv->vertex->x, &pv->vertex->y, x, y);
			//g_print("After  parallel VERTEX (%f,%f)\n\n", pv->vertex->x, pv->vertex->y);
			pv = pv->next;
		}
	}


	/* 楕円データ */
	else if (select->index == 16) {
		parallel(&select->diagram_point.ellipse_point->cx, 
				 &select->diagram_point.ellipse_point->cy, x, y);
	}

	return 1;
}





/* -------------------------------------------------------------------
 * 回転
 * 
 * SELECT DATA a を 原点(x,y) を中心に Angle 度回転移動
 * 
 */
int Rotation(SELECT *select, double x, double y, double Angle)
{
	double DX, DY;
	int i;
	VERTEX_LIST *pv;


	/* 移動ベクトル */
//	RAD = degrad(Angle);

	/* 図形データ */
	if (select->index == 2 || select->index == 4) {
		/* 点のとき */
		if ( select->diagram_point.cad_point->code == 0) {
			rotation(&select->diagram_point.cad_point->sx, 
					 &select->diagram_point.cad_point->sy, x, y, Angle);

			//DX = select->diagram_point.cad_point->sx - x;
			//DY = select->diagram_point.cad_point->sy - y;
			//select->diagram_point.cad_point->sx = sg((DX * cos(RAD) - DY * sin(RAD)) + x, calcu_digits);
			//select->diagram_point.cad_point->sy = sg((DY * cos(RAD) + DX * sin(RAD)) + y, calcu_digits);
		}

		/* 線のとき */
		else if ( select->diagram_point.cad_point->code == 1) {
			rotation(&select->diagram_point.cad_point->sx, 
					 &select->diagram_point.cad_point->sy, x, y, Angle);
			rotation(&select->diagram_point.cad_point->ex, 
					 &select->diagram_point.cad_point->ey, x, y, Angle);
		}

		/* 円弧のとき */
		else if ( select->diagram_point.cad_point->code == 2) {
			rotation(&select->diagram_point.cad_point->cx, 
					 &select->diagram_point.cad_point->cy, x, y, Angle);
			rotation(&select->diagram_point.cad_point->sx, 
					 &select->diagram_point.cad_point->sy, x, y, Angle);
			rotation(&select->diagram_point.cad_point->ex, 
					 &select->diagram_point.cad_point->ey, x, y, Angle);
		}

		/* 円のとき */
		else if ( select->diagram_point.cad_point->code == 4) {
			rotation(&select->diagram_point.cad_point->cx, 
					 &select->diagram_point.cad_point->cy, x, y, Angle);
		}
		else return 0;
	}



	/* 寸法データ */
	else if (select->index == 3) {
		select->diagram_point.dimension_point->Angle = (float) (select->diagram_point.dimension_point->Angle + Angle);
		rotation(&select->diagram_point.dimension_point->SearchPointX, 
				 &select->diagram_point.dimension_point->SearchPointY, x, y, Angle);


		if (select->diagram_point.dimension_point->index > 0) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {
				/* 点のとき */
				if ( select->diagram_point.dimension_point->AssistLine[i].defin == 0) {
					rotation(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y, Angle);
				}
				/* 線のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 1 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 10 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 11 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 20 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 21 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 30 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 31 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 70 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 80 
					) 
				{
					rotation(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y, Angle);
					rotation(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey, x, y, Angle);
				}
				/* 円弧のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 2 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 60 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 61 
					) 
				{
					rotation(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy, x, y, Angle);
					rotation(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy, x, y, Angle);
					rotation(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey, x, y, Angle);
				}
				/* 円のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 4) {
					rotation(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy, x, y, Angle);
				}
				else return 0;
			}
		}
	}


	/* ポリラインデータ */
	else if (select->index == 8) {
		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			rotation(&pv->vertex->x, 
					 &pv->vertex->y, x, y, Angle);
			pv = pv->next;
		}
	}


	/* 楕円データ */
	else if (select->index == 16) {
		DX = select->diagram_point.ellipse_point->cx + select->diagram_point.ellipse_point->dx;
		DY = select->diagram_point.ellipse_point->cy + select->diagram_point.ellipse_point->dy;

		rotation(&select->diagram_point.ellipse_point->cx, 
				 &select->diagram_point.ellipse_point->cy, x, y, Angle);

		rotation(&DX, &DY, x, y, Angle);

		select->diagram_point.ellipse_point->dx 
				= DX - select->diagram_point.ellipse_point->cx;
		select->diagram_point.ellipse_point->dy 
				= DY - select->diagram_point.ellipse_point->cy;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * 対象
 * 
 * SELECT DATA a を 直線(sx,sy)-(ex,ey) を中心に 対称移動
 * 
 * 寸法の文字もしたい。
 */
int Mirror(SELECT *select, double sx, double sy, double ex, double ey)
{
	double Dumy, DX, DY;
	int i;
	VERTEX_LIST *pv;
	SAG_POINT s_point, e_point;


	/* 図形データ */
	if (select->index == 2 || select->index == 4) {
		/* 点のとき */
		if ( select->diagram_point.cad_point->code == 0) {
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy);
		}
		/* 線のとき */
		else if ( select->diagram_point.cad_point->code == 1) {
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy);
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->ex, &select->diagram_point.cad_point->ey);
		}
		/* 円弧のとき */
		else if ( select->diagram_point.cad_point->code == 2) {
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->cx, &select->diagram_point.cad_point->cy);
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->sx, &select->diagram_point.cad_point->sy);
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->ex, &select->diagram_point.cad_point->ey);
			Dumy = select->diagram_point.cad_point->sx;
			select->diagram_point.cad_point->sx = select->diagram_point.cad_point->ex;
			select->diagram_point.cad_point->ex = Dumy;
			Dumy = select->diagram_point.cad_point->sy;
			select->diagram_point.cad_point->sy = select->diagram_point.cad_point->ey;
			select->diagram_point.cad_point->ey = Dumy;
		}
		/* 円のとき */
		else if ( select->diagram_point.cad_point->code == 4) {
			symmetry(sx, sy, ex, ey, &select->diagram_point.cad_point->cx, &select->diagram_point.cad_point->cy);
		}
		else return 0;
	}

	/* 寸法データ */
	else if (select->index == 3) {
		symmetry(sx, sy, ex, ey, 
				 &select->diagram_point.dimension_point->SearchPointX, 
				 &select->diagram_point.dimension_point->SearchPointY);

		if (select->diagram_point.dimension_point->index > 0) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {

				/* 点のとき */
				if ( select->diagram_point.dimension_point->AssistLine[i].defin == 0) 
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy);


				/* 線のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 1 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 10 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 11 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 20 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 21 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 30 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 31 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 70 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 80 
					) 
				{
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy);
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey);
				}


				/* 円弧のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 2 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 60 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 61 
					) 
				{
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy);
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].sx, 
							 &select->diagram_point.dimension_point->AssistLine[i].sy);
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].ex, 
							 &select->diagram_point.dimension_point->AssistLine[i].ey);
					Dumy = select->diagram_point.dimension_point->AssistLine[i].sx;
					select->diagram_point.dimension_point->AssistLine[i].sx 
								= select->diagram_point.dimension_point->AssistLine[i].ex;
					select->diagram_point.dimension_point->AssistLine[i].ex = Dumy;
					Dumy = select->diagram_point.dimension_point->AssistLine[i].sy;
					select->diagram_point.dimension_point->AssistLine[i].sy 
								= select->diagram_point.dimension_point->AssistLine[i].ey;
					select->diagram_point.dimension_point->AssistLine[i].ey = Dumy;
				}


				/* 円のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 4 ) {
					symmetry(sx, sy, ex, ey, 
							 &select->diagram_point.dimension_point->AssistLine[i].cx, 
							 &select->diagram_point.dimension_point->AssistLine[i].cy);
				}
				else {
					
				}

			}
		}
	}


	/* ポリラインデータ */
	else if (select->index == 8) {
		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			//g_print("Before symmetry VERTEX (%f,%f)\n", pv->vertex->x, pv->vertex->y);
			symmetry(sx, sy, ex, ey, &pv->vertex->x, &pv->vertex->y);
			//g_print("Before symmetry VERTEX (%f,%f)\n", pv->vertex->x, pv->vertex->y);
			pv = pv->next;
		}
	}


	/* 楕円データ */
	else if (select->index == 16) {
		DX = select->diagram_point.ellipse_point->cx + select->diagram_point.ellipse_point->dx;
		DY = select->diagram_point.ellipse_point->cy + select->diagram_point.ellipse_point->dy;

		/* 楕円の始点と終点を求める */
		get_ellipse_se_point(*select->diagram_point.ellipse_point, &s_point, &e_point);


		symmetry(sx, sy, ex, ey, &select->diagram_point.ellipse_point->cx, &select->diagram_point.ellipse_point->cy);
		symmetry(sx, sy, ex, ey, &DX, &DY);

		select->diagram_point.ellipse_point->dx 
				= DX - select->diagram_point.ellipse_point->cx;
		select->diagram_point.ellipse_point->dy 
				= DY - select->diagram_point.ellipse_point->cy;


		symmetry(sx, sy, ex, ey, &s_point.x, &s_point.y);
		symmetry(sx, sy, ex, ey, &e_point.x, &e_point.y);

		/* 傾いた楕円上の点から傾いてないときの楕円上の角度をを求める */
		select->diagram_point.ellipse_point->sa 
				= get_ellipse_angle_from_point(*select->diagram_point.ellipse_point, e_point);
		angle_check(&select->diagram_point.ellipse_point->sa);
		if (select->diagram_point.ellipse_point->sa == 0 || select->diagram_point.ellipse_point->sa == 360) {
			select->diagram_point.ellipse_point->sa = 0;
		}

		select->diagram_point.ellipse_point->ea 
				= get_ellipse_angle_from_point(*select->diagram_point.ellipse_point, s_point);
		angle_check(&select->diagram_point.ellipse_point->ea);
		if (select->diagram_point.ellipse_point->ea == 0 || select->diagram_point.ellipse_point->ea == 360) {
			select->diagram_point.ellipse_point->ea = 360;
		}
	}

	return 1;
}





/* -------------------------------------------------------------------
 * スケーリング
 * 
 * SELECT DATA を 原点(x,y) を中心に k 倍した図形に変換して返す
 * 
 */
int Scaling(SELECT *select, double x, double y, double k)
{
	int i;
	double DX, DY;
	VERTEX_LIST *pv;


	/* 図形データ */
	if (select->index == 2 || select->index == 4) {

		/* 点のとき */
		if (select->diagram_point.cad_point->code == 0) {
			scaling(&select->diagram_point.cad_point->sx, 
					&select->diagram_point.cad_point->sy, x, y, k);

			//select->diagram_point.cad_point->sx = sg((k * select->diagram_point.cad_point->sx) + x * (1 - k), calcu_digits);
			//select->diagram_point.cad_point->sy = sg((k * select->diagram_point.cad_point->sy) + y * (1 - k), calcu_digits);
		}


		/* 線のとき */
		else if (select->diagram_point.cad_point->code == 1) {
			scaling(&select->diagram_point.cad_point->sx, 
					&select->diagram_point.cad_point->sy, x, y, k);
			scaling(&select->diagram_point.cad_point->ex, 
					&select->diagram_point.cad_point->ey, x, y, k);
		}


		/* 円弧のとき */
		else if (select->diagram_point.cad_point->code == 2) {
			scaling(&select->diagram_point.cad_point->cx, 
					&select->diagram_point.cad_point->cy, x, y, k);
			scaling(&select->diagram_point.cad_point->sx, 
					&select->diagram_point.cad_point->sy, x, y, k);
			scaling(&select->diagram_point.cad_point->ex, 
					&select->diagram_point.cad_point->ey, x, y, k);
			select->diagram_point.cad_point->r = sg(k * select->diagram_point.cad_point->r, calcu_digits);
		}


		/* 円のとき */
		else if (select->diagram_point.cad_point->code == 4) {
			scaling(&select->diagram_point.cad_point->cx, 
					&select->diagram_point.cad_point->cy, x, y, k);
			select->diagram_point.cad_point->r = sg(k * select->diagram_point.cad_point->r, calcu_digits);
		}
	}

	/* 寸法データ */
	else if (select->index == 3) {
		scaling(&select->diagram_point.dimension_point->SearchPointX, 
				&select->diagram_point.dimension_point->SearchPointY, x, y, k);

		if (select->diagram_point.dimension_point->index > 0) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {

				/* 点のとき */
				if ( select->diagram_point.dimension_point->AssistLine[i].defin == 0) {
					scaling(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							&select->diagram_point.dimension_point->AssistLine[i].sy, x, y, k);
				}


				/* 線のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 1 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 10 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 11 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 20 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 21 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 30 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 31 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 70 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 80 
					) 
				{
					scaling(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							&select->diagram_point.dimension_point->AssistLine[i].sy, x, y, k);
					scaling(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							&select->diagram_point.dimension_point->AssistLine[i].ey, x, y, k);
				}


				/* 円弧のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 2 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 60 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 61 
					) 
				{
					scaling(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							&select->diagram_point.dimension_point->AssistLine[i].cy, x, y, k);
					scaling(&select->diagram_point.dimension_point->AssistLine[i].sx, 
							&select->diagram_point.dimension_point->AssistLine[i].sy, x, y, k);
					scaling(&select->diagram_point.dimension_point->AssistLine[i].ex, 
							&select->diagram_point.dimension_point->AssistLine[i].ey, x, y, k);
					select->diagram_point.dimension_point->AssistLine[i].r 
							= sg(k * select->diagram_point.dimension_point->AssistLine[i].r, calcu_digits);
				}
				/* 円のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 4) {
					scaling(&select->diagram_point.dimension_point->AssistLine[i].cx, 
							&select->diagram_point.dimension_point->AssistLine[i].cy, x, y, k);
					select->diagram_point.dimension_point->AssistLine[i].r 
							= sg(k * select->diagram_point.dimension_point->AssistLine[i].r, calcu_digits);
				}
			}
		}
	}


	/* ポリラインデータ */
	else if (select->index == 8) {
		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			scaling(&pv->vertex->x, 
					&pv->vertex->y, x, y, k);
			pv = pv->next;
		}
	}


	/* 楕円データ */
	else if (select->index == 16) {
		DX = select->diagram_point.ellipse_point->cx + select->diagram_point.ellipse_point->dx;
		DY = select->diagram_point.ellipse_point->cy + select->diagram_point.ellipse_point->dy;

		scaling(&select->diagram_point.ellipse_point->cx, 
				&select->diagram_point.ellipse_point->cy, x, y, k);
		scaling(&DX, &DY, x, y, k);

		select->diagram_point.ellipse_point->dx 
				= DX - select->diagram_point.ellipse_point->cx;
		select->diagram_point.ellipse_point->dy 
				= DY - select->diagram_point.ellipse_point->cy;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * 平行 移動＆複写
 * 
 * セレクト図形を ピッチ(x,y), 回数 Repeat で移動または複写する
 * (Repeat=1 移動	Repeat>1 複写)
 */
int CopyPara(double x, double y, int Repeat)
{
	SELECT_LIST *p;
	SELECT select;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;
	int i, IdoFrag = 0, Ret;
	VERTEX_LIST *pv;
	VERTEX vertex;


	/* 複写 */
	if (Repeat > 1) IdoFrag = 2;
	/* 移動 */
	else if (Repeat == 1) {
		IdoFrag = 1;
		Repeat = 2;
	}


	if (select_list_info.head != NULL) undo_index_plus();
	i = 1;
	while (i < Repeat) {
		p = select_list_info.head;
		while (p != NULL) {

			SelectDraw(drawing_area, p->select, SCD_HIDE, UPDATE_OFF);
			if (IdoFrag == 2) {
				SelectDraw(drawing_area, p->select, SCD_ORG, UPDATE_OFF);
			}

			/* ---------------------------------------------
			 * 図形データ
			 */
			if (p->select->index == 2 || p->select->index == 4) {
				cad = *p->select->diagram_point.cad_point;
				select.index = 2;
				select.diagram_point.cad_point = &cad;

				Ret = Parallel(&select, x, y);

				/* 移動 */
				if (IdoFrag == 1) {
					/* CAD Data を変更する、 Undo Baffer に書込む */
					cad_list_edit_with_undo(
							cad_search_cad(p->select->diagram_point.cad_point, &cad_list_info), 
							&cad, 
							&cad_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.cad_point = (cad_list_add_first_with_undo(&cad, &cad_list_info))->cad;
				}
			}


			/* ---------------------------------------------
			 * 寸法データ 
			 */
			else if (p->select->index == 3) {
				dimension = *p->select->diagram_point.dimension_point;
				select.index = 3;
				select.diagram_point.dimension_point = &dimension;

				dimension.diagram_of_char = NULL;

				if (IdoFrag == 2) {
					/* データ (AssistLine) を書き込むための領域を確保する */
					dimension.AssistLine 
							= (ASSISTANCE *) xmalloc(p->select->diagram_point.dimension_point->index * sizeof(ASSISTANCE));
					AssistLineCopy(&dimension, p->select->diagram_point.dimension_point);
				}

				Ret = Parallel(&select, x, y);

				/* 移動 */
				if (IdoFrag == 1) {
					/* DIMENSION Data を変更する、 Undo Baffer に書込む */
					dimension_list_edit_with_undo(
							dimension_search_dimension(p->select->diagram_point.dimension_point, &dimension_list_info), 
							&dimension, 
							&dimension_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.dimension_point 
							= (dimension_list_add_first_with_undo(&dimension, &dimension_list_info))->dimension;
				}
			}


			/* ---------------------------------------------
			 * 曲線データ 
			 */
			else if (p->select->index == 8) {
				polyline = *p->select->diagram_point.polyline_point;
				select.index = 8;
				select.diagram_point.polyline_point = &polyline;

				if (IdoFrag == 2) {
					polyline.vertex_list_info.head = NULL;
					polyline.vertex_list_info.tail = NULL;

					/* 作業用 POLYLINE Data に VERTEX をコピー */
					pv = p->select->diagram_point.polyline_point->vertex_list_info.head;
					while (pv != NULL) {
						vertex = *pv->vertex;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
						pv = pv->next;
					}
				}

				Parallel(&select, x, y);

				/* 移動 */
				if (IdoFrag == 1) {
					/* POLYLINE Data を変更する、 Undo Baffer に書込む */
					polyline_list_edit_with_undo(
							polyline_search_polyline(p->select->diagram_point.polyline_point, &polyline_list_info), 
							&polyline, 
							&polyline_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.polyline_point 
							= (polyline_list_add_first_with_undo(&polyline, &polyline_list_info))->polyline;
				}
			}


			/* ---------------------------------------------
			 * 楕円データ 
			 */
			else if (p->select->index == 16) {
				ellipse = *p->select->diagram_point.ellipse_point;
				select.index = 16;
				select.diagram_point.ellipse_point = &ellipse;

				Ret = Parallel(&select, x, y);

				/* 移動 */
				if (IdoFrag == 1) {
					/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
					ellipse_list_edit_with_undo(
							ellipse_search_ellipse(p->select->diagram_point.ellipse_point, &ellipse_list_info), 
							&ellipse, 
							&ellipse_list_info);
				}
				/* 複写 */
				else if (IdoFrag == 2) {
					/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.ellipse_point 
							= (ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info))->ellipse;
				}
			}


			SelectDraw(drawing_area, p->select, SCD_SELECT, UPDATE_OFF);
			p = p->next;
		}
		i++;
	}

	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * 回転 移動＆複写
 *	
 * セレクト図形を 原点(x,y), 角度 Angle, 回数 Repeat で移動または複写する
 * (Repeat=1 移動	Repeat>1 複写)
 */
int CopyRoll(double x, double y, double angle, int Repeat)
{
	SELECT_LIST *p;
	SELECT select;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;
	double DEG;
	int i, IdoFrag = 0;
	VERTEX_LIST *pv;
	VERTEX vertex;


	/* 複写 */
	if (Repeat > 1) IdoFrag = 2;
	/* 移動 */
	else if (Repeat == 1) {
		IdoFrag = 1;
		Repeat = 2;
	}


	if (select_list_info.head != NULL) undo_index_plus();
	i = 1;
	while (i < Repeat) {
		DEG = angle;

		p = select_list_info.head;
		while (p != NULL) {


			SelectDraw(drawing_area, p->select, SCD_HIDE, UPDATE_OFF);
			if (IdoFrag == 2) {
				SelectDraw(drawing_area, p->select, SCD_ORG, UPDATE_OFF);
			}


			/* ---------------------------------------------
			 * 図形データ 
			 */
			if (p->select->index == 2 || p->select->index == 4) {
				cad = *p->select->diagram_point.cad_point;
				select.index = 2;
				select.diagram_point.cad_point = &cad;

				Rotation(&select, x, y, DEG);

				/* 移動 */
				if (IdoFrag == 1) {
					/* CAD Data を変更する、 Undo Baffer に書込む */
					cad_list_edit_with_undo(
							cad_search_cad(p->select->diagram_point.cad_point, &cad_list_info), 
							&cad, 
							&cad_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.cad_point = (cad_list_add_first_with_undo(&cad, &cad_list_info))->cad;
				}
			}


			/* ---------------------------------------------
			 * 寸法データ 
			 */
			else if (p->select->index == 3) {
				dimension = *p->select->diagram_point.dimension_point;
				select.index = 3;
				select.diagram_point.dimension_point = &dimension;
				dimension.diagram_of_char = NULL;

				if (IdoFrag == 2) {
					/* データ (AssistLine) を書き込むための領域を確保する */
					dimension.AssistLine 
							= (ASSISTANCE *) xmalloc(p->select->diagram_point.dimension_point->index * sizeof(ASSISTANCE));
					AssistLineCopy(&dimension, p->select->diagram_point.dimension_point);
				}

				Rotation(&select, x, y, DEG);

				/* 移動 */
				if (IdoFrag == 1) {
					/* CAD Data を変更する、 Undo Baffer に書込む */
					dimension_list_edit_with_undo(
							dimension_search_dimension(p->select->diagram_point.dimension_point, &dimension_list_info), 
							&dimension, 
							&dimension_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.dimension_point 
							= (dimension_list_add_first_with_undo(&dimension, &dimension_list_info))->dimension;
				}
			}


			/* ---------------------------------------------
			 * 曲線データ 
			 */
			else if (p->select->index == 8) {
				polyline = *p->select->diagram_point.polyline_point;
				select.index = 8;
				select.diagram_point.polyline_point = &polyline;

				if (IdoFrag == 2) {
					polyline.vertex_list_info.head = NULL;
					polyline.vertex_list_info.tail = NULL;

					/* 作業用 POLYLINE Data に VERTEX をコピー */
					pv = p->select->diagram_point.polyline_point->vertex_list_info.head;
					while (pv != NULL) {
						vertex = *pv->vertex;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
						pv = pv->next;
					}
				}

				Rotation(&select, x, y, DEG);

				/* 移動 */
				if (IdoFrag == 1) {
					/* POLYLINE Data を変更する、 Undo Baffer に書込む */
					polyline_list_edit_with_undo(
							polyline_search_polyline(p->select->diagram_point.polyline_point, &polyline_list_info), 
							&polyline, 
							&polyline_list_info);
				}

				/* 複写 */
				else if (IdoFrag == 2) {
					/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.polyline_point 
							= (polyline_list_add_first_with_undo(&polyline, &polyline_list_info))->polyline;
				}
			}


			/* ---------------------------------------------
			 * 楕円データ 
			 */
			else if (p->select->index == 16) {
				ellipse = *p->select->diagram_point.ellipse_point;
				select.index = 16;
				select.diagram_point.ellipse_point = &ellipse;

				Rotation(&select, x, y, DEG);

				/* 移動 */
				if (IdoFrag == 1) {
					/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
					ellipse_list_edit_with_undo(
							ellipse_search_ellipse(p->select->diagram_point.ellipse_point, &ellipse_list_info), 
							&ellipse, 
							&ellipse_list_info);
				}
				/* 複写 */
				else if (IdoFrag == 2) {
					/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
					p->select->diagram_point.ellipse_point 
							= (ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info))->ellipse;
				}
			}


			SelectDraw(drawing_area, p->select, SCD_SELECT, UPDATE_OFF);
			p = p->next;
		}
		i++;
	}
	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * 対称　移動＆複写
 *	
 * セレクト図形を 直線(sx,sy)-(ex,ey) を軸に 対称移動または複写する
 * (Repeat=1 移動	Repeat=2 複写)
 */
int CopyMirr(double sx, double sy, double ex, double ey, int Repeat)
{
	SELECT_LIST *p;
	SELECT select;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;
	VERTEX_LIST *pv;
	VERTEX vertex;


	p = select_list_info.head;
	if (p != NULL) undo_index_plus();
	while (p != NULL) {


		SelectDraw(drawing_area, p->select, SCD_HIDE, UPDATE_OFF);
		if (Repeat == 2) {
			SelectDraw(drawing_area, p->select, SCD_ORG, UPDATE_OFF);
		}


		/* -------------------------------------------------
		 * 図形データ 
		 */
		if (p->select->index == 2 || p->select->index == 4) {
			cad = *p->select->diagram_point.cad_point;
			select.index = 2;
			select.diagram_point.cad_point = &cad;

			Mirror(&select, sx, sy, ex, ey);

			/* 移動 */
			if (Repeat == 1) {
				/* CAD Data を変更する、 Undo Baffer に書込む */
				cad_list_edit_with_undo(
						cad_search_cad(p->select->diagram_point.cad_point, &cad_list_info), 
						&cad, 
						&cad_list_info);
			}

			/* 複写 */
			else if (Repeat == 2) {
				/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
				p->select->diagram_point.cad_point = (cad_list_add_first_with_undo(&cad, &cad_list_info))->cad;
			}
		}


		/* -------------------------------------------------
		 * 寸法データ 
		 */
		if (p->select->index == 3) {
			dimension = *p->select->diagram_point.dimension_point;
			select.index = 3;
			select.diagram_point.dimension_point = &dimension;
			dimension.diagram_of_char = NULL;

			if (Repeat == 2) {
				/* データ (AssistLine) を書き込むための領域を確保する */
				dimension.AssistLine 
						= (ASSISTANCE *) xmalloc(p->select->diagram_point.dimension_point->index * sizeof(ASSISTANCE));
				AssistLineCopy(&dimension, p->select->diagram_point.dimension_point);
			}

			Mirror(&select, sx, sy, ex, ey);

			/* 移動 */
			if (Repeat == 1) {
				/* DIMENSION Data を変更する、 Undo Baffer に書込む */
				dimension_list_edit_with_undo(
						dimension_search_dimension(p->select->diagram_point.dimension_point, &dimension_list_info), 
						&dimension, 
						&dimension_list_info);
			}

			/* 複写 */
			else if (Repeat == 2) {
				/* DIMENSION Data をリストの最初に追加して、 Undo Baffer に書込む */
				p->select->diagram_point.dimension_point 
						= (dimension_list_add_first_with_undo(&dimension, &dimension_list_info))->dimension;
			}
		}


		/* -------------------------------------------------
		 * 曲線データ 
		 */
		else if (p->select->index == 8) {
			polyline = *p->select->diagram_point.polyline_point;
			select.index = 8;
			select.diagram_point.polyline_point = &polyline;

			if (Repeat == 2) {
				polyline.vertex_list_info.head = NULL;
				polyline.vertex_list_info.tail = NULL;

				/* 作業用 POLYLINE Data に VERTEX をコピー */
				pv = p->select->diagram_point.polyline_point->vertex_list_info.head;
				while (pv != NULL) {
					vertex = *pv->vertex;
					vertex_list_add_last(&vertex, &polyline.vertex_list_info);
					pv = pv->next;
				}
			}

			Mirror(&select, sx, sy, ex, ey);

			/* 移動 */
			if (Repeat == 1) {
				/* POLYLINE Data を変更する、 Undo Baffer に書込む */
				polyline_list_edit_with_undo(
						polyline_search_polyline(p->select->diagram_point.polyline_point, &polyline_list_info), 
						&polyline, 
						&polyline_list_info);
			}

			/* 複写 */
			else if (Repeat == 2) {
				/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
				p->select->diagram_point.polyline_point 
						= (polyline_list_add_first_with_undo(&polyline, &polyline_list_info))->polyline;
			}
		}


		/* -------------------------------------------------
		 * 楕円データ 
		 */
		else if (p->select->index == 16) {
			ellipse = *p->select->diagram_point.ellipse_point;
			select.index = 16;
			select.diagram_point.ellipse_point = &ellipse;

			Mirror(&select, sx, sy, ex, ey);

			/* 移動 */
			if (Repeat == 1) {
				/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
				ellipse_list_edit_with_undo(
						ellipse_search_ellipse(p->select->diagram_point.ellipse_point, &ellipse_list_info), 
						&ellipse, 
						&ellipse_list_info);
			}
			/* 複写 */
			else if (Repeat == 2) {
				/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
				p->select->diagram_point.ellipse_point 
						= (ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info))->ellipse;
			}
		}


		SelectDraw(drawing_area, p->select, SCD_SELECT, UPDATE_OFF);
		p = p->next;
	}
	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * スケーリング
 *	
 * セレクト図形を  原点(x,y) を中心に k 倍した図形に変換する
 * (元の図形をいじる)
 */
int CopyScaling(double x, double y, double k, int Frag)
{
	SELECT_LIST *p;
	SELECT select;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;


	p = select_list_info.head;
	if (p != NULL) undo_index_plus();
	while (p != NULL) {


		SelectDraw(drawing_area, p->select, SCD_HIDE, UPDATE_OFF);


		/* -------------------------------------------------
		 * 図形データ 
		 */
		if (p->select->index == 2 || p->select->index == 4) {
			cad = *p->select->diagram_point.cad_point;
			select.index = 2;
			select.diagram_point.cad_point = &cad;

			Scaling (&select, x, y, k);

			/* CAD Data を変更する、 Undo Baffer に書込む */
			cad_list_edit_with_undo(
					cad_search_cad(p->select->diagram_point.cad_point, &cad_list_info), 
					&cad, 
					&cad_list_info);
		}


		/* -------------------------------------------------
		 * 寸法データ 
		 */
		else if (p->select->index == 3) {
			dimension = *p->select->diagram_point.dimension_point;
			select.index = 3;
			select.diagram_point.dimension_point = &dimension;
			dimension.diagram_of_char = NULL;

			Scaling (&select, x, y, k);

			/* DIMENSION Data を変更する、 Undo Baffer に書込む */
			dimension_list_edit_with_undo(
					dimension_search_dimension(p->select->diagram_point.dimension_point, &dimension_list_info), 
					&dimension, 
					&dimension_list_info);
		}


		/* -------------------------------------------------
		 * 曲線データ 
		 */
		else if (p->select->index == 8) {
			polyline = *p->select->diagram_point.polyline_point;
			select.index = 8;
			select.diagram_point.polyline_point = &polyline;

			Scaling (&select, x, y, k);

			/* POLYLINE Data を変更する、 Undo Baffer に書込む */
			polyline_list_edit_with_undo(
					polyline_search_polyline(p->select->diagram_point.polyline_point, &polyline_list_info), 
					&polyline, 
					&polyline_list_info);
		}


		/* -------------------------------------------------
		 * 楕円データ 
		 */
		else if (p->select->index == 16) {
			ellipse = *p->select->diagram_point.ellipse_point;
			select.index = 16;
			select.diagram_point.ellipse_point = &ellipse;

			Scaling (&select, x, y, k);

			/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
			ellipse_list_edit_with_undo(
					ellipse_search_ellipse(p->select->diagram_point.ellipse_point, &ellipse_list_info), 
					&ellipse, 
					&ellipse_list_info);
		}


		SelectDraw(drawing_area, p->select, SCD_SELECT, UPDATE_OFF);
		p = p->next;
	}
	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * 格子
 * 
 * セレクト図形を 
 * X のピッチを x, Y のピッチを y, X の回数を RepeatX, Yの回数を RepeatY
 * で複写する
 * 
 */
int CopyKousi(double x, double y, int RepeatX, int RepeatY)
{
	SELECT_LIST *p;
	SELECT select;

	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;

	VERTEX_LIST *pv;
	VERTEX vertex;
	double DX, DY;
	int j, k;


	if (select_list_info.head != NULL) undo_index_plus();

	/* RepeatX */
	for (j = 0 ; j < RepeatX ; j++) {
		DX = x + x * (j - 1);

		/* RepeatY */
		for (k = 0 ; k < RepeatY ; k++) {
			DY = y + y * (k - 1);

			/* SELECT_LIST */
			p = select_list_info.head;
			while (p != NULL) {



				/* ---------------------------------------------
				 * 図形データ
				 */
				if (p->select->index == 2 || p->select->index == 4) {
					/* 元の図形の移動無しなので処理しない */
					if (j == 0 && k == 0) {
						CadDraw(drawing_area, p->select->diagram_point.cad_point, SCD_HIDE, UPDATE_OFF);
						CadDraw(drawing_area, p->select->diagram_point.cad_point, SCD_ORG, UPDATE_OFF);
					}
					else {
						cad = *p->select->diagram_point.cad_point;
						select.index = 2;
						select.diagram_point.cad_point = &cad;

						Parallel(&select, DX, DY);

						CadDraw(drawing_area, select.diagram_point.cad_point, SCD_ORG, UPDATE_OFF);

						
						/* 最後の図形をセレクト状態にする */
						if (j == RepeatX - 1 && k == RepeatY - 1) {
							/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
							p->select->diagram_point.cad_point 
									= (cad_list_add_first_with_undo(&cad, &cad_list_info))->cad;
							CadDraw(drawing_area, p->select->diagram_point.cad_point, SCD_SELECT, UPDATE_OFF);
						}
						else {
							/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
							cad_list_add_first_with_undo(&cad, &cad_list_info);
						}
					}
				}



				/* ---------------------------------------------
				 * 寸法データ 
				 */
				else if (p->select->index == 3) {
					/* 元の図形の移動無しなので処理しない */
					if (j == 0 && k == 0) {
						DimensionDraw (drawing_area, p->select->diagram_point.dimension_point, SCD_HIDE);
						DimensionDraw (drawing_area, p->select->diagram_point.dimension_point, SCD_ORG);
					}
					else {
						dimension = *p->select->diagram_point.dimension_point;
						select.index = 3;
						select.diagram_point.dimension_point = &dimension;

						dimension.diagram_of_char = NULL;

						/* データ (AssistLine) を書き込むための領域を確保する */
						dimension.AssistLine 
								= (ASSISTANCE *) xmalloc(p->select->diagram_point.dimension_point->index * sizeof(ASSISTANCE));
						AssistLineCopy(&dimension, p->select->diagram_point.dimension_point);

						Parallel(&select, DX, DY);

						DimensionDraw (drawing_area, select.diagram_point.dimension_point, SCD_ORG);

						/* 最後の図形をセレクト状態にする */
						if (j == RepeatX - 1 && k == RepeatY - 1) {
							/* DIMENSION Data をリストの最初に追加して、 Undo Baffer に書込む */
							p->select->diagram_point.dimension_point 
									= (dimension_list_add_first_with_undo(&dimension, &dimension_list_info))->dimension;
							DimensionDraw (drawing_area, p->select->diagram_point.dimension_point, SCD_SELECT);
						}
						else {
							/* DIMENSION Data をリストの最初に追加して、 Undo Baffer に書込む */
							dimension_list_add_first_with_undo(&dimension, &dimension_list_info);
						}
					}
				}



			/* ---------------------------------------------
			 * 曲線データ 
			 */
			else if (p->select->index == 8) {
				/* 元の図形の移動無しなので処理しない */
				if (j == 0 && k == 0) {
					PolyLineDraw(drawing_area, p->select->diagram_point.polyline_point, SCD_HIDE);
					PolyLineDraw(drawing_area, p->select->diagram_point.polyline_point, SCD_ORG);
				}

				else {
					polyline = *p->select->diagram_point.polyline_point;
					select.index = 8;
					select.diagram_point.polyline_point = &polyline;

					polyline.vertex_list_info.head = NULL;
					polyline.vertex_list_info.tail = NULL;

					/* 作業用 POLYLINE Data に VERTEX をコピー */
					pv = p->select->diagram_point.polyline_point->vertex_list_info.head;
					while (pv != NULL) {
						vertex = *pv->vertex;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
						pv = pv->next;
					}

					Parallel(&select, DX, DY);

					PolyLineDraw(drawing_area, select.diagram_point.polyline_point, SCD_ORG);

					/* 最後の図形をセレクト状態にする */
					if (j == RepeatX - 1 && k == RepeatY - 1) {
						/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
						p->select->diagram_point.polyline_point 
								= (polyline_list_add_first_with_undo(&polyline, &polyline_list_info))->polyline;
						PolyLineDraw(drawing_area, p->select->diagram_point.polyline_point, SCD_SELECT);
					}
					else {
						/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
						polyline_list_add_first_with_undo(&polyline, &polyline_list_info);
					}
				}
			}



				/* ---------------------------------------------
				 * 楕円データ
				 */
				else if (p->select->index == 16) {
					/* 元の図形の移動無しなので処理しない */
					if (j == 0 && k == 0) {
						EllipseDraw(drawing_area, p->select->diagram_point.ellipse_point, SCD_HIDE);
						EllipseDraw(drawing_area, p->select->diagram_point.ellipse_point, SCD_ORG);
					}
					else {
						ellipse = *p->select->diagram_point.ellipse_point;
						select.index = 16;
						select.diagram_point.ellipse_point = &ellipse;

						Parallel(&select, DX, DY);

						EllipseDraw(drawing_area, select.diagram_point.ellipse_point, SCD_ORG);

						/* 最後の図形をセレクト状態にする */
						if (j == RepeatX - 1 && k == RepeatY - 1) {
							/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
							p->select->diagram_point.ellipse_point 
									= (ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info))->ellipse;
							EllipseDraw(drawing_area, p->select->diagram_point.ellipse_point, SCD_SELECT);
						}
						else {
							/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
							ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info);
						}
					}
				}



				p = p->next;
			}
		}
	}
	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * 確保した copy_dimension の AssistLine に
 * org_dimension のデータをコピーする。
 *	
 */
int AssistLineCopy(DIMENSION *copy_dimension, DIMENSION *org_dimension)
{
	int i;

	if (org_dimension->index > 0) {
		for ( i = 0 ; i < org_dimension->index ; i++ ) {
			copy_dimension->AssistLine[i].defin = org_dimension->AssistLine[i].defin;
			copy_dimension->AssistLine[i].sx = org_dimension->AssistLine[i].sx;
			copy_dimension->AssistLine[i].sy = org_dimension->AssistLine[i].sy;
			copy_dimension->AssistLine[i].ex = org_dimension->AssistLine[i].ex;
			copy_dimension->AssistLine[i].ey = org_dimension->AssistLine[i].ey;
			copy_dimension->AssistLine[i].cx = org_dimension->AssistLine[i].cx;
			copy_dimension->AssistLine[i].cy = org_dimension->AssistLine[i].cy;
			copy_dimension->AssistLine[i].r  = org_dimension->AssistLine[i].r ;
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * スケーリング
 *	
 * CAD または DIMENSION DATA が入ったSELECT_LIST を 原点(x,y) を中心に k 倍した図形に変換して返す
 *	
 * スケーリング原点 x
 * スケーリング原点 y
 * スケーリング係数 k
 */
int ScalingXY(SELECT *select, double x, double y, double kx, double ky)
{
	int i;
	VERTEX_LIST *pv;


#ifdef TEST
	if (kx < 0) {
		kx = -1 * kx;
	}
	if (ky < 0) {
		ky = -1 * ky;
	}
#endif

	/* 図形データ */
	if (select->index == 2 || select->index == 4) {
		/* 点のとき */
		if (select->diagram_point.cad_point->code == 0) {
			select->diagram_point.cad_point->sx = sg((kx * select->diagram_point.cad_point->sx) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->sy = sg((ky * select->diagram_point.cad_point->sy) + y * (1 - ky), calcu_digits);
		}
		/* 線のとき */
		else if (select->diagram_point.cad_point->code == 1) {
			select->diagram_point.cad_point->sx = sg((kx * select->diagram_point.cad_point->sx) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->sy = sg((ky * select->diagram_point.cad_point->sy) + y * (1 - ky), calcu_digits);
			select->diagram_point.cad_point->ex = sg((kx * select->diagram_point.cad_point->ex) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->ey = sg((ky * select->diagram_point.cad_point->ey) + y * (1 - ky), calcu_digits);
		}
		/* 円弧のとき */
		else if (select->diagram_point.cad_point->code == 2) {
			select->diagram_point.cad_point->cx = sg((kx * select->diagram_point.cad_point->cx) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->cy = sg((ky * select->diagram_point.cad_point->cy) + y * (1 - ky), calcu_digits);
			select->diagram_point.cad_point->sx = sg((kx * select->diagram_point.cad_point->sx) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->sy = sg((ky * select->diagram_point.cad_point->sy) + y * (1 - ky), calcu_digits);
			select->diagram_point.cad_point->ex = sg((kx * select->diagram_point.cad_point->ex) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->ey = sg((ky * select->diagram_point.cad_point->ey) + y * (1 - ky), calcu_digits);
			select->diagram_point.cad_point->r = sg(kx * select->diagram_point.cad_point->r, calcu_digits);
		}
		/* 円のとき */
		else if (select->diagram_point.cad_point->code == 4) {
			select->diagram_point.cad_point->cx = sg((kx * select->diagram_point.cad_point->cx) + x * (1 - kx), calcu_digits);
			select->diagram_point.cad_point->cy = sg((ky * select->diagram_point.cad_point->cy) + y * (1 - ky), calcu_digits);
			select->diagram_point.cad_point->r = sg(kx * select->diagram_point.cad_point->r, calcu_digits);
		}
	}

	/* 寸法データ */
	else if (select->index == 3) {
		select->diagram_point.dimension_point->SearchPointX = sg((kx * select->diagram_point.dimension_point->SearchPointX) + x * (1 - kx), calcu_digits);
		select->diagram_point.dimension_point->SearchPointY = sg((ky * select->diagram_point.dimension_point->SearchPointY) + y * (1 - ky), calcu_digits);

		if (select->diagram_point.dimension_point->index > 0) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {
				/* 点のとき */
				if ( select->diagram_point.dimension_point->AssistLine[i].defin == 0) {
					select->diagram_point.dimension_point->AssistLine[i].sx = sg((kx * select->diagram_point.dimension_point->AssistLine[i].sx) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].sy = sg((ky * select->diagram_point.dimension_point->AssistLine[i].sy) + y * (1 - ky), calcu_digits);
				}
				/* 線のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 1 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 10 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 11 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 20 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 21 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 30 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 31 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 70 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 80 
					) 
				{
					select->diagram_point.dimension_point->AssistLine[i].sx = sg((kx * select->diagram_point.dimension_point->AssistLine[i].sx) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].sy = sg((ky * select->diagram_point.dimension_point->AssistLine[i].sy) + y * (1 - ky), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].ex = sg((kx * select->diagram_point.dimension_point->AssistLine[i].ex) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].ey = sg((ky * select->diagram_point.dimension_point->AssistLine[i].ey) + y * (1 - ky), calcu_digits);
				}
				/* 円弧のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 2 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 60 
					|| select->diagram_point.dimension_point->AssistLine[i].defin == 61 
					) 
				{
					select->diagram_point.dimension_point->AssistLine[i].cx = sg((kx * select->diagram_point.dimension_point->AssistLine[i].cx) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].cy = sg((ky * select->diagram_point.dimension_point->AssistLine[i].cy) + y * (1 - ky), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].sx = sg((kx * select->diagram_point.dimension_point->AssistLine[i].sx) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].sy = sg((ky * select->diagram_point.dimension_point->AssistLine[i].sy) + y * (1 - ky), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].ex = sg((kx * select->diagram_point.dimension_point->AssistLine[i].ex) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].ey = sg((ky * select->diagram_point.dimension_point->AssistLine[i].ey) + y * (1 - ky), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].r = sg(kx * select->diagram_point.dimension_point->AssistLine[i].r, calcu_digits);
				}
				/* 円のとき */
				else if ( select->diagram_point.dimension_point->AssistLine[i].defin == 4) {
					select->diagram_point.dimension_point->AssistLine[i].cx = sg((kx * select->diagram_point.dimension_point->AssistLine[i].cx) + x * (1 - kx), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].cy = sg((ky * select->diagram_point.dimension_point->AssistLine[i].cy) + y * (1 - ky), calcu_digits);
					select->diagram_point.dimension_point->AssistLine[i].r = sg(kx * select->diagram_point.dimension_point->AssistLine[i].r, calcu_digits);
				}
			}
		}
	}

	/* ポリラインデータ */
	else if (select->index == 8) {
		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			pv->vertex->x = sg((kx * pv->vertex->x) + x * (1 - kx), calcu_digits);
			pv->vertex->y = sg((ky * pv->vertex->y) + y * (1 - ky), calcu_digits);

			pv = pv->next;
		}
	}

	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyFunc.c
 * ====================================================================
 */
