/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CamProfile.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/10/24
 * ====================================================================
 */

#ifndef __CAMPROFILE_H__
#define __CAMPROFILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
struct _CAM_ENV {
	int CamCheck;
	int AbsInc;
	int Modal;
	int RIJ;
	int Heel;
	char StartStr[512];
	char EndStr[512];
};
typedef struct _CAM_ENV CAM_ENV;





/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _CAMPROFILE_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL int AbsInc , Modal , RIJ , Heel;
	GLOBAL int FPoint, CamCheck;
	GLOBAL char StartStr[256], EndStr[256];


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _CAMPROFILE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int Swap(double *a, double *b);
int CamDataRead(int frag);
int Hitohude(int CamCheck);
int NcOut(CAM_ENV CamProperty);


int SwapCam(int a, int b);
int CamTanTenLook(double x, double y);
int CamLineLook(double x, double y);
int CamArcLook(double x, double y);
int DummyFile(char *FileName);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CAMPROFILE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CamProfile.h
 * ====================================================================
 */
