/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : iges.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/10/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "intl.h"

#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
//#include "culcfunc.h"
#include "etc.h"
#include "culcfunc.h"
#define _IGES_
#include "iges.h"



/* -------------------------------------------------------------------
 * IGES 保存
 * IGES Ver 5.0		JAMA-IS Ver 1.0
 */
int igesFileSave(char *SaveFileName)
{
	char FileName[256];
	FILE *stream;


	sprintf(FileName, "%s", SaveFileName);
	cutExtName(FileName);
	strcat(FileName, ".igs");
	/* File Open */ 
	if ((stream = fopen( FileName, "w")) == NULL) {
		printf(_("The file could not be opened. [%s]\n"), FileName);
	}


	start_section_write(stream);
	global_section_write(SaveFileName, "yutaka", "SagiyaMold,Inc.", stream);
	directory_section_write(stream);
	parameter_section_write(stream);
	terminate_section_write(stream);


	fclose(stream);
	printf(_("The file saved. [%s]\n"), FileName);
	return 1;
}





/* -------------------------------------------------------------------
 * start_section_write
 * 
 */
int start_section_write(FILE *stream)
{
	char str[256];


	sprintf(str, "JAMA-IS VERSION  1.0                                                    S      1\n");
	fputs(str, stream );
	sprintf(str, "This JAMA-IS file is generated by Sagiya Mold,Inc.(SagCAD)              S      2\n");
	fputs(str, stream );
//	sprintf(str, "SagCAD by Yutaka Sagiya                                                 S      3\n");
//	fputs(str, stream );

	return 1;
}





/* -------------------------------------------------------------------
 * global_section_write
 * 
 */
int global_section_write(char *SaveFileName, char *UserName, char *CompanyName, FILE *stream)
{
	char str[256], Dumy[256], FileName[256];
	int len;
	char CreatDay[20];
	char DirectoryData[21][50];
	time_t tim;
	struct tm *tptr;


	/* G-1 */
	sprintf(Dumy, "%s", SaveFileName);
	strcpy(FileName, getFileName(Dumy));
	cutExtName(FileName);
	strcat(FileName, ".igs");
	len = strlen(FileName);
	sprintf(str, "1H,,1H;,6HSagCAD,%dH%s,", len, FileName);
	/* OUT */
	len = strlen(str);
	spclen(72-len, Dumy);
	strcat(str, Dumy);
	strcat(str, "G      1");
	sprintf(Dumy, "%s\n", str);
	fputs(Dumy, stream );

	/* G-2 */
	sprintf(str, "23HSagCAD by Yutaka Sagiya,                                             G      2\n");
	fputs(str, stream );

	/* G-3 */
	sprintf(str, "15HV2.5x(01/09/01),32,38,7,38,16,6HSagCAD,1.0,2,2HMM,8,1.0,             G      3\n");
	fputs(str, stream );

	/* G-4 */
//13H020827.075930,0.001,1000000.0,7H鷺谷 豊,                             G      4
	/* 現在の日付と時刻を得る */
	tim = time(NULL);
	/* 日付と時刻を分解する */
	tptr = localtime(&tim);
	
	strftime(CreatDay, 20, "13H%y%m%d.%H%M%S", tptr);


	/* [10] 行番号 */
	sprintf(DirectoryData[10], "G      4");
	len = strlen(UserName);
	sprintf(DirectoryData[0], "%dH%s", len, UserName);
	sprintf(str, "%s,0.001,1000000.0,%s,", CreatDay, DirectoryData[0]);
	len = strlen(str);
	spclen(72-len, Dumy);
	strcat(str, Dumy);
	strcat(str, DirectoryData[10]);
	sprintf(Dumy, "%s\n", str);
	fputs(Dumy, stream );

	/* G-5 */
	/* [10] 行番号 */
	sprintf(DirectoryData[10], "G      5");
	len = strlen(CompanyName);
	sprintf(DirectoryData[0], "%dH%s", len, CompanyName);
	sprintf(str, "%s,8,7,%s;", DirectoryData[0], CreatDay);
	len = strlen(str);
	spclen(72-len, Dumy);
	strcat(str, Dumy);
	strcat(str, DirectoryData[10]);
	sprintf(Dumy, "%s\n", str);
	fputs(Dumy, stream );

	return 1;
}



/* -------------------------------------------------------------------
 * directory_section_write
 * 
 */
int directory_section_write(FILE *stream)
{
	CAD_LIST *p;
	int i;
	char str[255];
	char DirectoryData[21][50];

	i = 0;
	/* 各図形要素 */
	p = cad_list_info.head;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		/* [2] パラメータ情報へのポインタ */
		sprintf(DirectoryData[2], "%d", (2*i-1) );
		lenN(8, DirectoryData[2]);
		/* [3] 構造定義へのポインタ */
		sprintf(DirectoryData[3], "       0");
		/* [4] Style */
		sprintf(DirectoryData[4], "%d", SagToIges_Style(p->cad->style) );
		lenN(8, DirectoryData[4]);
		/* [5] Layer */
		sprintf(DirectoryData[5], "%d", p->cad->layer);
		lenN(8, DirectoryData[5]);
		/* [6] 視点定義へのポインタ */
		sprintf(DirectoryData[6], "       0");
		/* [7] 変換行列定義へのポインタ */
		sprintf(DirectoryData[7], "       0");
		/* [8] ラベル表示定義へのポインタ */
		sprintf(DirectoryData[8], "       0");
		/* [9] 属性番号 */
		sprintf(DirectoryData[9], "00000000");
		/* [10] 行番号 */
		sprintf(DirectoryData[10], "%d", (2*i-1) );
		lenN(8, DirectoryData[10]);
		DirectoryData[10][0] = 'D';
		/* [20] 行番号 */
		sprintf(DirectoryData[20], "%d", (2*i) );
		lenN(8, DirectoryData[20]);
		DirectoryData[20][0] = 'D';
		/* [12] 線幅 */
		sprintf(DirectoryData[12], "       2");


		/* [13] Color */
//		sprintf(DirectoryData[13], "       3");
		sprintf(DirectoryData[13], "%d", SagToIges_Color(p->cad->color));
		lenN(8, DirectoryData[13]);

		/* [14] パラメーター 情報の行数 */
		sprintf(DirectoryData[14], "       2");
		/* [15] 形式番号 */
		sprintf(DirectoryData[15], "       0");
		/* [16] 予備 */
		sprintf(DirectoryData[16], "        ");
		/* [17] 予備 */
		sprintf(DirectoryData[17], "        ");
		/* [19] 追加規約番号 */
		sprintf(DirectoryData[19], "       0");

		if (p->cad->code == 0) {
			sprintf(DirectoryData[1], "     116");
			sprintf(DirectoryData[11], "     116");
			/* [18] 要素ラベル */
			sprintf(DirectoryData[18], "   POINT");
		}
		else if (p->cad->code == 1) {
			sprintf(DirectoryData[1], "     110");
			sprintf(DirectoryData[11], "     110");
			/* [18] 要素ラベル */
			sprintf(DirectoryData[18], "    LINE");
		}
		else if (p->cad->code == 2) {
			sprintf(DirectoryData[1], "     100");
			sprintf(DirectoryData[11], "     100");
			/* [18] 要素ラベル */
			sprintf(DirectoryData[18], "     ARC");
		}
		else if (p->cad->code == 4) {
			sprintf(DirectoryData[1], "     100");
			sprintf(DirectoryData[11], "     100");
			/* [18] 要素ラベル */
			sprintf(DirectoryData[18], "  CIRCLE");
		}
		sprintf(	str, 
					"%s%s%s%s%s%s%s%s%s%s\n",	
					DirectoryData[1], 
					DirectoryData[2], 
					DirectoryData[3], 
					DirectoryData[4], 
					DirectoryData[5], 
					DirectoryData[6], 
					DirectoryData[7], 
					DirectoryData[8], 
					DirectoryData[9], 
					DirectoryData[10]);
		fputs(str, stream );
		sprintf(	str, 
					"%s%s%s%s%s%s%s%s%s%s\n",	
					DirectoryData[11], 
					DirectoryData[12], 
					DirectoryData[13], 
					DirectoryData[14], 
					DirectoryData[15], 
					DirectoryData[16], 
					DirectoryData[17], 
					DirectoryData[18], 
					DirectoryData[19], 
					DirectoryData[20]);
		fputs(str, stream );

		p = p->next;	/* ポインタを次のデータに移す */
	}

	return 1;
}





/* -------------------------------------------------------------------
 * parameter_section_write
 * 
 */
int parameter_section_write(FILE *stream)
{
	CAD_LIST *p;
	int len, i;
	char str[255], Dumy[256];
	char DirectoryData[21][50];

	i = 0;
	/* 各図形要素 */
	p = cad_list_info.head;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		/* [10] 行番号 */
		sprintf(DirectoryData[10], "%d", (2*i-1) );
		lenN(8, DirectoryData[10]);
		DirectoryData[10][0] = 'P';
		/* [20] 行番号 */
		sprintf(DirectoryData[20], "%d", (2*i) );
		lenN(8, DirectoryData[20]);
		DirectoryData[20][0] = 'P';
		/* [9] 行番号 */
		sprintf(DirectoryData[9], "%d", (2*i-1) );
		lenN(8, DirectoryData[9]);

		/* -----------------------------------------------------
		 * POINT
		 */
		if (p->cad->code == 0) {
			/* --- POINT 1 --- */
			strcpy(str, "116,");
			/* SX */
			FloatOut6(Dumy, p->cad->sx, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* SY */
			FloatOut6(Dumy, p->cad->sy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* OUT */
			len = strlen(str);
			spclen( (64-len), Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[10]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );

			/* --- POINT 2 --- */
			sprintf(str, "0,0;");
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[20]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );
		}


		/* -----------------------------------------------------
		 * LINE
		 */
		else if (p->cad->code == 1) {
			/* --- LINE 1 --- */
			strcpy(str, "110,");
			/* SX */
			FloatOut6(Dumy, p->cad->sx, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* SY */
			FloatOut6(Dumy, p->cad->sy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* SZ */
			strcat(str, "0,");
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[10]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );

			/* --- LINE 2 --- */
			/* EX */
			FloatOut6(Dumy, p->cad->ex, 0);
			strcat(Dumy, ",");
			strcpy(str, Dumy);
			/* EY */
			FloatOut6(Dumy, p->cad->ey, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* EZ */
			strcat(str, "0;");
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[20]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );
		}


		/* -----------------------------------------------------
		 * ARC
		 */
		else if (p->cad->code == 2) {
			/* --- ARC 1 --- */
			strcpy(str, "100,0,");
			/* CX */
			FloatOut6(Dumy, p->cad->cx, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* CY */
			FloatOut6(Dumy, p->cad->cy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[10]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );

			/* --- ARC 2 --- */
			/* SX */
			FloatOut6(Dumy, p->cad->sx, 0);
			strcat(Dumy, ",");
			strcpy(str, Dumy);
			/* SY */
			FloatOut6(Dumy, p->cad->sy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* EX */
			FloatOut6(Dumy, p->cad->ex, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* EY */
			FloatOut6(Dumy, p->cad->ey, 0);
			strcat(Dumy, ";");
			strcat(str, Dumy);
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[20]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );
		}


		/* -----------------------------------------------------
		 * CIRCLE
		 */
		else if (p->cad->code == 4) {
			/* --- CIRCLE 1 --- */
			strcpy(str, "100,0,");
			/* CX */
			FloatOut6(Dumy, p->cad->cx, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* CY */
			FloatOut6(Dumy, p->cad->cy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[10]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );

			/* --- CIRCLE 2 --- */
			/* SX */
			FloatOut6(Dumy, (p->cad->cx + p->cad->r), 0);
			strcat(Dumy, ",");
			strcpy(str, Dumy);
			/* SY */
			FloatOut6(Dumy, p->cad->cy, 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* EX */
			FloatOut6(Dumy, (p->cad->cx + p->cad->r), 0);
			strcat(Dumy, ",");
			strcat(str, Dumy);
			/* EY */
			FloatOut6(Dumy, p->cad->cy, 0);
			strcat(Dumy, ";");
			strcat(str, Dumy);
			/* OUT */
			len = strlen(str);
			spclen(64-len, Dumy);
			strcat(str, Dumy);
			strcat(str, DirectoryData[9]);
			strcat(str, DirectoryData[20]);
			sprintf(Dumy, "%s\n", str);
			fputs(Dumy, stream );
		}
		p = p->next;	/* ポインタを次のデータに移す */
	}

	return 1;
}





/* -------------------------------------------------------------------
 * terminate_section_write
 * 
 */
int terminate_section_write(FILE *stream)
{
	char str[256];
	char DirectoryData[21][50];


	/* [1] */
	sprintf(DirectoryData[1], "S      3");
	/* [2] */
	sprintf(DirectoryData[2], "G      5");
	/* [3] */
	sprintf(DirectoryData[3], "%d", (int)(2 * cad_list_num(&cad_list_info) ));
	lenN(8, DirectoryData[3]);
	DirectoryData[3][0] = 'D';
	/* [4] */
	sprintf(DirectoryData[4], "%d", (int)(2 * cad_list_num(&cad_list_info) ));
	lenN(8, DirectoryData[4]);
	DirectoryData[4][0] = 'P';
	/* [10] 行番号 */
	sprintf(DirectoryData[10], "T      1");
	/* [5] NULL */
	sprintf(DirectoryData[5], "        ");
	sprintf(str, "%s%s%s%s%s%s%s%s%s%s\n", DirectoryData[1], DirectoryData[2], DirectoryData[3], DirectoryData[4],
				DirectoryData[5], DirectoryData[5], DirectoryData[5], DirectoryData[5], DirectoryData[5], DirectoryData[10]);
	fputs(str, stream );

	return 1;
}





/* -------------------------------------------------------------------
 * 線種を SagCAD 形式から iges 形式に変換
 * 
 */
int SagToIges_Style(int style)
{
	switch (style) {
		/* 実線 */
		case 0: return 1; break;
		/* 実線 */
		case 1: return 1; break;
		/* 点線 */
		case 2: return 5; break;
		/* 一点鎖線 */
		case 3: return 4; break;
		/* 二点鎖線 */
		case 4: return 3; break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * カラーを SagCAD 形式から iges 形式に変換
 * 変換できないものは、green に
 */
int SagToIges_Color(long color)
{
	switch (color) {
		/* 黒 */
		case 0x000000: return 1; break;
		/* 赤 */
		case 0xff0000: return 2; break;
		/* 緑 */
		case 0x00ff00: return 3; break;
		/* 青 */
		case 0x0000ff: return 4; break;
		/* 黄 */
		case 0x00ffff: return 5; break;
		/* 赤紫 */
		case 0xffff00: return 6; break;
		/* 水色 */
		case 0xff00ff: return 7; break;
		/* 白 */
		case 0xffffff: return 8; break;
	}
	return 3;
}





/* -------------------------------------------------------------------
 * str 文字列を左側にスペースを付加してｎ文字にする
 * 
 */
int lenN(int n, char *str)
{
	int len, i;
	char Dumy[10],Retstr[10];

	len = strlen(str);
	if(len > n) return 0;
	for (i = 1 ; i <= n - len ; i++) {
		Dumy[i-1] = ' ';
	}
	Dumy[n - len] = '\0';
	sprintf(Retstr, "%s%s", Dumy, str);
	sprintf(str, "%s", Retstr);
	return 1;
}





/* -------------------------------------------------------------------
 * str に ｎ文字のスペースを作成
 * 
 */
int spclen(int n, char *str)
{
	int i;
	char Dumy[100];

	for (i = 1 ; i <= n ; i++) {
		Dumy[i-1] = ' ';
	}
	Dumy[n] = '\0';
	sprintf(str, "%s", Dumy);
	return 1;
}





#ifdef TEST
/* -------------------------------------------------------------------
 * IGES 読み込み
 * IGES Ver 5.0		JAMA-IS Ver 1.0
 */
int igesFileRead(char *ReadFileName)
{
	char FileName[256], str[256];
	int FileEnd = 1;
	FILE *stream;
	int Ret;

//MessageBox(NULL , "igesFileRead in", "TEST" , MB_OK);

	sprintf(str, "%s", ReadFileName);
	getFileName(str);
	cutExtName(str);
	sprintf(FileName, "%s.igs", str);
	/* ファイルをオープン */
	if( (stream	 = fopen( FileName , "r" )) == NULL ){
		printf( "ファイル %s は開けませんでした。\n", FileName);
	}


	cad_list_all_free();
	dimension_list_all_free();
	PolyLine_list_all_free();


	while(FileEnd) {
		Ret = LineRead(stream, str);
		if (Ret == 0) {
			fclose(stream);
			FileEnd = 0;
		}
		/* スタート セクション */
		if (str[72] == 'S') {
//			MessageBox(NULL , "スタート セクション", "TEST" , MB_OK);
		}
		/* グローバル セクション */
		else if (str[72] == 'G') {
//			MessageBox(NULL , "グローバル セクション", "TEST" , MB_OK);
		}
		/* ディレクトリ セクション */
		else if (str[72] == 'D') {
//			MessageBox(NULL , "ディレクトリ セクション", "TEST" , MB_OK);
		}
		/* パラメータ セクション */
		else if (str[72] == 'P') {
//			MessageBox(NULL , "パラメータ セクション", "TEST" , MB_OK);
		}
		/* ターミネイト セクション */
		else if (str[72] == 'T') {
//			MessageBox(NULL , "ターミネイト セクション", "TEST" , MB_OK);
		}
	}
	return 1;
}
#endif


/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : iges.c
 * ====================================================================
 */


#ifdef DOC
/*
JAMA-IS VERSION  1.0                                                    S      1
This JAMA-IS file is generated by Sagiya Mold,Inc.(SagCAD)              S      2
1H,,1H;,6HSagCAD,11HNoName2.igs,                                        G      1
23HSagCAD by Yutaka Sagiya,                                             G      2
15HV2.5x(01/09/01),32,38,7,38,16,6HSagCAD,1.0,2,2HMM,8,1.0,             G      3
13H020827.075930,0.001,1000000.0,7H鷺谷 豊,                             G      4
12H㈲鷺谷製作所,8,7,13H020827.075930;                                   G      5
     116       1       0       4       0       0       0       000000000D      1
     116       2       8       2       0                   POINT       0D      2
     110       3       0       4       0       0       0       000000000D      3
     110       2       8       2       0                    LINE       0D      4
     110       5       0       4       0       0       0       000000000D      5
     110       2       8       2       0                    LINE       0D      6
     116       7       0       1       1       0       0       000000000D      7
     116       2       3       2       0                   POINT       0D      8
     100       9       0       1       1       0       0       000000000D      9
     100       2       5       2       0                  CIRCLE       0D     10
116,0,0,                                                               1P      1
0,0;                                                                   1P      2
110,50,0,0,                                                            3P      3
-50,0,0;                                                               3P      4
110,0,50,0,                                                            5P      5
0,-50,0;                                                               5P      6
116,20,20,                                                             7P      7
0,0;                                                                   7P      8
100,0,20,20,                                                           9P      9
25,20,25,20;                                                           9P     10
S      3G      5D     10P     10                                        T      1
*/
#endif

