/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Undo.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __LIST_UNDO_H__
#define __LIST_UNDO_H__

//#include <>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

#define CAD_DATA		1
#define DIMENSION_DATA	1
#define POLYLINE_DATA	1
#define BLOCK_DATA		1

#define CAD_NEW			11
#define CAD_DEL			12
#define CAD_EDIT		13
#define DIMENSION_NEW	21
#define DIMENSION_DEL	22
#define DIMENSION_EDIT	23
#define POLYLINE_NEW	31
#define POLYLINE_DEL	32
#define POLYLINE_EDIT	33
#define ELLIPSE_NEW		41
#define ELLIPSE_DEL		42
#define ELLIPSE_EDIT	43
#define INSERT_NEW		51
#define INSERT_DEL		52
#define INSERT_EDIT		53
#define BLOCK_NEW		61
#define BLOCK_DEL		62
#define BLOCK_EDIT		63



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_UNDO_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL	long	  Undo_index	GLOBAL_VAL(0);
	GLOBAL	long	  Undo_Now		GLOBAL_VAL(1);

	GLOBAL	UNDO_LIST *p_undo_list;
	GLOBAL	UNDO_LIST_INFO undo_list_info;
	GLOBAL	int *p_undo_list_type;
	GLOBAL	long *p_undo_list_index;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_UNDO_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
/* Undo_index 򥤥󥯥Ȥ */
void undo_index_plus(void);

/* Undo Data ꥹȤκǽɲ */
int undo_list_add_first(int type, LPDIAGRAM diagram_point, DIAGRAM diagram);
/* Redo  */
void Redo_Delete(void);
/*  index Ʊǽ Undo_index õ, Undo Buffer Υݥ󥿤֤ */
UNDO_LIST *search_list_undo_start(long index);
/*  index ƱǸ Undo_index õ, Undo Buffer Υݥ󥿤֤ */
UNDO_LIST *search_list_undo_end(long index);
/* Undo */
int Undo(void);
/* Redo */
int Redo(void);
void UndoRedo(UNDO_LIST *undo);

/* Undo Data ꥹȤ */
int undo_list_free(UNDO_LIST *del_List);
/* ꥹȤ */
void undo_list_all_free(void);
/* Undo Data ꥹȤκǸɲ */
int undo_list_add_last(int type, CAD_LIST *add_cad, DIMENSION_LIST *add_dimension);

/* UNDO_LIST Υǡɽ */
void undo_list_log(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_UNDO_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : List_Undo.h
 * ====================================================================
 */
