/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_polyline.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/05
 *    Last                 : 2007/10/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Vertex.h"
#include "List_Undo.h"
#define _LIST_POLYLINE_
#include "List_PolyLine.h"





int init_polyline(POLYLINE *polyline)
{
	polyline->layer = 0;
	/* -------------------------------------------
	 *	8  : ポリライン
	 * 16  : スプライン補間
	 * 32  : ３次Ｂスプライン曲線
	 *(64) : ベジェ曲線
	 */
	polyline->code = 1;
	/* 線種 */
	polyline->style = 1;
	/* 色 */
	polyline->color = 0xffffff;
	/* 分割数 */
	polyline->split = 7;
	/* ピッチ */
	polyline->pitch = 0.05;
	/* フラグ */
	polyline->frag = 0;
	/* 頂点の数 */
	polyline->index = 0;
	/* 頂点のデータ */
	polyline->vertex_list_info.head = NULL;
	polyline->vertex_list_info.tail = NULL;
	return 1;
}





/* -------------------------------------------------------------------
 * POLYLINE Data をリストの最初に追加
 *	
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *r_polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* 確保した領域にデータ (polyline) を書き込む */
	p_polyline_list->polyline = add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}

	return p_polyline_list_info->head;
}





/* -------------------------------------------------------------------
 * POLYLINE Data をリストの最初に追加
 * 
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* データ (polyline) を書き込むための領域を確保する */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* 確保した領域にデータ (polyline) を書き込む */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}

	return p_polyline_list_info->head;
}





/* ---------------------------------------------------------
 * POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む
 *	
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_add_first_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* データ (polyline) を書き込むための領域を確保する */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* 確保した領域にデータ (polyline) を書き込む */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}


	lpdiagram.polyline_point = p_polyline_list_info->head->polyline;
	diagram.polyline = polyline;

	/* Undo Buffa Write */
	undo_list_add_first(POLYLINE_NEW, lpdiagram, diagram);
	return p_polyline_list_info->head;
}





/* -------------------------------------------------------------------
 * POLYLINE Data をリストの最後に追加
 * 
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_add_last(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* データ (polyline) を書き込むための領域を確保する */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* 確保した領域にデータ (polyline) を書き込む */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_polyline_list_info->head != NULL 
				&& p_polyline_list_info->tail != NULL 
					&& p_polyline_list_info->head == p_polyline_list_info->tail) {
		p_polyline_list_info->head->next = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_polyline_list_info->tail;
		p_polyline_list_info->tail = p_polyline_list;
		p->next = p_polyline_list_info->tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, p_polyline_list_info->tail, NULL);
	return p_polyline_list_info->tail;
}





/* ---------------------------------------------------------
 * POLYLINE Data をリストの最後に追加、 Undo Baffer に書込む
 *	
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_add_last_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* データ (polyline) を書き込むための領域を確保する */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* 確保した領域にデータ (polyline) を書き込む */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_polyline_list_info->head != NULL 
				&& p_polyline_list_info->tail != NULL 
					&& p_polyline_list_info->head == p_polyline_list_info->tail) {
		p_polyline_list_info->head->next = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_polyline_list_info->tail;
		p_polyline_list_info->tail = p_polyline_list;
		p->next = p_polyline_list_info->tail;
	}


	lpdiagram.polyline_point = p_polyline_list_info->tail->polyline;
	diagram.polyline = polyline;

	/* Undo Buffa Write */
	undo_list_add_first(POLYLINE_NEW, lpdiagram, diagram);
	return p_polyline_list_info->tail;
}





/* -------------------------------------------------------------------
 * POLYLINE Data の削除機能 (メモリの削除ではない)
 * 
 */
int polyline_list_delete(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * 削除するポインタの前のデータを知りたいので、
	 * head (リストの先頭) から削除するポインタが
	 * 見つかるまで繰り返し、前のデータを探す。
	 */
	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL && p != del_List) {
		if (i == 0) i++;
		pb = p;			/* 前のデータのポインタとして保存しておく */
		p = p->next;	/* ポインタを次のデータに移す */
	}


	/* 見つかった場合 (p が NULL ではないとき) */
	if(p != NULL){
		/* 先頭のデータ (i = 0 のとき) */
		if (i == 0) {
			/* 先頭のデータ１個しかない場合(次のデータのポインタが NULL) */
			if (p->next == NULL) {
				p_polyline_list_info->head = NULL;
				p_polyline_list_info->tail = NULL;
			}
			/* ２個以上データがあるとき */
			else 
				p_polyline_list_info->head = p->next;
		}

		/* 最後のデータのとき (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* 中間のデータ (上の条件以外) */
		else pb->next = p->next;
		polyline_list_free(del_List, p_polyline_list_info);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * POLYLINE Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す)
 * 
 */
int polyline_list_delete_Undo(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;
	long i;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* -------------------------------------------
	 * 削除するポインタの前のデータを知りたいので、
	 * head (リストの先頭) から削除するポインタが
	 * 見つかるまで繰り返し、前のデータを探す。
	 */
	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* 前のデータのポインタとして保存しておく */
		p = p->next;	/* ポインタを次のデータに移す */
	}


	/* 見つかった場合 (p が NULL ではないとき) */
	if(p != NULL){
		/* 先頭のデータ (i = 0 のとき) */
		if (i == 0) {
			/* 先頭のデータ１個しかない場合(次のデータのポインタが NULL) */
			if (p->next == NULL) {
				p_polyline_list_info->head = NULL;
				p_polyline_list_info->tail = NULL;
			}
			/* ２個以上データがあるとき */
			else 
				p_polyline_list_info->head = p->next;
		}

		/* 最後のデータのとき (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* 中間のデータ (上の条件以外) */
		else pb->next = p->next;

		lpdiagram.polyline_point = del_List->polyline;
		diagram.polyline = *del_List->polyline;

		undo_list_add_first(POLYLINE_DEL, lpdiagram, diagram);
		xfree(del_List);
//		polyline_list_free(del_List);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * POLYLINE のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れる。
 * 
 * 戻り値　元のデータのアドレス
 * 
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_edit(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	/* データ (LIST) を書き込むための領域を確保する */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* データ (polyline) を書き込むための領域を確保する */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* 確保した領域に変更前のデータ (polyline) を書き込む */
	*p_polyline_list->polyline = *point->polyline;
//	p_polyline_list->next = point;

	/* 変更データを書き込む */
	*point->polyline = *change_polyline;

//	undo_list_add_first(13, p_polyline_list, NULL);
	return p_polyline_list;
}





/* ---------------------------------------------------------
 * POLYLINE の変更前のデータ(point)を Undo バッファ（編集）に入れて、
 * その場所に新しいデータ(change_polyline)を入れ、Undo Baffer に書込む
 *	
 * 戻り値　元のデータのアドレス
 *	
 * データ (vertex) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
POLYLINE_LIST *polyline_list_edit_with_undo(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* 確保した領域に変更前のデータ (POLYLINE) を書き込む */
	polyline = *point->polyline;

	/* 変更データを書き込む */
	*point->polyline = *change_polyline;


	lpdiagram.polyline_point = point->polyline;
	diagram.polyline = polyline;

	undo_list_add_first(POLYLINE_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 * リストの総数を調べる
 */
long polyline_list_num(POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 *	
 */
POLYLINE_LIST *polyline_search_num(long search_number, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	p = p_polyline_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE のデータの検索
 *	
 * 戻値  POLYLINE_LIST
 */
POLYLINE_LIST *polyline_search_polyline(POLYLINE *p_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	p = p_polyline_list_info->head;
	/*	*/
	while( p != NULL && p->polyline != p_polyline) {
		p = p->next;
	}

	/* p_polyline のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE のデータの検索
 *	
 * 戻値  long
 */
long polyline_search_polyline_to_num(POLYLINE *p_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	i = 1;
	p = p_polyline_list_info->head;
	/*	*/
	while( p != NULL && p->polyline != p_polyline) {
		p = p->next;
		i++;
	}

	/* p_polyline のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE Data をリストから削除
 */
int polyline_list_free(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;


	if (del_List == PolyLineStartData) {
		PolyLineStartData = NULL;
		//g_print ("List_PolyLine.c : polyline_list_free() : del_List = PolyLineStartData\n");
	}

	/* データが先頭で１個だけ  */
	if (del_List == p_polyline_list_info->head && del_List->next == NULL) {
		p_polyline_list_info->head = NULL;
		p_polyline_list_info->tail = NULL;
		//g_print("データが先頭で１個だけ\n");
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_polyline_list_info->head && del_List->next != NULL) {
		p_polyline_list_info->head = p_polyline_list_info->head->next;
		//g_print("データが先頭で２個以上\n");
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_polyline_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_polyline_list_info->tail) {
				pb->next = NULL;
				p_polyline_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_polyline_list_info->head && del_List != p_polyline_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("リストの POLYLINE データではない\n");
			return 0;
		}
	}
	vertex_list_all_free(&del_List->polyline->vertex_list_info);
//	xfree(del_List->polyline->vertex);
	xfree(del_List->polyline);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * 全リストを削除
 */
void polyline_list_all_free(POLYLINE_LIST_INFO *p_polyline_list_info)
{
	while (p_polyline_list_info->head != NULL) {
		polyline_list_free(p_polyline_list_info->head, p_polyline_list_info);
	}
}





/* ---------------------------------------------------------
 * POLYLINE_LIST のデータ log
 *	
 */
void polyline_list_log(POLYLINE_LIST_INFO *p_polyline_list_info)
{
#ifdef TEST
	int j = 0;
	VERTEX_LIST *v;
#endif
	POLYLINE_LIST *p;
	long i = 0;

	g_print("----- POLYLINE リストを表示 -----\n");
	p = p_polyline_list_info->head;
	while( p != NULL) {
		i++;
		g_print("POLYLINE LIST %d : POLYLINE adress = [%x]\n", (int)i, (int)p->polyline);
		g_print("layer [%d]  code [%d]  style [%d]  color [0x%x]  split [%d]  pitch [%f]  index [%d]\n", 
				p->polyline->layer, p->polyline->code, 
				p->polyline->style, (int)p->polyline->color, 
				p->polyline->split, p->polyline->pitch, 
				(int) vertex_list_num(&p->polyline->vertex_list_info) );

		vertex_list_print(&p->polyline->vertex_list_info);

		p = p->next;
	}
	g_print("-------------------------------\n");
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_polyline.c
 * ====================================================================
 */
