/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/10/24
 * ====================================================================
 */

#ifndef __LINE_DLG_H__
#define __LINE_DLG_H__

//#include <>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

typedef struct {
	int value;
	int style_value;
	long color_value;
	GtkWidget *dialog;
	GtkWidget *draw_area;
}Line_set;



/* -------------------------------------------------------
 * 2 : 外部変数
 * -------------------------------------------------------
 */
/* --- < Line_dlg.c から呼ばれたとき > --------------------- */
#ifdef LINE_DLG 
	long ColorMenu[25] ={	0x00ff00, /* green */
							0xffff00, /* yellow */
							0xf5deb3, /* wheat */
							0xffa500, /* orange */
							0xd2b48c, /* tan */
							0xb22222, /* firebrick */
							0xff69b4, /* HotPink */
							0xfff0f5, /* LavenderBlush1 */
							0x00ff7f, /* SpringGreen */
							0x98fb98, /* PaleGreen */
							0x2e8b57, /* SeaGreen */
							0x556b2f, /* DarkOliveGreen */
							0x7fffd4, /* aquamarine */
							0x5f9ea0, /* CadetBlue */
							0x00ffff, /* cyan */
							0x40e0d0, /* turquoise */
							0xb0e0e6, /* PowderBlue */
							0x4682b4, /* SteelBlue */
							0x87ceeb, /* SkyBlue */
							0x0000ff, /* blue */
							0xfffff0, /* ivory1 */
							0xda70d6, /* orchid */
							0xd3d3d3, /* LightGrey */
							0xfa8072, /* salmon */
							0xbebebe  /* gray */
							};

#ifdef TEST
							0x000080, /* NavyBlue */
							0x483d8b, /* DarkSlateBlue */
							0x4169e1, /* RoyalBlue */
							0xff69b4, /* HotPink */
							0xff1493, /* DeepPink */
							0xffc0cb, /* pink */
							0xff8c00, /* DarkOrange */
							0xfa8072, /* salmon */
							0xb22222, /* firebrick */
							0xd2b48c, /* tan */
							0xfff0f5, /* LavenderBlush1 */
							0xfffff0, /* ivory1 */
							0xda70d6, /* orchid */
							0xb03060, /* maroon */
							0xff8c69, /* salmon1 */
							0xff8c69, /* salmon1 */
							0xff8c69, /* salmon1 */
							0xff8c69, /* salmon1 */

#endif



/* --- < Line_dlg.c 以外から呼ばれたとき > ----------------- */
#else 
	extern long ColorMenu[25];



#endif /* LINE_DLG */
#undef LINE_DLG


/* -------------------------------------------------------
 * 3 : 外部関数
 * -------------------------------------------------------
 */
int Line_set_dlg(int *style, long *color);
int draw_area_box_draw(GtkWidget *widget, Line_set *lsbox);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LINE_DLG_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.h
 * ====================================================================
 */
