/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : InputBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/30
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define INPUTBOX
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "InputBox.h"





void inputbox_cancel_pushed(GtkWidget *widget, input_box *ibox)
{
	ibox->value = -1;
}

void inputbox_ok_pushed(GtkWidget *widget, input_box *ibox)
{
	strcpy(ibox->str, gtk_entry_get_text(GTK_ENTRY(ibox->entry)));
	strcpy(BeforeStr, ibox->str);
	ibox->value = 0;
}

static gint inputbox_delete_event(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	return TRUE;
}

static gboolean inputbox_key_pressed(GtkWidget *widget, GdkEventKey *event, input_box *ibox)
{
	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {
		inputbox_ok_pushed(widget, ibox);
		gtk_main_quit();
	}
	return FALSE;
}

static gint inputbox_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
#ifdef G_OS_WIN32
	gtk_window_present(GTK_WINDOW(widget));
#endif
	return FALSE;
}

/* -------------------------------------------------------------------
 * 文字列入力ダイアログ InputBox
 * 
 * 
 * 
 * 
 * 
 * OK Button が押されたら 1 を返す。
 * CANCEL Button が押されたら -1 を返す。
 * 
 * 
 * 
 */
int InputBox(const char *title, const char *msg1, const char *msg2, char *def_str)
{
	input_box *ibox;

	GtkWidget *label;
	GtkWidget *action_vbox;
	GtkWidget *hbox;
	//GtkWidget *entry;
	GtkWidget *btn_cancel, *btn_ok;


	/* def_str が NULL の場合 前の入力値(BeforeStr) */
	if(def_str[0] == '\0') {
		g_print("def_str が NULL BeforeStr = %s\n", BeforeStr);
		strcpy(def_str, BeforeStr);
	}

	ibox = (input_box *)g_malloc(sizeof(input_box));


	/* ダイアログ生成 */
	ibox->dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(ibox->dialog), title);
	gtk_window_set_resizable(GTK_WINDOW(ibox->dialog), FALSE);
	gtk_container_set_border_width
		(GTK_CONTAINER(GTK_DIALOG(ibox->dialog)->action_area), 5);
	gtk_window_set_position(GTK_WINDOW(ibox->dialog),
				GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_modal(GTK_WINDOW(ibox->dialog), TRUE);
	/* ダイアログがメインウィンドウの後ろに隠れてしまわないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(ibox->dialog), GTK_WINDOW(MainWindow));
	
	g_signal_connect(G_OBJECT(ibox->dialog), "delete_event",
			 G_CALLBACK(inputbox_delete_event), NULL);
	g_signal_connect(G_OBJECT(ibox->dialog), "key_press_event",
			 G_CALLBACK(inputbox_key_pressed), ibox);
	g_signal_connect(G_OBJECT(ibox->dialog), "focus_out_event",
			 G_CALLBACK(inputbox_focus_out), NULL);
	
	
	/* ラベル 1 生成 */
	if(msg1 != NULL) {
		label = gtk_label_new(msg1);
		gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->vbox, label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* ラベル 2 生成 */
	if(msg2 != NULL) {
		label = gtk_label_new(msg2);
		gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->vbox, label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* vbox生成 */
	action_vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->action_area, 
				action_vbox, TRUE, TRUE, 0);
	gtk_widget_show(action_vbox);

		/* テキストエントリー生成 */
		ibox->entry = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(action_vbox), ibox->entry, TRUE, TRUE, 0);
		gtk_entry_set_text(GTK_ENTRY(ibox->entry), def_str);
		gtk_editable_select_region(GTK_EDITABLE(ibox->entry), 
					0, GTK_ENTRY(ibox->entry)->text_length);
		gtk_widget_show(ibox->entry);


	/* hbox生成 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(action_vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

		/* CANCELボタンの生成 */
		btn_cancel = gtk_button_new_with_label("CANCEL");
		gtk_box_pack_start(GTK_BOX(hbox), btn_cancel, TRUE, TRUE, 2);
		g_signal_connect( G_OBJECT(btn_cancel), "clicked",
							G_CALLBACK(inputbox_cancel_pushed), ibox);
		g_signal_connect( G_OBJECT(btn_cancel), "clicked",
							G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(btn_cancel);


		/* OKボタンの生成 */
		btn_ok = gtk_button_new_with_label("OK");
		gtk_box_pack_start(GTK_BOX(hbox), btn_ok, TRUE, TRUE, 2);
		g_signal_connect(G_OBJECT(btn_ok), "clicked",
				   G_CALLBACK(inputbox_ok_pushed), ibox);
		g_signal_connect(G_OBJECT(btn_ok), "clicked",
				   G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(btn_ok);
		GTK_WIDGET_SET_FLAGS(btn_ok, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(btn_ok);


	/* ダイアログを可視状態へ */
	gtk_widget_show(ibox->dialog);
	
	/* メインイベントループ */
	gtk_main();
	
	gtk_widget_destroy(ibox->dialog);

	strcpy(def_str, ibox->str);
	//g_print ("InputBox() : return %d   str [%s]\n", ibox->value, def_str);
	return ibox->value; 
}


/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : InputBox.c
 * ====================================================================
 */
