<?php

/**
 * Sabel_DB_Pdo_Statement
 *
 * @abstract
 * @category   DB
 * @package    org.sabel.db.pdo
 * @author     Ebine Yutaka <ebine.yutaka@sabel.jp>
 * @copyright  2004-2008 Mori Reo <mori.reo@sabel.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 */
abstract class Sabel_DB_Pdo_Statement extends Sabel_DB_Statement
{
  abstract public function escape(array $values);
  
  public function __construct(Sabel_DB_Pdo_Driver $driver)
  {
    $this->driver = $driver;
  }
  
  public function execute($bindValues = array())
  {
    $query = $this->getQuery();
    $this->query = preg_replace('/@(.+?)@/', ':$1', $this->getQuery());
    
    if (empty($bindValues)) {
      if (empty($this->bindValues)) {
        $bindValues = array();
      } else {
        $bindValues = $this->escape($this->bindValues);
        foreach ($bindValues as $k => $v) {
          $bindValues[":{$k}"] = $v;
          unset($bindValues[$k]);
        }
      }
    }
    
    return parent::execute($bindValues);
  }
}
