#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <ndbm.h>


#define set_datum(d, s) \
    do { \
	(d)->dptr = (s); \
	(d)->dsize = strlen(s) + 1; \
    } while (0)


int main(void)
{
    DBM *dbm;
    datum key, val;

    dbm = dbm_open("testdb", O_RDWR | O_CREAT, 0666);

    key = dbm_firstkey(dbm);
    if (key.dptr) {
	do {
	    val = dbm_fetch(dbm, key);
	    printf("[%s] = [%s]\n", key.dptr, val.dptr);
	    key = dbm_nextkey(dbm, key);
	} while (key.dptr);
    }
    else {
	set_datum(&key, "foobar");
	set_datum(&val, "FB");
	dbm_store(dbm, key, val, DBM_REPLACE);
	set_datum(&key, "baz");
	set_datum(&val, "BZ");
	dbm_store(dbm, key, val, DBM_REPLACE);
	set_datum(&key, "quux");
	set_datum(&val, "QX");
	dbm_store(dbm, key, val, DBM_REPLACE);
    }

    dbm_close(dbm);

    return 0;
}
