#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <dbm.h>


#define set_datum(d, s) \
    do { \
	(d)->dptr = (s); \
	(d)->dsize = strlen(s) + 1; \
    } while (0)


int main(void)
{
    int dbm;
    datum key, val;

    dbm = dbminit("testdb");
    if (dbm < 0) {
	int f;
	f = creat("testdb.dir", 0666);
	close(f);
	f = creat("testdb.pag", 0666);
	close(f);
	dbm = dbminit("testdb");
    }

    key = firstkey();
    if (key.dptr) {
	do {
	    val = fetch(key);
	    printf("[%s] = [%s]\n", key.dptr, val.dptr);
	    key = nextkey(key);
	} while (key.dptr);
    }
    else {
	set_datum(&key, "foobar");
	set_datum(&val, "FB");
	store(key, val);
	set_datum(&key, "baz");
	set_datum(&val, "BZ");
	store(key, val);
	set_datum(&key, "quux");
	set_datum(&val, "QX");
	store(key, val);
    }

    dbmclose(dbm);

    return 0;
}
