# $Id: writer.rb,v 1.2 2005/02/20 16:50:49 kentarow Exp $

class Writer
  def initialize
    @ripping_fraction = 0.0
    @encode_fraction = 0.0
    @tracks = TRACKS.write_tracks
    @coding = PREF['filename_code'].upcase.tr("_", "-")
    @tagcode = PREF['id3_code'].upcase.tr("_", "-")
    @dir = File.expand_path(Iconv.conv(@coding, 'UTF8', 
                                       PREF['outdir'] + "/" + CDINFO[:DIR]))
    puts(@dir)
  end

  def exec
    start_time = Time.now

    if not File.exist?(@dir)
      system("mkdir", "-p", @dir)
    end

    MAIN.progressbar[0].set_fraction(0.0)
    MAIN.progressbar[1].set_fraction(0.0)

    group = ThreadGroup.new
    mutex = Mutex.new

    thread = Thread.start {
      @tracks.each { |track|
        # ripping
        ripping(track)

        # encode
        if track[:Mp3]
          encode_thread = Thread.start(track) { |_track|
            mutex.synchronize {
              encode(_track)
              unless track[:Wav]
                File.unlink(wav(track))
              end
            }
          }
          group.add(encode_thread)
        end
      }
    }
    group.add(thread)

    while not group.list.empty?
      Gtk.main_iteration
    end

    sec = Time.now - start_time
    MAIN.statusbar.push(0, sprintf("%d:%02d", sec / 60, sec % 60))
  end

  private

  def wav(track)
    "#{@dir}/#{Iconv.conv(@coding, 'UTF8', track[:Filename])}.wav"
  end

  def mp3(track)
    "#{@dir}/#{Iconv.conv(@coding, 'UTF8', track[:Filename])}.mp3"
  end

  def ripping(track)
    MAIN.progressbar[0].set_text("ripping #{track[:Title]}")
    if exec_command(PREF['ripping_command'], track)
      track[:Wav] = false
    end
    @ripping_fraction += 1.0
    MAIN.progressbar[0].set_fraction(@ripping_fraction / @tracks.size)
    MAIN.progressbar[0].set_text("done")
  end

  def ripping_cdda2wav(track)
    system("cdda2wav", 
	   "-H", 
	   "-q", 
	   "-D", @cd.ripping_dev, 
	   "-t", track.num.to_s, 
	   wav(track))
  end

  def ripping_cdparanoia(track)
    system("cdparanoia", 
           "-q", 
           track.num.to_s, 
           wav(track))
  end

  def encode(track)
    MAIN.progressbar[1].set_text("encoding #{track[:Title]}")
    if exec_command(PREF['encode_command'], track)
      track[:Mp3] = false
    end
    @encode_fraction += 1.0
    MAIN.progressbar[1].set_fraction(@encode_fraction / @tracks.size)
    MAIN.progressbar[1].set_text("done")
  end

  def encode_lame(track)
    system("lame", 
	   "--silent", 
           "--add-id3v2", 
	   "--tt", Iconv.conv(ID3TAG_CODE, 'UTF8', track.title), 
	   "--ta", Iconv.conv(ID3TAG_CODE, 'UTF8', @cd.artist), 
	   "--tl", Iconv.conv(ID3TAG_CODE, 'UTF8', @cd.title), 
	   "--tn", track.num.to_s, 
	   wav(track), mp3(track))
  end

  #
  def exec_command(cmd, track)
    args = cmd.split.collect { |arg|
      case arg
      when '%b'
        PREF['bitrate'].to_i.to_s
      when '%c'
        PREF['device']
      when '%w'
        wav(track)
      when '%m'
        mp3(track)
      when '%t'
        track[:Track].to_s
      when '%s'
        # start sector
      when '%e'
        # end sector
      when '%n'
        Iconv.conv(@tagcode, 'UTF8', track[:Title])
      when '%a'
        Iconv.conv(@tagcode, 'UTF8', CDINFO[:ARTIST])
      when '%d'
        Iconv.conv(@tagcode, 'UTF8', CDINFO[:ALBUM])
      when '%i'
        CDINFO[:DISCID]
      when '%y'
        CDINFO[:YEAR].to_s
      when '%G'
        CDINFO[:GENRE]
      else
        arg
      end
    }
    STDERR.puts(args.join(" "))
    result = system(*args)
    unless result
      puts("Error in #{args.join(" ")}")
    end
    result
  end
end
