# $Id: tracks.rb,v 1.2 2005/02/20 16:50:49 kentarow Exp $

##
#
#
class Tracks
  class Error < StandardError; end

  COLUMNS = [
    [ 'Track', Integer ], 
    [ 'Wav', TrueClass ], 
    [ 'Mp3', TrueClass ], 
    [ 'Title', String ], 
    [ 'Filename', String ], 
    [ 'Length', String ]
  ]

  class Track
    def initialize(model, track)
      @num = track
      @iter = model.append
      @iter[0] = track
      @iter[1] = false
      @iter[2] = true
      @iter[3] = ""
      @iter[4] = ""
      @iter[5] = ""
      @iter[6] = true
    end

    def path
      @iter.path.to_s
    end

    def [](field)
      @iter[get_index(field)]
    end

    def []=(field, value)
      @iter[get_index(field)] = value
      if field.to_s.intern == :Title and !value.empty?
        self[:Filename] = sprintf("%02d_%s", @num, encode_filename(value))
      end
    end

    private

    def get_index(field)
      COLUMNS.each_with_index { |elem, i|
        if elem[0] == field.to_s
          return i
        end
      }
      raise(Error, "no such field, '#{field.to_s}'")
    end
  end

  #
  def initialize
    @widget = make_widget
    @tracks = Array.new
    @path_to_track = Hash.new
  end
  attr_reader :widget

  #
  def clear
    @tracks.clear
    @model.clear
  end

  #
  def [](num)
    unless @tracks[num]
      track = Track.new(@model, num)
      @tracks[num] = track
      @path_to_track[track.path] = track
    end
    @tracks[num]
  end

  #
  def write_tracks
    @tracks.select { |track|
      track and (track[:Wav] or track[:Mp3])
    }
  end

  private

  def make_widget
    window = Gtk::ScrolledWindow.new
    window.set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC)
    @model = create_model
    @cell = Hash.new
    treeview = Gtk::TreeView.new(@model)
    add_columns(treeview)
    window.add(treeview)

    window
  end

  #
  def create_model
    columns = COLUMNS.collect { |label, klass| klass }
    columns << TrueClass
    model = Gtk::ListStore.new(*columns)
    model
  end

  #
  def add_columns(treeview)
    model = treeview.model

    COLUMNS.each_with_index { |column, i|
      label, klass = *column
      case klass.to_s.intern
      when :Integer
        column = Gtk::TreeViewColumn.new(label, 
                                         Gtk::CellRendererText.new, 
                                         :text => i)
        treeview.append_column(column)
      when :TrueClass
        cell = Gtk::CellRendererToggle.new
        @cell[cell] = label.intern
        cell.signal_connect('toggled') { |cell, path|
          track = @path_to_track[path.to_s]
          track[@cell[cell]] = !track[@cell[cell]]
        }
        column = Gtk::TreeViewColumn.new(label, cell, :active => i)
        treeview.append_column(column)
      when :String
        cell = Gtk::CellRendererText.new
        @cell[cell] = label.intern
        cell.signal_connect('edited') { |cell, path, text|
          track = @path_to_track[path.to_s]
          track[@cell[cell]] = text
        }
        column = Gtk::TreeViewColumn.new(label, cell, :text => i, 
                                         :editable => COLUMNS.size)
        treeview.append_column(column)
      end
    }
  end
end
