# $Id: rucd.rb,v 1.1 2005/02/20 16:50:49 kentarow Exp $

#
require "iconv"
require "uri"
require "thread"
#
require "gtk2"
Gtk.init
#
require "freedb"
#
require "genre.rb"
require "preferences.rb"
require "misc.rb"
require "cdinfo.rb"
require "tracks.rb"
require "cddb.rb"
require "writer.rb"

#
RUCD_VERSION	= defined?(Version) ? Version : '0.0'
RUCD_DIR	= File.expand_path('~/.rucd')

unless File.exist?(RUCD_DIR)
  Dir.mkdir(RUCD_DIR)
end

PREF = Preferences.new(File.dirname($0) + "/rucd.xml", 
                       "#{RUCD_DIR}/preferences.xml")

if File.exist?("#{RUCD_DIR}/gtkrc")
  Gtk::RC.parse("#{RUCD_DIR}/gtkrc")
end

CDINFO	= CDInfo.new
TRACKS	= Tracks.new

STDERR.reopen("#{RUCD_DIR}/log", "w")

##
#
#
class MainWindow < Gtk::Window
  #
  def initialize
    super
    set_title('RuCD')
    set_size_request(0, 0)
    set_default_size(PREF['window_width'].to_i, 
                     PREF['window_height'].to_i)
    set_resize_mode(Gtk::RESIZE_QUEUE)
    signal_connect('size-allocate') {
      PREF['window_width'] = size[0].to_s
      PREF['window_height'] = size[1].to_s
    }
    signal_connect('destroy') { quit }

    vbox = Gtk::VBox.new

    toolbar = Gtk::Toolbar.new
    toolbar.append('Fetch', 'Fetch from CDDB server') {
      CDDB.fetch
    }
    toolbar.append(Gtk::Stock::EXECUTE) {
      set_sensitive(false)
      Writer.new.exec
      set_sensitive(true)
    }
    toolbar.append_space
    toolbar.append(Gtk::Stock::PREFERENCES) {
      window = PREF.window
      window.set_modal(true)
      # window.set_transient_for(self)
      set_transient_for(window)
      window.signal_connect('size-allocate') {
        PREF.set_size(*window.size)
      }
    }
    toolbar.append_space
    toolbar.append(Gtk::Stock::QUIT) { quit }
    vbox.pack_start(toolbar, false)

    widget = CDINFO.widget
    vbox.pack_start(widget, false)

    widget = TRACKS.widget
    vbox.pack_start(widget)

    hbox = Gtk::HBox.new(true)

    @statusbar = Gtk::Statusbar.new
    @statusbar.set_has_resize_grip(false)
    @statusbar.push(0, "RuCD version #{RUCD_VERSION}")
    hbox.pack_start(@statusbar, false)

    @progressbar = Array.new
    2.times { |i|
      @progressbar[i] = Gtk::ProgressBar.new
      hbox.pack_start(@progressbar[i], false)
    }
    vbox.pack_start(hbox, false)

    add(vbox)

    show_all
  end
  attr_reader :statusbar, :progressbar

  #
  def quit
    PREF.save
    exit
  end
end

##
#
#
Thread.abort_on_exception = "yes"

MAIN = MainWindow.new
Gtk.main
