# $Id: misc.rb,v 1.2 2005/02/20 16:50:49 kentarow Exp $

#
def second_to_time(sec)
  sec = sec.to_i
  sprintf("%d:%02d", sec / 60, sec % 60)
end

#
def convert(outcode, incode, str)
  begin
    Iconv.conv(outcode, incode, str)
  rescue Iconv::IllegalSequence
    "failed"
  end
  # Glib.convert(str, outcode, incode)
end

#
def encode_filename(str)
  str = convert('EUC-JP', 'UTF8', str)
  # capitalize
  str.gsub!(/[A-Za-z\']+/e) { |match|
    if /^I+$/e.match(match)
      match
    elsif /^(([A-Z][A-Z\']*)|([A-Z][a-z\']*)|([a-z][a-z\']*))$/e.match(match)
      match.capitalize
    else
      match
    end
  }
  str.gsub!(/[ ?#&:\/]/e, "")
  str.gsub!(/[]/e, "")
  str.gsub!(/[(\[].*?[)\]]/e, "")
  str.tr!('"', "'")
  convert('UTF8', 'EUC-JP', str)
end
