# $Id: cdinfo.rb,v 1.2 2005/02/20 16:50:49 kentarow Exp $

##
#
#
class CDInfo
  YEARS = (1960 .. Time.now.year).to_a

  #
  def initialize
    @widget_hash = Hash.new
    @widget = make_widget
    self[:YEAR] = Time.now.year
  end
  attr_reader :widget

  #
  def [](field)
    widget = @widget_hash[field]
    case widget
    when Gtk::Label, Gtk::Entry
      widget.text
    when Gtk::OptionMenu
      widget.instance_variable_get(:@list)[widget.history]
    end
  end

  #
  def []=(field, string)
    widget = @widget_hash[field]
    case widget
    when Gtk::Label, Gtk::Entry
      widget.set_text(string.to_s)
      if (field == :ARTIST or field == :ALBUM) and
          (!self[:ARTIST].empty? and !self[:ALBUM].empty?)
        self[:DIR] = encode_filename(self[:ARTIST]) + "/" + 
          encode_filename(self[:ALBUM])
      end
    when Gtk::OptionMenu
      index = widget.instance_variable_get(:@list).index(string)
      if index
        widget.set_history(index)
      end
    end
  end

  private

  #
  def make_widget
    @table = Gtk::Table.new(6, 4)
    @table.set_border_width(4)

    @widget_hash[:DISCID] = make_label('DiscID', 0, 0)
    @widget_hash[:LENGTH] = make_label('Length', 2, 0)
    @widget_hash[:ARTIST] = make_entry('Artist', :ARTIST, 0, 1, 4)
    @widget_hash[:ALBUM] = make_entry('Album', :ALBUM, 0, 2, 4)
    @widget_hash[:DIR] = make_entry('Dir', :DIR, 0, 3, 4)
    @widget_hash[:CATEGORY] = 
      make_optionmenu('Category', Freedb::VALID_CATEGORIES, 4, 1)
    @widget_hash[:GENRE] = make_optionmenu('Genre', GENRE.sort, 4, 2)
    @widget_hash[:YEAR] = make_optionmenu('Year', YEARS, 4, 3)

    @table
  end

  #
  def make_field(label, x, y)
    label = Gtk::Label.new(label + ":")
    label.set_xalign(1.0)
    @table.attach(label, x, x + 1, y, y + 1, Gtk::FILL)
  end

  #
  def attach_widget(widget, x, y, width = 2)
    @table.attach(widget, x + 1, x + width, y, y + 1)
    widget
  end

  #
  def make_label(label, x, y, width = 2)
    make_field(label, x, y)
    label = Gtk::Label.new
    label.set_xalign(0.0)
    attach_widget(label, x, y)
    label
  end

  #
  def make_entry(label, field, x, y, width = 2)
    make_field(label, x, y)
    entry = Gtk::Entry.new
    entry.signal_connect('changed') { |widget|
      self[field] = widget.text
    }
    attach_widget(entry, x, y, width)
  end

  #
  def make_optionmenu(label, menulist, x, y, width = 2)
    make_field(label, x, y)
    menu = Gtk::Menu.new
    group = nil
    menulist.each { |item|
      menuitem = Gtk::RadioMenuItem.new(group, item.to_s)
      group = menuitem.group
      menu.append(menuitem)
    }
    optionmenu = Gtk::OptionMenu.new
    optionmenu.set_menu(menu)
    optionmenu.instance_variable_set(:@list, menulist)
    attach_widget(optionmenu, x, y, width)
  end
end
