# $Id: cddb.rb,v 1.2 2005/02/20 16:50:49 kentarow Exp $

require "kconv"

##
#
#
module CDDB
  def self.fetch
    db = Freedb.new(PREF['device'])
    proxy = URI.parse(PREF['proxy'])
    [ PREF['server1'], PREF['server2'], PREF['server3'] ].each { |uri|
      uri = URI.parse(uri)
      if uri.host
        MAIN.statusbar.push(0, "fetching #{uri.host}")
        Gtk.main_iteration
        db.fetch_cgi(uri.host, uri.port, proxy.host, proxy.port, uri.path)
        if db.results.size > 0
          db.get_result(0)
          break
        end
      end
    }
    if db.results.size > 0
      MAIN.statusbar.push(0, "#{db.tracks.size} tracks")
    else
      MAIN.statusbar.push(0, "not found")
    end

    CDINFO[:DISCID] = db.discid
    CDINFO[:LENGTH] = second_to_time(db.length)
    CDINFO[:CATEGORY] = db.category
    CDINFO[:GENRE] = db.genre
    CDINFO[:ARTIST] = artist = decode(db.artist)
    CDINFO[:ALBUM] = album = decode(db.title)
    CDINFO[:YEAR] = db.year

    TRACKS.clear
    db.tracks.each_with_index { |info, i|
      track = TRACKS[i + 1]
      track[:Wav] = false
      track[:Mp3] = true
      track[:Title] = title = decode(info['title'])
      track[:Length] = second_to_time(info['length'])
    }
  end

  def self.decode(str)
    begin
      convert('UTF8', 'SJIS', str)
    rescue Iconv::IllegalSequence
      ""
    end
  end
end
