<?php
/* ========================================================================
 - [modules/admin/item/list.php]
 -      コンテンツ記事一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/03] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * カテゴリID
     * @var integer
     */
    var $ref_category = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/item/list.tpl');

        // URL引数の取得
        $this->setSafety('ref_category');
        $this->ref_category = empty($this->ref_category)?
                                ITEM_CATEGORY_INFO:$this->ref_category;
        $this->Assign('ref_category', $this->ref_category);

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        if (!empty($_REQUEST['new'])){
            header('Location: '.HTTP_ACTION.'admin/item/item/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category);
            exit();
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/item/list/complete/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category);
            exit();
        }

        $this->set_category();
        $this->set_list();
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'itm_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        $this->Assign('categorys', $list);
    }

    /**
     * カバーリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql = 
            'SELECT '.
                'id,'.
                'open_date,'.
                'modify,'.
                'avail,'.
                'subject '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'ref_category = '.$this->ref_category.' '.
            'ORDER BY '.
                'modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id    = RKT_validate::number($values['id'])?$values['id']:0;
        $id    = $this->objdb->quote($id);
        $avail = empty($values['avail'])?AVAIL_DISABLE:AVAIL_ENABLE;

        $sql =
            'UPDATE '.
                DB_PREFIX.'itm_item '.
            'SET '.
                'avail = '.$avail.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }

} // webapp
?>
