<?php
/* ========================================================================
 - [modules/private/review/browse.php]
 -      商品レビュー閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * レビュー対象商品ID
     * @var integer
     */
    var $id = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('private/review/browse.tpl');

        $this->setSafety('id', '_GET');

        $this->set_item();
        $this->set_review();
        $this->set_list();

        $this->Assign('id', $this->id);
    }

    /**
     * レビュー対象商品の設定
     *
     * @access private
     * @return void
     */
    function set_item()
    {
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.url as url,'.
                'itm.asin as asin,'.
                'itm.name as name,'.
                'cat.category as category,'.
                'itm.ref_category as ref_category,'.
                'itm.creator as creator,'.
                'itm.manufacturer as manufacturer,'.
                'itm.imagemedium as imagemedium,'.
                'itm.listprice as listprice,'.
                'itm.total as total,'.
                'itm.total as point,'.
                'itm.post as post '.
            'FROM '.
                DB_PREFIX.'rev_category cat,'.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'cat.id = itm.ref_category AND '.
                'itm.id = rev.ref_item AND '.
                'itm.id = '.$this->id.' '.
            'GROUP BY '.
                'itm.id,'.
                'itm.url,'.
                'itm.asin,'.
                'itm.name,'.
                'cat.category,'.
                'itm.ref_category,'.
                'itm.creator,'.
                'itm.manufacturer,'.
                'itm.imagemedium,'.
                'itm.listprice,'.
                'itm.total,'.
                'itm.total,'.
                'itm.post';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $result['point'] = round($result['point']);

        $this->Assign('item', $result);
    }

    /**
     * 自分のレビューの設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $sql = 
            'SELECT '.
                'rev.id as id,'.
                'rev.modify as modify,'.
                'rev.ref_item as ref_item,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'rev.point as point,'.
                'rev.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'act.id = rev.ref_account AND '.
                'itm.id = rev.ref_item AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'itm.id = '.$this->id.' AND '.
                'act.id = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['id'])){
            return ;
        }

        $this->Assign('review', $result);
    }

    /**
     * レビューリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = empty($_REQUEST['offset'])?0:$_REQUEST['offset'];
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_REVIEW);

        $sql = 
            'SELECT '.
                'rev.id as id,'.
                'rev.modify as modify,'.
                'rev.ref_item as ref_item,'.
                'rev.ref_account as ref_account,'.
                'pro.nickname as nickname,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'rev.point as point,'.
                'rev.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = rev.ref_account AND '.
                'itm.id = rev.ref_item AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'itm.id = '.$this->id.' AND '.
                'act.id != '.$this->account['id'].' '.
            'ORDER BY '.
                'rev.modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $result = empty($result)?array():$result;

        $this->Assign('list', $result);
    }
} // webapp
?>
