<?php
/* ========================================================================
 - [libs/rktBLOB/blob_db.php]
 -      Binary Large OBject
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/11/25] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rktBlob/blob_common.php';

/**
 * BLOB_dbクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_db
 * @access public
 * @version 2.0.05.1.21
 */
class BLOB_db extends BLOB_common
{
    /**
     * データベース接続オブジェクト
     * @access private
     * @var object
     */
    var $objdb = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dsn
     * @return void
     */
    function BLOB_db($dsn=RKT_BLOB_DSN)
    {
        $this->objdb = RKT_pdo::factory($dsn, RKT_DB_USER, RKT_DB_PASSWD);
    }

    /**
     * 取得キーの変更
     *
     * @access public
     * @param string $oldname
     * @param string $newname
     * @return boolean
     */
    function rename($oldname, $newname)
    {
        $uid = $this->objdb->quote($this->uid);
        $gid = $this->objdb->quote($this->gid);

        $old_origin = md5($oldname);
        $new_origin = md5($newname);
        $sql = 
            'UPDATE '.
                RKT_TBL_BLOB.' '.
            'SET '.
                "origin = '".$new_origin."',".
                'uid = '.$uid.','.
                'gid = '.$gid.' '.
            'WHERE '.
                "origin = '".$old_origin."'";
        return $this->objdb->exec($sql);
    }

    /**
     * 対象データのコピー
     *
     * @access public
     * @param string $source
     * @param string $dest
     * @return boolean
     */
    function copy($source, $dest)
    {
        if (!$this->load($source)){
            return false;
        }
        return $this->save($dest);
    }

    /**
     * 対象データの保存
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    function save($filename)
    {
        $this->origin    = md5($filename);
        $this->name      = basename($filename);
        $this->mime_type = $this->get_mime_type($filename);
        $values = array(
            'modify'=>    $this->objdb->quote(date('Y-m-d H:i:s')),
            'origin'=>    $this->objdb->quote($this->origin),
            'name'=>      $this->objdb->quote($this->name),
            'mime_type'=> $this->objdb->quote($this->mime_type),
            'uid'=>       $this->objdb->quote($this->uid),
            'gid'=>       $this->objdb->quote($this->gid),
            'size'=>      $this->objdb->quote($this->size),
            'buffer'=>    $this->objdb->quote(base64_encode($this->buffer)),
        );

        /* 更新・挿入処理 */
        $result = $this->__update($values);
        if (!$result){
            $result = $this->__insert($values);
        }
        return $result;
    }

    /**
     * 対象データの保存
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    function load($filename)
    {
        $this->origin = md5($filename);
        $sql=
            'SELECT '.
                'modify,'.
                'regist_date,'.
                'origin,'.
                'name,'.
                'mime_type,'.
                'uid,'.
                'gid,'.
                'size,'.
                'buffer '.
            'FROM '.
                RKT_TBL_BLOB.' '.
            'WHERE '.
                "origin = '".$this->origin."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            $this->name      = '';
            $this->mime_type = '';
            $this->uid       = 0;
            $this->gid       = 0;
            $this->size      = 0;
            $this->buffer    = '';
            return false;
        }
        
        $this->name      = $result['name'];
        $this->mime_type = $result['mime_type'];
        $this->uid       = $result['uid'];
        $this->gid       = $result['gid'];
        $this->size      = empty($result['size'])?strlen($result['buffer']):$result['size'];
        $this->buffer    = base64_decode($result['buffer']);

        return true;
    }

    /**
     * 削除処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function unlink($filename)
    {
        $origin = $this->objdb->quote(md5($filename));
        $sql = 
            'DELETE FROM '.
                RKT_TBL_BLOB.' '.
            'WHERE '.
                'origin = '.$origin;
        return $this->objdb->exec($sql);
    }

    /**
     * 削除処理
     *
     * @access private
     * @param array $params
     * @return boolean
     */
    function delete($params)
    {
        extract($params);
        $wheres = array();
        if (!empty($uid)){
            $uid = $this->objdb->quote($uid);
            $wheres[] = 'uid = '.$uid;
        }
        if (!empty($gid)){
            $gid = $this->objdb->quote($gid);
            $wheres[] = 'gid = '.$gid;
        }
        if (!empty($origin)){
            $origin = $this->objdb->quote(md5($origin));
            $wheres[] = 'origin = '.$origin;
        }

        /* 削除条件 */
        if (!count($wheres)){
            return false;
        }
        $where = implode(' AND ',$wheres) .' ';

        $sql = 
            'DELETE FROM '.
                RKT_TBL_BLOB.' '.
            'WHERE '.
                $where;
        return $this->objdb->exec($sql);
    }

    /**
     * 更新処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function __update($values)
    {
        $sql = 
            'UPDATE '.
                RKT_TBL_BLOB.' '.
            'SET '.
                'modify = '.$values['modify'].','.
                'name = '.$values['name'].','.
                'mime_type = '.$values['mime_type'].','.
                'uid = '.$values['uid'].','.
                'gid = '.$values['gid'].','.
                'size = '.$values['size'].','.
                'buffer = '.$values['buffer'].' '.
            'WHERE '.
                'origin = '.$values['origin'];
        return $this->objdb->exec($sql);
    }

    /**
     * 挿入処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function __insert($values)
    {
        $sql = 
            'INSERT INTO '.
                RKT_TBL_BLOB.' ('.
                    'modify,'.
                    'regist_date,'.
                    'origin,'.
                    'name,'.
                    'mime_type,'.
                    'uid,'.
                    'gid,'.
                    'size,'.
                    'buffer'.
                ') VALUES ('.
                    $values['modify'].','.
                    $values['modify'].','.
                    $values['origin'].','.
                    $values['name'].','.
                    $values['mime_type'].','.
                    $values['uid'].','.
                    $values['gid'].','.
                    $values['size'].','.
                    $values['buffer'].
                ')';
        return $this->objdb->exec($sql);
    }
} // BLOB_dbの終了
?>