// ========================================================================
// - [common.js]
// - package：Common functions
// - author：Yujiro Takahashi
// - modified：
// -      [2004/02/07] created
// - contact：    yujiro@rakuto.net
// -      Copyright (C) 2004-2006 `rakuto.net'. All Rights Reserved.
// - =======================================================================

// ------------------------------------------------
// Change of cursor
// param-> object  node		this object
//		-> string  cur		cursor type
// ------------------------------------------------
function chCursor(node, cur){
	node.style.cursor = cur;
}

// ------------------------------------------------
// Cursor is changed into a hand
// param-> object  node		this object
//		-> string  cur		cursor type
// ------------------------------------------------
function chHand(node, cur){
	navi = navigator.appName.toUpperCase();

	if (navi.indexOf("EXPLORER") >= 0 && cur == "pointer"){
		node.style.cursor = 'hand';
	} else {
		node.style.cursor = cur;
	}
}

// ------------------------------------------------
// Cursor is changed into a hand
// param-> object  node		this object
//		-> string  cur		cursor type
// ------------------------------------------------
function chStyle(node, name){
	node.setAttribute('id', name);
}

// ------------------------------------------------
// Transmission of a check message
// param-> string  msg		check message
// ------------------------------------------------
function checkConfirm(msg){
	if (!confirm(msg)){
		return false;
	}
	return true;
}

// ------------------------------------------------
// Transmission of a check message
// param-> object  node		this object
//		-> string  cur		cursor type
// ------------------------------------------------
function movePage(node, name){
	var doc = null;
	eval('form = document.'+ name +';');
	
	form.offset.value = node[node.selectedIndex].value;
	form.submit();
}

// ------------------------------------------------
// Transmission of a check message
// param-> object  node		this object
//		-> string  cur		cursor type
// ------------------------------------------------
function chIdName(id, name){
	var node = Object();
	while (node = document.getElementById(id)){
		node.setAttribute('id', name);
	}
}

// ------------------------------------------------
// Photo
// param-> object  node		this object
//		-> string  name		cursor type
// ------------------------------------------------
function setPhoto(node,name) {
	var browse  = navigator.appName.toUpperCase();

	if (browse.indexOf("NETSCAPE") >= 0){
		return ;
	}

	var width = new Number(180);
	var height = new Number(180);

	var local = new Image();
	local.src = node.value;

	var w_scale = width / local.width;
	var h_scale = height / local.height;

	var scale = (w_scale < h_scale) ? w_scale:h_scale;
	scale = (scale >= 1.0)?1:scale;

	width  = local.width * scale;
	height = local.height * scale;

	
	document.images[name].src = local.src;
	document.images[name].width = width;
	document.images[name].height = height;
}

// ------------------------------------------------
// Thumbnail
// param-> object  node		this object
//		-> string  name		cursor type
// ------------------------------------------------
function setThumbnail(node,name) {
	var browse  = navigator.appName.toUpperCase();

	if (browse.indexOf("NETSCAPE") >= 0){
		return ;
	}

	var width = new Number(76);
	var height = new Number(76);

	var local = new Image();
	local.src = node.value;

	var w_scale = width / local.width;
	var h_scale = height / local.height;

	var scale = (w_scale < h_scale) ? w_scale:h_scale;
	scale = (scale >= 1.0)?1:scale;

	width  = local.width * scale;
	height = local.height * scale;

	img = document.getElementById(name);
	img.src    = local.src;
	img.width  = width;
	img.height = height;
}

// ------------------------------------------------
// allChecked
// param-> string  form		this object
//		-> string  name		cursor type
//		-> number  num		cursor type
//		-> boolean set		cursor type
// ------------------------------------------------
function allChecked(form,name,num,set) {
	var node = Object();
	eval('node = document.'+ form +';');
	
	for (ct=0; ct<num; ct++){
		node.elements[name + ct].checked = set;
	}
}
