<?php
/* ========================================================================
 - [modules/community/edit/names.php]
 -      コミュニティ参加名簿
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/11] メンバー削除時に会員数を更新するように修正
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 名簿登録削除ID
     * @var integer
     */
    var $delete = null;

    /**
     * 管理依頼ID
     * @var integer
     */
    var $change = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/edit/names.tpl');

        /* URL引数の取得 */
        $this->setSafety('delete');
        $this->setSafety('change');

        /* 管理者以外は退場 */
        if (!$this->admin){
            header('Location: '.HTTP_ACTION.'community/show/community/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* 削除 */
        if ($this->delete_names()){
            $this->update_total();
            header('Location: '.HTTP_ACTION.'community/edit/names/'.$this->sid.'/'.$this->ref_community.'/'.WAP_URI_SEPARATOR.'updated=1');
            exit();
        }
        /* 管理者変更依頼 */
        if ($this->change_admin()){
            $this->send_mail($this->change, 'change_request');
            header('Location: '.HTTP_ACTION.'community/edit/names/'.$this->sid.'/'.$this->ref_community.'/'.WAP_URI_SEPARATOR.'updated=1');
            exit();
        }
        
        if (!empty($_REQUEST['updated'])){
            $this->Assign('updated_names',true);        
        }

        $this->set_member();
        $this->set_no_change();
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, 50);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'nam.id as ref_names,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'pro.publicity as publicity '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'com_names nam,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.id = nam.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'nam.ref_community = '.$this->ref_community .' AND '.
                sql_query::bitFlag('nam.status & '.STATUS_COMMUNITY_MEMBERS).' '.
            'ORDER BY '.
                'nam.modify ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        
        $this->Assign('members', $result);
    }

    /**
     * 管理の依頼設定
     *
     * @access private
     * @return void
     */
    function set_no_change()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'status = '.STATUS_COMMUNITY_CHANGE;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('no_change',empty($result['ct']));
    }

    /**
     * 会員名簿の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_names()
    {
        if (!$this->admin){
            return false;
        }
        if (empty($this->delete)){
            return false;
        }

        $this->send_mail($this->delete, 'names_delete');

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'id ='.$this->delete .' AND '.
                'ref_community = '.$this->ref_community.' AND '.
                'status != '.STATUS_COMMUNITY_ADMIN;
        return $this->objdb->exec($sql);
    }

    /**
     * 会員総数を更新
     *
     * @access private
     * @return void
     */
    function update_total()
    {
        $sql = 
            'SELECT '.
                'count(id) as total '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community. ' AND '.
                sql_query::bitFlag('status & '.STATUS_COMMUNITY_MEMBERS);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_community '.
            'SET '.
                'total = '.$total.' '.
            'WHERE '.
                'id = '.$this->ref_community;
        $this->objdb->exec($sql);
    }

    /**
     * 管理人の交代申請
     *
     * @access private
     * @return integer  データ操作結果
     */
    function change_admin()
    {
        if (!$this->admin){
            return false;
        }
        if (empty($this->change)){
            return false;
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_names '.
            'SET '.
                'status = '.STATUS_COMMUNITY_CHANGE.' '.
            'WHERE '.
                'id ='.$this->change .' AND '.
                'ref_community = '.$this->ref_community.' AND '.
                'status != '.STATUS_COMMUNITY_ADMIN;
        return $this->objdb->exec($sql);
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @param integer $id
     * @param string $tpl
     * @return void
     */
    function send_mail($id,$tpl)
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'act.email as email,'.
                'pro.nickname as nickname,'.
                'frm.nickname as from_name,'.
                'com.community as community,'.
                'com.ref_account as ref_account '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'act_profile frm,'.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = nam.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'com.id = nam.ref_community AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.id = '.$id.' AND '.
                'frm.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail($tpl);

        $objmail->Assign('friend', $infos['from_name']);
        $objmail->Assign('user_name', $infos['nickname']);
        $objmail->Assign('community', $infos['community']);
        $objmail->Assign('url', HTTP_ACTION.'community/show/community/'.$communitys['id'].'/');
        $objmail->Assign('url2', HTTP_ACTION.'private/edit/relation/');

        $to = sql_query::decrypt($infos['email']);
        $objmail->send($to);
    }
} // webapp
?>
