<?php
/* ========================================================================
 - [modules/public/content/category.php]
 -      カテゴリ閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * ページ名
     * @var string
     */
    var $origin = '';

    /**
     * カテゴリID
     * @var integer
     */
    var $ref_category = 1;

    /**
     * リスト
     * @var array
     */
    var $list = array();

    /**
     * リンク表示方法
     * @var integer
     */
    var $link_style = 1;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/content/category.tpl');

        /* PathInfoによる引数の取得 */
        $this->setPathInfo('origin',0,'string');
        $this->Assign('origin', $this->origin);

        $this->set_category();
        $this->set_inner_item();
        $this->set_list();
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category,'.
                'nltobr,'.
                'link_style,'.
                'url,'.
                'body '.
            'FROM '.
                DB_PREFIX.'itm_category '.
            'WHERE '.
                'status = '.VISIBILITY_PUBLIC.' AND '.
                "origin='".$this->origin."' ";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->ref_category = $result['id'];
        $this->link_style = $result['link_style'];

        $this->Assign('main_title', $result['category']);
        $this->Assign('category', $result);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function set_inner_item()
    {
        $sql=
            'SELECT '.
                'regist_date,'.
                'modify,'.
                'origin,'.
                'subject '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'ref_category = '.$this->ref_category.' AND '.
                'status = '.VISIBILITY_PUBLIC.' '.
            'ORDER BY '.
                'regist_date';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        foreach ($result as $value){
            $this->list[] = array(
                'regist_date'=> $value['regist_date'],
                'modify'=> $value['modify'],
                'title'=> $value['subject'],
                'page'=>  $value['origin'].'/'
            );
        }
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     */
    function set_list()
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($this->list as $value){
            // 改行処理
            if ($column >= $this->link_style){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } 
        
        $this->Assign('list', $list);
    }
} // webapp
?>
