<?php
/* ========================================================================
 - [modules/public/community/community.php]
 -      コミュニティ情報
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/08/29] 表示整形の不具合修正
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * コミュニティID
     * @var integer
     */
    var $ref_community = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/community/community.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_community');
        $this->Assign('ref_community', $this->ref_community);

        $this->set_community();
        $this->set_member();
        $this->set_category();

        $visibilitys = array(
            VISIBILITY_PUBLIC=>  VISIBILITY_LABEL_PUBLIC_ENTRY,
            VISIBILITY_PRIVATE=> VISIBILITY_LABEL_PRIVATE,
            VISIBILITY_HIDDEN=>  VISIBILITY_LABEL_HIDDEN,
        );
        $this->Assign('visibilitys', $visibilitys);
    }

    /**
     * コミュニティ情報の設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $visibility = '';
        if (!WAP_SNS_VISIBILITY){
            $visibility = 'com.visibility = '.VISIBILITY_PUBLIC.' AND ';
        }
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'com.regist_date as regist_date,'.
                'com.visibility as visibility,'.
                'com.total as total,'.
                'com.publicity as publicity,'.
                'com.ref_account as ref_account,'.
                'pro.nickname as nickname,'.
                'prf.prefecture as prefecture,'.
                'pic.filename as src,'.
                'pic.width as width,'.
                'pic.height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'ara_prefecture prf '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = com.ref_account AND '.
                'prf.id = com.ref_prefecture AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                $visibility.
                'com.id = '.$this->ref_community;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community',$result);
    }

    /**
     * 会員の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = nam.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'nam.ref_community = '.$this->ref_community .' AND '.
                'pro.visibility = '.VISIBILITY_PUBLIC.' AND '.
                sql_query::bitFlag('nam.status & '.STATUS_COMMUNITY_MEMBERS).' '.
            'ORDER BY '.
                'nam.modify '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list=array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?NOPHOTO_SMALL:$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=>            $value['id'],
                'nickname'=>      $value['nickname'],
                'friend_number'=> $value['friend_number'],
                'src'=>           $value['src'],
                'width'=>         $value['width'],
                'height'=>        $value['height']
            );
            $row++;
        }
        
        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $list[] = array(
                'id'=> 0,
                'nickname'=> '',
                'friend_number'=>0,
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('member', $this->shape_member($list));
    }

    /**
     * 会員情報の成形
     *
     * @access private
     * @return void
     */
    function shape_member($friends)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($friends as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql = 
            'SELECT '.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'com_genre gen,'.
                DB_PREFIX.'com_category cat,'.
                DB_PREFIX.'com_select sel '.
            'WHERE '.
                'gen.id = cat.ref_genre AND '.
                'cat.id = sel.ref_category AND '.
                'sel.ref_community = '.$this->ref_community .' '.
            'ORDER BY '.
                'gen.sort,'.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $this->Assign('categorys', $result);
    }
} // webapp
?>
