<?php
/* ========================================================================
 - [modules/private/review/post.php]
 -      レビュー投稿
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'PEAR/Services/Amazon.php';
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * レビューID
     * @var integer
     */
    var $id = null;

    /**
     * ASINコード
     * @var string
     */
    var $asin = '';

    /**
     * データ整合性ブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 商品情報
     * @var array
     */
    var $item = array();

    /**
     * 商品ID
     * @var integer
     */
    var $ref_item = 0;

    /**
     * カテゴリ
     * @var integer
     */
    var $ref_category = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('private/review/post.tpl');

        $this->setSafety('id');
        $this->setSafety('asin', '_REQUEST', 'string');
        $this->setSafety('ref_category');

        /* アクション処理 */
        if (empty($this->asin)){
            header('Location: '.HTTP_ACTION.'private/review/list/');
            exit();
        }
        if (!empty($_REQUEST['back'])){
            header('Location: '.HTTP_ACTION.'private/review/post/again/'.WAP_URI_SEPARATOR.'id='.$this->id.'&asin='.urlencode($this->asin).'&ref_category='.$this->ref_category);
            exit();
        }

        $this->set_item();
        
        if ($this->delete_review()){
            $this->update_total();
            header('Location: '.HTTP_ACTION.'private/review/list/'.WAP_URI_SEPARATOR.'delete=1');
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'rev_review');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_total();
            header('Location: '.HTTP_ACTION.'private/review/browse/'.WAP_URI_SEPARATOR.'id='.$this->ref_item);
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/review/post/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id.'&asin='.urlencode($this->asin).'&ref_category='.$this->ref_category);
            exit();
        }
        
        $this->set_point();

        $this->Assign('id', $this->id);
        $this->Assign('asin',$this->asin);
        $this->Assign('ref_category',$this->ref_category);

        $this->setEmojiInit();
    }

    /**
     * 評価ポイントの設定
     *
     * @access private
     * @return void
     */
    function set_point()
    {
        $sql=
            'SELECT '.
                'point,'.
                'label '.
            'FROM '.
                DB_PREFIX.'rev_point '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['point']] = $value['label'];
        }
        
        $this->Assign('points', $list);
    }

    /**
     * レビュー対象商品情報の設定
     *
     * @access private
     * @return void
     */
    function set_item()
    {
        $amazon = &new Services_Amazon(AMAZON_TOKEN, AMAZON_ASSOCIATEID, AMAZON_LOCALE, AMAZON_BASEURL);

        $products = $amazon->searchAsin($this->asin);

        $this->item = array();
        for ($row=0; $row<LIMIT_REVIEW; $row++) {
            if (!isset($products[$row])){
                break;
            }

            $product = $products[$row];
            $product['authors'] = empty($product['authors'])?null:$product['authors'];
            $product['artists'] = empty($product['artists'])?null:$product['artists'];


            if (is_array($product['authors'])) {
                $product['creator'] = implode(', ', $product['authors']);
            } elseif (is_array($product['artists'])) {
                $product['creator'] = implode(', ', $product['artists']);
            }

            $ourprice = empty($product['ourprice'])?null:$product['ourprice'];
            $product['listprice'] = empty($product['listprice'])?$ourprice:$product['listprice'];
            $product['ourprice']  = empty($product['ourprice'])?$product['listprice']:$product['ourprice'];
            if ($product['listprice'] != $product['ourprice']) {
                $product['price'] = $product['listprice'] .'('. $product['ourprice'].')';
            } else {
                $product['price'] = $product['listprice'];
            }

            $this->item = $product;
        }

        $this->Assign('item', $this->item);
    }

    /**
     * アカウントの確認
     *
     * @access private
     * @return integer
     */
    function set_carid()
    {
        $sql = 
            'SELECT '.
                'rev.id as id '.
            'FROM '.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'itm.id = rev.ref_item AND '.
                'itm.asin = '.$this->objdb->quote($this->asin).' AND '.
                'rev.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->id = empty($result['id'])?'':$result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* カレントIDの設定 */
        $this->set_carid();
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);

        $is_manip  = preg_match('/manip/',$_SERVER['REQUEST_URI']);        
        if (!empty($is_manip)){
            $this->objmnp->setValue('ref_item', $this->query_item());
        }


        /* 入力フォームからをキャッチ */
        $skip = array(
            'ref_item',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  ID
     */
    function query_item()
    {
        $sql = 
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'rev_item '.
            'WHERE '.
                'asin = '."'".$this->asin."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'rev_item');

        $objmnp->setValue('modify', date('Y-m-d H:i:s'));
        
        $id = empty($result['id'])?null:$result['id'];
        $this->manip_item($id);
        
        return $this->ref_item;
    }

    /**
     * 商品情報の挿入
     *
     * @access private
     * @param integer $id
     * @return integer  データ操作結果
     */
    function manip_item($id)
    {
        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'rev_item');

        if (!empty($id)){
            $objmnp->setCurID($id);
        }

        $objmnp->setValue('modify',       date('Y-m-d H:i:s'));
        $objmnp->setValue('ref_category', $this->ref_category);
        $objmnp->setValue('url',          $this->item['url']);
        $objmnp->setValue('asin',         $this->item['asin']);
        $objmnp->setValue('name',         $this->item['name']);
        $objmnp->setValue('creator',      $this->item['creator']);
        $objmnp->setValue('release',      $this->item['release']);
        $objmnp->setValue('manufacturer', $this->item['manufacturer']);
        $objmnp->setValue('imagesmall',   $this->item['imagesmall']);
        $objmnp->setValue('imagemedium',  $this->item['imagemedium']);
        $objmnp->setValue('imagelarge',   $this->item['imagelarge']);
        $objmnp->setValue('listprice',    $this->item['listprice']);
        $objmnp->setValue('ourprice',     $this->item['ourprice']);

        $objmnp->doManip($this);
        
        $this->ref_item = $objmnp->getCurID();
    }

    /**
     * レビューの削除
     *
     * @access private
     * @param integer $id
     * @return integer
     */
    function delete_review()
    {
        if (empty($_REQUEST['delete'])){
            return false;
        }
        if (empty($this->id)){
            return false;
        }

        $sql = 
            'SELECT '.
                'ref_item '.
            'FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'id='.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['ref_item'])){
            return false;
        }
        $this->ref_item = $result['ref_item'];

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'id='.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * ポイント総数を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_total()
    {
        $sql = 
            'SELECT '.
                '(sum(point) / count(id)) as total,'.
                'count(id) as post '.
            'FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'ref_item = '.$this->ref_item;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'rev_item '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'total = '.$total.','.
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->ref_item;
        $this->objdb->exec($sql);
    }
} // webapp
?>
