<?php
/* ========================================================================
 - [modules/private/edit/profile.php]
 -      プロフィール編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/05/27] 市区町村取得エラーを修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'private/act_enquete.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * データ操作ブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 入力フォーム格納用
     * @var array
     */
    var $objenq = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('private/edit/profile.tpl');
        
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/edit/profile/'.$this->sid.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_profile');
        $this->objenq = new act_enquete($this->objdb, $this);
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/edit/profile/'.$this->sid.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/edit/profile/'.$this->sid.'/confirm/');
            exit();
        }

        $this->set_date();
        $this->set_prefecture();
        $this->set_local('ref_prefecture');
        $this->set_local('ref_hometown');
        $this->set_sex();
        $this->set_blood();
        $this->set_married();

        $visibilitys = array(
            VISIBILITY_PUBLIC=>    VISIBILITY_LABEL_PUBLIC,
            VISIBILITY_PROTECTED=> VISIBILITY_LABEL_PROTECTED,
            VISIBILITY_FRIEND=>    VISIBILITY_LABEL_FRIEND,
            VISIBILITY_HIDDEN=>    VISIBILITY_LABEL_HIDDEN,
        );
        $this->Assign('visibilitys', $visibilitys);
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
    	$years = array();
    	$months = array();
    	$days = array();

    	$max_year = date('Y') + 1;
    	for ($num=WAP_START_AGE;$num<=$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);

        $now_date = '';

        /* 開始年月日: */
        $date = $this->objmnp->getValue('birthday');
        $date = empty($date)?$this->objmnp->getInitValue('birthday'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('birthday', $init_date);
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 市区町村の設定
     *
     * @access private
     * @return void
     */
    function set_local($target)
    {
        $assign = array(
            'ref_prefecture'=>'locals',
            'ref_hometown'=>  'homelocals',
        );
        /* 開始年月日: */
        $ref_parent = $this->objmnp->getValue($target);
        $ref_parent = empty($ref_parent)?$this->objmnp->getInitValue($target):$ref_parent;
        $ref_parent = empty($ref_parent)?0:$ref_parent;

        $sql=
            'SELECT '.
                'id,'.
                'local '.
            'FROM '.
                DB_PREFIX.'ara_local '.
            'WHERE '.
                'ref_prefecture = '.$ref_parent.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $list[0] = '市区町村';
        foreach ($result as $value){
            $list[$value['id']] = $value['local'];
        }
        
        $this->Assign($assign[$target], $list);
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sex '.
            'FROM '.
                DB_PREFIX.'act_sex '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['sex'];
        }
        
        $this->Assign('sexs',$list);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'id,'.
                'blood '.
            'FROM '.
                DB_PREFIX.'act_blood '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['blood'];
        }
        
        $this->Assign('bloods',$list);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'id,'.
                'married '.
            'FROM '.
                DB_PREFIX.'act_married '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['married'];
        }
        
        $this->Assign('marrieds',$list);
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return void
     */
    function get_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* カレントIDの設定 */
        $this->objmnp->setCurID($this->get_curid());

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        $is_manip  = preg_match('/manip/',$_SERVER['REQUEST_URI']);

        $this->objenq->execute();
        if (!$this->objenq->getValidate()){
            $this->objmnp->setAlert('act_enquete');
        }

        /* 初期データの加工設定 */
        $func = array('sql_query', 'decrypt');
        $this->objmnp->setInitEffect('first_name', array('func'=>$func));
        $this->objmnp->setInitEffect('second_name', array('func'=>$func));

        /* 入力データの加工設定 */
        $func = array('sql_query', 'encrypt');
        $this->objmnp->setInputEffect('first_name', array('func'=>$func));
        $this->objmnp->setInputEffect('second_name', array('func'=>$func));

        $this->objmnp->setInputEffect('publicity', array('func'=>array('webapp', 'emojiConvert')));

        /* 入力フォームからをキャッチ */
        $skip = array(
            'ref_account',
        );
        return $this->objmnp->execute($this, $skip);
    }
} // webapp
?>
