<?php
/* ========================================================================
 - [modules/private/edit/community.php]
 -      参加コミュニティ一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 友達登録ID
     * @var object
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/edit/community.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');

        $this->set_community();
    }

    /**
     * グループの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, 50);    // クラスの生成
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'com.publicity as publicity,'.
                'com.total as total,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('nms.status & '.STATUS_COMMUNITY_MEMBERS).' AND '.
                'nms.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'nms.modify ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        
        $list = array();
        $row=0;
        
        $this->Assign('communitys', $result);
    }
} // webapp
?>
