<?php
/* ========================================================================
 - [modules/friend/diary/list.php]
 -      日記一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/07/18] 一覧取得時の負荷軽減処置
 -      [2007/02/13] 公開フラグをビットフラグに対応
 -      [2006/07/27] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 日記情報
     * @var array
     */
    var $diary = array();

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objcal = null;

    /**
     * テーブル名
     * @var string
     */
    var $table = '';

    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * GROUP句
     * @var string
     */
    var $group = '';

    /**
     * 公開設定
     * @var string
     */
    var $visibility = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/diary/list.tpl');

        /* カレンダーオブジェクトの生成 */
        $this->objcal = new RKT_calendar();

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->ref_friend);
        $objmenu->setMenu($this->account['id']);

        $this->set_diary();
        $this->set_visibility();
        $this->set_condition();
        $this->set_list();
    }

    /**
     * 日記情報の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'id,'.
                'visibility,'.
                'url '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->diary = $result;
        $this->Assign('another_diary', $result['url']);
    }

    /**
     * 閲覧者判定の設定
     *
     * @access private
     * @return void
     */
    function set_visibility()
    {
        $this->visibility  = VISIBILITY_PUBLIC;
        $this->visibility |= VISIBILITY_PROTECTED;

        /* 友達に公開 */
        if ($this->isFriend()){
            $this->visibility |= VISIBILITY_FRIEND;
        }
    }

    /**
     * コメント数の設定
     *
     * @access private
     * @return void
     */
    function set_comment_num()
    {
        $sql=
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $comment_num = empty($result['ct'])?0:$result['ct'];
        $this->Assign('comment_num', $comment_num);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'day'=> array(
                'type'=> 'date',
                'option'=> array('format'=>'%Y-%m-%d')
            ),
            'date'=> array(
                'type'=> 'date',
                'option'=> array('format'=>'%Y-%m-%d')
            ),
            'category'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * 記事リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();

        /* 日付 */
        if (!empty($conditions['day'])){
            $date_format = sql_query::dateFormat('ent.regist_date','%Y-%m-%d');
            $where[] = $date_format."='".$conditions['day']."'";
        }
        /* アーカイブ年月 */
        if (!empty($conditions['date'])){
            $month_format = sql_query::dateFormat('ent.regist_date','%Y-%m-01');
            $where[] = $month_format."='".$conditions['date']."'";
        }
        /* カテゴリ */
        if (!empty($conditions['category'])){
            $this->table = ','.DB_PREFIX.'dia_select sel ';
            $where[] = 'ent.id = sel.ref_entry';
            $where[] = 'sel.ref_category = '.$conditions['category'];
        }

        /* GROUP BY */
        if (!empty($this->table)){
            $this->group = 'GROUP BY ent.id ';
        }

        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_entry
     * @return void
     */
    function get_picture($ref_entry)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result;
    }

    /**
     * カテゴリの取得
     *
     * @access private
     * @param integer $ref_entry
     * @return array
     */
    function get_category($ref_entry)
    {
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat,'.
                DB_PREFIX.'dia_select sel '.
            'WHERE '.
                'cat.id = sel.ref_category AND '.
                'cat.ref_diary = '.$this->diary['id'].' AND '.
                'sel.ref_entry = '.$ref_entry.' '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_DIARY);    // クラスの生成
        $sql=
            'SELECT '.
                'ent.id as id,'.
                'ent.modify as modify,'.
                'ent.regist_date as regist_date,'.
                'ent.visibility as visibility,'.
                'ent.subject as subject,'.
                'ent.body as body,'.
                'ent.post as comments '.
            'FROM '.
                DB_PREFIX.'dia_entry ent '.
                $this->table.
            'WHERE '.
                'ent.ref_account = '.$this->ref_friend.' AND '.
                sql_query::bitFlag('ent.visibility & '.$this->visibility).' '.
                $this->where.' '.
                $this->group.' '.
            'ORDER BY '.
                'ent.regist_date DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $value['picture'] = $this->get_picture($value['id']);
            $value['categorys'] = $this->get_category($value['id']);
            $list[] = $value;
        }

        $this->Assign('list', $list);
    }
} // webapp
?>
