<?php
/* ========================================================================
 - [webapp/libs/wap_friend.php]
 -      friend用WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/07/05] 絵文字コンバートで文字コードの変更はなし
 -      [2007/02/13] 公開レベルを保持
 -      [2006/09/20] $this->base['uri_separator']を追加
 -      [2006/08/28] あしあと処理をメンバ関数に所持
 -      [2006/08/26] 友達情報をメンバ変数に所持
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once LIB_DIR.'rkt_webapp.php';

/**
 * friend用WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_friend
 * @access public
 * @version 1.0
 */
class WAP_friend extends RKT_webapp
{
    /**
     * PHPSESSID
     * @var string
     */
    var $sid = '';

    /**
     * アカウント情報
     * @var object
     */
    var $account = array();

    /**
     * 友達情報
     * @var object
     */
    var $friend = array();

    /**
     * error情報
     * @var boolean
     */
    var $error = false;

    /**
     * 友達ID
     * @var integer
     */
    var $ref_friend = 0;

    /**
     * 表示公開レベル
     * @var integer
     */
    var $visibility = VISIBILITY_PUBLIC;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function WAP_friend()
    {
        $this->RKT_webapp();

        $objact = account::getInstance();
        $this->sid = $objact->getSessionID();
        $this->account = $objact->getInfo();
        $this->base['account'] = $this->account;

        $this->__initialize();

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friend');

        if ($this->account['id'] == $this->ref_friend){
            header('Location: '.HTTP_ACTION.'private/show/profile/'.$this->sid.'/');
            exit();
        }

        /* 友達情報の設定 */
        $this->set_friend_info();
        if (empty($this->friend['id'])){
            header('Location: '.HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            exit();
        }

        if ($this->breaker()){
            header('Location: '.HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            exit();
        }
        $this->set_visibility();

        $this->base['ref_friend'] = $this->ref_friend;
        $this->base['friend']     = $this->friend;
        $this->base['visibility'] = $this->visibility;
    }

    /**
     * MobileAppの初期化
     *
     * @access private
     * @return void
     */
    function __initialize()
    {
        $this->smarty->register_outputfilter('tpl_utf2sjis');

        foreach ($_POST as $key=> $value){
            if (is_string($value)){
                $_POST[$key] = mb_convert_encoding($value, ENCODE_TYPE, 'SJIS');
                $_REQUEST[$key] = $_POST[$key];
            }
        } // foreach ($_POST as $key=> $value)

        foreach ($_GET as $key=> $value){
            if (is_string($value)){
                $_GET[$key] = mb_convert_encoding($value, ENCODE_TYPE, 'SJIS');
                $_REQUEST[$key] = $_GET[$key];
            }
        } // foreach ($_GET as $key=> $value)
        
        $this->base['sid']    = session_id();
        $this->base['url']    = BASE_URL;
        $this->base['http']   = HTTP_ACTION;
        $this->base['ssl']    = SSL_ACTION;
        $this->base['config'] = 'friend.conf';

        $this->base['uri_separator']  = htmlspecialchars(WAP_URI_SEPARATOR);
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
        if ($this->error){
            $this->template_file = 'error.tpl';
            error_log('WAP_friend::error'."\r\n", 3, ERROR_LOG_FILE);
        }
        $this->mixOutput();
    }

    /**
     * 友達情報の設定
     *
     * @access private
     * @return void
     **/
    function set_friend_info()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.email as email,'.
                'act.block as block,'.
                'act.last_login as last_login,'.
                'act.friend_number as friend_number,'.
                'pro.nickname as nickname,'.
                'pro.publicity as publicity,'.
                'sex.sex as sex,'.
                'pht.filename as href,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->friend = $stmt->fetch(PDO_FETCH_ASSOC);

        if (empty($this->friend['src'])){
            $this->friend['href']   = NOPHOTO_LARGE;
            $this->friend['src']    = NOPHOTO_SMALL;
            $this->friend['width']  = PHOTO_SMALL_SIZE;
            $this->friend['height'] = PHOTO_SMALL_SIZE;
        }
    }

    /**
     * 嫌なユーザーを遮断する
     *
     * @access public
     * @return void
     **/
    function breaker()
    {
        $sql=
            'SELECT '.
                'block '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'id = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $blocks = explode("\r\n", $result['block']);
        
        return in_array($this->account['id'], $blocks);
    }

    /**
     * 友達かの判定
     *
     * @access public
     * @return boolean
     */
    function isFriend()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                '('.
                    '(ref_account = '.$this->ref_friend.' AND '.
                    'ref_friend = '.$this->account['id'].') OR '.
                    '(ref_account = '.$this->account['id'].' AND '.
                    'ref_friend = '.$this->ref_friend.')'.
                ')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        return !empty($result['ct']);
    }

    /**
     * あしあと処理
     *
     * @access public
     * @return boolean
     */
    function doFootprint()
    {
        $this->insert_footprint();
        $this->insert_accesslog();
        $this->send_kiriban();
    }

    /**
     * 足跡の挿入
     *
     * @access private
     * @return integer  データ操作結果
     */
    function insert_footprint()
    {
        $to_date = sql_query::toDate('modify');
        $sql = 
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_footprint '.
            'WHERE '.
                $to_date." = '".date('Y-m-d')."' AND ".
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        if (empty($result['id'])){
            $sql =
                'INSERT INTO '.
                    DB_PREFIX.'fri_footprint('.
                        'modify,'.
                        'ref_account,'.
                        'ref_friend '.
                    ') VALUES ('.
                        "'".date('Y-m-d H:i:s')."',".
                        $this->ref_friend.','.
                        $this->account['id'].
                    ')';
        } else {
            $sql =
                'UPDATE '.
                    DB_PREFIX.'fri_footprint '.
                'SET '.
                    "modify = '".date('Y-m-d H:i:s')."' ".
                'WHERE '.
                    'id='.$result['id'];
        }
        return $this->objdb->exec($sql);
    }

    /**
     * アクセスログの挿入
     *
     * @access private
     * @return boolean 正常時：真
     */
    function insert_accesslog()
    {
        $sql = 
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'fri_accesslog '.
            'WHERE '.
                "modify > '".date('Y-m-d H:i:s',time()-3600)."' AND ".
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        if (empty($result['ct'])){
            $unique = 1;
            $sql=
                'INSERT INTO '.
                    DB_PREFIX.'fri_accesslog('.
                        'modify,'.
                        'ref_account,'.
                        'ref_friend,'.
                        'unique_flag '.
                    ') VALUES ('.
                        "'".date('Y-m-d H:i:s')."',".
                        $this->ref_friend.','.
                        $this->account['id'].','.
                        "'".$unique."'".
                    ')';
            $this->objdb->exec($sql);
        }
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail($footprint)
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);

        include_once WEBAPP_LIB_DIR.'sendmail.php';
        $objmail = new sendmail('footprint');

        $objmail->Assign('footprint', $footprint);
        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'friend/show/profile/'.$this->account['id'].'/');
        
        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }

    /**
     * キリ番訪問のお知らせメール
     *
     * @access private
     * @return void
     */
    function send_kiriban()
    {
        $sql = 
            'SELECT '.
                'act.footprint as footprint,'.
                'act.total as total,'.
                'count(acc.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'fri_accesslog acc '.
                    'ON act.id = acc.ref_account AND '.
                    'acc.unique_flag = 1 '.
            'WHERE '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_friend.' '.
            'GROUP BY '.
                'act.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        if (empty($result['footprint'])){
            return ;
        }

        $total = $result['total'] + $result['ct'];        
        if ($total == $result['footprint']){
            $this->send_mail($result['footprint']);
        }
    }

    /**
     * 公開レベルの設定
     *
     * @access private
     * @return void
     */
    function set_visibility()
    {
        $this->visibility  = VISIBILITY_PUBLIC;
        $this->visibility |= VISIBILITY_PROTECTED;
        $sql=
            'SELECT '.
                'status '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'ref_account ='.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result['status'])){
            return ;
        }

        $this->visibility |= VISIBILITY_FRIEND;
    }

    /**
     * 絵文字コンバート
     *
     * @access public
     * @return void
     **/
    function emojiConvert($string)
    {
        static $objemoji;
        
        if (empty($objemoji)) {        
            $objemoji = new RKT_emoji();
        }
        $string = $objemoji->convert($string, 'Tag');

        return $string;
    }
}
// WAP_friendの終了
?>
