<?php
/* ========================================================================
 - [libs/rktEmoji/EZweb.php]
 -      EZweb用絵文字変換
 -      Copyright (c) 2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 参考資料：
 -       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 - 更新履歴：
 -      [2007/06/24] 作成
 - ======================================================================== */

/**
 * EZweb用絵文字変換
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package emoji_EZweb
 * @access public
 * @version 0.1
 */
class emoji_EZweb
{
    /**
     * EZwebから独自タグへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    function ezweb2tag($hex)
    {
        $map = array(
            'F659'=>'[m:1]',      'F65A'=>'[m:2]',      'F65B'=>'[m:3]',      'F748'=>'[m:4]',      'F749'=>'[m:5]',
            'F74A'=>'[m:6]',      'F74B'=>'[m:7]',      'F74C'=>'[m:8]',      'F74D'=>'[m:9]',      'F74E'=>'[m:10]',
            'F74F'=>'[m:11]',     'F69A'=>'[m:12]',     'F6EA'=>'[m:13]',     'F796'=>'[m:14]',     'F65E'=>'[m:15]',
            'F65F'=>'[m:16]',     'F750'=>'[m:17]',     'F751'=>'[m:18]',     'F752'=>'[m:19]',     'F753'=>'[m:20]',
            'F754'=>'[m:21]',     'F755'=>'[m:22]',     'F756'=>'[m:23]',     'F757'=>'[m:24]',     'F797'=>'[m:25]',
            'F758'=>'[m:26]',     'F759'=>'[m:27]',     'F75A'=>'[m:28]',     'F75B'=>'[m:29]',     'F75C'=>'[m:30]',
            'F75D'=>'[m:31]',     'F75E'=>'[m:32]',     'F75F'=>'[m:33]',     'F760'=>'[m:34]',     'F761'=>'[m:35]',
            'F762'=>'[m:36]',     'F763'=>'[m:37]',     'F764'=>'[m:38]',     'F765'=>'[m:39]',     'F766'=>'[m:40]',
            'F767'=>'[m:41]',     'F768'=>'[m:42]',     'F769'=>'[m:43]',     'F660'=>'[m:44]',     'F693'=>'[m:45]',
            'F7B1'=>'[m:46]',     'F661'=>'[m:47]',     'F6EB'=>'[m:48]',     'F77C'=>'[m:49]',     'F6D3'=>'[m:50]',
            'F7B2'=>'[m:51]',     'F69B'=>'[m:52]',     'F6EC'=>'[m:53]',     'F76A'=>'[m:54]',     'F76B'=>'[m:55]',
            'F77D'=>'[m:56]',     'F798'=>'[m:57]',     'F654'=>'[m:58]',     'F77E'=>'[m:59]',     'F662'=>'[m:60]',
            'F76C'=>'[m:61]',     'F76D'=>'[m:62]',     'F76E'=>'[m:63]',     'F76F'=>'[m:64]',     'F69C'=>'[m:65]',
            'F770'=>'[m:66]',     'F780'=>'[m:67]',     'F6D4'=>'[m:68]',     'F663'=>'[m:69]',     'F771'=>'[m:70]',
            'F772'=>'[m:71]',     'F6ED'=>'[m:72]',     'F773'=>'[m:73]',     'F6B8'=>'[m:74]',     'F640'=>'[m:75]',
            'F644'=>'[m:76]',     'F64E'=>'[m:77]',     'F6B9'=>'[m:78]',     'F7AC'=>'[m:79]',     'F6D5'=>'[m:80]',
            'F774'=>'[m:81]',     'F775'=>'[m:82]',     'F674'=>'[m:83]',     'F7AD'=>'[m:84]',     'F7B3'=>'[m:85]',
            'F6D6'=>'[m:86]',     'F799'=>'[m:87]',     'F776'=>'[m:88]',     'F777'=>'[m:89]',     'F790'=>'[m:90]',
            'F675'=>'[m:91]',     'F781'=>'[m:92]',     'F7B4'=>'[m:93]',     'F6EE'=>'[m:94]',     'F664'=>'[m:95]',
            'F694'=>'[m:96]',     'F782'=>'[m:97]',     'F65C'=>'[m:98]',     'F642'=>'[m:99]',     'F783'=>'[m:100]',
            'F784'=>'[m:101]',    'F785'=>'[m:102]',    'F786'=>'[m:103]',    'F6EF'=>'[m:104]',    'F787'=>'[m:105]',
            'F676'=>'[m:106]',    'F665'=>'[m:107]',    'F6FA'=>'[m:108]',    'F79A'=>'[m:109]',    'F6F0'=>'[m:110]',
            'F79B'=>'[m:111]',    'F684'=>'[m:112]',    'F6BD'=>'[m:113]',    'F79C'=>'[m:114]',    'F79D'=>'[m:115]',
            'F6D7'=>'[m:116]',    'F778'=>'[m:117]',    'F779'=>'[m:118]',    'F6F1'=>'[m:119]',    'F6F2'=>'[m:120]',
            'F788'=>'[m:121]',    'F677'=>'[m:122]',    'F79E'=>'[m:123]',    'F6F3'=>'[m:124]',    'F68A'=>'[m:125]',
            'F79F'=>'[m:126]',    'F791'=>'[m:127]',    'F792'=>'[m:128]',    'F6F4'=>'[m:129]',    'F7A0'=>'[m:130]',
            'F789'=>'[m:131]',    'F77A'=>'[m:132]',    'F6A7'=>'[m:133]',    'F6BA'=>'[m:134]',    'F7A1'=>'[m:135]',
            'F77B'=>'[m:136]',    'F78A'=>'[m:137]',    'F6F5'=>'[m:138]',    'F7A2'=>'[m:139]',    'F6D8'=>'[m:140]',
            'F6D9'=>'[m:141]',    'F78B'=>'[m:142]',    'F678'=>'[m:143]',    'F6A8'=>'[m:144]',    'F6F6'=>'[m:145]',
            'F685'=>'[m:146]',    'F78C'=>'[m:147]',    'F68B'=>'[m:148]',    'F679'=>'[m:149]',    'F7A3'=>'[m:150]',
            'F7AE'=>'[m:151]',    'F7A4'=>'[m:152]',    'F7AF'=>'[m:153]',    'F7B0'=>'[m:154]',    'F6F7'=>'[m:155]',
            'F686'=>'[m:156]',    'F78D'=>'[m:157]',    'F67A'=>'[m:158]',    'F793'=>'[m:159]',    'F69D'=>'[m:160]',
            'F7A5'=>'[m:161]',    'F7A6'=>'[m:162]',    'F6DA'=>'[m:163]',    'F7A7'=>'[m:164]',    'F6F8'=>'[m:165]',
            'F6F9'=>'[m:166]',    'F666'=>'[m:167]',    'F68C'=>'[m:168]',    'F68D'=>'[m:169]',    'F6A1'=>'[m:170]',
            'F7A8'=>'[m:171]',    'F68E'=>'[m:172]',    'F7A9'=>'[m:173]',    'F7AA'=>'[m:174]',    'F7AB'=>'[m:175]',
            'F655'=>'[m:176]',    'F656'=>'[m:177]',    'F657'=>'[m:178]',    'F658'=>'[m:179]',    'F6FB'=>'[m:180]',
            'F6FC'=>'[m:181]',    'F740'=>'[m:182]',    'F741'=>'[m:183]',    'F742'=>'[m:184]',    'F743'=>'[m:185]',
            'F744'=>'[m:186]',    'F745'=>'[m:187]',    'F746'=>'[m:188]',    'F747'=>'[m:189]',    'F641'=>'[m:190]',
            'F65D'=>'[m:191]',    'F667'=>'[m:192]',    'F668'=>'[m:193]',    'F669'=>'[m:194]',    'F66A'=>'[m:195]',
            'F66B'=>'[m:196]',    'F66C'=>'[m:197]',    'F66D'=>'[m:198]',    'F66E'=>'[m:199]',    'F66F'=>'[m:200]',
            'F670'=>'[m:201]',    'F671'=>'[m:202]',    'F672'=>'[m:203]',    'F673'=>'[m:204]',    'F67B'=>'[m:205]',
            'F67C'=>'[m:206]',    'F67D'=>'[m:207]',    'F67E'=>'[m:208]',    'F680'=>'[m:209]',    'F681'=>'[m:210]',
            'F682'=>'[m:211]',    'F683'=>'[m:212]',    'F78E'=>'[m:213]',    'F78F'=>'[m:214]',    'F687'=>'[m:215]',
            'F688'=>'[m:216]',    'F689'=>'[m:217]',    'F643'=>'[m:218]',    'F68F'=>'[m:219]',    'F690'=>'[m:220]',
            'F691'=>'[m:221]',    'F692'=>'[m:222]',    'F645'=>'[m:223]',    'F695'=>'[m:224]',    'F696'=>'[m:225]',
            'F697'=>'[m:226]',    'F698'=>'[m:227]',    'F699'=>'[m:228]',    'F646'=>'[m:229]',    'F647'=>'[m:230]',
            'F69E'=>'[m:231]',    'F69F'=>'[m:232]',    'F6A0'=>'[m:233]',    'F6A2'=>'[m:234]',    'F6A3'=>'[m:235]',
            'F6A4'=>'[m:236]',    'F6A5'=>'[m:237]',    'F6A6'=>'[m:238]',    'F6A9'=>'[m:239]',    'F6AA'=>'[m:240]',
            'F6AB'=>'[m:241]',    'F6AC'=>'[m:242]',    'F6AD'=>'[m:243]',    'F6AE'=>'[m:244]',    'F6AF'=>'[m:245]',
            'F648'=>'[m:246]',    'F6B0'=>'[m:247]',    'F6B1'=>'[m:248]',    'F6B2'=>'[m:249]',    'F6B3'=>'[m:250]',
            'F6B4'=>'[m:251]',    'F6B5'=>'[m:252]',    'F6B6'=>'[m:253]',    'F6B7'=>'[m:254]',    'F6BB'=>'[m:255]',
            'F6BC'=>'[m:256]',    'F649'=>'[m:257]',    'F64A'=>'[m:258]',    'F64B'=>'[m:259]',    'F64C'=>'[m:260]',
            'F64D'=>'[m:261]',    'F6BE'=>'[m:262]',    'F6BF'=>'[m:263]',    'F6C0'=>'[m:264]',    'F64F'=>'[m:265]',
            'F650'=>'[m:266]',    'F651'=>'[m:267]',    'F652'=>'[m:268]',    'F653'=>'[m:269]',    'F6C1'=>'[m:270]',
            'F6C2'=>'[m:271]',    'F6C3'=>'[m:272]',    'F6C4'=>'[m:273]',    'F6C5'=>'[m:274]',    'F6C6'=>'[m:275]',
            'F6C7'=>'[m:276]',    'F6C8'=>'[m:277]',    'F6C9'=>'[m:278]',    'F6CA'=>'[m:279]',    'F6CB'=>'[m:280]',
            'F6CC'=>'[m:281]',    'F6CD'=>'[m:282]',    'F6CE'=>'[m:283]',    'F6CF'=>'[m:284]',    'F6D0'=>'[m:285]',
            'F6D1'=>'[m:286]',    'F6D2'=>'[m:287]',    'F6DB'=>'[m:288]',    'F6DC'=>'[m:289]',    'F6DD'=>'[m:290]',
            'F6DE'=>'[m:291]',    'F6DF'=>'[m:292]',    'F6E0'=>'[m:293]',    'F6E1'=>'[m:294]',    'F6E2'=>'[m:295]',
            'F6E3'=>'[m:296]',    'F6E4'=>'[m:297]',    'F794'=>'[m:298]',    'F795'=>'[m:299]',    'F6E5'=>'[m:300]',
            'F6E6'=>'[m:301]',    'F6E7'=>'[m:302]',    'F6E8'=>'[m:303]',    'F6E9'=>'[m:304]',    'F7B5'=>'[m:305]',
            'F7B6'=>'[m:306]',    'F7B7'=>'[m:307]',    'F7B8'=>'[m:308]',    'F7B9'=>'[m:309]',    'F7BA'=>'[m:310]',
            'F7BB'=>'[m:311]',    'F7BC'=>'[m:312]',    'F7BD'=>'[m:313]',    'F7BE'=>'[m:314]',    'F7BF'=>'[m:315]',
            'F7C0'=>'[m:316]',    'F7C1'=>'[m:317]',    'F7C2'=>'[m:318]',    'F7C3'=>'[m:319]',    'F7C4'=>'[m:320]',
            'F7C5'=>'[m:321]',    'F7C6'=>'[m:322]',    'F7C7'=>'[m:323]',    'F7C8'=>'[m:324]',    'F7C9'=>'[m:325]',
            'F7CA'=>'[m:326]',    'F7CB'=>'[m:327]',    'F7CC'=>'[m:328]',    'F7CD'=>'[m:329]',    'F7CE'=>'[m:330]',
            'F7CF'=>'[m:331]',    'F7D0'=>'[m:332]',    'F7D1'=>'[m:333]',    'F7E5'=>'[m:334]',    'F7E6'=>'[m:335]',
            'F7E7'=>'[m:336]',    'F7E8'=>'[m:337]',    'F7E9'=>'[m:338]',    'F7EA'=>'[m:339]',    'F7EB'=>'[m:340]',
            'F7EC'=>'[m:341]',    'F7ED'=>'[m:342]',    'F7EE'=>'[m:343]',    'F7EF'=>'[m:344]',    'F7F0'=>'[m:345]',
            'F7F1'=>'[m:346]',    'F7F2'=>'[m:347]',    'F7F3'=>'[m:348]',    'F7F4'=>'[m:349]',    'F7F5'=>'[m:350]',
            'F7F6'=>'[m:351]',    'F7F7'=>'[m:352]',    'F7F8'=>'[m:353]',    'F7F9'=>'[m:354]',    'F7FA'=>'[m:355]',
            'F7FB'=>'[m:356]',    'F7FC'=>'[m:357]',    'F340'=>'[m:358]',    'F341'=>'[m:359]',    'F342'=>'[m:360]',
            'F343'=>'[m:361]',    'F344'=>'[m:362]',    'F345'=>'[m:363]',    'F346'=>'[m:364]',    'F347'=>'[m:365]',
            'F348'=>'[m:366]',    'F349'=>'[m:367]',    'F34A'=>'[m:368]',    'F34B'=>'[m:369]',    'F34C'=>'[m:370]',
            'F34D'=>'[m:371]',    'F34E'=>'[m:372]',    'F34F'=>'[m:373]',    'F350'=>'[m:374]',    'F351'=>'[m:375]',
            'F352'=>'[m:376]',    'F353'=>'[m:377]',    'F354'=>'[m:378]',    'F355'=>'[m:379]',    'F356'=>'[m:380]',
            'F357'=>'[m:381]',    'F358'=>'[m:382]',    'F359'=>'[m:383]',    'F35A'=>'[m:384]',    'F35B'=>'[m:385]',
            'F35C'=>'[m:386]',    'F35D'=>'[m:387]',    'F35E'=>'[m:388]',    'F35F'=>'[m:389]',    'F360'=>'[m:390]',
            'F361'=>'[m:391]',    'F362'=>'[m:392]',    'F363'=>'[m:393]',    'F364'=>'[m:394]',    'F365'=>'[m:395]',
            'F366'=>'[m:396]',    'F367'=>'[m:397]',    'F368'=>'[m:398]',    'F369'=>'[m:399]',    'F36A'=>'[m:400]',
            'F36B'=>'[m:401]',    'F36C'=>'[m:402]',    'F36D'=>'[m:403]',    'F36E'=>'[m:404]',    'F36F'=>'[m:405]',
            'F370'=>'[m:406]',    'F371'=>'[m:407]',    'F372'=>'[m:408]',    'F373'=>'[m:409]',    'F374'=>'[m:410]',
            'F375'=>'[m:411]',    'F376'=>'[m:412]',    'F377'=>'[m:413]',    'F378'=>'[m:414]',    'F379'=>'[m:415]',
            'F37A'=>'[m:416]',    'F37B'=>'[m:417]',    'F37C'=>'[m:418]',    'F37D'=>'[m:419]',    'F37E'=>'[m:420]',
            'F380'=>'[m:421]',    'F381'=>'[m:422]',    'F382'=>'[m:423]',    'F383'=>'[m:424]',    'F384'=>'[m:425]',
            'F385'=>'[m:426]',    'F386'=>'[m:427]',    'F387'=>'[m:428]',    'F388'=>'[m:429]',    'F389'=>'[m:430]',
            'F38A'=>'[m:431]',    'F38B'=>'[m:432]',    'F38C'=>'[m:433]',    'F38D'=>'[m:434]',    'F38E'=>'[m:435]',
            'F38F'=>'[m:436]',    'F390'=>'[m:437]',    'F391'=>'[m:438]',    'F392'=>'[m:439]',    'F393'=>'[m:440]',
            'F394'=>'[m:441]',    'F395'=>'[m:442]',    'F396'=>'[m:443]',    'F397'=>'[m:444]',    'F398'=>'[m:445]',
            'F399'=>'[m:446]',    'F39A'=>'[m:447]',    'F39B'=>'[m:448]',    'F39C'=>'[m:449]',    'F39D'=>'[m:450]',
            'F39E'=>'[m:451]',    'F39F'=>'[m:452]',    'F3A0'=>'[m:453]',    'F3A1'=>'[m:454]',    'F3A2'=>'[m:455]',
            'F3A3'=>'[m:456]',    'F3A4'=>'[m:457]',    'F3A5'=>'[m:458]',    'F3A6'=>'[m:459]',    'F3A7'=>'[m:460]',
            'F3A8'=>'[m:461]',    'F3A9'=>'[m:462]',    'F3AA'=>'[m:463]',    'F3AB'=>'[m:464]',    'F3AC'=>'[m:465]',
            'F3AD'=>'[m:466]',    'F3AE'=>'[m:467]',    'F3AF'=>'[m:468]',    'F3B0'=>'[m:469]',    'F3B1'=>'[m:470]',
            'F3B2'=>'[m:471]',    'F3B3'=>'[m:472]',    'F3B4'=>'[m:473]',    'F3B5'=>'[m:474]',    'F3B6'=>'[m:475]',
            'F3B7'=>'[m:476]',    'F3B8'=>'[m:477]',    'F3B9'=>'[m:478]',    'F3BA'=>'[m:479]',    'F3BB'=>'[m:480]',
            'F3BC'=>'[m:481]',    'F3BD'=>'[m:482]',    'F3BE'=>'[m:483]',    'F3BF'=>'[m:484]',    'F3C0'=>'[m:485]',
            'F3C1'=>'[m:486]',    'F3C2'=>'[m:487]',    'F3C3'=>'[m:488]',    'F3C4'=>'[m:489]',    'F3C5'=>'[m:490]',
            'F3C6'=>'[m:491]',    'F3C7'=>'[m:492]',    'F3C8'=>'[m:493]',    'F3C9'=>'[m:494]',    'F3CA'=>'[m:495]',
            'F3CB'=>'[m:496]',    'F3CC'=>'[m:497]',    'F3CD'=>'[m:498]',    'F3CE'=>'[m:499]',    'F7D2'=>'[m:500]',
            'F7D3'=>'[m:501]',    'F7D4'=>'[m:502]',    'F7D5'=>'[m:503]',    'F7D6'=>'[m:504]',    'F7D7'=>'[m:505]',
            'F7D8'=>'[m:506]',    'F7D9'=>'[m:507]',    'F7DA'=>'[m:508]',    'F7DB'=>'[m:509]',    'F7DC'=>'[m:510]',
            'F7DD'=>'[m:511]',    'F7DE'=>'[m:512]',    'F7DF'=>'[m:513]',    'F7E0'=>'[m:514]',    'F7E1'=>'[m:515]',
            'F7E2'=>'[m:516]',    'F7E3'=>'[m:517]',    'F7E4'=>'[m:518]',    'F3CF'=>'[m:700]',    'F3D0'=>'[m:701]',
            'F3D1'=>'[m:702]',    'F3D2'=>'[m:703]',    'F3D3'=>'[m:704]',    'F3D4'=>'[m:705]',    'F3D5'=>'[m:706]',
            'F3D6'=>'[m:707]',    'F3D7'=>'[m:708]',    'F3D8'=>'[m:709]',    'F3D9'=>'[m:710]',    'F3DA'=>'[m:711]',
            'F3DB'=>'[m:712]',    'F3DC'=>'[m:713]',    'F3DD'=>'[m:714]',    'F3DE'=>'[m:715]',    'F3DF'=>'[m:716]',
            'F3E0'=>'[m:717]',    'F3E1'=>'[m:718]',    'F3E2'=>'[m:719]',    'F3E3'=>'[m:720]',    'F3E4'=>'[m:721]',
            'F3E5'=>'[m:722]',    'F3E6'=>'[m:723]',    'F3E7'=>'[m:724]',    'F3E8'=>'[m:725]',    'F3E9'=>'[m:726]',
            'F3EA'=>'[m:727]',    'F3EB'=>'[m:728]',    'F3EC'=>'[m:729]',    'F3ED'=>'[m:730]',    'F3EE'=>'[m:731]',
            'F3EF'=>'[m:732]',    'F3F0'=>'[m:733]',    'F3F1'=>'[m:734]',    'F3F2'=>'[m:735]',    'F3F3'=>'[m:736]',
            'F3F4'=>'[m:737]',    'F3F5'=>'[m:738]',    'F3F6'=>'[m:739]',    'F3F7'=>'[m:740]',    'F3F8'=>'[m:741]',
            'F3F9'=>'[m:742]',    'F3FA'=>'[m:743]',    'F3FB'=>'[m:744]',    'F3FC'=>'[m:745]',    'F440'=>'[m:746]',
            'F441'=>'[m:747]',    'F442'=>'[m:748]',    'F443'=>'[m:749]',    'F444'=>'[m:750]',    'F445'=>'[m:751]',
            'F446'=>'[m:752]',    'F447'=>'[m:753]',    'F448'=>'[m:754]',    'F449'=>'[m:755]',    'F44A'=>'[m:756]',
            'F44B'=>'[m:757]',    'F44C'=>'[m:758]',    'F44D'=>'[m:759]',    'F44E'=>'[m:760]',    'F44F'=>'[m:761]',
            'F450'=>'[m:762]',    'F451'=>'[m:763]',    'F452'=>'[m:764]',    'F453'=>'[m:765]',    'F454'=>'[m:766]',
            'F455'=>'[m:767]',    'F456'=>'[m:768]',    'F457'=>'[m:769]',    'F458'=>'[m:770]',    'F459'=>'[m:771]',
            'F45A'=>'[m:772]',    'F45B'=>'[m:773]',    'F45C'=>'[m:774]',    'F45D'=>'[m:775]',    'F45E'=>'[m:776]',
            'F45F'=>'[m:777]',    'F460'=>'[m:778]',    'F461'=>'[m:779]',    'F462'=>'[m:780]',    'F463'=>'[m:781]',
            'F464'=>'[m:782]',    'F465'=>'[m:783]',    'F466'=>'[m:784]',    'F467'=>'[m:785]',    'F468'=>'[m:786]',
            'F469'=>'[m:787]',    'F46A'=>'[m:788]',    'F46B'=>'[m:789]',    'F46C'=>'[m:790]',    'F46D'=>'[m:791]',
            'F46E'=>'[m:792]',    'F46F'=>'[m:793]',    'F470'=>'[m:794]',    'F471'=>'[m:795]',    'F472'=>'[m:796]',
            'F473'=>'[m:797]',    'F474'=>'[m:798]',    'F475'=>'[m:799]',    'F476'=>'[m:800]',    'F477'=>'[m:801]',
            'F478'=>'[m:802]',    'F479'=>'[m:803]',    'F47A'=>'[m:804]',    'F47B'=>'[m:805]',    'F47C'=>'[m:806]',
            'F47D'=>'[m:807]',    'F47E'=>'[m:808]',    'F480'=>'[m:809]',    'F481'=>'[m:810]',    'F482'=>'[m:811]',
            'F483'=>'[m:812]',    'F484'=>'[m:813]',    'F485'=>'[m:814]',    'F486'=>'[m:815]',    'F487'=>'[m:816]',
            'F488'=>'[m:817]',    'F489'=>'[m:818]',    'F48A'=>'[m:819]',    'F48B'=>'[m:820]',    'F48C'=>'[m:821]',
            'F48D'=>'[m:822]',    
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * EZwebからDoCoMoへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    function ezweb2docomo($hex)
    {
        $map = array(
            'F659'=>'&#63964;',        'F65A'=>'&#63911;',        'F65B'=>'？',              'F748'=>'&#63878;',        'F749'=>'<',
            'F74A'=>'>',               'F74B'=>'<<',              'F74C'=>'>>',              'F74D'=>'■',              'F74E'=>'■',
            'F74F'=>'[i]',             'F69A'=>'&#63995;',        'F6EA'=>'[スピーカ]',      'F796'=>'&#63930;',        'F65E'=>'&#63811;',
            'F65F'=>'&#63651;',        'F750'=>'■',              'F751'=>'■',              'F752'=>'◆',              'F753'=>'◆',
            'F754'=>'■',              'F755'=>'■',              'F756'=>'&#63808;',        'F757'=>'&#63808;',        'F797'=>'&#63940;',
            'F758'=>'＋',              'F759'=>'－',              'F75A'=>'＊',              'F75B'=>'↑',              'F75C'=>'↓',
            'F75D'=>'&#63965;',        'F75E'=>'▼',              'F75F'=>'▲',              'F760'=>'▼',              'F761'=>'▲',
            'F762'=>'◆',              'F763'=>'◆',              'F764'=>'■',              'F765'=>'■',              'F766'=>'&#63808;',
            'F767'=>'&#63808;',        'F768'=>'&#63736;',        'F769'=>'&#63735;',        'F660'=>'&#63647;',        'F693'=>'&#63668;',
            'F7B1'=>'&#63838;',        'F661'=>'&#63810;',        'F6EB'=>'&#63928;',        'F77C'=>'φ',              'F6D3'=>'&#63893;',
            'F7B2'=>'&#63889;',        'F69B'=>'&#63698;',        'F6EC'=>'&#63974;',        'F76A'=>'&#63959;',        'F76B'=>'×',
            'F77D'=>'&#63722;',        'F798'=>'&#63937;',        'F654'=>'&#63937;',        'F77E'=>'[フロッピー]',    'F662'=>'[雪結晶]',
            'F76C'=>'×',              'F76D'=>'×',              'F76E'=>'→',              'F76F'=>'←',              'F69C'=>'&#63699;',
            'F770'=>'÷',              'F780'=>'[カレンダー]',    'F6D4'=>'&#63893;',        'F663'=>'☆',              'F771'=>'&#63705;',
            'F772'=>'&#63817;',        'F6ED'=>'&#63936;',        'F773'=>'[チェックマーク]','F6B8'=>'&#63813;',        'F640'=>'☆彡',
            'F644'=>'&#63903;',        'F64E'=>'&#63904;',        'F6B9'=>'&#63988;',        'F7AC'=>'[フォルダ]',      'F6D5'=>'&#63893;',
            'F774'=>'&#63958;',        'F775'=>'&#63963;',        'F674'=>'&#63715;',        'F7AD'=>'[フォルダ]',      'F7B3'=>'&#63720;',
            'F6D6'=>'[フキダシ]',      'F799'=>'[カード]',        'F776'=>'▲',              'F777'=>'▼',              'F790'=>'[USA]',
            'F675'=>'&#63716;',        'F781'=>'&#63722;',        'F7B4'=>'&#63697;',        'F6EE'=>'&#63714;',        'F664'=>'&#63649;',
            'F694'=>'[フットボール]',  'F782'=>'&#63716;',        'F65C'=>'&#63956;',        'F642'=>'&#63694;',        'F783'=>'&#63716;',
            'F784'=>'&#63716;',        'F785'=>'&#63716;',        'F786'=>'&#63722;',        'F6EF'=>'&#63702;',        'F787'=>'[カレンダー]',
            'F676'=>'&#63711;',        'F665'=>'&#63648;',        'F6FA'=>'&#63863;',        'F79A'=>'&#63866;',        'F6F0'=>'&#63704;',
            'F79B'=>'&#63704;',        'F684'=>'&#63684;',        'F6BD'=>'&#63976;',        'F79C'=>'[包丁]',          'F79D'=>'[ビデオ]',
            'F6D7'=>'&#63739;',        'F778'=>'└→',            'F779'=>'&#63870;',        'F6F1'=>'&#63873;',        'F6F2'=>'&#63869;',
            'F788'=>'&#63716;',        'F677'=>'&#63716;',        'F79E'=>'[ネジ]',          'F6F3'=>'&#63701;',        'F68A'=>'&#63679;',
            'F79F'=>'[フロッピー]',    'F791'=>'[グラフ]',        'F792'=>'[グラフ]',        'F6F4'=>'&#63686;',        'F7A0'=>'&#63904;',
            'F789'=>'&#63716;',        'F77A'=>'[チェックマーク]','F6A7'=>'&#63980;',        'F6BA'=>'&#63813;',        'F7A1'=>'[電池]',
            'F77B'=>'&#63919;',        'F78A'=>'[画びょう]',      'F6F5'=>'&#63869;',        'F7A2'=>'&#63930;',        'F6D8'=>'←',
            'F6D9'=>'→',              'F78B'=>'&#63716;',        'F678'=>'&#63957;',        'F6A8'=>'&#63718;',        'F6F6'=>'[名札]',
            'F685'=>'&#63696;',        'F78C'=>'&#63716;',        'F68B'=>'[トラック]',      'F679'=>'&#63934;',        'F7A3'=>'[PDC]',
            'F7AE'=>'&#63859;',        'F7A4'=>'&#63933;',        'F7AF'=>'[送信BOX]',       'F7B0'=>'[受信BOX]',       'F6F7'=>'&#63720;',
            'F686'=>'&#63685;',        'F78D'=>'[定規]',          'F67A'=>'[三角定規]',      'F793'=>'[グラフ]',        'F69D'=>'[肉]',
            'F7A5'=>'&#63721;',        'F7A6'=>'[コンセント]',    'F6DA'=>'[家族]',          'F7A7'=>'[リンク]',        'F6F8'=>'&#63718;',
            'F6F9'=>'&#63860;',        'F666'=>'&#63647;',        'F68C'=>'&#63683;',        'F68D'=>'&#63815;',        'F6A1'=>'[サイコロ]',
            'F7A8'=>'[新聞]',          'F68E'=>'&#63676;',        'F7A9'=>'　',              'F7AA'=>'',                'F7AB'=>'',
            'F655'=>'&#63712;',        'F656'=>'&#63713;',        'F657'=>'&#63740;',        'F658'=>'[若葉マーク]',    'F6FB'=>'&#63879;',
            'F6FC'=>'&#63880;',        'F740'=>'&#63881;',        'F741'=>'&#63882;',        'F742'=>'&#63883;',        'F743'=>'&#63884;',
            'F744'=>'&#63885;',        'F745'=>'&#63886;',        'F746'=>'&#63887;',        'F747'=>'[10]',            'F641'=>'&#63652;',
            'F65D'=>'&#63650;',        'F667'=>'&#63655;',        'F668'=>'&#63656;',        'F669'=>'&#63657;',        'F66A'=>'&#63658;',
            'F66B'=>'&#63659;',        'F66C'=>'&#63660;',        'F66D'=>'&#63661;',        'F66E'=>'&#63662;',        'F66F'=>'&#63663;',
            'F670'=>'&#63664;',        'F671'=>'&#63665;',        'F672'=>'&#63666;',        'F673'=>'[蛇使座]',        'F67B'=>'&#63689;',
            'F67C'=>'&#63691;',        'F67D'=>'&#63695;',        'F67E'=>'&#63693;',        'F680'=>'[バス停]',        'F681'=>'[アンテナ]',
            'F682'=>'&#63682;',        'F683'=>'&#63688;',        'F78E'=>'&#63692;',        'F78F'=>'[地図]',          'F687'=>'&#63938;',
            'F688'=>'&#63681;',        'F689'=>'&#63678;',        'F643'=>'&#63960;',        'F68F'=>'&#63671;',        'F690'=>'&#63670;',
            'F691'=>'&#63927;',        'F692'=>'&#63674;',        'F645'=>'[観覧車]',        'F695'=>'&#63900;',        'F696'=>'&#63984;',
            'F697'=>'&#63824;',        'F698'=>'&#63831;',        'F699'=>'[東京タワー]',    'F646'=>'[777]',           'F647'=>'[オメデトウ]',
            'F69E'=>'[的中]',          'F69F'=>'&#63724;',        'F6A0'=>'&#63930;',        'F6A2'=>'&#63816;',        'F6A3'=>'&#63981;',
            'F6A4'=>'[お化け]',        'F6A5'=>'[日の丸]',        'F6A6'=>'[スイカ]',        'F6A9'=>'&#63983;',        'F6AA'=>'[フライパン]',
            'F6AB'=>'&#63975;',        'F6AC'=>'&#63990;',        'F6AD'=>'[イチゴ]',        'F6AE'=>'&#63982;',        'F6AF'=>'&#63700;',
            'F648'=>'[クジラ]',        'F6B0'=>'[ウサギ]',        'F6B1'=>'&#63993;',        'F6B2'=>'[サル]',          'F6B3'=>'[カエル]',
            'F6B4'=>'&#63814;',        'F6B5'=>'&#63989;',        'F6B6'=>'[アリ]',          'F6B7'=>'&#63994;',        'F6BB'=>'[ビーチ]',
            'F6BC'=>'[ひまわり]',      'F649'=>'&#63893;',        'F64A'=>'&#63894;',        'F64B'=>'&#63954;',        'F64C'=>'&#63952;',
            'F64D'=>'&#63910;',        'F6BE'=>'&#63905;',        'F6BF'=>'&#63916;',        'F6C0'=>'&#63949;',        'F64F'=>'&#63891;',
            'F650'=>'&#63892;',        'F651'=>'&#63903;',        'F652'=>'&#63907;',        'F653'=>'[炎]',            'F6C1'=>'[SOS]',
            'F6C2'=>'[力こぶ]',        'F6C3'=>'&#63889;',        'F6C4'=>'&#63902;',        'F6C5'=>'[宇宙人]',        'F6C6'=>'&#63652;',
            'F6C7'=>'&#63737;',        'F6C8'=>'[アクマ]',        'F6C9'=>'[花丸]',          'F6CA'=>'&#63961;',        'F6CB'=>'[100点]',
            'F6CC'=>'&#63906;',        'F6CD'=>'&#63917;',        'F6CE'=>'[ウンチ]',        'F6CF'=>'[人差し指]',      'F6D0'=>'[得]',
            'F6D1'=>'[ドクロ]',        'F6D2'=>'&#63948;',        'F6DB'=>'&#63723;',        'F6DC'=>'&#63703;',        'F6DD'=>'&#63924;',
            'F6DE'=>'&#63908;',        'F6DF'=>'[ギター]',        'F6E0'=>'[バイオリン]',    'F6E1'=>'&#63707;',        'F6E2'=>'&#63925;',
            'F6E3'=>'[ピストル]',      'F6E4'=>'[エステ]',        'F794'=>'[EZ]',            'F795'=>'&#63867;',        'F6E5'=>'&#63725;',
            'F6E6'=>'&#63923;',        'F6E7'=>'[UFO]',           'F6E8'=>'[UP!]',           'F6E9'=>'[注射]',          'F7B5'=>'&#63653;',
            'F7B6'=>'&#63669;',        'F7B7'=>'&#63673;',        'F7B8'=>'&#63675;',        'F7B9'=>'&#63708;',        'F7BA'=>'[演劇]',
            'F7BB'=>'&#63710;',        'F7BC'=>'&#63717;',        'F7BD'=>'&#63719;',        'F7BE'=>'&#63727;',        'F7BF'=>'&#63728;',
            'F7C0'=>'&#63729;',        'F7C1'=>'&#63730;',        'F7C2'=>'&#63731;',        'F7C3'=>'&#63733;',        'F7C4'=>'&#63734;',
            'F7C5'=>'&#63808;',        'F7C6'=>'&#63809;',        'F7C7'=>'&#63810;',        'F7C8'=>'&#63872;',        'F7C9'=>'&#63888;',
            'F7CA'=>'&#63920;',        'F7CB'=>'&#63897;',        'F7CC'=>'&#63890;',        'F7CD'=>'&#63914;',        'F7CE'=>'&#63915;',
            'F7CF'=>'[ezplus]',        'F7D0'=>'[地球]',          'F7D1'=>'&#63985;',        'F7E5'=>'&#63874;',        'F7E6'=>'&#63923;',
            'F7E7'=>'&#63738;',        'F7E8'=>'&#63931;',        'F7E9'=>'[ラジオ]',        'F7EA'=>'[バラ]',          'F7EB'=>'[教会]',
            'F7EC'=>'&#63677;',        'F7ED'=>'&#63973;',        'F7EE'=>'&#63899;',        'F7EF'=>'[天使]',          'F7F0'=>'[トラ]',
            'F7F1'=>'[クマ]',          'F7F2'=>'[ネズミ]',        'F7F3'=>'&#63950;',        'F7F4'=>'&#63947;',        'F7F5'=>'&#63996;',
            'F7F6'=>'&#63944;',        'F7F7'=>'[タコ]',          'F7F8'=>'[ロケット]',      'F7F9'=>'&#63935;',        'F7FA'=>'&#63902;',
            'F7FB'=>'[ハンマー]',      'F7FC'=>'[花火]',          'F340'=>'&#63980;',        'F341'=>'&#63715;',        'F342'=>'[噴水]',
            'F343'=>'[キャンプ]',      'F344'=>'[麻雀]',          'F345'=>'[VS]',            'F346'=>'[トロフィー]',    'F347'=>'[カメ]',
            'F348'=>'[スペイン]',      'F349'=>'[ロシア]',        'F34A'=>'[工事中]',        'F34B'=>'&#63900;',        'F34C'=>'[祝日]',
            'F34D'=>'[夕焼け]',        'F34E'=>'&#63988;',        'F34F'=>'[株価]',          'F350'=>'[警官]',          'F351'=>'&#63686;',
            'F352'=>'&#63687;',        'F353'=>'&#63971;',        'F354'=>'&#63690;',        'F355'=>'&#63682;',        'F356'=>'[18禁]',
            'F357'=>'[バリ3]',         'F358'=>'[COOL]',          'F359'=>'[割]',            'F35A'=>'[サービス]',      'F35B'=>'&#63868;',
            'F35C'=>'&#63968;',        'F35D'=>'&#63966;',        'F35E'=>'[指]',            'F35F'=>'[営]',            'F360'=>'↑',
            'F361'=>'↓',              'F362'=>'[占い]',          'F363'=>'[マナーモード]',  'F364'=>'[ケータイOFF]',   'F365'=>'&#63722;',
            'F366'=>'[ネクタイ]',      'F367'=>'[ハイビスカス]',  'F368'=>'[花束]',          'F369'=>'[サボテン]',      'F36A'=>'&#63984;',
            'F36B'=>'&#63699;',        'F36C'=>'[祝]',            'F36D'=>'[薬]',            'F36E'=>'[風船]',          'F36F'=>'[クラッカー]',
            'F370'=>'[EZナビ]',        'F371'=>'[帽子]',          'F372'=>'[ブーツ]',        'F373'=>'[マニキュア]',    'F374'=>'[美容院]',
            'F375'=>'[床屋]',          'F376'=>'[着物]',          'F377'=>'[ビキニ]',        'F378'=>'&#63726;',        'F379'=>'&#63889;',
            'F37A'=>'&#63889;',        'F37B'=>'&#63889;',        'F37C'=>'&#63889;',        'F37D'=>'&#63889;',        'F37E'=>'&#63903;',
            'F380'=>'&#63672;',        'F381'=>'&#63812;',        'F382'=>'&#63939;',        'F383'=>'&#63986;',        'F384'=>'[ソフトクリーム]',
            'F385'=>'[ポテト]',        'F386'=>'[だんご]',        'F387'=>'[せんべい]',      'F388'=>'&#63985;',        'F389'=>'[パスタ]',
            'F38A'=>'[カレー]',        'F38B'=>'[おでん]',        'F38C'=>'[すし]',          'F38D'=>'&#63978;',        'F38E'=>'[みかん]',
            'F38F'=>'[トマト]',        'F390'=>'[ナス]',          'F391'=>'[弁当]',          'F392'=>'[鍋]',            'F393'=>'&#63953;',
            'F394'=>'&#63941;',        'F395'=>'&#63992;',        'F396'=>'&#63952;',        'F397'=>'&#63896;',        'F398'=>'&#63910;',
            'F399'=>'&#63942;',        'F39A'=>'&#63996;',        'F39B'=>'[風邪ひき]',      'F39C'=>'[熱]',            'F39D'=>'&#63946;',
            'F39E'=>'&#63897;',        'F39F'=>'&#63944;',        'F3A0'=>'&#63908;',        'F3A1'=>'&#63893;',        'F3A2'=>'(>３<)',
            'F3A3'=>'(´３｀)',        'F3A4'=>'[鼻]',            'F3A5'=>'&#63902;',        'F3A6'=>'(>人<)',          'F3A7'=>'[拍手]',
            'F3A8'=>'&#63920;',        'F3A9'=>'&#63909;',        'F3AA'=>'&#63734;',        'F3AB'=>'&#63956;',        'F3AC'=>'&#63920;',
            'F3AD'=>'m(_ _)m',         'F3AE'=>'&#63890;',        'F3AF'=>'[バニー]',        'F3B0'=>'[トランペット]',  'F3B1'=>'[ビリヤード]',
            'F3B2'=>'[水泳]',          'F3B3'=>'[消防車]',        'F3B4'=>'[救急車]',        'F3B5'=>'[パトカー]',      'F3B6'=>'[ジェットコースター]',
            'F3B7'=>'[門松]',          'F3B8'=>'[ひな祭り]',      'F3B9'=>'[卒業式]',        'F3BA'=>'[ランドセル]',    'F3BB'=>'[こいのぼり]',
            'F3BC'=>'&#63654;',        'F3BD'=>'[花嫁]',          'F3BE'=>'[カキ氷]',        'F3BF'=>'[線香花火]',      'F3C0'=>'[巻貝]',
            'F3C1'=>'[風鈴]',          'F3C2'=>'[ハロウィン]',    'F3C3'=>'[お月見]',        'F3C4'=>'[サンタ]',        'F3C5'=>'&#63831;',
            'F3C6'=>'[虹]',            'F3C7'=>'&#63690;',        'F3C8'=>'&#63647;',        'F3C9'=>'&#63709;',        'F3CA'=>'[デパート]',
            'F3CB'=>'[城]',            'F3CC'=>'[城]',            'F3CD'=>'[工場]',          'F3CE'=>'[フランス]',      'F7D2'=>'[オープンウェブ]',
            'F7D3'=>'[カギ]',          'F7D4'=>'[ABCD]',          'F7D5'=>'[abcd]',          'F7D6'=>'[1234]',          'F7D7'=>'[記号]',
            'F7D8'=>'[可]',            'F7D9'=>'[チェックマーク]','F7DA'=>'&#63826;',        'F7DB'=>'[ラジオボタン]',  'F7DC'=>'&#63873;',
            'F7DD'=>'[←BACK]',        'F7DE'=>'[ブックマーク]',  'F7DF'=>'&#63858;',        'F7E0'=>'&#63684;',        'F7E1'=>'&#63686;',
            'F7E2'=>'&#63722;',        'F7E3'=>'&#63869;',        'F7E4'=>'&#63962;',        'F3CF'=>'[ドイツ]',        'F3D0'=>'[イタリア]',
            'F3D1'=>'[イギリス]',      'F3D2'=>'[中国]',          'F3D3'=>'[韓国]',          'F3D4'=>'[白人]',          'F3D5'=>'[中国人]',
            'F3D6'=>'[インド人]',      'F3D7'=>'[おじいさん]',    'F3D8'=>'[おばあさん]',    'F3D9'=>'[赤ちゃん]',      'F3DA'=>'[工事現場の人]',
            'F3DB'=>'[お姫様]',        'F3DC'=>'[イルカ]',        'F3DD'=>'[ダンス]',        'F3DE'=>'&#63990;',        'F3DF'=>'[ゲジゲジ]',
            'F3E0'=>'[ゾウ]',          'F3E1'=>'[コアラ]',        'F3E2'=>'[牛]',            'F3E3'=>'[ヘビ]',          'F3E4'=>'[ニワトリ]',
            'F3E5'=>'[イノシシ]',      'F3E6'=>'[ラクダ]',        'F3E7'=>'[A]',             'F3E8'=>'[B]',             'F3E9'=>'[O]',
            'F3EA'=>'[AB]',            'F3EB'=>'&#63737;',        'F3EC'=>'&#63738;',        'F3ED'=>'&#63875;',        'F3EE'=>'&#63898;',
            'F3EF'=>'&#63909;',        'F3F0'=>'&#63912;',        'F3F1'=>'&#63913;',        'F3F2'=>'&#63919;',        'F3F3'=>'[メロン]',
            'F3F4'=>'[パイナップル]',  'F3F5'=>'[ブドウ]',        'F3F6'=>'&#63977;',        'F3F7'=>'[とうもろこし]',  'F3F8'=>'[キノコ]',
            'F3F9'=>'[栗]',            'F3FA'=>'[モモ]',          'F3FB'=>'[やきいも]',      'F3FC'=>'[ピザ]',          'F440'=>'[チキン]',
            'F441'=>'[七夕]',          'F442'=>'&#63698;',        'F443'=>'[辰]',            'F444'=>'[ピアノ]',        'F445'=>'&#63927;',
            'F446'=>'&#63990;',        'F447'=>'[ボーリング]',    'F448'=>'[なまはげ]',      'F449'=>'[天狗]',          'F44A'=>'[パンダ]',
            'F44B'=>'&#63949;',        'F44C'=>'&#63994;',        'F44D'=>'[花]',            'F44E'=>'[アイスクリーム]','F44F'=>'[ドーナツ]',
            'F450'=>'[クッキー]',      'F451'=>'[チョコ]',        'F452'=>'[キャンディ]',    'F453'=>'[キャンディ]',    'F454'=>'(/_＼)',
            'F455'=>'(・×・)',        'F456'=>'|(・×・)|',      'F457'=>'[火山]',          'F458'=>'&#63889;',        'F459'=>'[ABC]',
            'F45A'=>'[プリン]',        'F45B'=>'[ミツバチ]',      'F45C'=>'[てんとう虫]',    'F45D'=>'[ハチミツ]',      'F45E'=>'&#63978;',
            'F45F'=>'[飛んでいくお金]','F460'=>'[クラクラ]',      'F461'=>'&#63945;',        'F462'=>'&#63945;',        'F463'=>'&#63831;',
            'F464'=>'(´３｀)',        'F465'=>'&#63893;',        'F466'=>'&#63859;',        'F467'=>'&#63951;',        'F468'=>'&#63951;',
            'F469'=>'&#63947;',        'F46A'=>'&#63896;',        'F46B'=>'&#63896;',        'F46C'=>'&#63955;',        'F46D'=>'&#63955;',
            'F46E'=>'&#63992;',        'F46F'=>'[ドレス]',        'F470'=>'[モアイ]',        'F471'=>'[駅]',            'F472'=>'[花札]',
            'F473'=>'[ジョーカー]',    'F474'=>'[エビフライ]',    'F475'=>'&#63863;',        'F476'=>'&#63960;',        'F477'=>'[パトカー]',
            'F478'=>'[EZムービー]',    'F479'=>'&#63890;',        'F47A'=>'&#63988;',        'F47B'=>'&#63926;',        'F47C'=>'&#63932;',
            'F47D'=>'&#63962;',        'F47E'=>'&#63969;',        'F480'=>'&#63970;',        'F481'=>'&#63972;',        'F482'=>'&#63979;',
            'F483'=>'&#63987;',        'F484'=>'&#63992;',        'F485'=>'&#63992;',        'F486'=>'[Cメール]',       'F487'=>'&#63974;',
            'F488'=>'&#63732;',        'F489'=>'&#63877;',        'F48A'=>'(^-^)/',          'F48B'=>'＼(^o^)／',       'F48C'=>'&#63896;',
            'F48D'=>'&#63945;',
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * EZwebからEZweb(内部画像)へ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    function ezweb2ezweb($hex)
    {
        $map = array(
            'F659'=>'F659',    'F65A'=>'F65A',    'F65B'=>'F65B',    'F748'=>'F748',    'F749'=>'F749',
            'F74A'=>'F74A',    'F74B'=>'F74B',    'F74C'=>'F74C',    'F74D'=>'F74D',    'F74E'=>'F74E',
            'F74F'=>'F74F',    'F69A'=>'F69A',    'F6EA'=>'F6EA',    'F796'=>'F796',    'F65E'=>'F65E',
            'F65F'=>'F65F',    'F750'=>'F750',    'F751'=>'F751',    'F752'=>'F752',    'F753'=>'F753',
            'F754'=>'F754',    'F755'=>'F755',    'F756'=>'F756',    'F757'=>'F757',    'F797'=>'F797',
            'F758'=>'F758',    'F759'=>'F759',    'F75A'=>'F75A',    'F75B'=>'F75B',    'F75C'=>'F75C',
            'F75D'=>'F75D',    'F75E'=>'F75E',    'F75F'=>'F75F',    'F760'=>'F760',    'F761'=>'F761',
            'F762'=>'F762',    'F763'=>'F763',    'F764'=>'F764',    'F765'=>'F765',    'F766'=>'F766',
            'F767'=>'F767',    'F768'=>'F768',    'F769'=>'F769',    'F660'=>'F660',    'F693'=>'F693',
            'F7B1'=>'F7B1',    'F661'=>'F661',    'F6EB'=>'F6EB',    'F77C'=>'F77C',    'F6D3'=>'F6D3',
            'F7B2'=>'F7B2',    'F69B'=>'F69B',    'F6EC'=>'F6EC',    'F76A'=>'F76A',    'F76B'=>'F76B',
            'F77D'=>'F77D',    'F798'=>'F798',    'F654'=>'F654',    'F77E'=>'F77E',    'F662'=>'F662',
            'F76C'=>'F76C',    'F76D'=>'F76D',    'F76E'=>'F76E',    'F76F'=>'F76F',    'F69C'=>'F69C',
            'F770'=>'F770',    'F780'=>'F780',    'F6D4'=>'F6D4',    'F663'=>'F663',    'F771'=>'F771',
            'F772'=>'F772',    'F6ED'=>'F6ED',    'F773'=>'F773',    'F6B8'=>'F6B8',    'F640'=>'F640',
            'F644'=>'F644',    'F64E'=>'F64E',    'F6B9'=>'F6B9',    'F7AC'=>'F7AC',    'F6D5'=>'F6D5',
            'F774'=>'F774',    'F775'=>'F775',    'F674'=>'F674',    'F7AD'=>'F7AD',    'F7B3'=>'F7B3',
            'F6D6'=>'F6D6',    'F799'=>'F799',    'F776'=>'F776',    'F777'=>'F777',    'F790'=>'F790',
            'F675'=>'F675',    'F781'=>'F781',    'F7B4'=>'F7B4',    'F6EE'=>'F6EE',    'F664'=>'F664',
            'F694'=>'F694',    'F782'=>'F782',    'F65C'=>'F65C',    'F642'=>'F642',    'F783'=>'F783',
            'F784'=>'F784',    'F785'=>'F785',    'F786'=>'F786',    'F6EF'=>'F6EF',    'F787'=>'F787',
            'F676'=>'F676',    'F665'=>'F665',    'F6FA'=>'F6FA',    'F79A'=>'F79A',    'F6F0'=>'F6F0',
            'F79B'=>'F79B',    'F684'=>'F684',    'F6BD'=>'F6BD',    'F79C'=>'F79C',    'F79D'=>'F79D',
            'F6D7'=>'F6D7',    'F778'=>'F778',    'F779'=>'F779',    'F6F1'=>'F6F1',    'F6F2'=>'F6F2',
            'F788'=>'F788',    'F677'=>'F677',    'F79E'=>'F79E',    'F6F3'=>'F6F3',    'F68A'=>'F68A',
            'F79F'=>'F79F',    'F791'=>'F791',    'F792'=>'F792',    'F6F4'=>'F6F4',    'F7A0'=>'F7A0',
            'F789'=>'F789',    'F77A'=>'F77A',    'F6A7'=>'F6A7',    'F6BA'=>'F6BA',    'F7A1'=>'F7A1',
            'F77B'=>'F77B',    'F78A'=>'F78A',    'F6F5'=>'F6F5',    'F7A2'=>'F7A2',    'F6D8'=>'F6D8',
            'F6D9'=>'F6D9',    'F78B'=>'F78B',    'F678'=>'F678',    'F6A8'=>'F6A8',    'F6F6'=>'F6F6',
            'F685'=>'F685',    'F78C'=>'F78C',    'F68B'=>'F68B',    'F679'=>'F679',    'F7A3'=>'F7A3',
            'F7AE'=>'F7AE',    'F7A4'=>'F7A4',    'F7AF'=>'F7AF',    'F7B0'=>'F7B0',    'F6F7'=>'F6F7',
            'F686'=>'F686',    'F78D'=>'F78D',    'F67A'=>'F67A',    'F793'=>'F793',    'F69D'=>'F69D',
            'F7A5'=>'F7A5',    'F7A6'=>'F7A6',    'F6DA'=>'F6DA',    'F7A7'=>'F7A7',    'F6F8'=>'F6F8',
            'F6F9'=>'F6F9',    'F666'=>'F666',    'F68C'=>'F68C',    'F68D'=>'F68D',    'F6A1'=>'F6A1',
            'F7A8'=>'F7A8',    'F68E'=>'F68E',    'F7A9'=>'F7A9',    'F7AA'=>'F7AA',    'F7AB'=>'F7AB',
            'F655'=>'F655',    'F656'=>'F656',    'F657'=>'F657',    'F658'=>'F658',    'F6FB'=>'F6FB',
            'F6FC'=>'F6FC',    'F740'=>'F740',    'F741'=>'F741',    'F742'=>'F742',    'F743'=>'F743',
            'F744'=>'F744',    'F745'=>'F745',    'F746'=>'F746',    'F747'=>'F747',    'F641'=>'F641',
            'F65D'=>'F65D',    'F667'=>'F667',    'F668'=>'F668',    'F669'=>'F669',    'F66A'=>'F66A',
            'F66B'=>'F66B',    'F66C'=>'F66C',    'F66D'=>'F66D',    'F66E'=>'F66E',    'F66F'=>'F66F',
            'F670'=>'F670',    'F671'=>'F671',    'F672'=>'F672',    'F673'=>'F673',    'F67B'=>'F67B',
            'F67C'=>'F67C',    'F67D'=>'F67D',    'F67E'=>'F67E',    'F680'=>'F680',    'F681'=>'F681',
            'F682'=>'F682',    'F683'=>'F683',    'F78E'=>'F78E',    'F78F'=>'F78F',    'F687'=>'F687',
            'F688'=>'F688',    'F689'=>'F689',    'F643'=>'F643',    'F68F'=>'F68F',    'F690'=>'F690',
            'F691'=>'F691',    'F692'=>'F692',    'F645'=>'F645',    'F695'=>'F695',    'F696'=>'F696',
            'F697'=>'F697',    'F698'=>'F698',    'F699'=>'F699',    'F646'=>'F646',    'F647'=>'F647',
            'F69E'=>'F69E',    'F69F'=>'F69F',    'F6A0'=>'F6A0',    'F6A2'=>'F6A2',    'F6A3'=>'F6A3',
            'F6A4'=>'F6A4',    'F6A5'=>'F6A5',    'F6A6'=>'F6A6',    'F6A9'=>'F6A9',    'F6AA'=>'F6AA',
            'F6AB'=>'F6AB',    'F6AC'=>'F6AC',    'F6AD'=>'F6AD',    'F6AE'=>'F6AE',    'F6AF'=>'F6AF',
            'F648'=>'F648',    'F6B0'=>'F6B0',    'F6B1'=>'F6B1',    'F6B2'=>'F6B2',    'F6B3'=>'F6B3',
            'F6B4'=>'F6B4',    'F6B5'=>'F6B5',    'F6B6'=>'F6B6',    'F6B7'=>'F6B7',    'F6BB'=>'F6BB',
            'F6BC'=>'F6BC',    'F649'=>'F649',    'F64A'=>'F64A',    'F64B'=>'F64B',    'F64C'=>'F64C',
            'F64D'=>'F64D',    'F6BE'=>'F6BE',    'F6BF'=>'F6BF',    'F6C0'=>'F6C0',    'F64F'=>'F64F',
            'F650'=>'F650',    'F651'=>'F651',    'F652'=>'F652',    'F653'=>'F653',    'F6C1'=>'F6C1',
            'F6C2'=>'F6C2',    'F6C3'=>'F6C3',    'F6C4'=>'F6C4',    'F6C5'=>'F6C5',    'F6C6'=>'F6C6',
            'F6C7'=>'F6C7',    'F6C8'=>'F6C8',    'F6C9'=>'F6C9',    'F6CA'=>'F6CA',    'F6CB'=>'F6CB',
            'F6CC'=>'F6CC',    'F6CD'=>'F6CD',    'F6CE'=>'F6CE',    'F6CF'=>'F6CF',    'F6D0'=>'F6D0',
            'F6D1'=>'F6D1',    'F6D2'=>'F6D2',    'F6DB'=>'F6DB',    'F6DC'=>'F6DC',    'F6DD'=>'F6DD',
            'F6DE'=>'F6DE',    'F6DF'=>'F6DF',    'F6E0'=>'F6E0',    'F6E1'=>'F6E1',    'F6E2'=>'F6E2',
            'F6E3'=>'F6E3',    'F6E4'=>'F6E4',    'F794'=>'F794',    'F795'=>'F795',    'F6E5'=>'F6E5',
            'F6E6'=>'F6E6',    'F6E7'=>'F6E7',    'F6E8'=>'F6E8',    'F6E9'=>'F6E9',    'F7B5'=>'F7B5',
            'F7B6'=>'F7B6',    'F7B7'=>'F7B7',    'F7B8'=>'F7B8',    'F7B9'=>'F7B9',    'F7BA'=>'F7BA',
            'F7BB'=>'F7BB',    'F7BC'=>'F7BC',    'F7BD'=>'F7BD',    'F7BE'=>'F7BE',    'F7BF'=>'F7BF',
            'F7C0'=>'F7C0',    'F7C1'=>'F7C1',    'F7C2'=>'F7C2',    'F7C3'=>'F7C3',    'F7C4'=>'F7C4',
            'F7C5'=>'F7C5',    'F7C6'=>'F7C6',    'F7C7'=>'F7C7',    'F7C8'=>'F7C8',    'F7C9'=>'F7C9',
            'F7CA'=>'F7CA',    'F7CB'=>'F7CB',    'F7CC'=>'F7CC',    'F7CD'=>'F7CD',    'F7CE'=>'F7CE',
            'F7CF'=>'F7CF',    'F7D0'=>'F7D0',    'F7D1'=>'F7D1',    'F7E5'=>'F7E5',    'F7E6'=>'F7E6',
            'F7E7'=>'F7E7',    'F7E8'=>'F7E8',    'F7E9'=>'F7E9',    'F7EA'=>'F7EA',    'F7EB'=>'F7EB',
            'F7EC'=>'F7EC',    'F7ED'=>'F7ED',    'F7EE'=>'F7EE',    'F7EF'=>'F7EF',    'F7F0'=>'F7F0',
            'F7F1'=>'F7F1',    'F7F2'=>'F7F2',    'F7F3'=>'F7F3',    'F7F4'=>'F7F4',    'F7F5'=>'F7F5',
            'F7F6'=>'F7F6',    'F7F7'=>'F7F7',    'F7F8'=>'F7F8',    'F7F9'=>'F7F9',    'F7FA'=>'F7FA',
            'F7FB'=>'F7FB',    'F7FC'=>'F7FC',    'F340'=>'F340',    'F341'=>'F341',    'F342'=>'F342',
            'F343'=>'F343',    'F344'=>'F344',    'F345'=>'F345',    'F346'=>'F346',    'F347'=>'F347',
            'F348'=>'F348',    'F349'=>'F349',    'F34A'=>'F34A',    'F34B'=>'F34B',    'F34C'=>'F34C',
            'F34D'=>'F34D',    'F34E'=>'F34E',    'F34F'=>'F34F',    'F350'=>'F350',    'F351'=>'F351',
            'F352'=>'F352',    'F353'=>'F353',    'F354'=>'F354',    'F355'=>'F355',    'F356'=>'F356',
            'F357'=>'F357',    'F358'=>'F358',    'F359'=>'F359',    'F35A'=>'F35A',    'F35B'=>'F35B',
            'F35C'=>'F35C',    'F35D'=>'F35D',    'F35E'=>'F35E',    'F35F'=>'F35F',    'F360'=>'F360',
            'F361'=>'F361',    'F362'=>'F362',    'F363'=>'F363',    'F364'=>'F364',    'F365'=>'F365',
            'F366'=>'F366',    'F367'=>'F367',    'F368'=>'F368',    'F369'=>'F369',    'F36A'=>'F36A',
            'F36B'=>'F36B',    'F36C'=>'F36C',    'F36D'=>'F36D',    'F36E'=>'F36E',    'F36F'=>'F36F',
            'F370'=>'F370',    'F371'=>'F371',    'F372'=>'F372',    'F373'=>'F373',    'F374'=>'F374',
            'F375'=>'F375',    'F376'=>'F376',    'F377'=>'F377',    'F378'=>'F378',    'F379'=>'F379',
            'F37A'=>'F37A',    'F37B'=>'F37B',    'F37C'=>'F37C',    'F37D'=>'F37D',    'F37E'=>'F37E',
            'F380'=>'F380',    'F381'=>'F381',    'F382'=>'F382',    'F383'=>'F383',    'F384'=>'F384',
            'F385'=>'F385',    'F386'=>'F386',    'F387'=>'F387',    'F388'=>'F388',    'F389'=>'F389',
            'F38A'=>'F38A',    'F38B'=>'F38B',    'F38C'=>'F38C',    'F38D'=>'F38D',    'F38E'=>'F38E',
            'F38F'=>'F38F',    'F390'=>'F390',    'F391'=>'F391',    'F392'=>'F392',    'F393'=>'F393',
            'F394'=>'F394',    'F395'=>'F395',    'F396'=>'F396',    'F397'=>'F397',    'F398'=>'F398',
            'F399'=>'F399',    'F39A'=>'F39A',    'F39B'=>'F39B',    'F39C'=>'F39C',    'F39D'=>'F39D',
            'F39E'=>'F39E',    'F39F'=>'F39F',    'F3A0'=>'F3A0',    'F3A1'=>'F3A1',    'F3A2'=>'F3A2',
            'F3A3'=>'F3A3',    'F3A4'=>'F3A4',    'F3A5'=>'F3A5',    'F3A6'=>'F3A6',    'F3A7'=>'F3A7',
            'F3A8'=>'F3A8',    'F3A9'=>'F3A9',    'F3AA'=>'F3AA',    'F3AB'=>'F3AB',    'F3AC'=>'F3AC',
            'F3AD'=>'F3AD',    'F3AE'=>'F3AE',    'F3AF'=>'F3AF',    'F3B0'=>'F3B0',    'F3B1'=>'F3B1',
            'F3B2'=>'F3B2',    'F3B3'=>'F3B3',    'F3B4'=>'F3B4',    'F3B5'=>'F3B5',    'F3B6'=>'F3B6',
            'F3B7'=>'F3B7',    'F3B8'=>'F3B8',    'F3B9'=>'F3B9',    'F3BA'=>'F3BA',    'F3BB'=>'F3BB',
            'F3BC'=>'F3BC',    'F3BD'=>'F3BD',    'F3BE'=>'F3BE',    'F3BF'=>'F3BF',    'F3C0'=>'F3C0',
            'F3C1'=>'F3C1',    'F3C2'=>'F3C2',    'F3C3'=>'F3C3',    'F3C4'=>'F3C4',    'F3C5'=>'F3C5',
            'F3C6'=>'F3C6',    'F3C7'=>'F3C7',    'F3C8'=>'F3C8',    'F3C9'=>'F3C9',    'F3CA'=>'F3CA',
            'F3CB'=>'F3CB',    'F3CC'=>'F3CC',    'F3CD'=>'F3CD',    'F3CE'=>'F3CE',    'F7D2'=>'F7D2',
            'F7D3'=>'F7D3',    'F7D4'=>'F7D4',    'F7D5'=>'F7D5',    'F7D6'=>'F7D6',    'F7D7'=>'F7D7',
            'F7D8'=>'F7D8',    'F7D9'=>'F7D9',    'F7DA'=>'F7DA',    'F7DB'=>'F7DB',    'F7DC'=>'F7DC',
            'F7DD'=>'F7DD',    'F7DE'=>'F7DE',    'F7DF'=>'F7DF',    'F7E0'=>'F7E0',    'F7E1'=>'F7E1',
            'F7E2'=>'F7E2',    'F7E3'=>'F7E3',    'F7E4'=>'F7E4',    'F3CF'=>'F3CF',    'F3D0'=>'F3D0',
            'F3D1'=>'F3D1',    'F3D2'=>'F3D2',    'F3D3'=>'F3D3',    'F3D4'=>'F3D4',    'F3D5'=>'F3D5',
            'F3D6'=>'F3D6',    'F3D7'=>'F3D7',    'F3D8'=>'F3D8',    'F3D9'=>'F3D9',    'F3DA'=>'F3DA',
            'F3DB'=>'F3DB',    'F3DC'=>'F3DC',    'F3DD'=>'F3DD',    'F3DE'=>'F3DE',    'F3DF'=>'F3DF',
            'F3E0'=>'F3E0',    'F3E1'=>'F3E1',    'F3E2'=>'F3E2',    'F3E3'=>'F3E3',    'F3E4'=>'F3E4',
            'F3E5'=>'F3E5',    'F3E6'=>'F3E6',    'F3E7'=>'F3E7',    'F3E8'=>'F3E8',    'F3E9'=>'F3E9',
            'F3EA'=>'F3EA',    'F3EB'=>'F3EB',    'F3EC'=>'F3EC',    'F3ED'=>'F3ED',    'F3EE'=>'F3EE',
            'F3EF'=>'F3EF',    'F3F0'=>'F3F0',    'F3F1'=>'F3F1',    'F3F2'=>'F3F2',    'F3F3'=>'F3F3',
            'F3F4'=>'F3F4',    'F3F5'=>'F3F5',    'F3F6'=>'F3F6',    'F3F7'=>'F3F7',    'F3F8'=>'F3F8',
            'F3F9'=>'F3F9',    'F3FA'=>'F3FA',    'F3FB'=>'F3FB',    'F3FC'=>'F3FC',    'F440'=>'F440',
            'F441'=>'F441',    'F442'=>'F442',    'F443'=>'F443',    'F444'=>'F444',    'F445'=>'F445',
            'F446'=>'F446',    'F447'=>'F447',    'F448'=>'F448',    'F449'=>'F449',    'F44A'=>'F44A',
            'F44B'=>'F44B',    'F44C'=>'F44C',    'F44D'=>'F44D',    'F44E'=>'F44E',    'F44F'=>'F44F',
            'F450'=>'F450',    'F451'=>'F451',    'F452'=>'F452',    'F453'=>'F453',    'F454'=>'F454',
            'F455'=>'F455',    'F456'=>'F456',    'F457'=>'F457',    'F458'=>'F458',    'F459'=>'F459',
            'F45A'=>'F45A',    'F45B'=>'F45B',    'F45C'=>'F45C',    'F45D'=>'F45D',    'F45E'=>'F45E',
            'F45F'=>'F45F',    'F460'=>'F460',    'F461'=>'F461',    'F462'=>'F462',    'F463'=>'F463',
            'F464'=>'F464',    'F465'=>'F465',    'F466'=>'F466',    'F467'=>'F467',    'F468'=>'F468',
            'F469'=>'F469',    'F46A'=>'F46A',    'F46B'=>'F46B',    'F46C'=>'F46C',    'F46D'=>'F46D',
            'F46E'=>'F46E',    'F46F'=>'F46F',    'F470'=>'F470',    'F471'=>'F471',    'F472'=>'F472',
            'F473'=>'F473',    'F474'=>'F474',    'F475'=>'F475',    'F476'=>'F476',    'F477'=>'F477',
            'F478'=>'F478',    'F479'=>'F479',    'F47A'=>'F47A',    'F47B'=>'F47B',    'F47C'=>'F47C',
            'F47D'=>'F47D',    'F47E'=>'F47E',    'F480'=>'F480',    'F481'=>'F481',    'F482'=>'F482',
            'F483'=>'F483',    'F484'=>'F484',    'F485'=>'F485',    'F486'=>'F486',    'F487'=>'F487',
            'F488'=>'F488',    'F489'=>'F489',    'F48A'=>'F48A',    'F48B'=>'F48B',    'F48C'=>'F48C',
            'F48D'=>'F48D',    'F48E'=>'F48E',    'F48F'=>'F48F',    'F490'=>'F490',    'F491'=>'F491',
            'F492'=>'F492',    'F493'=>'F493',    
        );
        return empty($map[$hex])?'':pack('H4',$map[$hex]);
    }


    /**
     * EZwebからVodafoneへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    function ezweb2vodafone($hex)
    {
        $map = array(
            'F659'=>'$Fr',             'F65A'=>'$GA',             'F65B'=>'$G@',             'F748'=>'[Q]',               'F749'=>'$F[',
            'F74A'=>'$FZ',             'F74B'=>'$F]',             'F74C'=>'$F\',             'F74D'=>'$F;',             'F74E'=>'$F:',
            'F74F'=>'[i]',               'F69A'=>'$Gd',             'F6EA'=>'$Ea',             'F796'=>'$EO',             'F65E'=>'$Gl',
            'F65F'=>'$E]',             'F750'=>'$F;',             'F751'=>'$F:',             'F752'=>'$F;',             'F753'=>'$F;',
            'F754'=>'$F;',             'F755'=>'$F:',             'F756'=>'$F9',             'F757'=>'$F9',             'F797'=>'[腕時計]',
            'F758'=>'＋',                'F759'=>'－',                'F75A'=>'＊',                'F75B'=>'$FR',             'F75C'=>'$FS',
            'F75D'=>'[禁止]',            'F75E'=>'▼',                'F75F'=>'▲',                'F760'=>'▼',                'F761'=>'▲',
            'F762'=>'$F;',             'F763'=>'$F;',             'F764'=>'$F;',             'F765'=>'$F:',             'F766'=>'$F9',
            'F767'=>'$F9',             'F768'=>'$FW',             'F769'=>'$FX',             'F660'=>'$Gj',             'F693'=>'$G6',
            'F7B1'=>'$GM',             'F661'=>'$Gl',             'F6EB'=>'$OE',             'F77C'=>'φ',                'F6D3'=>'$G"',
            'F7B2'=>'$GB',             'F69B'=>'$Gd',             'F6EC'=>'$E0',             'F76A'=>'$QW',             'F76B'=>'$OS',
            'F77D'=>'$O!',             'F798'=>'[砂時計]',          'F654'=>'[砂時計]',          'F77E'=>'$O6',             'F662'=>'[雪結晶]',
            'F76C'=>'$OS',             'F76D'=>'$OS',             'F76E'=>'$FT',             'F76F'=>'$FU',             'F69C'=>'$Gg',
            'F770'=>'÷',                'F780'=>'[カレンダー]',      'F6D4'=>'$Gv',             'F663'=>'$OO',             'F771'=>'$FV',
            'F772'=>'$FY',             'F6ED'=>'$GT',             'F773'=>'[チェックマーク]',  'F6B8'=>'$Gr',             'F640'=>'☆彡',
            'F644'=>'$ON',             'F64E'=>'$E/',             'F6B9'=>'$QC',             'F7AC'=>'[フォルダ]',        'F6D5'=>'$G!',
            'F774'=>'$Fn',             'F775'=>'$Fo',             'F674'=>'$OC',             'F7AD'=>'[フォルダ]',        'F7B3'=>'$G)',
            'F6D6'=>'[フキダシ]',        'F799'=>'[カード]',          'F776'=>'▲',                'F777'=>'▼',                'F790'=>'$Q,',
            'F675'=>'$Eh',             'F781'=>'$O!',             'F7B4'=>'$Ge',             'F6EE'=>'$G(',             'F664'=>'$Gk',
            'F694'=>'$PK',             'F782'=>'$Eh',             'F65C'=>'$EW',             'F642'=>'$En',             'F783'=>'$Eh',
            'F784'=>'$Eh',             'F785'=>'$Eh',             'F786'=>'$O!',             'F6EF'=>'$O3',             'F787'=>'[カレンダー]',
            'F676'=>'$EE',             'F665'=>'$Gi',             'F6FA'=>'$E#',             'F79A'=>'￥',                'F6F0'=>'$G]',
            'F79B'=>'$G]',             'F684'=>'$GV',             'F6BD'=>'$O$',             'F79C'=>'[包丁]',            'F79D'=>'$EI',
            'F6D7'=>'[メガネ]',          'F778'=>'└→',              'F779'=>'←┘',              'F6F1'=>'$E4',             'F6F2'=>'$G_',
            'F788'=>'$Eh',             'F677'=>'$Eh',             'F79E'=>'[ネジ]',            'F6F3'=>'$E^',             'F68A'=>'$G;',
            'F79F'=>'$O6',             'F791'=>'$Ej',             'F792'=>'$Ej',             'F6F4'=>'$E!',             'F7A0'=>'[懐中電灯]',
            'F789'=>'$Eh',             'F77A'=>'[チェックマーク]',  'F6A7'=>'$E8',             'F6BA'=>'$Gr',             'F7A1'=>'[電池]',
            'F77B'=>'[スクロール]',      'F78A'=>'[画びょう]',        'F6F5'=>'$Ed',             'F7A2'=>'$EO',             'F6D8'=>'$FP',
            'F6D9'=>'$FQ',             'F78B'=>'$Eh',             'F678'=>'[クリップ]',        'F6A8'=>'$E2',             'F6F6'=>'[名札]',
            'F685'=>'$Gc',             'F78C'=>'$Eh',             'F68B'=>'$PO',             'F679'=>'$O!',             'F7A3'=>'[PDC]',
            'F7AE'=>'$E#',             'F7A4'=>'[レンチ]',          'F7AF'=>'[送信BOX]',         'F7B0'=>'[受信BOX]',         'F6F7'=>'$G)',
            'F686'=>'$GX',             'F78D'=>'[定規]',            'F67A'=>'[三角定規]',        'F793'=>'[グラフ]',          'F69D'=>'[肉]',
            'F7A5'=>'$G*',             'F7A6'=>'[コンセント]',      'F6DA'=>'[家族]',            'F7A7'=>'[リンク]',          'F6F8'=>'$E2',
            'F6F9'=>'$G+',             'F666'=>'$Gj',             'F68C'=>'$G=',             'F68D'=>'$G<',             'F6A1'=>'[サイコロ]',
            'F7A8'=>'[新聞]',            'F68E'=>'$G>',             'F7A9'=>'　',                'F7AA'=>'',                  'F7AB'=>'',
            'F655'=>'$O.',             'F656'=>'$F(',             'F657'=>'$F*',             'F658'=>'$F)',             'F6FB'=>'$F<',
            'F6FC'=>'$F=',             'F740'=>'$F>',             'F741'=>'$F?',             'F742'=>'$F@',             'F743'=>'$FA',
            'F744'=>'$FB',             'F745'=>'$FC',             'F746'=>'$FD',             'F747'=>'[10]',              'F641'=>'$Pc',
            'F65D'=>'$Gh',             'F667'=>'$F_',             'F668'=>'$F`',             'F669'=>'$Fa',             'F66A'=>'$Fb',
            'F66B'=>'$Fc',             'F66C'=>'$Fd',             'F66D'=>'$Fe',             'F66E'=>'$Ff',             'F66F'=>'$Fg',
            'F670'=>'$Fh',             'F671'=>'$Fi',             'F672'=>'$Fj',             'F673'=>'$Fk',             'F67B'=>'$Et',
            'F67C'=>'$Ev',             'F67D'=>'$Eq',             'F67E'=>'$Eo',             'F680'=>'$Ep',             'F681'=>'$Ek',
            'F682'=>'$F"',             'F683'=>'$Em',             'F78E'=>'$GZ',             'F78F'=>'[地図]',            'F687'=>'$EV',
            'F688'=>'$Ey',             'F689'=>'$G?',             'F643'=>'$E5',             'F68F'=>'$G8',             'F690'=>'$G5',
            'F691'=>'[スノボ]',          'F692'=>'$ER',             'F645'=>'$ED',             'F695'=>'$EC',             'F696'=>'$O+',
            'F697'=>'$OD',             'F698'=>'$Pk',             'F699'=>'$Q)',             'F646'=>'$ES',             'F647'=>'[オメデトウ]',
            'F69E'=>'$EP',             'F69F'=>'[ゲーム]',          'F6A0'=>'$EO',             'F6A2'=>'$GS',             'F6A3'=>'$GP',
            'F6A4'=>'$E;',             'F6A5'=>'$Q+',             'F6A6'=>'$Oh',             'F6A9'=>'$Gf',             'F6AA'=>'$Eg',
            'F6AB'=>'[さくらんぼ]',      'F6AC'=>'$G9',             'F6AD'=>'$Og',             'F6AE'=>'$Ob',             'F6AF'=>'$E@',
            'F648'=>'$Gt',             'F6B0'=>'$QL',             'F6B1'=>'$G:',             'F6B2'=>'$E)',             'F6B3'=>'$QQ',
            'F6B4'=>'$Go',             'F6B5'=>'$Gu',             'F6B6'=>'[アリ]',            'F6B7'=>'$E+',             'F6BB'=>'$O'."'".'',
            'F6BC'=>'$O%',             'F649'=>'$Gw',             'F64A'=>'$Gy',             'F64B'=>'$P1',             'F64C'=>'$P&',
            'F64D'=>'$E\',             'F6BE'=>'$OT',             'F6BF'=>'$OQ',             'F6C0'=>'$E%',             'F64F'=>'$GC',
            'F650'=>'$OG',             'F651'=>'$ON',             'F652'=>'$O1',             'F653'=>'$E=',             'F6C1'=>'[SOS]',
            'F6C2'=>'$El',             'F6C3'=>'$OI',             'F6C4'=>'$G#',             'F6C5'=>'$E,',             'F6C6'=>'[なると]',
            'F6C7'=>'$QV',             'F6C8'=>'$E:',             'F6C9'=>'[花丸]',            'F6CA'=>'$O5',             'F6CB'=>'[100点]',
            'F6CC'=>'$G-',             'F6CD'=>'$OP',             'F6CE'=>'$Gz',             'F6CF'=>'$G/',             'F6D0'=>'$FF',
            'F6D1'=>'$E<',             'F6D2'=>'$G.',             'F6DB'=>'$EJ',             'F6DC'=>'$G\',             'F6DD'=>'[財布]',
            'F6DE'=>'$OF',             'F6DF'=>'$Ga',             'F6E0'=>'[バイオリン]',      'F6E1'=>'$O*',             'F6E2'=>'$O<',
            'F6E3'=>'$E3',             'F6E4'=>'$O>',             'F794'=>'[EZ]',              'F795'=>'[FREE]',            'F6E5'=>'$EF',
            'F6E6'=>'$G&',             'F6E7'=>'$E,',             'F6E8'=>'$F3',             'F6E9'=>'$E[',             'F7B5'=>'[霧]',
            'F7B6'=>'$G4',             'F7B7'=>'$PJ',             'F7B8'=>'[ポケベル]',        'F7B9'=>'$Q"',             'F7BA'=>'$Q#',
            'F7BB'=>'[イベント]',        'F7BC'=>'$O4',             'F7BD'=>'$Ok',             'F7BE'=>'$F.',             'F7BF'=>'$F-',
            'F7C0'=>'$F/',             'F7C1'=>'$P9',             'F7C2'=>'$P;',             'F7C3'=>'$G1',             'F7C4'=>'$G2',
            'F7C5'=>'●',                'F7C6'=>'$Gl',             'F7C7'=>'$Gl',             'F7C8'=>'[CL]',              'F7C9'=>'$FE',
            'F7CA'=>'$Fm',             'F7CB'=>'$P&',             'F7CC'=>'$OG',             'F7CD'=>'[ドンッ]',          'F7CE'=>'$OQ',
            'F7CF'=>'[ezplus]',          'F7D0'=>'[地球]',            'F7D1'=>'$O`',             'F7E5'=>'$F2',             'F7E6'=>'$G&',
            'F7E7'=>'$G'."'".'',       'F7E8'=>'$G,',             'F7E9'=>'$EH',             'F7EA'=>'$GR',             'F7EB'=>'$GW',
            'F7EC'=>'$PT',             'F7ED'=>'$G[',             'F7EE'=>'$G^',             'F7EF'=>'$Gn',             'F7F0'=>'$Gp',
            'F7F1'=>'$Gq',             'F7F2'=>'$Gs',             'F7F3'=>'$P%',             'F7F4'=>'$E&',             'F7F5'=>'$P0',
            'F7F6'=>'$E(',             'F7F7'=>'$E*',             'F7F8'=>'$E-',             'F7F9'=>'$E.',             'F7FA'=>'$E1',
            'F7FB'=>'$E6',             'F7FC'=>'$E7',             'F340'=>'$E9',             'F341'=>'$E>',             'F342'=>'$EA',
            'F343'=>'$EB',             'F344'=>'$EM',             'F345'=>'$EN',             'F346'=>'$EQ',             'F347'=>'[カメ]',
            'F348'=>'$Q1',             'F349'=>'$Q2',             'F34A'=>'$EW',             'F34B'=>'$E_',             'F34C'=>'$Ec',
            'F34D'=>'$Ef',             'F34E'=>'$QC',             'F34F'=>'$Ej',             'F350'=>'$Er',             'F351'=>'$Es',
            'F352'=>'$Eu',             'F353'=>'$Ew',             'F354'=>'$Ex',             'F355'=>'$F"',             'F356'=>'$F'."'".'',
            'F357'=>'$F+',             'F358'=>'$F4',             'F359'=>'$FG',             'F35A'=>'$FH',             'F35B'=>'$FI',
            'F35C'=>'$FJ',             'F35D'=>'$FK',             'F35E'=>'$FL',             'F35F'=>'$FM',             'F360'=>'$FN',
            'F361'=>'$FO',             'F362'=>'$F^',             'F363'=>'$Fp',             'F364'=>'$Fq',             'F365'=>'$O!',
            'F366'=>'$O"',             'F367'=>'$O#',             'F368'=>'$O&',             'F369'=>'$O(',             'F36A'=>'$O+',
            'F36B'=>'$O,',             'F36C'=>'$O-',             'F36D'=>'$O/',             'F36E'=>'$O0',             'F36F'=>'$O2',
            'F370'=>'[EZナビ]',          'F371'=>'$O8',             'F372'=>'$O;',             'F373'=>'$O=',             'F374'=>'$O?',
            'F375'=>'$O@',             'F376'=>'$OA',             'F377'=>'$OB',             'F378'=>'$F,',             'F379'=>'$OG',
            'F37A'=>'$OJ',             'F37B'=>'$OK',             'F37C'=>'$OL',             'F37D'=>'$OM',             'F37E'=>'$ON',
            'F380'=>'$G3',             'F381'=>'$OR',             'F382'=>'$OX',             'F383'=>'$OY',             'F384'=>'$OZ',
            'F385'=>'$O[',             'F386'=>'$O\',             'F387'=>'$O]',             'F388'=>'$O^',             'F389'=>'$O_',
            'F38A'=>'$Oa',             'F38B'=>'$Oc',             'F38C'=>'$Od',             'F38D'=>'$Oe',             'F38E'=>'$Of',
            'F38F'=>'$Oi',             'F390'=>'$Oj',             'F391'=>'$Ol',             'F392'=>'$Om',             'F393'=>'$P"',
            'F394'=>'$P#',             'F395'=>'$P$',             'F396'=>'$P&',             'F397'=>'$P'."'".'',       'F398'=>'$P(',
            'F399'=>'$P*',             'F39A'=>'$P+',             'F39B'=>'$P,',             'F39C'=>'$P-',             'F39D'=>'$P.',
            'F39E'=>'$P0',             'F39F'=>'$P/',             'F3A0'=>'$OF',             'F3A1'=>'$Gv',             'F3A2'=>'$P7',
            'F3A3'=>'$P8',             'F3A4'=>'$P:',             'F3A5'=>'$P<',             'F3A6'=>'$P=',             'F3A7'=>'$P?',
            'F3A8'=>'$P@',             'F3A9'=>'$PA',             'F3AA'=>'$P>',             'F3AB'=>'$PC',             'F3AC'=>'$PD',
            'F3AD'=>'$PF',             'F3AE'=>'$PE',             'F3AF'=>'$PI',             'F3B0'=>'$Gb',             'F3B1'=>'$PL',
            'F3B2'=>'$PM',             'F3B3'=>'$PP',             'F3B4'=>'$PQ',             'F3B5'=>'$PR',             'F3B6'=>'$PS',
            'F3B7'=>'$PV',             'F3B8'=>'$PX',             'F3B9'=>'$PY',             'F3BA'=>'$PZ',             'F3BB'=>'$P[',
            'F3BC'=>'$P\',             'F3BD'=>'[花嫁]',            'F3BE'=>'$P_',             'F3BF'=>'$P`',             'F3C0'=>'$Pa',
            'F3C1'=>'$Pb',             'F3C2'=>'$Pe',             'F3C3'=>'$Pf',             'F3C4'=>'$Ph',             'F3C5'=>'$Pk',
            'F3C6'=>'$Pl',             'F3C7'=>'$Q!',             'F3C8'=>'$Pi',             'F3C9'=>'$Q#',             'F3CA'=>'$Q$',
            'F3CB'=>'$Q%',             'F3CC'=>'$Q&',             'F3CD'=>'$Q(',             'F3CE'=>'$Q-',             'F7D2'=>'[オープンウェブ]',
            'F7D3'=>'$Ed',             'F7D4'=>'[ABCD]',            'F7D5'=>'[abcd]',            'F7D6'=>'[1234]',            'F7D7'=>'[記号]',
            'F7D8'=>'[可]',              'F7D9'=>'[チェックマーク]',  'F7DA'=>'[ペン]',            'F7DB'=>'[ラジオボタン]',    'F7DC'=>'$E4',
            'F7DD'=>'$FU',             'F7DE'=>'[ブックマーク]',    'F7DF'=>'$E$',             'F7E0'=>'$GV',             'F7E1'=>'$E!',
            'F7E2'=>'$O!',             'F7E3'=>'$Ed',             'F7E4'=>'↑↓',              'F3CF'=>'$Q.',             'F3D0'=>'$Q/',
            'F3D1'=>'$Q0',             'F3D2'=>'$Q3',             'F3D3'=>'$Q4',             'F3D4'=>'$Q5',             'F3D5'=>'$Q6',
            'F3D6'=>'$Q7',             'F3D7'=>'$Q8',             'F3D8'=>'$Q9',             'F3D9'=>'$Q:',             'F3DA'=>'$Q;',
            'F3DB'=>'$Q<',             'F3DC'=>'$Q@',             'F3DD'=>'$Q?',             'F3DE'=>'$QB',             'F3DF'=>'$QE',
            'F3E0'=>'$QF',             'F3E1'=>'$QG',             'F3E2'=>'$QK',             'F3E3'=>'$QM',             'F3E4'=>'$QN',
            'F3E5'=>'$QO',             'F3E6'=>'$QP',             'F3E7'=>'$QR',             'F3E8'=>'$QS',             'F3E9'=>'$QU',
            'F3EA'=>'$QT',             'F3EB'=>'$QV',             'F3EC'=>'$G'."'".'',       'F3ED'=>'[旗]',              'F3EE'=>'$FV',
            'F3EF'=>'$FX',             'F3F0'=>'！？',              'F3F1'=>'！！',              'F3F2'=>'～',                'F3F3'=>'[メロン]',
            'F3F4'=>'[パイナップル]',    'F3F5'=>'[ブドウ]',          'F3F6'=>'[バナナ]',          'F3F7'=>'[とうもろこし]',    'F3F8'=>'[キノコ]',
            'F3F9'=>'[栗]',              'F3FA'=>'[モモ]',            'F3FB'=>'[やきいも]',        'F3FC'=>'[ピザ]',            'F440'=>'[チキン]',
            'F441'=>'[七夕]',            'F442'=>'$Gd',             'F443'=>'[辰]',              'F444'=>'[ピアノ]',          'F445'=>'$G7',
            'F446'=>'$G9',             'F447'=>'[ボーリング]',      'F448'=>'[なまはげ]',        'F449'=>'[天狗]',            'F44A'=>'[パンダ]',
            'F44B'=>'$P)',             'F44C'=>'$E+',             'F44D'=>'$O%',             'F44E'=>'[アイスクリーム]',  'F44F'=>'[ドーナツ]',
            'F450'=>'[クッキー]',        'F451'=>'[チョコ]',          'F452'=>'[キャンディ]',      'F453'=>'[キャンディ]',      'F454'=>'(/_＼)',
            'F455'=>'(・×・)',          'F456'=>'|(・×・)|',        'F457'=>'[火山]',            'F458'=>'$OH',             'F459'=>'[ABC]',
            'F45A'=>'[プリン]',          'F45B'=>'[ミツバチ]',        'F45C'=>'[てんとう虫]',      'F45D'=>'[ハチミツ]',        'F45E'=>'$Oe',
            'F45F'=>'[飛んでいくお金]',  'F460'=>'$P'."'".'',       'F461'=>'$P6',             'F462'=>'$P6',             'F463'=>'$Pk',
            'F464'=>'$P8',             'F465'=>'$Gw',             'F466'=>'$E#',             'F467'=>'$P2',             'F468'=>'$P2',
            'F469'=>'$E&',             'F46A'=>'$P#',             'F46B'=>'$P#',             'F46C'=>'$P3',             'F46D'=>'$P3',
            'F46E'=>'$P$',             'F46F'=>'$O9',             'F470'=>'[モアイ]',          'F471'=>'$GY',             'F472'=>'[花札]',
            'F473'=>'[ジョーカー]',      'F474'=>'[エビフライ]',      'F475'=>'$E#',             'F476'=>'$F!',             'F477'=>'$PR',
            'F478'=>'[EZムービー]',      'F479'=>'$OG',             'F47A'=>'$QC',             'F47B'=>'[ジーンズ]',        'F47C'=>'$E#',
            'F47D'=>'↑↓',              'F47E'=>'⇔',                'F480'=>'↑↓',              'F481'=>'$P^',             'F482'=>'$E0',
            'F483'=>'[カタツムリ]',      'F484'=>'$P$',             'F485'=>'$P$',             'F486'=>'[Cメール]',         'F487'=>'$E0',
            'F488'=>'$G0',             'F489'=>'$F0',             'F48A'=>'$G2',             'F48B'=>'$PG',             'F48C'=>'$P#',
            'F48D'=>'$P6',    
        );
        return empty($map[$hex])?'':$map[$hex];
    }
} // emoji_EZweb
?>