<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {rkt_sponsor} function plugin
 *
 * Type:     function<br>
 * Name:     rkt_sponsor<br>
 * Purpose:  If[^̏o<br>
 * Input:<br>
 *         - links = array of link data
 *         - request = string of request data
 *         - separator = string of separator
 *
 *
 * Examples:
 * <pre>
 * {rkt_sponsor position=$position}
 * </pre>
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @version  1.0
 * @link none
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_rkt_sponsor($params, &$smarty)
{
    $_html_result = '';
    if (!is_array($params)){
        return $_html_result;
    }
    include_once LIB_DIR.'rkt_db.php';

    extract($params);
    
    $sponsor = rkt_sponsor_get_sponsor($position);
    $_html_result = $sponsor['html'];

    return $_html_result;
}

/**
 * X|T[ꗗ̎擾
 *
 * @access public
 * @param integer $position
 * @return array
 */
function rkt_sponsor_get_sponsor($position)
{
    $objdb = RKT_db::getInstance();
    $sql=
        'SELECT '.
            'id,'.
            'html '.
        'FROM '.
            DB_PREFIX.'sys_sponsor '.
        'WHERE '.
            'avail = '.AVAIL_ENABLE.' AND '.
            'position = '.$position;
    $stmt = $objdb->prepare($sql); 
    $stmt->execute(); 
    $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
    if (empty($result)){
        return array('id'=>'', 'html'=>'');
    }
    
    $max = count($result) - 1;
    $select = rand (0, $max);
    
    return $result[$select];
}


/* vim: set expandtab: */

?>
