<?php
/* ========================================================================
 - [modules/private/content/list.php]
 -      コンテンツ記事閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/content/list.tpl');

        $this->set_category();
        $this->set_condition();
        $this->set_list();
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'itm_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys',$list);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'ref_category'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();

        /* カテゴリ */
        if (!empty($conditions['ref_category'])){
            $where[] = 'ref_category='.$conditions['ref_category'];
        }
        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_CONTENTS);    // クラスの生成

        $where = '';
        if (!empty($this->ref_category)){
            $where = 'AND ref_category = '.$this->ref_category.' ';
        }

        $now = sql_query::now();
        $sql = 
            'SELECT '.
                'id,'.
                'origin,'.
                'open_date,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'open_date <= '.$now.' AND '.
                'avail = '.AVAIL_ENABLE.' '.
                $this->where.
            'ORDER BY '.
                'open_date DESC ';
        $objpgr->setSql($sql);
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('list', $result);
    }
} // webapp
?>
