<?php
/* ========================================================================
 - [modules/friend/diary/entry.php]
 -      記事閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/13] 日記コメント投稿数を記事に保存
 -      [2007/02/03] 日記コメント未読フラグ追加
 -      [2006/08/28] あしあと処理実行部位追加
 -      [2006/07/27] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 記事ID
     * @var integer
     */
    var $id = null;

    /**
     * 日記ID
     * @var integer
     */
    var $ref_diary = null;

    /**
     * 日付
     * @var string
     */
    var $regist_date = null;

    /**
     * 削除コメントID
     * @var integer
     */
    var $delete = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/diary/entry.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('delete');

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/diary/entry/'.$this->ref_friend.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id.'#commentform');
            exit();
        }

        $this->set_entry();
        $this->set_next();
        $this->set_prev();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_comment');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_entry();
            header('Location: '.HTTP_ACTION.'friend/diary/entry/'.$this->ref_friend.'/complete/'.WAP_URI_SEPARATOR.'id='.$this->id.'#comment');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'friend/diary/entry/'.$this->ref_friend.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id.'#commentform');
            exit();
        }


        /* コメントの削除 */
        if ($this->delete_comment()){
            $this->update_entry();
            $this->Assign('deleted', true);
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->ref_friend);
        $objmenu->setMenu($this->account['id']);

        $this->set_picture();
        $this->set_category();
        $this->set_comment_num();
        $this->set_comment();

        $this->doFootprint();
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_entry()
    {
        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'ref_diary,'.
                'regist_date,'.
                'visibility,'.
                'format,'.
                'link,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['ref_diary'];
        $this->regist_date = $result['regist_date'];

        $this->Assign('entry', $result);
    }

    /**
     * 次の日記の設定
     *
     * @access private
     * @return void
     */
    function set_next()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_account = '.$this->ref_friend.' AND '.
                "regist_date > '".$this->regist_date."' ".
            'ORDER BY '.
                'regist_date ASC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('next', $result);
    }

    /**
     * 前の日記の設定
     *
     * @access private
     * @return void
     */
    function set_prev()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_account = '.$this->ref_friend.' AND '.
                "regist_date < '".$this->regist_date."' ".
            'ORDER BY '.
                'regist_date DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('prev', $result);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @return void
     */
    function set_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('pictures', $result);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(ref.ref_entry) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat,'.
                DB_PREFIX.'dia_select ref,'.
                DB_PREFIX.'dia_select sel '.
            'WHERE '.
                'cat.id = ref.ref_category AND '.
                'cat.id = sel.ref_category AND '.
                'cat.ref_diary = '.$this->ref_diary.' AND '.
                'sel.ref_entry = '.$this->id.' '.
            'GROUP BY '.
                'cat.id,sel.ref_category '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('categorys', $result);
    }

    /**
     * コメント数の設定
     *
     * @access private
     * @return void
     */
    function set_comment_num()
    {
        $sql=
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $comment_num = empty($result['ct'])?0:$result['ct'];
        $this->Assign('comment_num', $comment_num);
    }

    /**
     * コメントの設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $sql=
            'SELECT '.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'cmt.id as id,'.
                'cmt.modify as modify,'.
                'cmt.ref_account as ref_account,'.
                'cmt.subject as subject,'.
                'cmt.body as body,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_comment cmt '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = cmt.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'cmt.ref_entry = '.$this->id.' '.
            'ORDER BY '.
                'cmt.modify DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('comments', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('ref_entry', $this->id);
        $this->objmnp->setValue('flag', COMMENT_FLAG_UNREAD);

        // 更新しない項目名
        $skip = array(
            'ref_account',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'id = '.$this->delete .' AND '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_entry = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 日記記事の更新
     *
     * @access private
     * @return boolean  真偽値
     */
    function update_entry()
    {
        $sql = 
            'SELECT '.
                'count(*) post '.
            'FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_entry '.
            'SET '.
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
