<?php
/* ========================================================================
 - [modules/community/item/upload.php]
 -      アップロード
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_upload.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 画像ID
     * @var integer
     */
    var $id = null;

    /**
     * コミュニティID
     * @var boolean
     */
    var $ref_community = 0;

    /**
     * 記事(トピック)ID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * 画像削除フラグ
     * @var integer
     */
    var $delete = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateBase('base/xml.tpl');
        $this->setTemplateFile('community/item/upload.tpl');
        $this->addJavas('prototype.js');

        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM); 
        $this->objfile->setUID($this->account['id']);

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic', 1);
        $this->ref_topic = empty($this->ref_topic)?0:$this->ref_topic;

        /* URL引数の設定 */
        $this->setSafety('id');
        $this->setSafety('delete');

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }
        /* 編集権限が無い */
        if (!$this->is_editor()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_picture');
        $this->do_query();
        $this->delete_picture();

        $this->set_pictures();
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_pictures()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename href,'.
                'thumbnail src,'.
                't_width width,'.
                't_height height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_relation = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        $row = 0;
        $html = '<table width="100%" border="1"><tr>';
        foreach ($result as $value){
            $html .= 
                '<td><img src="'.BASE_URL.$value['src'].'" width="'.$value['width'].'" height="'.$value['height'].'"><br />'.
                '<a href="javascript:insertImg(\\\''.BASE_URL.$value['href'].'\\\')">'.
                '<img src="'.BASE_URL.'resource/img/icons/picture_add.gif" width="16" height="16" alt="原寸表示" /></a>&nbsp;&nbsp;'.
                '<a href="javascript:void(0)" onclick="insertImgLink(\\\''.BASE_URL.$value['href'].'\\\',\\\''.BASE_URL.$value['src'].'\\\')">'.
                '<img src="'.BASE_URL.'resource/img/icons/picture_delete.gif" width="16" height="16" alt="縮小表示" /></a>&nbsp;&nbsp;'.
                '<a href="'.HTTP_ACTION.'community/item/upload/'.$this->ref_community.'/'.$this->ref_topic.'/'.WAP_URI_SEPARATOR.'id='.$value['id'].'&amp;delete=1" target="imgframe">'.
                '<img src="'.BASE_URL.'resource/img/icons/cross.gif" width="16" height="16" alt="削除" /></a>'.
                '<input type="hidden" name="ref_pictures[]" value="'.$value['id'].'" />'.
                '</td>';
            $row ++;
            if ($row >= 3){
                $row = 0;
                $html .= '</tr><tr>';
            }
        }
        $html .= '</tr></table>';

        $this->Assign('pictures', $html);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* 一覧用画像 */
        if (!$this->objfile->catchFile('image')) {
            return false;
        }
        if (!$this->objfile->isImage()){
            return false;
        }
        $title = $this->objfile->getName();
        $extension = $this->objfile->getExtension();

        // 直接入力
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_relation', $this->ref_topic);
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('title', $title);
        $this->objmnp->setValue('status', STATUS_PICTURE_TOPIC);

        /* データベース操作実行 */
        $result = $this->objmnp->doManip($this);
        $id = $this->objmnp->getCurID();
        $name = $id.time();

        // ファイルの保存先
        $large_src = ARCHIVES_MEMBER_PATH.$this->account['id'].'/large/'.$name.'.'.$extension;
        $small_src = ARCHIVES_MEMBER_PATH.$this->account['id'].'/small/'.$name.'.'.$extension;

        // ファイルの保存
        $large = $this->objfile->saveResize($large_src,PHOTO_MAX_SIZE,PHOTO_MAX_SIZE);
        $small = $this->objfile->saveResize($small_src,PHOTO_SMALL_SIZE,PHOTO_SMALL_SIZE);

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_picture '.
            'SET '.
                "filename = '".$large_src."',".
                'width = '.$large['width'].','.
                'height = '.$large['height'].','.
                "thumbnail = '".$small_src."',".
                't_width = '.$small['width'].','.
                't_height = '.$small['height'].' '.
            'WHERE '.
                'id ='.$id .' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_picture()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_community = '.$this->ref_community;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        $this->objfile->unlink($result['thumbnail']);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_community = '.$this->ref_community;
        $return = $this->objdb->exec($sql);
        
        return $return;
    }

    /**
     * トピックの編集権限
     *
     * @access private
     * @return boolean
     */
    function is_editor()
    {
        if (empty($this->id)){
            return true;
        }
        if ($this->admin){
            return true;
        }

        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id = '.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['id']);
    }
} // webapp
?>
