<?php
/* ========================================================================
 - [modules/admin/inquire/browse.php]
 -      問合せ一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * フラグ
     * @var integer
     */
    var $flag = null;

    /**
     * メール送信ID
     * @var integer
     */
    var $ref_inquire = null;

    /**
     * 削除ID
     * @var integer
     */
    var $delete = null;

    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/inquire/browse.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_inquire');
        $this->Assign('ref_inquire', $this->ref_inquire);

        $this->setSafety('delete');

        /* メッセージ操作 */        
        if ($this->update_query()){
            header('Location: '.HTTP_ACTION.'admin/inquire/list/'.$this->status.'/updated/');
            exit();
        }
        if ($this->delete_query()){
            header('Location: '.HTTP_ACTION.'admin/inquire/browse/'.$this->ref_inquire.'/deleted/');
            exit();
        }
        if (!empty($_POST['respond'])){
            header('Location: '.HTTP_ACTION.'admin/inquire/sendmail/'.$this->ref_inquire.'/');
            exit();
        }
        $this->set_inquire();
        $this->set_response();

        $statuses = array(
            STATAS_INQUIRE_NEW=> STATAS_INQUIRE_LABEL_NEW,
            STATAS_INQUIRE_PENDING=> STATAS_INQUIRE_LABEL_PENDING,
            STATAS_INQUIRE_RESPONDED=> STATAS_INQUIRE_LABEL_RESPONDED,
            STATAS_INQUIRE_TRASH=> STATAS_INQUIRE_LABEL_TRASH
        );
        $this->Assign('statuses', $statuses);

        $this->update_flag();
        $this->set_result();
    }

    /**
     * アクション結果の設定
     *
     * @access private
     * @return void
     */
    function set_result()
    {
        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }
        if (preg_match('/send/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('send', true);
        }
        if (preg_match('/updated/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('updated', true);
        }
        if (preg_match('/deleted/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('deleted', true);
        }
    }

    /**
     * 問合せ内容の設定
     *
     * @access private
     * @return void
     */
    function set_inquire()
    {
        $sql = 
            'SELECT '.
                'inq.id as id,'.
                'inq.modify as modify,'.
                'inq.regist_date as regist_date,'.
                'inq.ref_account as ref_account,'.
                'cat.category as category,'.
                'inq.status as status,'.
                'inq.flag as flag,'.
                'inq.name as name,'.
                'inq.url as url,'.
                'inq.email as email,'.
                'inq.comment as comment '.
            'FROM '.
                DB_PREFIX.'inq_category cat,'.
                DB_PREFIX.'inq_inquire inq '.
            'WHERE '.
                'cat.id = inq.ref_category AND '.
                'inq.id = '.$this->ref_inquire;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->flag = $result['flag'];

        $this->Assign('inquire',$result);
        $this->set_account($result['ref_account']);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_account($ref_account)
    {
        if (empty($ref_account)){
            return ;
        }
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.last_login as last_login,'.
                'pht.filename as href,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();        
        
        $this->Assign('account', $result);
    }

    /**
     * 問合せ内容の設定
     *
     * @access private
     * @return void
     */
    function set_response()
    {
        $sql = 
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'inq_response '.
            'WHERE '.
                'ref_inquire = '.$this->ref_inquire.' '.
            'ORDER BY '.
                'regist_date';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('responses',$result);
    }


    /**
     * メッセージボックスの移動
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query()
    {
        if (empty($_POST['manip'])){
            return ;
        }

        $statuses = array(
            STATAS_INQUIRE_NEW,
            STATAS_INQUIRE_PENDING,
            STATAS_INQUIRE_RESPONDED,
            STATAS_INQUIRE_TRASH
        );

        $this->status = empty($_POST['status'])?STATAS_INQUIRE_TRASH:$_POST['status'];        
        $this->status = in_array($this->status,$statuses)?$this->status:STATAS_INQUIRE_TRASH;
        
        $sql =
            'UPDATE '.
                DB_PREFIX.'inq_inquire '.
            ' SET '.
                'status='.$this->status.' '.
            ' WHERE '.
                'id = '.$this->ref_inquire;
        return $this->objdb->exec($sql);
    }

    /**
     * フラグの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_flag()
    {
        if ($this->flag != MESSAGE_FLAG_UNREAD){
            return false;
        }
        $sql =
            'UPDATE '.
                DB_PREFIX.'inq_inquire '.
            'SET '.
                'flag='.MESSAGE_FLAG_READ.' '.
            'WHERE '.
                'id = '.$this->ref_inquire;
        return $this->objdb->exec($sql);
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function delete_query()
    {
        if (empty($this->delete)){
            return ;
        }
        
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'inq_response '.
            'WHERE '.
                'id = '.$this->delete;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
