<?php
/* ========================================================================
 - [modules/community/edit/intro.php]
 -      友達に紹介する
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * ページ情報
     * @var string
     */
    var $page = '';

    /**
     * 友達ＩＤ格納用
     * @var array
     */
    var $ref_friends = array();

    /**
     * コミュニティ名
     * @var string
     */
    var $community = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/edit/intro.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('page', 1,'string');
        $is_edit = empty($this->page)?'again':$this->page;
        $this->Assign('edit', preg_match('/^again$/',$is_edit));
        
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/edit/intro/'.$this->sid.'/'.$this->ref_community.'/again/');
            exit();
        }

        $this->set_ref_friends();
        
        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_message');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->do_send_message();
            $this->Assign('complete', true);
            unset($_SESSION[DB_PREFIX.'fri_message']);
            unset($_SESSION['ref_friends']);
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['ref_friends'] = $this->ref_friends;
            header('Location: '.HTTP_ACTION.'community/edit/intro/'.$this->sid.'/'.$this->ref_community.'/confirm/');
            exit();
        }
        $this->set_friend();
    }

    /**
     * 紹介相手の設定
     *
     * @access private
     * @return array
     */
    function set_ref_friends()
    {
        if (!empty($_POST['ref_friends'])){
            $this->ref_friends = $_POST['ref_friends'];
            unset($_SESSION['ref_friends']);
            return ;
        }

        if (!empty($_SESSION['ref_friends'])){
            $this->ref_friends = $_SESSION['ref_friends'];
            return ;
        }

        $this->ref_friends = array();
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'nam.status as status,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'com_names nam '.
                    'ON act.id = nam.ref_account AND '.
                        'nam.ref_community = '.$this->ref_community .','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = fri.ref_friend AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $row){
            if (empty($row['status'])){
                $row['checked'] = !empty($this->ref_friends[$row['id']]);
                $list[] = $row;
            }
        } // foreach ($result as $row)
                
        $this->Assign('friends', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($_POST['manip'])){
            return RKT_MANIP_COMPLETE;
        }
        $this->objmnp->validate('number','ref_friends', null, true);

        // 更新しない項目名
        $skip = array(
            'regist_date',
            'modify',
            'ref_account',
            'ref_message',
            'ref_to',
            'ref_from',
            'flag',
            'status',
            'subject',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doValidate($this);
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return void
     */
    function do_send_message()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $body = 
            $infos['nickname'].'さんからおすすめコミュニティ紹介です'."\r\n".
            "\r\n".
            '[コミュニティ名]:'.$this->community['community']."\r\n".
            "\r\n".
            '[コメント]:'."\r\n".
            $_SESSION[DB_PREFIX.'fri_message']['body']."\r\n".
            "\r\n".
            '[コミュニティのUR]:'."\r\n".
            HTTP_ACTION.'community/show/community/'.$this->ref_community.'/'."\r\n";


        $value = array(
            'modify'=> date('Y-m-d H:i:s'),
            'regist_date'=> date('Y-m-d H:i:s'),
            'ref_account'=> 0,
            'ref_to'=> 0,
            'ref_from'=> $this->account['id'],
            'subject'=> 'コミュニティおすすめメッセージ',
            'body'=> $body,
        );

        foreach ($this->ref_friends as $id){
            $value['ref_account'] = $id;
            $value['ref_to'] = $id;
            $this->insert_message($value);
        }
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return integer  データ操作結果
     */
    function insert_message($value)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'fri_message('.
                    'modify,'.
                    'regist_date,'.
                    'status,'.
                    'ref_account,'.
                    'ref_to,'.
                    'ref_from,'.
                    'flag,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$value['modify']."',".
                    "'".$value['regist_date']."',".
                    MESSAGE_INBOX.','.
                    $value['ref_account'].','.
                    $value['ref_to'].','.
                    $value['ref_from'].','.
                    MESSAGE_FLAG_UNREAD.','.
                    "'".$value['subject']."',".
                    "'".$value['body']."'".
                ')';
        return $this->objdb->exec($sql);
    }
} // webapp
?>
