<?php
/* ========================================================================
 - [libs/rkt_manip(ulation).php]
 -      DB操作クラス
 -      Copyright (c) 2005-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/03/11] 入力データのエスケープ処理をRKT_validateへ移行
 -      [2006/05/19] privateの関数をpublickに変更（query関連）
 -      [2005/06/01] コンストラクタ引数変更、DB接続オジェクトを追加
 -      [2005/05/12] グローバルスコープ・フォーム入力関連を修正
 -      [2005/05/05] グローバルスコープ・フォーム入力関連を修正
 -      [2005/03/19] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';

/**
 * 操作後の挙動定義
 * @const RKT_MANIP_ERROR エラー
 */
define('RKT_MANIP_ERROR', 0);
/**
 * 操作後の挙動定義
 * @const RKT_MANIP_INIT 初期化
 */
define('RKT_MANIP_INIT', 1);
/**
 * 操作後の挙動定義
 * @const RKT_MANIP_ALERT 警告
 */
define('RKT_MANIP_ALERT', 2);
/**
 * 操作後の挙動定義
 * @const RKT_MANIP_VALIDATED 有効な値
 */
define('RKT_MANIP_VALIDATED', 3);
/**
 * 操作後の挙動定義
 * @const RKT_MANIP_COMPLETE 完了
 */
define('RKT_MANIP_COMPLETE', 4);

/**
 * 操作の種類
 * @const RKT_MANIP_NONE 何もしない
 */
define('RKT_MANIP_NONE', 0);
/**
 * 操作の種類
 * @const RKT_MANIP_INSERT 挿入
 */
define('RKT_MANIP_INSERT', 1);
/**
 * 操作の種類
 * @const RKT_MANIP_UPDATE 更新
 */
define('RKT_MANIP_UPDATE', 2);
/**
 * 操作の種類
 * @const RKT_MANIP_DELETE 削除
 */
define('RKT_MANIP_DELETE', 3);


/**
 * DB操作クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_manip
 * @access public
 * @version 1.1
 */
class RKT_manip extends RKT_validate
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * 入力内容
     * @var array
     */
    var $values = array();

    /**
     * カレントID
     * @var integer
     */
    var $cur_id = 0;

    /**
     * テーブル名
     * @var string
     */
    var $tbl_name = '';

    /**
     * シーケンス名
     * @var string
     */
    var $seq_name = '';

    /**
     * 初期値用のSQL文
     * @var string
     */
    var $init_sql = '';

    /**
     * 初期値を取得する配列
     * @var array
     */
    var $init_values = array();

    /**
     * プライマリキー文字列
     * @var string
     */
    var $primary_key = '';

    /**
     * プライマリキー整合性情報
     * @var string
     */
    var $primary_validate = array();

    /**
     * GET,POST,COKKIEのクオート設定
     * @var string
     */
    var $magic_quotes_gpc = false;

    /**
     * 操作の種類
     * @var string
     */
    var $action_flag = RKT_MANIP_NONE;

    /**
     * DBタイプ
     * @var string
     */
    var $type = RKT_DB_DRIVER;

    /**
     * フィールド名用のクォート
     * @var string
     */
    var $key_quote = '';

    /**
     * 初期valuesのテンプレート変数の名前
     * @var string
     */
    var $values_key = 'value';

    /**
     * 初期値への加工設定
     * @var array
     */
    var $init_effects = array();

    /**
     * 入力値への加工設定
     * @var array
     */
    var $input_effects = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $tbl_name テーブル名
     */
    function RKT_manip(&$objdb, $tbl_name, $type=RKT_DB_DRIVER)
    {
        $this->RKT_validate();
        $this->objdb =& $objdb;

        $this->type       = $type;
        $this->tbl_name   = $tbl_name;
        $this->seq_name   = $tbl_name;
        
        $key_quote = array(
            'mysql'=> '`',
            'pgsql'=> '"',
            'sqlite'=> '',
        );
        $this->key_quote = $key_quote[$this->type];

        $this->values     = array();
        $this->primary_key= 'id';

        $this->primary_validate = array(
            'type'=>   'number',
            'option'=> array(
                'min_length'=>1)
        );

        $this->magic_quotes_gpc = get_magic_quotes_gpc();
    }

    /**
     * DB操作の実行
     *
     * @access public
     * @param reference $objhtml
     * @param array $skip
     * @param array $validates
     * @return integer 実行結果
     */
    function execute(&$objhtml, $skip=null, $validates=null)
    {
        $is_manip   = preg_match('/manip/i',$_SERVER['REQUEST_URI']);
        $is_confirm = preg_match('/confirm/i',$_SERVER['REQUEST_URI']);
        $is_complete = preg_match('/complete/i',$_SERVER['REQUEST_URI']);

        $manip = array(
            'edit'=>     empty($is_confirm),
            'complete'=> !empty($is_complete),
            'action'=>   empty($is_confirm)?'edit':'manip',
        );
        $objhtml->Assign('manip', $manip);
        
        if ($is_manip){
            $this->setRequestType("_SESSION['".$this->tbl_name."']");
        }

        if (!empty($validates)){
            foreach ($validates as $key=>$validate) {
                $this->setInput($key, $validate);
            }            
        } // if (!empty($validates))

        $this->catchInput($skip);


        $result = RKT_MANIP_INIT;
        if ($is_manip){
            $_SESSION[$this->tbl_name]['manip'] = true;
            $result = $this->doManip($objhtml);
        } else {
            $result = $this->doValidate($objhtml);
        }

        if ($result == RKT_MANIP_COMPLETE){
            unset($_SESSION[$this->tbl_name]);
        }
        return $result;
    }

    /**
     * 初期値を取得するSELECT文の設定
     *
     * @access public
     * @param string $init_sql 初期値を取得するSELECT文
     */
    function setInitSql($sql='')
    {
        $this->init_sql = $sql;
    }

    /**
     * プライマリキーの設定
     *
     * @access public
     * @param string $primary_key プライマリキー
     */
    function setPrimaryKey($primary_key)
    {
        $this->primary_key = $primary_key;
    }

    /**
     * カレントIDの設定
     *
     * @access public
     * @param integer $cur_id カレントID
     */
    function setCurID($cur_id)
    {
        $this->cur_id = trim($cur_id);
    }

    /**
     * 挿入・更新情報の設定
     *
     * @access public
     * @parmas string $key 項目の名
     * @parmas mixed $value 挿入・更新情報
     * @return integer 0:エラー 1:正常
     */
    function setValue($key, $value)
    {
        $this->values[$key] = $value;
    }

    /**
     * 初期valuesのテンプレート変数名の設定
     *
     * @access public
     * @parmas string $key 変数名
     * @return void
     */
    function setValuesKey($key)
    {
        $this->values_key = $key;
    }

    /**
     * 初期値への加工設定
     *
     * @access public
     * @parmas string $key 変数名
     * @parmas array  $value エフェクト
     * @return void
     */
    function setInitEffect($key, $value)
    {
        $this->init_effects[$key] = $value;
    }

    /**
     * 入力値への加工設定
     *
     * @access public
     * @parmas string $key 変数名
     * @parmas array  $value エフェクト
     * @return void
     */
    function setInputEffect($key, $value)
    {
        $this->input_effects[$key] = $value;
    }

    /**
     * カレントIDの取得
     *
     * @access public
     * @return integer カレントID
     */
    function getCurID()
    {
        return $this->cur_id;
    }

    /**
     * 既存値の取得
     *
     * @access public
     * @parmas string $key フィールド名
     * @return mixed カレントID
     */
    function getValue($key)
    {
        return @$this->values[$key];
    }

    /**
     * 初期値の取得
     *
     * @access public
     * @parmas string $key フィールド名
     * @return mixed カレントID
     */
    function getInitValue($key)
    {
        return @$this->init_values[$key];
    }

    /**
     * アクションフラグの取得
     *
     * @access public
     * @return integer カレントID
     */
    function getActionFlag()
    {
        return $this->action_flag;
    }

    /**
     * 外部入力の設定
     *
     * @access public
     * @param string $key グローバルスコープの添え字
     * @param mixed $validate_info 整合性情報
     *      ['type'] = string
     *      ['option'] = array()
     *      ['required'] = boolean
     * @return boolean
     */
    function setInput($key, $validate_info)
    {
        if(is_array($validate_info)){
            extract($validate_info);
        }
        $type     = empty($type)? 'required':$type;
        $option   = empty($option)? null:$option;
        $required = empty($required)? false:$required;
        $effect   = empty($effect)? array('RKT_validate', 'escape_character'):$effect;

        if (!$this->validate($type, $key, $option, $required, $effect)){
            $this->values[$key] = '';
            return false;
        }

        $value = $this->getRequest($key);
        /* 対象が日付型の場合 */
        if ($type === 'date'){
            $value = RKT_calendar::joinDate($value);
        }
        $this->values[$key] = $value;

        return true;
    }

    /**
     * フォームから飛んでくるカレントID取得
     *
     * @access public
     */
    function catchCurID()
    {
        /* プライマリキーの取得 */
        $this->validate(
            $this->primary_validate['type'], 
            $this->primary_key, 
            $this->primary_validate['option']
        );
        $this->cur_id = @$this->requests[$this->primary_key];
        $this->escape_character($this->cur_id);
    }

    /**
     * フォームから飛んでくるカレント入力値を取得
     *
     * @access public
     * @param array $skip
     * @retrun void
     */
    function catchInput($skip=null)
    {
        include_once LIB_DIR.'rktManip/manip_'.$this->type.'.php';
        $classname = 'manip_'.$this->type;

        $obj =& new $classname($this->objdb, $this->tbl_name);

        // 既に入力されたものを除外に追加
        $skip = is_array($skip) ? $skip : array();
        foreach ($this->values as $key=>$value){
            $skip[] = $key;
        }

        /* 整合性チェック情報の取得 */
        $validates = $obj->parseColumns($skip);
        // 整合性チェック
        foreach ($validates as $key=>$validate) {
            $this->setInput($key, $validate);
        } // foreach ($validates as $key=>$validate)
    }

    /**
     * 初期値データへの加工処理
     *
     * @access public
     * @retrun void
     */
    function initEffect()
    {
        foreach ($this->init_effects as $key=>$effect){
            $init_key = empty($effect['key'])?$key:$effect['key'];
            $this->init_values[$key] = call_user_func($effect['func'], $this->init_values[$init_key]);
        }
    }

    /**
     * 入力データへの加工処理
     *
     * @access public
     * @retrun void
     */
    function inputEffect()
    {
        foreach ($this->input_effects as $key=>$effect){
            $req_key = empty($effect['key'])?$key:$effect['key'];
            $this->values[$key] = call_user_func($effect['func'], $this->requests[$req_key]);
        }
    }

    /**
     * 操作の実行
     *
     * @access public
     * @param string $trigger きっかけキーワード
     * @return integer 影響を与えたテーブル行数
     */
    function doManip(&$objhtml,$trigger='manip')
    {
        $is_init = true;
        eval('$is_init = empty($'.$this->request_type.'[$trigger]);');
        if ($is_init){
            $this->selectQuery();
            $this->displayValues($objhtml);
            return RKT_MANIP_INIT;
        }

        /* 行の削除 */
        if ($trigger == 'delete') {
            $result = $this->deleteQuery();
            if (!$result){
                return RKT_MANIP_ERROR;
            }
            return RKT_MANIP_COMPLETE;
        } // if ($trigger == 'delete')

        /* 入力チェック判定 */
        $check = $this->getValidate();
        if (!$check){
            $this->displayAlert($objhtml);
            $objhtml->Assign('value', $this->requests);
            $this->selectQuery();
            return RKT_MANIP_ALERT;
        }
        
        /* 入力データへの加工処理 */
        $this->inputEffect();

        /* 更新・挿入処理 */
        $result = $this->updateQuery();
        if (!$result){
            $result = $this->insertQuery();
        }

        $this->displayValues($objhtml);
        if (!$result){
            return RKT_MANIP_ERROR;
        }
    
        return RKT_MANIP_COMPLETE;
    }

    /**
     * 操作の実行
     *
     * @access public
     * @param string $trigger きっかけキーワード
     * @return integer 影響を与えたテーブル行数
     */
    function doValidate(&$objhtml,$trigger='validate')
    {
        $is_edit = false;
        $is_again = preg_match('/again/i',$_SERVER['REQUEST_URI']);
        $is_confirm = preg_match('/confirm/i',$_SERVER['REQUEST_URI']);
        if (empty($is_again) && empty($is_confirm)){
            $is_edit = true;
        }

        /* セッションスタート */
        $session_id = session_id();
        if (!$session_id){
            session_start();
        }

        /* 状態判定 */
        $is_init = true;
        eval('$is_init = empty($'.$this->request_type.'[$trigger]);');
        if ($is_init){
            if (isSet($_SESSION[$this->tbl_name]) && $is_edit==false){
                $this->init_values = $_SESSION[$this->tbl_name];
            } else {
                $this->selectQuery();
            }

            $this->displayValues($objhtml);
            return RKT_MANIP_INIT;
        }

        /* 入力チェック判定 */
        $check = $this->getValidate();
        if ($check){
            $_SESSION[$this->tbl_name] = $this->requests;
        } else {
            $this->displayAlert($objhtml);
            $objhtml->Assign('value', $this->requests);
            $this->selectQuery();
            return RKT_MANIP_ALERT;
        }
    
        return RKT_MANIP_VALIDATED;
    }

    /**
     * 初期値を取得する
     *
     * @access publick
     */
    function selectQuery()
    {
        /* SELECT文の生成 */
        if (empty($this->init_sql)){
            $keys = array_keys($this->values);
            $column = implode($this->key_quote.','.$this->key_quote,$keys);

            $this->init_sql =
                'SELECT '.
                    $this->primary_key.','.
                    $this->key_quote.$column.$this->key_quote.' '.
                'FROM '.
                    $this->tbl_name.' '.
                'WHERE '.
                    $this->primary_key."='".$this->cur_id."'";
        }
        /* 全ての情報を取得（添え字を項目名） */
        $stmt = $this->objdb->prepare($this->init_sql);
        $stmt->execute(); 
        $this->init_values = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!$this->init_values){
            $this->init_values = array();
            return false;
        }

        /* 初期値への加工処理 */
        $this->initEffect();

        return true;
    }

    /**
     * 更新処理
     *
     * @access publick
     * @return integer 影響を与えたテーブル行数
     */
    function updateQuery()
    {
        $set = '';
        foreach ($this->values as $key=>$value) {
            $value = ($value===''||$value===null)?'NULL':$this->objdb->quote($value);
            $set .= $this->key_quote.$key.$this->key_quote.'='.$value.',';
        }
        $where = $this->key_quote.$this->primary_key.$this->key_quote."='".$this->cur_id."'";

        $sql =
            'UPDATE '.
                $this->tbl_name.
            ' SET '.
                substr($set,0,-1).
            ' WHERE '.
                $where;
        $result = $this->objdb->exec($sql);
        if ($result > 0){
            $this->action_flag = RKT_MANIP_UPDATE;
        }
        return $result;
    }

    /**
     * 挿入処理
     *
     * @access publick
     * @return integer 影響を与えたテーブル行数
     */
    function insertQuery()
    {
        if (!empty($this->cur_id)){
            $this->values[$this->primary_key] = $this->cur_id;
        }
        $keys = array_keys($this->values);
        $column = implode($this->key_quote.','.$this->key_quote,$keys);

        $values = array();
        foreach ($this->values as $key=>$value) {
            $values[] = ($value===''||$value===null)?'NULL':$this->objdb->quote($value);
        }
        $value = implode(',',$values);

        $sql =
            'INSERT INTO '.
                $this->tbl_name.'('.$this->key_quote.$column.$this->key_quote.')'.
                ' VALUES ('.$value.')';
        $result = $this->objdb->exec($sql);

        if ($result > 0){
            if (empty($this->cur_id)){
                $this->cur_id = $this->objdb->lastInsertId();
            }
            $this->action_flag = RKT_MANIP_INSERT;
        }
        return $result;
    }

    /**
     * 行の削除
     *
     * @access public
     * @return integer 影響を与えたテーブル行数
     */
    function deleteQuery()
    {
        $primary_key = $this->key_quote.$this->primary_key.$this->key_quote;
        $sql =
            'DELETE FROM '.
                $this->tbl_name.' '.
            'WHERE '.
                $primary_key."='".$this->cur_id."'";
        $result = $this->objdb->exec($sql);

        if ($result){
            $this->action_flag = RKT_MANIP_DELETE;
        }

        return $result;
    }

    /**
     * 初期値の設定
     *
     * @access public
     * @return boolean 成功時：真
     */
    function displayValues(&$objhtml)
    {
        if (!is_array($this->init_values)){
            return false;
        }

        $objhtml->Assign($this->values_key, $this->init_values);

        return true;
    }
} // RKT_manipの終了
?>
