<?php
/* ========================================================================
 - [libs/rktPDO/drivers/rkt_mysql.php]
 -      なんちゃってPDO MySQLライバ
 -      Copyright (c) 2005-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/12/18]    定数定義をrkt_pdo.phpへ集中
 -      [2006/09/29]    リクエスト結果取得関連の定数宣言を追加
 -      [2005/03/19]    bindParam追加・RKT_mysql::query()の戻り値を修正
 -      [2005/01/08]    作成
 - ======================================================================== */

/**
 * なんちゃってPDO MySQLライバ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_mysql
 * @access public
 * @version 1.0
 */
class RKT_mysql
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * errmessage
     * @access private
     * @var string
     */
    var $sqlerror = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_mysql($dsn,$arg=null)
    {
        $this->dbh = mysql_connect($dsn['host'], $dsn['username'], $dsn['passwd']);
        mysql_select_db($dsn['dbname'], $this->dbh);
        
        $func_names = array(
            0=> array('RKT_mysql','dummy'),     // NAMES OFF 0
            1=> array('RKT_mysql','set_names')  // NAMES ON  1
        );
        call_user_func($func_names[USE_SET_NAMES]);
    }

    /**
     * 文字コードの設定
     *
     * @access public
     * @return void
     */
    function set_names()
    {
        mysql_query("SET NAMES 'utf8'", $this->dbh);
    }

    /**
     * ダミー
     *
     * @access public
     * @return void
     */
    function dummy()
    {
    }

    /**
     * オープンされたMySQLデータベースを閉じる
     *
     * @access public
     * @return void
     */
    function db_close()
    {
        mysql_close($this->dbh);
        $this->dbh = null;
    }


    /**
     * 最後に発行したIDの取得
     *
     * @access public
     * @return integer
     */
    function lastInsertId()
    {
        return @mysql_insert_id($this->dbh);
    }

    /**
     * プリペアドステートメントの作成
     *
     * @access public
     * @return object
     */
    function &prepare($sql)
    {
        $stmt = new RKT_mysqlStatement($this->dbh);
        $stmt->setSql($sql);
        
        return $stmt;
    }

    /**
     * トランザクションの開始
     *
     * @access public
     * @return boolean
     */
    function beginTransaction()
    {
        $result = mysql_query('BEGIN TRANSACTION', $this->dbh);
        
        return ($result)?true:false;
    }

    /**
     * トランザクションの確証
     *
     * @access public
     * @return boolean
     */
    function commit()
    {
        $result = mysql_query('COMMIT', $this->dbh);
        
        return ($result)?true:false;
    }

    /**
     * トランザクション内のクエリ取りやめ
     *
     * @access public
     * @return boolean
     */
    function rollBack()
    {
        $result = mysql_query('ROLLBACK', $this->dbh);
        
        return ($result)?true:false;
    }

    /**
     * アトリビュート設定
     *
     * @access public
     * @param long $attribute
     * @param mixed $value
     * @return boolean
     */
    function setAttribute($attribute, $value)
    {        
        return true;
    }

    /**
     * クエリ用の文字列をクオートする
     *
     * @access public
     * @param string $query
     * @return string
     */
    function quote($query)
    {
        return "'".mysql_escape_string($query)."'";
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return integer
     */
    function exec($query)
    {
		ob_start();
        mysql_query($query, $this->dbh);
		$this->sqlerror .= ob_get_contents();
		ob_end_clean();
        
        return @mysql_affected_rows($this->dbh);
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return integer
     */
    function query($query)
    {
		ob_start();
        $result = mysql_query($query, $this->dbh);
		$this->sqlerror .= ob_get_contents();
		ob_end_clean();

        $result = @mysql_query($query, $this->dbh);
        
        return ($result)?true:false;
    }
} // RKT_mysqlの終了

/**
 * なんちゃってPDOStatement
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_mysqlStatement
 * @access public
 * @version 1.1
 */
class RKT_mysqlStatement
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * sql
     * @access private
     * @var string
     */
    var $sql = '';

    /**
     * result
     * @access private
     * @var resource
     */
    var $result = null;

    /**
     * bind_flag
     * @access private
     * @var boolean
     */
    var $bind_flag = false;
 
    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance(&$dbh)
    {
        static $__singleton;
        
        if ($__singleton == null) {
            $__singleton = new RKT_mysqlStatement($dbh);
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_mysqlStatement(&$dbh)
    {
        $this->dbh = $dbh;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setSql($sql)
    {
        $this->sql = $sql;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setBindFlag($flag)
    {
        $this->bind_flag = $flag;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function execute()
    {
        if ($this->bind_flag){
            $sql = $this->_bind($this->sql);
        } else {
            $sql = $this->sql;
        }
        $this->result = mysql_query($sql, $this->dbh);

        return ($this->result)?true:false;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function rowCount()
    {
        return @mysql_affected_rows($this->dbh);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetch($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>MYSQL_ASSOC,
                PDO_FETCH_NUM=>  MYSQL_NUM,
                PDO_FETCH_BOTH=> MYSQL_BOTH
            );
        return @mysql_fetch_array($this->result, $result_type[$how]);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @return mixed
     */
    function fetchSingle()
    {
        $row = @mysql_fetch_row($this->result);
        return $row[0];
    }

    /**
     * 結果リソースの全ての値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetchAll($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>MYSQL_ASSOC,
                PDO_FETCH_NUM=>  MYSQL_NUM,
                PDO_FETCH_BOTH=> MYSQL_BOTH
            );
        $values = array();
        $row = 0;
        // @mysql_data_seek($this->result, 0);
        while ($fetch = @mysql_fetch_array($this->result, $result_type[$how])) {
            foreach ($fetch as $key=>$value) {
                $values[$row][$key] = $value;
            }
            $row++;
        }
        return $values;
    }

    /**
     * バインド変数設定
     *
     * @access public
     * @param mixed $paramno
     * @param mixed &$param
     * @param integer $type
     * @param integer $maxlen
     * @param mixed $driverdata
     * @return boolean
     */
    function bindParam($paramno, &$param, $type=PDO_PARAM_STR, $maxlen=0, $driverdata=null)
    {
         $this->bind_flag = true;
         $this->param[$paramno] = array(
            'key'=>   $paramno,
            'param'=> &$param,
            'type'=>  $type,
            'maxlen'=>$maxlen
        );
        return true;
    }

    /**
     * カーソルを閉じる
     *
     * @access public
     * @return boolean
     */
    function closeCursor()
    {
        return true;
    }

    /**
     * バインド変数処理
     *
     * @access public
     * @return string
     */
    function _bind()
    {
        $types = array(
                PDO_PARAM_NULL=> '',
                PDO_PARAM_INT=>  '',
                PDO_PARAM_STR=>  "'",
                PDO_PARAM_LOB=>  '',
                PDO_PARAM_STMT=> ''
            );

        foreach ($this->param as $param){
            $value  = $types[$param['type']];
            $value .= mysql_escape_string($param['param']);
            $value .= $types[$param['type']];

            $sql = preg_replace( '/'.$param['key'].'/', $value, $sql, 1);
        }

        return $sql;
    }
} // RKT_mysqlStatementの終了
?>