<?php
/* ========================================================================
 - [libs/rktManip/manip_pgsql.php]
 -      rkt_manip(ulation).php PostgreSQLドライバ
 -      Copyright (c) 2006-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/03/11]    入力データのエスケープ処理指定を追加
 -      [2006/12/17]    作成
 - ======================================================================== */

/**
 * manipulation PostgreSQLドライバ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package manip_pgsql
 * @access public
 * @version 1.0
 */
class manip_pgsql
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * テーブル名
     * @var string
     */
    var $tbl_name = "";

    /**
     * テーブル名
     * @var string
     */
    var $primary_key = "";

    /**
     * コンストラクタ
     *
     * @access public
     * @param object $objdb    データベースオブジェクト
     * @param string $tbl_name テーブル名
     */
    function manip_pgsql(&$objdb, $tbl_name='')
    {
        $this->objdb =& $objdb;

        $this->tbl_name = $tbl_name;
    }

    /**
     * プライマリキーの取得
     *
     * @access public
     * @return string
     */
    function getPrimaryKey()
    {
        return $this->primary_key;
    }

    /**
     * 項目情報の解析
     *
     * @access public
     * @param array $skip
     * @return array
     */
    function parseColumns($skip=array())
    {
        $result = null;
        $sql=
            'SELECT '.
                'att.attname,'.
                'typ.typname,'.
                'att.attlen,'.
                'att.attnotnull,'.
                'att.atttypmod,'.
                'att.attnum,'.
                'idx.indkey '.
            'FROM '.
                'pg_type typ,'.
                'pg_class cls,'.
                'pg_attribute att,'.
                'pg_index idx '.
            'WHERE '.
                'cls.oid = att.attrelid AND '.
                'cls.oid = idx.indrelid AND '.
                'typ.oid = att.atttypid AND '.
                "cls.relname = '".$this->tbl_name."' AND ".
                'idx.indisprimary = true AND '.
                'att.attnum > 0 '.
            'ORDER BY '.
                'att.attnum';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $validates = array();
        foreach ($result as $value){
            $key  = $value['attname'];
            $parse = $this->parse_type($value['typname'],$key,$value['atttypmod']);
            $infos = array(
                'type'=>    $parse['type'],
                'option'=>  $parse['option'],
                'required'=>$this->parse_required($value['attnotnull']),
                'effect'=>  array('RKT_validate', 'escape_character'),
            );

            /* プライマリキーは別扱い */
            if ($value['attnum'] == $value['indkey']){
                $this->primary_key = array(
                    'key'=>  $key,
                    'info'=> $infos
                );
            } else {
                if (!in_array($key,$skip)){
                    $validates[$key] = $infos;
                }
            } // if (!$this->catch_primary_key($value['Key']))
        }

        return $validates;
    }

    /**
     * フィールドの型を解析
     *
     * @access public
     * @param string $subject
     * @param string $option
     * @return array
     */
    function parse_type($subject,$field,$size)
    {
        $type = 'number';
        $option = null;
        $size -= 4;
        if ($size <= 0){
            $size = 8000;
        }

        /* 型名から設定 */
        if (preg_match("/varchar/i",$subject)){
            $type = 'string';
            $option = array(
                'max_length'=>$size
            );
        } else if (preg_match("/int/i",$subject)){
            $type = 'number';
        } else if (preg_match("/text/i",$subject)){
            $type = 'string';
            $option = array(
                'max_length'=>$size
            );
        } else if (preg_match("/date/i",$subject)){
            $type = 'date';
            $option = array(
                'format'=> '%Y-%n-%d'
            );
        } else if (preg_match("/timestamp/i",$subject)){
            $type = 'date';
            $option = array(
                'format'=> '%Y-%n-%d %H:%i:%s'
            );
        } else if (preg_match("/float/i",$subject)){
            $type = 'number';
            $option = array(
                'decimal'=>'.'
            );
        } else if (preg_match("/double/i",$subject)){
            $type = 'number';
            $option = array(
                'decimal'=>'.'
            );
        } else if (preg_match("/bytea/i",$subject)){
            $type = 'string';
            $option = array(
                'max_length'=>$size
            );
        }
        
        /* フィールド名から設定 */
        if (preg_match("/email/i",$field)){
            $type = 'email';
        } else if (preg_match("/url/i",$field)){
            $type = 'uri';
        } else if (preg_match("/postal/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+'
            );
        } else if (preg_match("/phone/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+[-]*\d+'
            );
        } else if (preg_match("/fax/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+[-]*\d+'
            );
        } else if (preg_match("/password/i",$field)){
            $type = 'string';
            $option = array(
                'format'=> '\w+',
                'min_length'=>4,
                'max_length'=>$size
            );
        }
        
        return array('type'=>$type, 'option'=>$option);
    }

    /**
     * 必須項目設定の解析
     *
     * @access public
     * @param string $subject
     * @return boolean
     */
    function parse_required($subject)
    {
        $pg2boolean = array(
            't'=> true,
            'f'=> false            
        );

        return $pg2boolean[$subject];
    }
} // manip_pgsqlの終了
?>