<?php
/* ========================================================================
 - [libs/rktBLOB/blob_common.php]
 -      Binary Large OBject
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/03/11] MIMEタイプの取得を追加
 -      [2006/11/25] 作成
 - ======================================================================== */

/**
 * BLOB_commonクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_db
 * @access public
 * @version 2.0.05.1.21
 */
class BLOB_common
{
    /**
     * ファイル名キー
     * @var string
     */
    var $origin = '';

    /**
     * ファイル名
     * @var string
     */
    var $name = '';

    /**
     * MIMEタイプ
     * @var string
     */
    var $mime_type = '';

    /**
     * ユーザーID
     * @var integer
     */
    var $uid = 0;

    /**
     * グループID
     * @var integer
     */
    var $gid = 0;

    /**
     * サイズ
     * @var integer
     */
    var $size = 0;

    /**
     * バイナリデータ
     * @var binary
     */
    var $buffer = null;

    /**
     * MIMEタイプの設定
     *
     * @access public
     * @param string $mime_type
     * @return void
     */
    function setMimeType($mime_type)
    {
        $this->mime_type = $mime_type;
    }

    /**
     * ユーザーIDの設定
     *
     * @access public
     * @param integer $uid
     * @return void
     */
    function setUID($uid)
    {
        $this->uid = $uid;
    }

    /**
     * グループIDの設定
     *
     * @access public
     * @param integer $gid
     * @return void
     */
    function setGID($gid)
    {
        $this->gid = $gid;
    }

    /**
     * サイズの設定
     *
     * @access public
     * @param integer $size
     * @return void
     */
    function setSize($size)
    {
        $this->size = $size;
    }

    /**
     * バッファーの設定
     *
     * @access public
     * @param binary $buffer
     * @return void
     */
    function setBuffer($buffer)
    {
        $this->buffer = $buffer;
        $this->size = strlen($this->buffer);
    }

    /**
     * ファイル名の取得
     *
     * @access public
     * @return string
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * MIMEタイプの取得
     *
     * @access public
     * @return string
     */
    function getMimeType()
    {
        return $this->mime_type;
    }

    /**
     * 所持バッファーの取得
     *
     * @access public
     * @return binary
     */
    function getBuffer()
    {
        return $this->buffer;
    }

    /**
     * 拡張子の取得
     *
     * @access public
     * @return string 拡張子
     */
    function getExtension()
    {
        $pos = strrpos($this->name, '.');
        if (!$pos){
            return '';
        }
        $extension = substr($this->name, $pos+1);

        return strtolower($extension);
    }

    /**
     * MIME-TYPEの取得
     *
     * @access public
     * @param string $name
     * @return string mime-type
     */
    function get_mime_type($name)
    {
    	$pos = strrpos($name, '.');
        if (!$pos){
            return '';
        }
    	$extension = substr($name, $pos+1);
    	$extension = strtolower($extension);
    
        $mime_types = array(
            'zip' => 'application/zip',
            'gz'  => 'application/x-gzip',
            'pdf' => 'application/pdf',
            'js'  => 'application/x-javascript',
            'jpeg'=> 'image/jpeg',
            'jpg' => 'image/jpeg',
            'png' => 'image/png',
            'gif' => 'image/gif',
            'html'=> 'text/html',
            'htm' => 'text/html',
            'xml' => 'text/xml',
            'css' => 'text/css',
            'txt' => 'text/plain',
        );
        return $mime_types[$extension];
    }

    /**
     * ファイルをバッファに格納
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    function readfile($filename)
    {
        if (!file_exists ($filename)){
            return false;
        }
        $this->name      = basename($filename);
        $this->size      = filesize($filename);
        $this->mime_type = $this->get_mime_type($filename);

        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'rb');
        if (!is_resource($handle)) {
            return false;
        }
        $this->buffer = fread($handle, $this->size);
        fclose($handle);
        
        return true;
    }

    /**
     * 対象データの出力
     *
     * @access public
     * @param boolean $inline
     * @return void
     */
    function output($inline=true)
    {
        if ($inline){
            Header('Content-Type: '.$this->mime_type);
            Header('Content-Length: '.$this->size);
            Header('Content-disposition: inline; filename='.$this->name);
        } else {
            Header('Content-Type: application/force-download');
            Header('Content-Length: '.$this->size);
            Header('Content-disposition: attachment; filename='.$this->name);
        }
        echo $this->buffer;
    }
} // RKT_blobの終了
?>