<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_uri2atag<br>
 * Purpose:  URI<a>^Oň͂
 * Example:  {$text|rkt_uri2atag}
 * @version  1.0
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @return string
 */
function smarty_modifier_rkt_uri2atag($string)
{
    return preg_replace_callback("/([^\"\']|^)(https?|ftp)(:\/\/[[:alnum:]\+\$\?\.%,!#~*\/:@&=_-]+)/i", '__rkt_callback_strwidth', $string);
}

/**
 * URL̒k߂
 *
 * @access public
 * @param integer $position
 * @return array
 */
function __rkt_callback_strwidth($matches)
{
    $uri = $matches[2].$matches[3];
    $label = substr($uri, 0, 60);
    if (strlen($uri) != strlen($label)){
        $label .= '...';
    }

    return $matches[1]."<a href=\"".$uri."\" target=\"_top\">".$label."</a>";
}

/* vim: set expandtab: */

?>
