<?php
/* ========================================================================
 - [htdocs/exec.php]
 -      Front Controller
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/11] 日記からPDFを作成するページ追加
 -      [2006/09/04] コンテンツ一覧、最近の一覧を追加
 -      [2006/08/27] ベーステンプレート読み込みを各クラス内に変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once BASE_DIR.'webapp'.DIRECTORY_SEPARATOR.'wap_config.php';
require_once LIB_DIR.'OpenPNE/KtaiUA.php';

define('WAP_DEFAULT_NUMBER', 4);

// ------------------------------------------------
// 実行関数
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function _main()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args = explode('/',$path_info);
    $group = empty($args[1])?'public':$args[1];
    $module = empty($args[2])?'content':$args[2];
    $page   = empty($args[3])?$module:$args[3];

    $titles = array (
        'admin'=>   array(
            'account'=>     array(      // アカウント管理
                'exit'=>        '退会処理',
                'mails'=>       'メール配信',
                'profile'=>     'プロフィール',
                'result'=>      '会員検索結果',
                'search'=>      '会員検索',
                'sendmail'=>    '配信メール送信',
            ),
            'community'=>     array(      // コミュニティ管理
                'community'=>   'コミュニティ詳細',
                'result'=>      'コミュニティ検索結果',
                'search'=>      'コミュニティ検索',
            ),
            'design'=>      array(      // デザイン設定
                'css'=>         'スタイルシート編集',
                'design'=>      'デザイン設定',
                'list'=>        'テーマ一覧',
                'preview'=>     'デザイン画像表示',
                'theme'=>       'デザインテーマ編集',
                'upload'=>      'テーマ素材アップロード',
            ),
            'environment'=> array(      // 環境設定
                'account'=>     '管理者情報編集',
                'config'=>      '環境設定',
            ),
            'inquire'=>     array(      // お問合せ
                'browse'=>      '問合せ参照',
                'list'=>        '問合せ一覧',
                'sendmail'=>    '問合せ返信メール',
            ),
            'item'=>        array(      // コンテンツ記事
                'category'=>    'コンテンツカテゴリ',
                'image_list'=>  'TinyMCE用画像リスト',
                'item'=>        'コンテンツ記事編集',
                'link_list'=>   'TinyMCE用リンクリスト',
                'list'=>        'コンテンツ記事一覧',
                'options'=>     '質問選択肢',
                'upload'=>      'コンテンツ添付ファイルアップロード',
            ),
            'mail'=>        array(      // 配信メールテンプレート
                'list'=>        '自動メール定型文一覧',
                'mail'=>        '自動メール定型文'
             ),
            'master'=>      array(      // マスターテーブル
                'com_category'=>'コミュニティカテゴリ',
                'com_genre'=>   'コミュニティジャンル',
                'frm_category'=>'フォーラムカテゴリ',
                'frm_genre'=>   'フォーラムジャンル',
                'inquire'=>     '問合せカテゴリ',
                'married'=>     '結婚マスター',
                'review'=>      'レビューカテゴリ',
                'sys_sort'=>    '各一覧ページ並び順(ORDER BY句)定義'
             ),
            'profile'=>     array(      // プロフィール
                'enquete'=>     'プロフィール追加項目編集',
                'enquetes'=>    'プロフィール項目一覧',
                'items'=>       'アンケート選択肢一覧',
            ),
            'sponsor'=>     array(      // スポンサー
                'list'=>        'スポンサーバナー一覧',
                'sponsor'=>     'スポンサーバナー編集',
            ),
        ), /* 管理者ページ */
        'community'=>   array(
            'bbs'=>         array(      // トピック、イベント
                'browse'=>      'トピック参照',
                'comment'=>     'コメントを書き込む',
                'entrys'=>      'イベント参加メンバー一覧',
                'event'=>       '新しいイベントを作成する',
                'list'=>        'トピック一覧',
                'send'=>        'イベント参加者へメッセージ送信',
                'topic'=>       '新しいトピックを作成する',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   'コミュニティ基礎情報',
                'entry'=>       'コミュニティに参加',
                'exit'=>        'コミュニティの退会',
                'intro'=>       '友達に紹介する',
                'names'=>       'コミュニティ参加名簿',
            ),
            'item'=>        array(      // コミュニティ記事
                'browse'=>      'コミュニティ記事閲覧',
                'enquete'=>     'コミュニティアンケート',
                'item'=>        'コミュニティ記事',
                'question'=>    'アンケート結果',
                'upload'=>      'アップロード',
                'option'=>      'オプション',
            ),
            'search'=>      array(      // コミュニティ検索
                'event'=>       'イベント検索結果',
                'result'=>      'コミュニティ検索結果',
                'search'=>      'コミュニティ検索',
            ),
            'show'=>        array(      // コミュニティ情報閲覧
                'calendar'=>    'コミュニティイベントカレンダー',
                'community'=>   'コミュニティ情報',
                'member'=>      'メンバー一覧',
            ),
        ), /* コミュニティページ */
        'friend'=>   array(
            'diary'=>       array(      // 友達日記
                'comments'=>    'コメント一覧',
                'entry'=>       '記事閲覧',
                'list'=>        '日記一覧',
                'result'=>      '日記検索結果',
                'search'=>      '日記検索',
            ),
            'edit'=>        array(      // 各種編集
                'favorite'=>    'お気に入り追加',
                'intro'=>       '紹介文編集',
                'message'=>     'メッセージを送る',
                'relation'=>    '友達追加',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'トピック参照',
                'comment'=>     'コメントを書き込む',
                'list'=>        'トピック一覧',
                'result'=>      'トピック検索結果',
                'search'=>      'トピック検索',
            ),
            'search'=>      array(      // 友達検索
                'condition'=>   '友達検索項目一覧',
                'result'=>      '友達検索結果',
                'search'=>      '友達検索',
            ),
            'show'=>        array(      // 友達情報閲覧
                'community'=>   'コミュニティ一覧',
                'friends'=>     '友達一覧',
                'intro'=>       '紹介文一覧',
                'photo'=>       '写真一覧',
                'profile'=>     'プロフィール',
                'review'=>      '投稿レビュー一覧表示',
            ),
         ), /* 友達ページ */
        'private'=>   array(
            'account'=>     array(      // 会員情報
                'account'=>     '会員基礎情報',
                'exit'=>        '退会処理',
                'passwd'=>      'パスワード変更',
            ),
            'content'=>     array(      // コンテンツ閲覧
                'browse'=>      'コンテンツ記事閲覧',
                'inquire'=>     '問合せフォーム',
                'list'=>        'コンテンツ一覧',
                'question'=>    'アンケート結果',
            ),
            'diary'=>       array(      // 日記
                'book'=>        '本・印刷',
                'books'=>       '本一覧',
                'category'=>    'カテゴリ',
                'comments'=>    'コメント一覧',
                'diary'=>       '日記設定',
                'entry'=>       '記事閲覧',
                'list'=>        '日記一覧',
                'post'=>        '日記記事投稿',
                'upload'=>      '画像投稿',
                'wysiwyg'=>     '日記記事投稿',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   '参加コミュニティ一覧',
                'friend'=>      '友達リスト管理',
                'photo'=>       '写真編集',
                'profile'=>     'プロフィール編集',
                'relation'=>    '各種認証',
                'schedule'=>    'スケジュール編集',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'トピック閲覧',
                'comment'=>     'コメントを書き込む',
                'list'=>        'トピック一覧',
                'response'=>    '返事を書く',
                'topic'=>       'トピック編集',
            ),
            'home'=>        array(      // Myホーム
                'home'=>        'Myホーム',
                'invite'=>      '友達招待フォーム',
                'nobody'=>      '閲覧できません',
                'recent'=>      '最近の一覧',
                'search'=>      '各種検索',
            ),
            'message'=>     array(      // メッセージ
                'browse'=>      'メッセージ閲覧',
                'list'=>        'メッセージボックス',
                'send'=>        'メッセージを送る',
            ),
            'review'=>      array(      // レビュー
                'browse'=>      '商品レビュー閲覧',
                'item'=>        'レビュー対象商品検索',
                'list'=>        '投稿レビュー一覧表示',
                'post'=>        'レビュー投稿',
                'search'=>      '投稿レビュー検索',
            ),
            'show'=>        array(      // 各種閲覧
                'calendar'=>    'カレンダー',
                'favorite'=>    'お気に入り',
                'footprint'=>   'あしあと',
                'friends'=>     '友達一覧',
                'intro'=>       '紹介文一覧',
                'profile'=>     'プロフィール確認',
                'schedule'=>    'スケジュール確認',
            ),
        ), /* プライベートページ */
        'public'=>   array(
            'community'=>   array(      // 一般公開用コミュニティ
                'community'=>   'コミュニティ情報',
                'member'=>      'メンバー一覧',
                'result'=>      'コミュニティ検索結果',
                'search'=>      'コミュニティ検索',
            ),
            'content'=>     array(      // コンテンツ記事
                'browse'=>      'コンテンツ記事閲覧',
                'default'=>     WAP_SYSTEM_NAME,
                'inquire'=>     '問合せフォーム',
            ),
            'friend'=>      array(      // 一般公開用友達
                'community'=>   'コミュニティ一覧',
                'friends'=>     '友達一覧',
                'profile'=>     'プロフィール',
                'result'=>      '友達検索結果',
                'search'=>      '友達検索',
            ),
            'json'=>        array(      // JSON
                'local'=>       '市区町村リスト生成',
            ),
            'login'=>       array(      // ログイン
                'entrance'=>    'ログインフォーム',
                'exit'=>        '退会ページ',
                'login'=>       'ログイン',
                'logout'=>      'ログアウト',
                'reissue'=>     'パスワードの再発行',
            ),
            'registry'=>    array(      // 会員登録
                'account'=>     '会員登録フォーム',
                'confirm'=>     '入力内容確認',
                'invite'=>      '自動招待フォーム',
                'registry'=>    '会員登録',
                'sendmail'=>    '会員登録確認メール発送',
            ),
        ), /* 一般公共ページ */
    );

    /* ---------------------------------------- */
    /* 携帯用ページへ */
    $ktaiUA = new OpenPNE_KtaiUA();
    if ($ktaiUA->is_ktai()){
        header('Location: '.BASE_URL.'mobile'.WAP_ACTION_STYLE);
        exit();        
    }

    /* ---------------------------------------- */
    /* 環境設定：セッション */
    include_once LIB_DIR.'rkt_session.php';
    RKT_session::setSaveHandler();                                      // セッションハンドル設定

    /* デフォルト読み込みモジュール */
    $include = 'public/content/default.php';
    /* テンプレートファイルの読み込み */
    if (empty($titles[$group][$module][$page])){
        $group  = 'public';
        $module = 'content';
        $page   = 'default';
    }
    $include = $group.'/'.$module.'/'.$page.'.php';
    include_once MODULE_DIR.$include;

    header('Content-Type: text/html; charset='.ENCODE_TYPE);
    $obj_webapp = new webapp();
    $obj_webapp->baseAssign('title', $titles[$group][$module][$page]);
    $obj_webapp->execute();
    $obj_webapp->display();

    if (DEBUG_ENV == 1){
        echo "<div id=\"left\">\n";
        echo "<pre style=\"text-align:left;\">".print_r($_REQUEST,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_SESSION,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_COOKIE,true)."</pre>";
        echo "</div>\n";
    }
}
_main();    // 実行関数
?>
