<?php
/* ========================================================================
 - [htdocs/cache.php]
 - 内容：キャッシュ用データの出力
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 -      Copyright (C) 2006 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/09/14] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once BASE_DIR.'webapp'.DIRECTORY_SEPARATOR.'wap_config.php';
require_once RKT_INCLUDE_ACCOUNT;

/**
 * 拡張子の取得
 *
 * @access public
 * @return string 拡張子
 */
function getMimeType($name)
{
	$pos = strrpos($name, '.');
    if (!$pos){
        return '';
    }
	$extension = substr($name, $pos+1);
	$extension = strtolower($extension);
    
    $mime_types = array(
        'zip' => 'application/zip',
        'gz'  => 'application/x-gzip',
        'pdf' => 'application/pdf',
        'jpeg'=> 'image/jpeg',
        'jpg' => 'image/jpeg',
        'png' => 'image/png',
        'gif' => 'image/gif',
        'html'=> 'text/html',
        'htm' => 'text/html',
        'xml' => 'text/xml',
        'txt' => 'text/plain',
    );
    return $mime_types[$extension];
}

// ------------------------------------------------
// 実行関数
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function _main()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $filename = CACHE_DIR.$path_info;
    $inline = true;
    if (preg_match('/diary_book\.pdf/i', $path_info)){
        $objact = account::getInstance();
        $account = $objact->getInfo();

        $name = 'diary_'.$account['id'].'.pdf';
        $filename = CACHE_DIR.'tcpdf/'.$name;
        
        $mime_type = 'application/pdf';
    } else {
        $mime_type = getMimeType($filename);
    }

    /* ファイルの中身を取得 */
    $handle = fopen($filename, 'rb');
    if (!is_resource($handle)) {
        return false;
    }
    $buffer = fread($handle, filesize($filename));
    fclose($handle);

    // ヘッダー
    if ($inline){
    	Header('Content-Type: '.$mime_type);
    	Header('Content-Length: '.strlen($buffer));
    	Header('Content-disposition: inline; filename='.basename($filename));
    } else {
        Header('Content-Type: application/force-download');
    	Header('Content-Length: '.strlen($buffer));
    	Header('Content-disposition: attachment; filename='.basename($filename));
    }
    
    echo $buffer;
    exit();
}

_main();    // 実行関数
?>