<?php
/**
 * ページ情報画面クラス
 *
 * ページ情報画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class pageview extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // GETでページIDがセットされていたら、取得する
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'id' ] = 0;

      // ページID
      if ( isset( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'id' ] = strip_tags( trim( $_GET[ 'id' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたページIDが数字でなければ、値がなかったものとして取り扱う
      if ( ! is_numeric( $tmp_entered[ 'id' ] ) )
      {
        $tmp_entered[ 'id' ] = 0;
      } // end of if



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $tmp_t_pages = $this->mycage . '_t_pages';
        $sql =<<<End_Of_SQL

              SELECT `pages`.`page_title` -- タイトル
                   , `pages`.`page_body`  -- 本文
                FROM $tmp_t_pages pages
               WHERE `pages`.`page_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'id' ]
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は値を取得できなかったものとして扱う
          $this->gotDat = null;
        } // end of if
        else
        {
          // 正常に実行できた場合は取得した値を採用する
          $this->gotDat = $tmp_result;
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は値を取得できなかったものとして扱う
      else
      {
        $this->gotDat = null;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $headers            = $this->obj_util->getHeader();
      $headers[ 'title' ] = $this->gotDat[ 'page_title' ];
      $this->smarty->assign ( 'header', $headers );
      $this->smarty->assign ( 'body',   stripslashes( $this->gotDat[ 'page_body' ] ) );

      // 表示
      $this->smarty->display( 'pageview.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageview
?>
