<?php
/**
 * ユーザ情報変更内容入力画面クラス
 *
 * ユーザ情報変更内容入力画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_user_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class usermod_entry extends admin_user_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.user」でない or 前画面のActが「userlist」 and 「usermod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.user' or ( $tmp_act != 'userlist' and $tmp_act != 'usermod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'userlist', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'user_id' ] = null;

      // セッションからエラーメッセージと入力値を取得し、削除する
      $tmp_entered = $this->obj_sess->sessLoad(  $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );
      // 前画面のエラーメッセージをクラス変数に格納
      $this->gotDat[ 'errMsg' ] = $tmp_entered[ 'message' ];



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // ユーザ名
      if ( isset( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'user_id' ] = strip_tags( trim( $_GET[ 'id' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたユーザIDがnullか数字でなければ、ユーザ選択画面に遷移する
      if ( $tmp_entered[ 'user_id' ] == null or ! is_numeric( $tmp_entered[ 'user_id' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_username';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'userlist', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // グループ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // ユーザ情報を取得する
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_id`            -- ユーザID
                   , `user`.`user_name`          -- ユーザ名
                   , `user`.`group_id`           -- グループID
                FROM `risoluto_t_user` user
               WHERE `user`.`user_id` = ?
                 AND `user`.`status`  = 1

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'user_id' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_userdat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_userdat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'user information get Failure' );
          return false;
        } // end of if
        // 正常に取得できていれば、クラス変数にセットする
        else
        {
          $this->gotDat[ 'userinfo' ] = $tmp_userdat;

          // グループIDがセッション中に存在すればその値でオーバーライド
          if ( isset( $tmp_entered[ 'group_id' ] ) and !empty( $tmp_entered[ 'group_id' ] ) )
          {
            $this->gotDat[ 'userinfo' ][ 'group_id' ] = $tmp_entered[ 'group_id' ];
          } // end of if
        } // end of else



        // グループ情報を取得する
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `groups`.`group_id`    -- グループID
                   , `groups`.`group_name`  -- グループ名
                FROM `risoluto_m_group` groups
               WHERE `groups`.`group_id` >= ?
                 AND `groups`.`status`    = 1
            ORDER BY `groups`.`group_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $this->obj_sess->sessLoad( 'login_groupid' )
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_groupdat = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_groupdat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'grouplist get Failure' );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      // グループ情報を適切な形式に加工
      foreach( $tmp_groupdat as $dat )
      {
        $this->gotDat[ 'grouplist' ][ $dat[ 'group_id' ] ] = $dat[ 'group_name' ];
      } // end of foreach



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',         $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',          $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'errMsg',            $this->gotDat[ 'errMsg'    ] );
      $this->smarty->assign ( 'entered_user_id',   $this->gotDat[ 'userinfo'  ][ 'user_id'   ] );
      $this->smarty->assign ( 'entered_username',  $this->gotDat[ 'userinfo'  ][ 'user_name' ] );
      $this->smarty->assign ( 'entered_group_id',  $this->gotDat[ 'userinfo'  ][ 'group_id'  ] );
      $this->smarty->assign ( 'grouplist',         $this->gotDat[ 'grouplist' ] );

      // 表示
      $this->smarty->display( 'usermod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:usermod_entry

?>
