#!/bin/sh

#==============================================================================
# @package   risoluto
# @author    Risoluto Developers
# @license   http://opensource.org/licenses/bsd-license.php new BSD license
# @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
#==============================================================================

#==============================================================================
# 設定情報
#==========================================================================from

# BATCHDIR
BATCHDIR="`/bin/pwd`/"

# HOMEDIR
HOMEDIR="${BATCHDIR}"

# LOGPATH
LOGPATH="${BATCHDIR}../logs/risoluto_`date '+%Y%m%d'`.log"

# Download URL
DL_URL="http://www.post.japanpost.jp/zipcode/dl/kogaki/lzh/ken_all.lzh"

# ダウンロードフォルダパス情報
DOWN_LOAD_PATH="${HOMEDIR}"

# ダウンロードファイルパス情報
DOWN_LOAD_FILE="${HOMEDIR}KEN_ALL.CSV"

# PHPBIN
PHPBIN=`/usr/bin/which php`
PHPBIN_STATUS=`echo $?`

# LHABIN
LHABIN=`/usr/bin/which lha`
LHABIN_STATUS=`echo $?`

# WGETBIN
WGETBIN=`/usr/bin/which wget`
WGETBIN_STATUS=`echo $?`

# IMPORTERBIN
IMPORTERBIN="${BATCHDIR}zipcode_batch.php"

#===========================================================================to

#============================================================================
# 処理
#============================================================================

# 必須コマンドのチェック
if [ "${PHPBIN_STATUS}" -ne 0 ];
then
  echo "[error at `date '+%Y-%m-%d %H:%M:%S(%Z)'`][SHELL:zipcode.sh]php command not found. Exit..." >> ${LOGPATH};
  exit;
fi
if [ "${LHABIN_STATUS}" -ne 0 ];
then
  echo "[error at `date '+%Y-%m-%d %H:%M:%S(%Z)'`][SHELL:zipcode.sh]lha command not found. Exit..." >> ${LOGPATH};
  exit;
fi
if [ "${WGETBIN_STATUS}" -ne 0 ];
then
  echo "[error at `date '+%Y-%m-%d %H:%M:%S(%Z)'`][SHELL:zipcode.sh]wget command not found. Exit..." >> ${LOGPATH};
  exit;
fi

if [ ! -e "${IMPORTERBIN}" ];
then
  echo "[error at `date '+%Y-%m-%d %H:%M:%S(%Z)'`][SHELL:zipcode.sh]${IMPORTERBIN} command not found. Exit..." >> ${LOGPATH};
  exit;
fi

# ダウンロード先指定
cd ${DOWN_LOAD_PATH}

# 前回までのファイルを削除
/bin/rm -f ken_all.lzh >/dev/null 2>&1
/bin/rm -f KEN_ALL.CSV >/dev/null 2>&1

# ゆうびんホームページより全国データをダウンロード
${WGETBIN} --quiet "${DL_URL}" >/dev/null 2>&1

# ダウンロードしたファイルを解凍
${LHABIN} xdf "ken_all.lzh" >/dev/null 2>&1

# インポート処理を実行
${PHPBIN} ${IMPORTERBIN}
