<?php
/**
 * トラックバック承認取消画面クラス
 *
 * トラックバック承認取消画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class trackback_ng extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // 前画面のCageが自分と同じでない or 前画面のActが「trackbacklist」でない場合、
      // 一覧画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'trackbacklist' ) )
      {
        $this->obj_util->redirectTo( 'trackbacklist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'trackback_id' ] = null;

      // トラックバックID
      if ( isset( $_GET[ 'trackback_id' ] ) )
      {
        $tmp_entered[ 'trackback_id' ] = strip_tags( trim( $_GET [ 'trackback_id' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // トラックバックID（数値ではない）
      if ( ! is_numeric( $tmp_entered[ 'trackback_id' ] ) )
      {
        // 例外を投げる
        throw new Exception( 'invalid trackback_id' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // トラックバックを削除
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              UPDATE `simpleblog_t_trackback`
                 SET `mtime`         = now()
                   , `muser`         = ?
                   , `status`        = 0
               WHERE `trackback_id`  = ?

End_Of_SQL;

        // パラメタも用意する
        $tmp_myself = $this->obj_util->answerMyId();
        $param = array(
                        $tmp_myself
                      , $tmp_entered[ 'trackback_id' ]
                      );

        // Updateを実行
        $tmp_update_result = $this->obj_db->dbExecSQL( $sql, $param );
        if ( PEAR::isError( $tmp_update_result ) )
        {
          // エラーの場合はロールバックして接続を閉じ、例外を投げる
          $this->obj_db->dbRollback();
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Update Failure' );
          return false;
        } // end of if
        else
        {
          // 正常に実行できた場合はコミットして接続を閉じる
          $this->obj_db->dbCommit();
          $this->obj_db->dbDisConnect();
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // トラックバック一覧画面にリダイレクトする
      $this->obj_util->redirectTo( 'trackbacklist', $tmp_cage_current );
      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      return true;

    } // end of function:view()

  } // end of class:trackback_ng

?>
